#ifndef __PSHINEPLUGIN_H
#define __PSHINEPLUGIN_H

#include "pslib.h"

/*

  A Shine plugin should have the following funtions:

*/

//________________________________________________________________________________________________________________________________________________________________________

#define cMaxPluginParameterSize 1024

//________________________________________________________________________________________________________________________________________________________________________

enum eShinePluginEvent_t {
	cSPNoEvent, cSPMouseOver, cSPMouseAway, cSPMouseLeft
};

//________________________________________________________________________________________________________________________________________________________________________

enum eShineAction_t {
	cSANoAction, cSAFollowLink
};

//________________________________________________________________________________________________________________________________________________________________________

struct rShinePluginInformation_t {
	float			Version;
	long			xres, yres;
	long			refreshTime;
	char			parameter[cMaxPluginParameterSize];
	long*			renderBuffer;
	long			backColor;
	long			color;
	char			libraryName[256];
	int				ID;
	char			link[cMaxPluginParameterSize];
};

//________________________________________________________________________________________________________________________________________________________________________

struct rShinePluginUpdate_t {
	int				musicVolume;
	int				musicLeft;
	int				musicRight;
	int				mouseX;
	int				mouseY;
};

//________________________________________________________________________________________________________________________________________________________________________

struct rShinePluginAction_t {
	eShineAction_t eShineAction;
	union {
		char linkFilename[256];
	}u;
};

//________________________________________________________________________________________________________________________________________________________________________

#endif