;Star toast main title screen code
TitleScreen				sei
						;Switch to bank #$00, charset $e000, and
						;use screen memory $c400-$c7e7. Switch off
						;all sprites
						
						lda #<ScrollText																	
						sta MessRead+1																	
						lda	#>ScrollText																
						sta MessRead+2																
						lda SoundOption
						cmp #$01
						bne DoNotRestartMusic
						lda #$00
						jsr MusicInit
DoNotRestartMusic
						lda #$00	;Switch to bank #$00
						sta $dd00
						sta xpos	;init xpos
						lda #$18	;Multicolour mode on
						sta $d016
						sta $d018	;Charset at $e000, to BANK #$00 Screen $c400+
						lda #$00
						sta $d01a	;Switch of existing interrupts
						sta $d019
						sta $d015	;Disable all sprites on screen
						
						lda #$00	;Set to black border/background
						sta $d020
						sta $d021
						
						;Fill the screen memory to be used with
						;the SPACEBAR character
						;(I am using BANK #$00, $E000-$E800
						;charset, and $C400-$C7E8 screen RAM
						ldx #$00	
ClearScreenMem			lda #$20
						sta $c400,x
						sta $c500,x
						sta $c600,x
						sta $c6e8,x
						inx
						bne ClearScreenMem
						
						;Now display the title text (remember to keep the
						;convert text subroutine which was already
						;installed inside the game over code, where
						;with PART 1, we converted TASS encoded chars
						;into the correct screen characters
						
						ldx #$00
DoTitleTextDisplay		lda TitleTextLine1,x	;(C)2017 Scene World
						jsr CheckCharCase
						sta $c568,x				
						lda TitleTextLine2,x	;Progamming, Graphics and Music by
						jsr CheckCharCase
						sta $c5b8,x
						lda TitleTextLine3,x	;Richard Bayliss
						jsr CheckCharCase
						sta $c5e0,x
						
						lda #1					;Colour white chars
						sta $d968,x
						lda #3					;Colour yellow chars
						sta $d9b8,x
						lda #7
						sta $d9e0,x
						lda #$05				;Colour green chars
						sta $da30,x				;(For scroll text)
						sta $da58,x
						
						
						inx
						cpx #40					;40 chars read per row
						bne DoTitleTextDisplay
						
;Fill the colour scheme for the Star Toast logo with
;Multicolour+White

						ldx #$00
FillMCWhite				lda #$0b	;Colour grey = multicolour - cyan
						sta $d800,x
					    sta $d828,x
						sta $d850,x
						sta $d878,x
						sta $d8a0,x
						sta $d8c8,x
						sta $d8f0,x
						sta $d918,x
						sta $dad0,x
						sta $daf8,x
						sta $db20,x
						sta $db48,x
						sta $db70,x
						sta $db98,x
						sta $dbc0,x
						inx
						cpx #$28
						bne FillMCWhite
						
						
						;Setup init IRQ raster interrupt
						;for the title screen.
						
						lda #<Tirq1 ;Set low/hibyte of non
						ldx #>Tirq1 ;kernal ints
						sta $fffe
						stx $ffff
						
						lda #<nmi	;Disable runstop+restore
						ldx #>nmi	;pointing to NMI/RTI code
						sta $fffa
						stx $fffb	
						lda #$00	;Init raster position
						sta $d012
						lda #$7f	;Enable interrupt mode
						sta $dc0d
						lda #$1b	;Screen switched on to
						sta $d011	;standard char mode v pos
						lda #$01
						sta $d01a	;Switch IRQ to sync mode
						lda #$04
						sta $d022	;BGR Multicol = purple 
						lda #$0e
						sta $d023	;BGR Multicol = light blue
						
						lda #0			;Initialise fire button
						sta FireButton
						
					
						cli				;Clear IRQ flag 
						
						;Synchronize delay for main title loop
						
TitleLoop				lda #$00						
						sta SyncDelay						
						cmp SyncDelay						
						beq *-3						
											
						;Scroll 'Star Toast logo' call routine
											
						jsr MoveLogo						
								
						jmp TitleLoop				
											
											
												
;Move the 100 column title screen logo across the screen																								
;to the left.																								

MoveLogo				
						ldx #$00
move1					lda #$f8
						cmp $d012
						bne *-3
						jsr MoveLogoToTheLeft
					 	jsr MoveLogoToTheRight
					
						;Reads a char from each column, then
						;pastes it to the last screen char at
						;the top of the screen, or first char
						;of the screen, before moving to the
						;next char row.
						
						lda TitleScreenLogo,x
						sta $c427
					
						sta $c7c0
						lda TitleScreenLogo+100,x
						sta $c44f
						sta $c798
						lda TitleScreenLogo+200,x
						sta $c477
						sta $c770
						lda TitleScreenLogo+300,x
						sta $c49f
						sta $c748
						lda TitleScreenLogo+400,x
						sta $c4c7
						sta $c720
						lda TitleScreenLogo+500,x
						sta $c4ef
						sta $c6f8
						
						lda TitleScreenLogo+600,x
						sta $c517
						sta $c6d0
						inx
						cpx #100
						bne move1
						rts
						

;Move 8 of the top char rows to the left, so the						
;logo can scroll across.						
						
MoveLogoToTheLeft		ldy #$00		
move2					lda $c401,y
						sta $c400,y
						lda $c429,y
						sta $c428,y
						lda $c451,y
						sta $c450,y
						lda $c479,y
						sta $c478,y
						lda $c4a1,y
						sta $c4a0,y
						lda $c4c9,y
						sta $c4c8,y
						lda $c4f1,y
						sta $c4f0,y
						lda $c519,y
						sta $c518,y
						iny
						cpy #$27
						bne move2						
						rts						
												
;Move 8 of the bottom char rows to the right, so the												
;logo can scroll across.												
												
MoveLogoToTheRight		ldy #$26											
move3									
															
						lda $c798-1,y											
						sta $c798,y											
						lda $c770-1,y											
						sta $c770,y											
						lda $c748-1,y										
						sta $c748,y											
						lda $c720-1,y											
						sta $c720,y											
						lda $c6f8-1,y										
						sta $c6f8,y										
						lda $c6d0-1,y										
						sta $c6d0,y									
						dey							
						bne move3										
						rts										

;Scroll the text message (Also was featured in Zap Zone)															
																
ScrollMessage
						lda xpos																	
						sec																	
						sbc #3																	
						and #$07																	
						sta xpos															
						bcs endscroll																	
																							
						ldx #$00																	
pullchr					lda $c659,x																	
						sta $c658,x																	
						inx																	
						cpx #$27																	
						bne pullchr																	
MessRead				lda ScrollText																	
						cmp #$00																	
						bne StoreChar																	
						lda #<ScrollText																	
						sta MessRead+1																	
						lda	#>ScrollText																
						sta MessRead+2																
						jmp MessRead																
StoreChar				jsr CheckCharCase
						sta $c67f																
						inc MessRead+1										
						bne endscroll										
						inc MessRead+2										
endscroll				rts										

;Check in game sound option  and then display the sound option char icon.

CheckSoundOption		lda SoundOption
						cmp #$01
						beq SFXOptionShow
						lda #81 ;Selected character for music icon
						sta $c7e7 ;Place as very last char in memory
						lda #$04  ;Colour purple
						sta $dbe7
						rts
SFXOptionShow			lda #82 ;Show SFX char in memory
						sta $c7e7
						lda #$04
						sta $dbe7
						rts
												
;Main title IRQ interrupts. 

Tirq1					sta tstacka1+1 
						stx tstackx1+1
						sty tstacky1+1
						lda $dc0d	;CIA Sync check
						sta $dd0d
						asl $d019	;Trigger IRQ position sync
						lda #$22	;First raster start position
						sta $d012
						lda #$18	;Screen H-Pos Multicolour mode on
						sta $d016
						jsr CheckSoundOption ;Subroutine to check sound option
						jsr MusicPlayer		 ;Subroutine for PAL/NTSC music player
						jsr ScrollMessage	 ;Subroutine for horizontal soft scroll text
						lda #<Tirq2				
						ldx #>Tirq2			 ;Point to low/byte addresses of the next
						sta $fffe			 ;IRQ interrupt.
						stx $ffff
tstacka1				lda #$00			 ;Self-mod stack A
tstackx1				ldx #$00			 ;Self-mod stack X
tstacky1				ldy #$00			 ;Self-mod stack Y
						rti					 
						
Tirq2					sta tstacka2+1						
						stx tstackx2+1						
						sty tstacky2+1						
						asl $d019			 ;Trigger IRQ sync			
							
						lda #$a2			 ;Next raster position			
						sta $d012						
						lda #$18			 ;Screen multicolour on
						sta $d016				
						
						lda #<Tirq3			 ;Point to low/hi byte addresses of the next
						ldx #>Tirq3			 ;IRQ interrupt.
						sta $fffe
						stx $ffff
					
						
tstacka2				lda #$00					
tstackx2				ldx #$00					
tstacky2				ldy #$00					
					
					
						rti
						
						;IRQ 3, this sets up the smooth scroller 
						
Tirq3					sta tstacka3+1
						stx tstackx3+1
						sty tstacky3+1
						asl $d019
						lda #$b8		;Next Raster position
						sta $d012
						lda xpos		;Smooth scroller set to
						sta $d016		;horizontal screen position
						lda #1
						sta SyncDelay
WaitToPlayGame										
						lda $dc00		;Read joystick port 2					
						lsr				;Read up - No effect
						lsr				;Read down - No effect
						lsr				;Read left (For selecting in game music)
						bcs CheckJRight		
						lda #0			;In game music set
						sta SoundOption		
						jmp skipPlay		
CheckJRight				lsr				;Read right (For selecting sfx and atmospherics)
						bcs CheckJFire
						lda #1			;No in game music, and allow atmospherics
						sta SoundOption
						jmp skipPlay
CheckJFire
						lsr				;Check for fire button					
						bit FireButton	;pressed.
						ror FireButton					
						bmi skipPlay	;Not pressed			
						bvc skipPlay	;-----------			
						jmp StartGame	;Yes. Pressed, execute game
skipPlay				
										
						lda #<Tirq1		;Point to low/hi byte address
						ldx #>Tirq1		;for first IRQ interrupt position.
						sta $fffe
						stx $ffff
tstacka3				lda #$00
tstackx3				ldx #$00
tstacky3				ldy #$00
						rti
						
						
						;Setup title screen text display
						
TitleTextLine1			.text "       (c)2017 scene world magazine     "					
TitleTextLine2			.text "   programming, graphics and music by   "						
TitleTextLine3			.text "             richard  bayliss           "						

ScrollText						
TitleTextLine4			.text "          last score was: "
FinalScore				.text "000000"	;Self mod score text					
TitleTextLine5			.text " ...   hi score is: "
HiScore					.text "000000 ";Self mod hi-score text 
						.text "...    "						
						;Main scroll text message.
						.text "... it's time to get blasting with ---> star toast <--- ...   "
						.text "game design, programming, graphics and boppy tune by richard bayliss ...    "
						.text "this is the final 64tass version of the game, which accompanies issue 28 of scene world ...    "
						.text "plug a joystick into port 2, use left/right to select in game sound option (in game music "
						.text "or sound effects) ...   pressing fire will commence play ...    "
						.text "how to play: this is a simple little score attack game in which you must move "
						.text "your space ship around the space background and do battle against "
						.text "infinite fleets of killer aliens ...   your mission is to blast them in to "
						.text "oblivion ...   for every alien hit, you will be awarded 200 points ...   "
						.text "watch out though, should you make contact with aliens or their lasers, you will become "
						.text ">>> star toast <<< hahaha ...    you have 3 ships at your disposal ...   lose the "
						.text "lot, it is game over ...    the player will start with a shield engaged, but "
						.text "your shield will be short lived ...   be careful ...    to learn more about making this type of "
						.text "the game, please refer to the source code and the article 'let's make a game - part 4', which is also on issue 28 of scene world ...    "
						.text "for the game source code and binary data, please check out www.sceneworld.org, or "
						.text "tnd64.unikat.sk/swo.html ...   "
						.text "and now ... it's that time once again ...   it's the c64 greetings list ...   "  
						.text "richard sends his greetings to the following friends, contacts and c64 fanatics out there: "
                        .text "alf yngve, kenz, tmr, jon wells, tlr, max hall, frank gasking, bieno marti, vinny mainolfi, "
      					.text "paul kubiszyn, carl mason, eleanor burns, steve day, paulie hughes, wayne womersley, merman, nafcom, "
      					.text "nodepond, baracuda, st0rmfr0nt, the overkiller, ian coog, stu collier, rotteroy, didi, jazzcat, unkle k, mermaid, graham axten, "
      					.text "anthony stiller, flex/artline design, bordeaux, dandee, "
      					.text "drax, mr. mouse, jsl, saul cross, achim volkers, trevor storey, "
      					.text "canseco, alan simek, marq watkin, fritske, pievspie, goat, lasse oorni, mr. nop, heavystylus, "
      					.text "randall, jammer, nick vivid, errazking, mark hindsbo, retromarkie, the doc, neil grayson, "
      					.text "matteo angelini, minimoog, the overkiller, the mad scientist, gfellow, roberto ricioppo, "
					    .text "christian siege, endurion, the guys and girls at lemon64, protovision, psytronik, rgcd, scene world, k&a, reset magazine, commodore format archive, revival retro events, retrovision, and anyone else who i have missed out ...   "       
						.text "i hope you have fun playing >>> star toast <<< and will look forward to future "
						.text "productions from me in the near future ...   press fire to play ...         "
						.byte 0 			

;A couple of pointers. xpos controls the smoothness of a
;scroll when triggered to $d016 inside an interrupt. 
;LogoMoveDelay sets the duration to wait before the logo
;can move across.

xpos			.byte 0						
LogoMoveDelay .byte 0

						
						