;SCENE WORLD issue 28
;Game Programming for beginners - PART 4

;STAR TOAST - BUILD V2 - Complete
; by Richard Bayliss

;GENERAL INFORMATION:
;--------------------
;STAR TOAST is a simple little score attack shoot 'em up with no 
;levels. The game will feature the following: 

;- A simple smooth vertical scrolling space background 
;- 8 Animated sprites (One player, player bullet, 5 aliens, 1 alien bullet) 
;- Split screen, for score panel. 


;MEMORY AREA USAGE

;GAME GRAPHICS CHARSET - $0800 - $0FFF <- Main space background charset
;MUSIC                 - $1000 - $1FFF <- Richard's awesome game tune
;GAME SPRITES          - $2000 - $3FFF <- Frames of game sprites
;GAME SCREEN/MAP       - $4000 - $43e7 <- Single screen of space background
;STATUS PANEL MAP      - $4400 - $4500 <- The status/score panel map
;STATUS PANEL COLOURS  - $4500 - $45FF <- Colour data for score panel
;GAME CODE             - $4800 - $xxxx <- Main code for the game
;ALIEN FORMATION DATA  - $A000 - $BFFF <- Data made from the alien formation maker
;STATUS PANEL CHARSET  - $E000 - $E7FF <- Character set for the score panel
;Title Logo matrix     - $EC00 - $EFE7 <- 80 column matrix for title screen logo									
;Import the main game character set data to $0800-$0FFF. This charset											
;represents the background scrolling graphics. Uses CharPad V2.0 RAW binary											
;format.											
											
			*=$0800							
GameCharsetData							
			.binary "gamedata/backgroundchar.bin"	
;---------------------------------------------------------------------			
;Import the music data PRG file into memory $1000-$1fff. For
;this example I'm using StarToastMusic.prg (The PRG was generated from
;Lasse's Goat Tracker V2.7). You may use any tune PRG data at $1000
;to $1fff should you wish to ...
			*=$1000	
MusicPlayerData			
			.binary "gamedata/StarToastMusic.prg",2	
;---------------------------------------------------------------------				
;Import the game sprite data into memory, so we can use the frames	
;for each game sprite. The data here is Spritpad's V2.0 RAW binary format.  	
			*=$2000	
SpriteData	
			.binary "gamedata/sprites.bin"
;---------------------------------------------------------------------
;Import the single wrap-around screen of the main game map. Must be
;a multicoloured map, of course :). Format is yet again in RAW bin
;format from CharPad V2.0
GameMap
			*=$4000
			.binary "gamedata/backgroundscreen.bin"
;---------------------------------------------------------------------			
;Import the score panel screen, exported from CharPad V2.0 raw BIN			
;format.			
			*=$4400			
ScorePanelScreen			
			.binary "gamedata/panelscreen.bin"		
;----------------------------------------------------------------------		
;Import the score panel attributes/colour data, made with CharPad V2.0		 
			*=$4500		
ScorePanelColours		
			.binary "gamedata/panelcolours.bin"		
					
;Link the main title screen source			
;-----------------------------------------------------------------------			
			*=$4800
			
								;Remove all Kernal ROMs
								lda #$35
								sta $01
								;Autodetect PAL/NTSC and store to system
								;pointer.
								lda $02a6
								sta System
								lda #$00 ;One time music init
								jsr MusicInit
TitleCode	.include "titlecode.asm"			
			
GameCode
			.include "gamecode2.asm"


			
;Import the game over screen				
GameOverScreen			
			.binary "gamedata/gameoverscreen.bin"			
			
			;100 column logo 
TitleScreenLogo				
			.binary "gamedata/scrolllogo.bin"
						
			
;Import all of the alien formation data, created from the Alien			
;formation maker. Each table is 256 bytes, too many of these will			
;take up a lot of memory. I have decided to do 16 max of these. :)			
;File is C64 program file, so ,2 prefix is required after formation data
;We can use spare memory to fit 16 different alien formation tables if you
;want.


			*=$a000
Formation01	.binary "gamedata/formation01.prg",2
Formation02	.binary "gamedata/formation02.prg",2
Formation03	.binary "gamedata/formation03.prg",2
Formation04 .binary "gamedata/formation04.prg",2
Formation05 .binary "gamedata/formation05.prg",2
Formation06 .binary "gamedata/formation06.prg",2
Formation07 .binary "gamedata/formation07.prg",2
Formation08 .binary "gamedata/formation08.prg",2
Formation09 .binary "gamedata/formation09.prg",2
Formation10 .binary "gamedata/formation10.prg",2
Formation11 .binary "gamedata/formation11.prg",2
Formation12 .binary "gamedata/formation12.prg",2
Formation13 .binary "gamedata/formation13.prg",2
Formation14 .binary "gamedata/formation14.prg",2
Formation15 .binary "gamedata/formation15.prg",2
Formation16 .binary "gamedata/formation16.prg",2
			
;-----------------------------------------------------------------------			
;Finally place the score panel charset into memory bank #$00, and 			
;place it at $e000. This is yet again CharPad RAW binary format			
			*=$e000			
ScorePanelCharset			
			.binary "gamedata/panelchar.bin"				
;------------------------------------------------------------------------
;END OF SOURCE			
;------------------------------------------------------------------------			
			
