;Star Toast - Main game code.

;Initialise code, and disable KERNAL vectors
;initialise interrupts to nothing, before drawing 
;initialising the game completely.


MusicInit = $1000 ;Initialise Richard's music
MusicPlay = $1003 ;Play Richard's music
SFXPlay = $1006   ;Goat Tracker SFX player
MapData = $4000								
								
;Variables for scroll control (Each row consist of 40 chars)								
;So basically the default starting screen is set at $0400. To get each						
;row, we just add 40 chars or multiply the charset row, by the number of						
;columns, in order to get the next row. For example						
;$0400+7*40 takes you to row 7						
						
screen = $0400
row0 = screen
row1 = screen+1*40
row2 = screen+2*40
row3 = screen+3*40
row4 = screen+4*40
row5 = screen+5*40
row6 = screen+6*40
row7 = screen+7*40
row8 = screen+8*40
row9 = screen+9*40
row10 = screen+10*40
row11 = screen+11*40
row12 = screen+12*40
row13 = screen+13*40
row14 = screen+14*40
row15 = screen+15*40
row16 = screen+16*40
row17 = screen+17*40
row18 = screen+18*40
row19 = screen+19*40
row20 = screen+20*40

ScorePos = $c777 ;Screen char position for score display
LivesPos = $c796 ;Screen char position for lives display
;Temporary spare memory placement for placing 40 chars. 
rowtemp = $9000

;Backup memory for placing actual alien formation
FormationBackup = $9800

;Limited stopping position values stored for the player ship, when in motion
PlayerUpStopPosition = $48	;Stop position for player moving up so that it cannot
							;move outside the border.
							
PlayerDownStopPosition = $b8 ;Stop position for player moving down so that it 
							 ;cannot move outside the bottom game area.
							
PlayerLeftStopPosition = $0c ;Stop position for player moving left so that it
							 ;cannot move outside the left border

PlayerRightStopPosition = $a0 ;Stop position for player moving left so that it
							 ;cannot move outside the right border

Alien1Interval = 10 ;Delay limit for alien 1 spawning
Alien2Interval = 20 ;Delay limit for alien 2 spawning
Alien3Interval = 30 ;Delay limit for alien 3 spawning
Alien4Interval = 40 ;Delay limit for alien 4 spawning
Alien5Interval = 50 ;Delay limit for alien 5 spawning


;---------------------------------------------------------------------
;Setup the game background and charset, colours and draw the background								
;screen straight away. You may have remembered this from last time with								
;Zap Zone :)								
;---------------------------------------------------------------------
StartGame						sei
								lda #0		;Black border + Background
								sta $d020
								sta $d021
								
								ldx #1
								stx RandCounter
								
								;Initialise score pointers
								ldx #$00
ZeroScoreTable					lda #$30
								sta PlayerScore,x
								inx
								cpx #$06
								bne ZeroScoreTable
								
								;Default number of lives to 3
								lda #$33
								sta PlayerLives

								
								ldx #$00								
DrawScreen						lda MapData,x ;Read from map binary 								
								sta $0400,x   ;Draw to default BANK #$03 screen RAM	
								lda MapData+$100,x ;Read the next 256 chars	
								sta $0500,x	  ;Paste them to the screen	
								lda MapData+$200,x	;and so on ...
								sta $0600,x  	
								lda MapData+$2e8,x	
								sta $06e8,x	
									;Fill main colour of star map multicolour cyan.	
								lda #$0b 	
								sta $d800,x ;Draw to colour RAM	
								sta $d900,x	;fill next 256 bytes
								sta $da00,x	;... and so on
								sta $dae8,x	
								lda #$20	;Fill with space char
								sta $c400,x
								sta $c500,x
								sta $c600,x
								sta $c6e8,x
								inx	
								bne DrawScreen	
								
								lda #$ff
								sta SpriteTrigger+1
								;All aliens should be offset. Init pointers
								;so that they are.
								ldx #0
								stx TableSelect
								
								lda #1
								sta Alien1Offset
								sta Alien2Offset
								sta Alien3Offset
								sta Alien4Offset
								sta Alien5Offset
								
								;Also ensure aliens are not dead either
								lda #0
								sta Alien1IsDead
								sta Alien2IsDead
								sta Alien3IsDead
								sta Alien4IsDead
								sta Alien5IsDead
								
								;Next reset all alien wait timers
								
								sta Alien1WaitTime
								sta Alien2WaitTime
								sta Alien3WaitTime
								sta Alien4WaitTime
								sta Alien5WaitTime
								
								;And also say aliens are not ready to move
								
								sta Alien1Ready
								sta Alien2Ready
								sta Alien3Ready
								sta Alien4Ready
								sta Alien5Ready
								
								;Initialise low + hi byte of alien formation
								
								lda #<Formation01
								sta Alien1MoveX+1
								sta Alien2MoveX+1
								sta Alien3MoveX+1
								sta Alien4MoveX+1
								sta Alien5MoveX+1
								lda #>Formation01
								sta Alien1MoveX+2
								sta Alien2MoveX+2
								sta Alien3MoveX+2
								sta Alien4MoveX+2
								sta Alien5MoveX+2
								lda #<Formation01+$100
								sta Alien1MoveY+1
								sta Alien2MoveY+1
								sta Alien3MoveY+1
								sta Alien4MoveY+1
								sta Alien5MoveY+1
								lda #>Formation01+$100
								sta Alien1MoveY+2
								sta Alien2MoveY+2
								sta Alien3MoveY+2
								sta Alien4MoveY+2
								sta Alien5MoveY+2
								;Init alien bullet wait time also
								lda #0
								sta AlienBulletWaitTime
								ldx #0
								stx FormationPointer1
								stx FormationPointer2
								stx FormationPointer3
								stx FormationPointer4
								stx FormationPointer5
							
								;And disable alien bullet
								
								sta AlienBulletReady
								
								;Reset player shield time
								
								sta FlashShieldDelay
								sta ShieldTime
								sta FlashShieldPointer
								
								;Enable player shield
								lda #1
								sta ShieldActive
;---------------------------------------------------------------------								
;Setup and draw the scoring and status panel to the screen memory
;at BANK #$00 (Use last 4 char rows ($C748 - $C7E7). Also colour
;in the status panel charset.
;---------------------------------------------------------------------
DrawStatusPanel					ldx #$00
DrawStatusLoop					lda ScorePanelScreen,x 
								sta $c748,x
								inx
								cpx #160 ;4 rows x 40 chars = 160 chars 
								bne DrawStatusLoop
								;Paste colour attributes to colours
								ldx #$00
DrawStatColours					ldy $c748,x 			;Read char type
								lda ScorePanelColours,y ;Select colour
								sta $db48,x				;Draw it to char
								inx
								cpx #160 ;4 rows x 40 chars = 160 colours
								bne DrawStatColours								
												
												
;---------------------------------------------------------------------
;Now initialise IRQ interrupts for Non-Kernal, disable RESTORE key in
;order to avoid crashing interrupt code, and also set the background
;multicolour settings for the game (purple, light blue).
;---------------------------------------------------------------------

								ldx #<irq1								
								ldy #>irq1								
								stx $fffe	;IRQ in NON KERNAL								
								sty $ffff								
								ldx #<nmi	;Restore disable								
								ldy #>nmi	;to avoid crashing			
								stx $fffa	;the code.		
								sty $fffb								
								ldx #$04 	;Colour - purple																
								ldy #$0e	;Colour - light blue											
								stx $d022											
								sty $d023											
								lda #$32	;Init raster position start
								sta $d012		
								lda #$7f	;Enable CIA timing for IRQ
								sta $dc0d	;raster interrupt
								
								lda #$01	;Enable synchronized speed	
								sta $d01a	;for IRQ interrupt
								
								lda #$1b	;Enable screen, char mode.		
								sta $d011		
								
								lda #$10		;Initialise ypos for
								sta ypos	;screen scroller
								
								lda SoundOption
								cmp #$01
								beq PlayAtmospherics
								jmp SkipAtmospherics
											
								;Play atmospherical sounds, (tune 2) from
								;Goat Tracker V2.7
PlayAtmospherics				lda #$01
								jsr MusicInit
								
SkipAtmospherics
								cli				;Clear the flag.
;---------------------------------------------------------------------
;Initialise in game pointers, and default position all game sprites.
;this is a new game start after all.
;---------------------------------------------------------------------
								ldx #$00
DefaultSpriteStartPosition		lda SpriteDefaultStartTable,x
								sta objpos,x
								inx
								cpx #16
								bne DefaultSpriteStartPosition
								
								lda #$ff	;Enable all sprites
								sta $d015 
								sta $d01c   ;Same for sprite multicolour
								
								lda #$0b	;Set colour grey
								sta $d025   ;Sprite multicolour 1
								
								lda #$01
								sta $d026   ;Sprite multicolour 2
								
								lda #$00	;Disables the following:
								sta $d01b   ;Sprite behind background
								sta $d017   ;Sprite expansion X
								sta $d01d   ;Sprite expandion Y
								
;---------------------------------------------------------------------
;Main game loop. Synchronize the game timer, and call other subroutines								
;to perform a game engine in place. For example, expand sprite MSB  
;position, scroll background, call player functions, enemy functions, 
;etc. Each JSR has been commented in this area. 
;---------------------------------------------------------------------								
								
GameLoop						;Call subroutine to sync timer to IRQ 
								jsr SyncGameControl 
								;Call subroutine to expand MSB for
								;sprites, and render to hardware.
								jsr ExpandMSB
								
								;Call subroutine to scroll game screen
								jsr ScrollBackground
								;Call subroutine to animate sprites
								jsr AnimateSprites
								;Call subroutine to test player properties
								;and allow / disallow player control
								jsr PlayerProperties
								;Call subroutine to test player bullet
								;properties.
								jsr PlayerBulletProperties
								;Call subroutine to test alien properties
								;and allow / disallow alien control.
								jsr AlienProperties
								;Call subroutine to test alien bullet
								;properties
								jsr AlienBulletProperties
								;Call subroutine to test sprite/sprite
								;collision.
								jsr SpriteToSpriteCollision
								;Call subroutine to render score and lives
								;data to actual screen area in bank #$00
								jsr RenderScoreLives
								
								jmp GameLoop ;Infinite game loop, unless
										     ;a game over event occurs.
;---------------------------------------------------------------------								
;Synchronize the timer of the IRQ with the game code.
;---------------------------------------------------------------------
SyncGameControl					lda #0
								sta SyncDelay
								cmp SyncDelay
								beq *-3
								rts
;---------------------------------------------------------------------								
;Expand the sprite position MSB, so that sprites are rendered to								
;the C64's hardware sprite pos value.								
;---------------------------------------------------------------------								
ExpandMSB						ldx #$00								
ExpandLoop						lda objpos+1,x ;Read y position of sprites								
								sta $d001,x    ;store to hardware SpriteY								
								lda objpos,x   ;Read x position of sprites								
								asl								
								ror $d010      ;Expand position								
								sta $d000,x    ;store to hardware spriteX								
								inx								
								inx								
								cpx #16		   ;Read 16 positions (8xX,8xY)								
								bne ExpandLoop								
								rts								
;---------------------------------------------------------------------
;Setup and control the delay for the smooth scrolling background.														
;A pointer 'ypos' is being used for this instance.														
;---------------------------------------------------------------------								
ScrollBackground							
								lda ydelay  ;Check delay of scroll				
								cmp #$01   ;Delay set to 1?				
								beq OkayToScroll ;Yes				
								inc ydelay  ;Else add next delay				
								rts				
												
											
OkayToScroll												
								lda #$00	;Okay to reset scroll														
								sta ydelay	;delay.
								
								;This is the main control for the
								;smoothness of the screen scroller.
								;which is then set inside a raster
								;split.
								
								;In vertical screen mode, you need to
								;set a correct value of ypos so that
								;it sets as #$10 in scroll mode.
								;This is a shortest possible routine
								;for scrolling control
								
								inc ypos
								lda ypos
								cmp #$18 ;Reached screen on ypos limit	
								bpl DoMainScroll ;Okay to scroll.
								
								rts
DoMainScroll					lda #$10 ;Reset the ypos scroll limit
								sta ypos
																
;---------------------------------------------------------------------
;The hard scroll. For this game, we are using the hard scroll to do
;a char wrapping technique. Basically pick a row from the bottom of
;the screen, then plonk it in place to the top of the screen row and
;keep wrapping around. 
;---------------------------------------------------------------------
DoHardScroll
								
								
;Start with the top half of the screen first.
;This subroutine calls a simple loop, which will take 40
;chars of a screen row, and then place it into the next row
;Char rows 1 - 10 will go one step downwards. Char 10 also should
;be stored into a temporary memory location (set as rowtemp)

fitrows
      							ldx #$27
shiftrows1						lda row10,x		;Pickup row 10
      							sta rowtemp,x   ;then place it to 'rowtemp' pointer
      							lda row9,x		;Grab screen row 9
      							sta row10,x		;then move it one row down ...
      							lda row8,x		;Grab screen row 8
      							sta row9,x		;then move it one row down ...
      							lda row7,x		;Same as before, as each
      							sta row8,x		;row gets moved down to another
      							lda row6,x		;row position. 
      							sta row7,x
      							lda row5,x
      							sta row6,x
     							lda row4,x
      							sta row5,x
      							lda row3,x
      							sta row4,x
      							lda row2,x
      							sta row3,x
      							lda row1,x
      							sta row2,x
      							lda row0,x
      							sta row1,x
    							dex			;Move to next screen char column
      									;40 chars per row read?
      							bpl shiftrows1	;keep doing it until complete.
      							
;Now we do a similar loop routine for the bottom half of the game screen

					   		    ldx #$27
shiftrows2						lda row19,x		;Fetch last row stored, then
								sta row0,x		;place it to the top row...
								lda row18,x		;Fetch row 18 ...
					            sta row19,x		;Store to row 19 ...  etc..
      							lda row17,x     ;(Refer to hitrows subroutine
      							sta row18,x		;if unsure!) ...
      							lda row16,x
      							sta row17,x
      							lda row15,x
      							sta row16,x
      							lda row14,x
      							sta row15,x
      							
      							lda row13,x
      							sta row14,x
      							lda row12,x
      							sta row13,x
      							lda row11,x
      							sta row12,x
      							lda rowtemp,x ;Pick up variable 'rowtemp'
      							sta row11,x   ;place it to the middle row
      							dex			  ;Next char position
      									  ;40 chars read?
      							bpl shiftrows2 ;Loop to shiftrows 2
      							rts			   ;Complete
      							
      							

      							
				
;------------------------------------------------------------      
;Sprite animator subroutine - Sets up animation for player alive,      
;and alien animations.       
;------------------------------------------------------------      
AnimateSprites					lda AnimDelay	;Set interval per      
								cmp #$04		;animation
								beq DoSpriteAnim
								inc AnimDelay
								rts      

DoSpriteAnim					lda #$00		;Reset anim delay								
								sta AnimDelay								
																
								jsr DoAnimPlayer								
								jsr DoAnimAliens								
								rts								

;Animate the player ship frame, and store it to a pointer
;so that every time the player is alive, the ship is animated.

DoAnimPlayer
								ldx PlayerAnimPointer
								lda PlayerShipFrameTable,x
								sta PlayerAnimStore
								inx
								cpx #5 ;Read 5 frames before reset
								beq ResetPlayerAnimFrame
								inc PlayerAnimPointer ;read next frame
								rts
ResetPlayerAnimFrame			ldx #$00
								stx PlayerAnimPointer
								rts

;Animate the alien frame, and store it to a pointer, which
;corresponds to the alien type.

DoAnimAliens					ldx AlienAnimPointer						
								;Read eye alien frame					
								lda Alien1FrameTable,x						
								sta Alien1FrameStore						
								lda Alien2FrameTable,x						
								sta Alien2FrameStore						
								lda Alien3FrameTable,x						
								sta Alien3FrameStore						
								lda Alien4FrameTable,x						
								sta Alien4FrameStore						
								lda Alien5FrameTable,x						
								sta Alien5FrameStore						
								lda Alien6FrameTable,x						
								sta Alien6FrameStore						
								lda Alien7FrameTable,x						
								sta Alien7FrameStore						
								lda Alien8FrameTable,x						
								sta Alien8FrameStore						
								inx						
								cpx #6						
								beq ResetAlienAnim						
								inc AlienAnimPointer						
								rts						
ResetAlienAnim					ldx #$00						
								stx AlienAnimPointer				
								rts						
						
;------------------------------------------------------------						
;Player in game properties. Test whether or not the player						
;ship is alive or has been destroyed by an alien. Set up						
;correct animation, and enable/disable player control, "						
;depending on whether or not the player is alive or not.						
;------------------------------------------------------------						
PlayerProperties			;Permanantly set player bullet frame and
							;set colour to light green.
							
							
							
							lda PlayerBulletFrame	;Fetch value from pointer
							sta $07f9				;Store to hardware sprite1
													;type/frame
													
							lda #$0d				;Colour green						
							sta $d028				;Sprite multicolour						
														
CheckIfPlayerIsDead			lda PlayerIsDead 		;Is player dead?
							cmp #$01		 		;if so. 
							beq PlayerIsDestroyed 	;Destroy player animation.							jmp PlayerIsAlive       ;Player is alive. So jump
													;to the code where player

											
							jmp PlayerIsAlive		;Else player is alive
							
;The player is destroyed - Call animation for player's death.

PlayerIsDestroyed			lda PlayerDeathDelay	;The delay pointer is set
							cmp #$04				;to 4 frames before animation
							beq PlayerDeathAnimOk	;of explosion can take place
							inc PlayerDeathDelay
							rts
PlayerDeathAnimOk			lda #$00				;Reset the delay pointer, in
							sta PlayerDeathDelay	;order to repeat frames at
													;same speed.
													
							ldx PlayerDeathPointer	;Call pointer and frame table							
							lda ExplosionFrame,x	;of actual explosion frame.
							sta $07f8				;Store to hardware sprite 0 type.
							
							lda #$07				;Sprite 0 colour set as yellow
							sta $d027				;for the explosion.
							
							inx						;Read the next frame
							cpx #$08				;until 8 frames are read.
							beq ExplosionFinished	;Call reset of animation frame
							
							inc PlayerDeathPointer	;Move to next frame.
							rts
ExplosionFinished			lda #$00				;The explosion has finished, 
							sta PlayerDeathDelay 	;so reset death delay and pointer
							ldx #$00				;for the player.
							sta PlayerDeathPointer
								
							lda #$00				;Player is alive again
							sta PlayerIsDead
							
							;Decrement amount of lives. 
							dec PlayerLives
							lda PlayerLives
							cmp #$30
							beq GameOver
						
							
							lda #$01
							sta ShieldActive
							lda #$00
							sta ShieldTime
							
							lda PlayerDefaultStartX	;Reposition the player
							sta objpos				;to ghost X + Y starting
							lda PlayerDefaultStartY	;position. Like you would at
							sta objpos+1			;the start of a new game.
							
							
							rts 
							
;The game is over. Remove all of the sprites, and then MASK
;the game over text on to screen.
							
GameOver					
							lda #$00 ;Disable interrupts and sprites
							sta $d015
							
							jsr RenderScoreLives ;Once more render score and
							
							;Now mask the game over screen
							;on to the game screen
							
								lda #$00
								sta SpriteTrigger+1
							ldx #$00
CopyGameOverMatrix			lda GameOverScreen,x
							cmp #$00 ;Check for @ char as map in char pad
							beq GOokay1 ;was filled with '@' for space.
							sta $0400,x
GOokay1						lda GameOverScreen+$100,x
							cmp #$00
							beq GOokay2
							sta $0500,x
GOokay2						lda GameOverScreen+$200,x
							cmp #$00
							beq GOokay3
							sta $0600,x
GOokay3						lda GameOverScreen+$2e8,x
							cmp #$00
							beq GOokay4
							sta $06e8,x
GOokay4						inx
							bne CopyGameOverMatrix
							
							;Now copy player's score to Final Score (Text)							
							ldx #$00
CopyScore					lda PlayerScore,x
							sta FinalScore,x
							inx 
							cpx #$06
							bne CopyScore
							
							;Then check whether or not the player has reached
							;the hiscore.
							
							lda FinalScore
							sec
							lda HiScore+5
							sbc FinalScore+5
							lda HiScore+4
							sbc FinalScore+4
							lda HiScore+3
							sbc FinalScore+3
							lda HiScore+2
							sbc FinalScore+2
							lda HiScore+1
							sbc FinalScore+1
							lda HiScore
							sbc FinalScore
							bpl NoHiScore
							
							;Make player score the highest score
							ldx #$00
MakeNewHiScore				lda FinalScore,x
							sta HiScore,x
							inx
							cpx #$06
							bne MakeNewHiScore
							
NoHiScore					
							lda #0
							sta FireButton ;Initialise firebutton
						
							
WaitToExitGameOver			lda $dc00
							lsr
							lsr
							lsr
							lsr
							lsr
							bit FireButton
							ror FireButton
							bmi WaitToExitGameOver
							bvc WaitToExitGameOver
							jmp TitleScreen
							
;Simple check case subroutine, which automatically encoded text													
;assembled from TASS, becomes standard text on screen. This is linked													
;to the GAME OVER screen message. 													

CheckCharCase				cmp #$3f ;Too high?							
							bcc CharCaseOkay							
							sec							
							sbc #$60 ;Back to C64 lower case							
CharCaseOkay				rts							
														
								
;The player is alive, set the anim frame for the player alive 
;to the hardware - set colour as CYAN. 
PlayerIsAlive				lda PlayerAnimStore 
							sta $07f8 ;Hardware frame for sprite 0
									  ;(player)
							jsr TestPlayerControl					
;Test for player shield being active. If it is active then
;call subroutine to do the shield flashing process.

							lda ShieldActive
							cmp #$01
							beq FlashShield
							jmp RestorePlayerColour
							
							;Time for player shield has elapsed, so make it
							;inactive. So player can be destroyed by aliens.
ShieldStop					lda #$00							
							sta ShieldActive							
							rts							
							;Flash the player sprite with the shield flash
							;properties
FlashShield					lda ShieldTime 
							cmp #200
							beq ShieldStop
							inc ShieldTime
							lda FlashShieldDelay							
							cmp #$02							
							beq FlashShieldOkay							
							inc FlashShieldDelay							
							rts							
FlashShieldOkay				lda #$00										
							sta FlashShieldDelay										
							ldx FlashShieldPointer										
							lda FlashShieldColour,x										
							sta $d027										
							inx										
							cpx #$08										
							beq ResetShieldColours										
							inc FlashShieldPointer										
							rts										
ResetShieldColours			ldx #$00
							stx FlashShieldPointer
							rts
														
RestorePlayerColour							
							lda #$03  ;Colour cyan
							sta $d027 ;Hardware colour frame for sprite 0
							rts
;Control player, using a joystick in port 2
TestPlayerControl
							lda #1		;Value for up
							bit $dc00	;Joy movement detected?
							bne CheckDown ;No, check down.
							jsr MovePlayerUp ;Call subroutine to move player up
							
CheckDown					lda #2		;Value for down
							bit $dc00	;(See above)
							bne CheckLeft ;No, check left
							jsr MovePlayerDown ;Call subroutine to move player down
							
CheckLeft					lda #4		;Value for left					
							bit $dc00	;Joy movement?					
							bne CheckRight; No, check right						
							jsr MovePlayerLeft	;Call subroutine to move player left	
								
CheckRight					lda #8		;Value for right		
							bit $dc00	;Joy movement?	
							bne CheckFire ;No check for fire button		
							jsr MovePlayerRight	 ;Call subroutine to move player right
							
CheckFire					lda #16		;Value for fire
							bit $dc00	;Joy movement? / Button pressed?
							bne ControlIdle ;Joystick not used / Control is idle
							;Check whether or not the bullet is allowed to fired.
							;basically is the bullet offset?
							lda objpos+$02 ;X position for sprite 2
							cmp #$00	   ;Positioned outside the border
							beq RespawnBullet ;Bullet is offset okay to respawn
ControlIdle				
							 ;Bullet can still move.							
							rts		
;Respawn bullet on to the player's ship							
RespawnBullet				
											
							lda objpos	;Read player X position
							sta objpos+2;Store bullet X position
							lda objpos+1 ;Read player Y position
							sta objpos+3;Store bullet Y position
							lda SoundOption
							cmp #1
							bne NotPlayerFireSFX
							lda #<PlayerFireSFX
							ldy #>PlayerFireSFX
							ldx #07 ;Channel
							jsr SFXPlay
NotPlayerFireSFX							
							rts			;job done
							
;Test Bullet properties.							
;Otherwise, just move the bullet upwards
PlayerBulletProperties
							lda objpos+3
							sec
							sbc #$07 ;Speed of bullet chosen
							cmp #$22 ;Below position $2a (Out of screen)
							bcs BulletMoving
							lda #$00 	   ;Place player bullet out of screen
							sta objpos+2 ;Move bullet inside border
							
BulletMoving				sta objpos+3							
							rts						
							
							
;Move player upwards, until reached TOP most position							
							
MovePlayerUp				lda objpos+1 ;Read player Y position							
							sec							
							sbc #2       ;Speed of Y position
							cmp #PlayerUpStopPosition ;Reached upper stop position
							bcs ForceUpPosition		  ;not quite ...
							lda #PlayerUpStopPosition ;Force upper stop position
ForceUpPosition				sta objpos+1			  ;store player's new Y position
							rts							
														
;Move player downwards, until reached BOTTOM most position							

MovePlayerDown				lda objpos+1 ;Read player Y position again							
							clc							
							adc #2		 ;Speed of Y position for player					
							cmp #PlayerDownStopPosition	;Reached lower stop position						
							bcc ForceDownPosition		;not quite ...
							lda #PlayerDownStopPosition	;Force lower stop position						
ForceDownPosition			sta objpos+1				;store player's new Y position
							rts							
														
;Move player to the left, until reached LEFT most position							

MovePlayerLeft				lda objpos	;Read player X position						
							sec			
							sbc #1		;Speed of X position for player					
							cmp #PlayerLeftStopPosition	;Reached left most stop position		
							bcs ForceLeftPosition		;not quite ...					
							lda #PlayerLeftStopPosition	;Force left most stop position						
ForceLeftPosition			sta objpos					;store player's new X position		
							rts							
														
;Move player to the right, until reached RIGHT most position							

MovePlayerRight				lda objpos	;Read player X position						
							clc							
							adc #1		;Speed of X position for player					
							cmp #PlayerRightStopPosition	;Reached right most stop position						
							bcc ForceRightPosition			;not quite ...				
							lda #PlayerRightStopPosition	;Force right most stop position						
ForceRightPosition			sta objpos						;store player's new X position	
							rts							
							
;------------------------------------------------------------							
;Setup alien properties. Each item should take effect on							
;each alien. Code can be repeated several times. Although
;it would be much easier to generate .macro routines to make
;typing of each subroutine shorter. 
;------------------------------------------------------------							

AlienProperties			
							jsr TestAlien1 ;Call subroutine to test alien 1
							jsr TestAlien2 ;Call subroutine to test alien 2
							jsr TestAlien3 ;Call subroutine to test alien 3
							jsr TestAlien4 ;Call subroutine to test alien 4
							jsr TestAlien5 ;Call subroutine to test alien 5
							jsr TestRespawn ;Call subroutine to test alien respawn
							rts
							
							
;-------------------------------------------------------------------------							
;This routine will detect whether or not an alien is active. If it isn't							
;then a subroutine, zero positions the alien and forces it to offset, until							
;the delay has finished. This code is similar to the one I provided with							
;Zap Zone :) 							
;--------------------------------------------------------------------------							
;Code corresponds to ALIEN 1							
;--------------------------------------------------------------------------							
TestAlien1					lda Alien1IsDead
							cmp #$01
							beq DoAlien1DeathSequence
							jmp Alien1IsNotDead
;Alien is currently dead, so destrouy it, by setting explosion colour
;to yellow, and also animate the explosion sequence.

DoAlien1DeathSequence		lda Alien1ExplosionDelay	;Short delay							
							cmp #$02					;to get frame rate
							beq Alien1ExplosionDelayExpired	;for animation						
							inc Alien1ExplosionDelay							
							rts							
Alien1ExplosionDelayExpired							
							lda #$00					;reset short frame rate		
							sta Alien1ExplosionDelay							
							ldx Alien1ExplosionPointer	;Call pointer in order						
							lda ExplosionFrame,x		;to display the explosion					
							sta $07fa					;and place to sprite 2's frame		
							lda #$07					;also set sprite 2's colour		
							sta $d029					;to yellow.		
							inx							
							cpx #$08					;8 frames per animation		
							beq FinishAlienExplosion1	;Explosion finished?						
							inc Alien1ExplosionPointer	;Not yet.						
							rts							
FinishAlienExplosion1		ldx #$00					;Reset explosion pointer		
							stx Alien1ExplosionPointer							
							lda #0						;Remove alien from screen
							sta objpos+4				;into the border position
							sta objpos+5
							lda #1						;Place alien offset	
							sta Alien1Offset							
							lda #0						;Alien is not ready	
							sta Alien1Ready							
							sta Alien1IsDead			;Also is not dead now				
							rts							
														
							
Alien1IsNotDead
							
							lda Alien1Offset
							cmp #$01
							bne Alien1NotOffset
							lda #0
							sta objpos+4
							sta objpos+5
							rts
Alien1NotOffset				lda Alien1Ready ;Is alien 1 ready to be active
							cmp #$01		
							bne Alien1NotActivated ;No
							jmp Alien1IsActivated
Alien1NotActivated			jsr HoldAlien1  ;No, just call wait subroutine!
							
							rts

;Alien 1 is active so allow it to move according to picked formation. 
Alien1IsActivated 
;Set animation object and colour for alien type.
Alien1Type					lda Alien1FrameStore
							sta $07fa 	;Store to sprite 2 hardware frame
SetAlien1Colour				lda #5
							sta $d029	;Store to sprite 2 hardware colour
							
;As we have done before with Zap Zone. Read the X and Y position							
;from the Alien Formation table, and then store it to alien 1's							
;X and Y sprite position. 							

Alien1MoveX					lda Formation01 ;Self-modifying 							
							sta objpos+4	;Force to alien position X							
Alien1MoveY					lda Formation01+$100 ;Read the Y position table							
							sta objpos+5							

;Increment lo+hi byte of self-mod pointers 					
;so that the next byte from the formation table							
;is read. Until it is complete							
													
							inc Alien1MoveX+1 ;Increment lo-byte							
							inc Alien1MoveY+1 ;Increment hi-byte							
							lda Alien1MoveX+1 ;Resets?							
							beq EndFormation1 ;Yes, end formation.							
							rts							
														
;We now officially know that the alien formation is complete for							
;our chosen alien. So now, force the alien to offset mode.							

EndFormation1							
							lda #$01							
							sta Alien1Offset							
							lda #$00							
							sta Alien1Ready							
							rts							
														
;The chosen alien is not ready to released, so keep the alien														
;offset before it gets released into the game area. Also zero														
;both the X and Y position of the held back sprite.														

HoldAlien1					lda #0														
							sta objpos+4	;Keep alien x,y 														
							sta objpos+5	;position to zero									
							lda Alien1WaitTime									
							cmp #Alien1Interval		;Time has elapsed?									
							beq LaunchAlien1									
							inc Alien1WaitTime ;Else wait for time out									
													
							rts									
											
;Time out - Alien can now be unleashed.				
LaunchAlien1
							lda #0				
							sta Alien1Offset				
							lda #1				
							sta Alien1Ready			
							rts				
														
;--------------------------------------------------------------------------							
;Code corresponds to ALIEN 2							
;--------------------------------------------------------------------------							
TestAlien2				
							lda Alien2IsDead
							cmp #$01
							beq DoAlien2DeathSequence
							jmp Alien2IsNotDead
;Alien is currently dead, so destrouy it, by setting explosion colour
;to yellow, and also animate the explosion sequence.

DoAlien2DeathSequence		lda Alien2ExplosionDelay	;Short delay							
							cmp #$02					;to get frame rate
							beq Alien2ExplosionDelayExpired	;for animation						
							inc Alien2ExplosionDelay							
							rts							
Alien2ExplosionDelayExpired							
							lda #$00					;reset short frame rate		
							sta Alien2ExplosionDelay							
							ldx Alien2ExplosionPointer	;Call pointer in order						
							lda ExplosionFrame,x		;to display the explosion					
							sta $07fb					;and place to sprite 3's frame		
							lda #$07					;also set sprite 3's colour		
							sta $d02a					;to yellow.		
							inx							
							cpx #$08					;8 frames per animation		
							beq FinishAlienExplosion2	;Explosion finished?						
							inc Alien2ExplosionPointer	;Not yet.						
							rts							
FinishAlienExplosion2		ldx #$00					;Reset explosion pointer		
							stx Alien2ExplosionPointer							
							lda #0
							sta objpos+6
							sta objpos+7							
							lda #1						;Place alien offset	
							sta Alien2Offset							
							lda #0						;Alien is not ready	
							sta Alien2Ready							
							sta Alien2IsDead			;Also is not dead now				
							rts							
Alien2IsNotDead														
							lda Alien2Offset
							cmp #$01
							bne Alien2NotOffset
							lda #0
							sta objpos+6
							sta objpos+7
							rts
Alien2NotOffset				lda Alien2Ready ;Is alien 2 ready to be active
							cmp #$01		
							bne Alien2NotActivated ;No
							jmp Alien2IsActivated
Alien2NotActivated			jsr HoldAlien2  ;No, just call wait subroutine!
							
							rts

;Alien 1 is active so allow it to move according to picked formation. 
Alien2IsActivated 
;Set animation object and colour for alien type.
Alien2Type					lda Alien1FrameStore
							sta $07fb 	;Store to sprite 3 hardware frame
SetAlien2Colour				lda #5
							sta $d02a	;Store to sprite 3 hardware colour
							
;As we have done before with Zap Zone. Read the X and Y position							
;from the Alien Formation table, and then store it to alien 1's							
;X and Y sprite position. 							

Alien2MoveX					lda Formation01 ;Self-modifying 							
							sta objpos+6	;Force to alien position X							
Alien2MoveY					lda Formation01+$100 ;Read the Y position table							
							sta objpos+7							

;Increment lo+hi byte of self-mod pointers 					
;so that the next byte from the formation table							
;is read. Until it is complete							
													
							inc Alien2MoveX+1 ;Increment lo-byte							
							inc Alien2MoveY+1 ;Increment hi-byte							
							lda Alien2MoveX+1 ;Resets?							
							beq EndFormation2 ;Yes, end formation.							
							rts							
														
;We now officially know that the alien formation is complete for							
;our chosen alien. So now, force the alien to offset mode.							

EndFormation2							
							lda #$01							
							sta Alien2Offset							
							lda #$00							
							sta Alien2Ready							
							rts							
														
;The chosen alien is not ready to released, so keep the alien														
;offset before it gets released into the game area. Also zero														
;both the X and Y position of the held back sprite.														

HoldAlien2					lda #0														
							sta objpos+6	;Keep alien x,y 														
							sta objpos+7	;position to zero									
							lda Alien2WaitTime									
							cmp #Alien2Interval	;Time has elapsed?									
							beq LaunchAlien2									
							inc Alien2WaitTime ;Else wait for time out									
													
							rts									
											
;Time out - Alien can now be unleashed.				
LaunchAlien2
							lda #0				
							sta Alien2Offset				
							lda #1				
							sta Alien2Ready			
							rts				
			 							
;--------------------------------------------------------------------------							
;Code corresponds to ALIEN 3							
;--------------------------------------------------------------------------							
TestAlien3					lda Alien3IsDead
							cmp #$01
							beq DoAlien3DeathSequence
							jmp Alien3IsNotDead
;Alien is currently dead, so destrouy it, by setting explosion colour
;to yellow, and also animate the explosion sequence.

DoAlien3DeathSequence		lda Alien3ExplosionDelay	;Short delay							
							cmp #$02					;to get frame rate
							beq Alien3ExplosionDelayExpired	;for animation						
							inc Alien3ExplosionDelay							
							rts							
Alien3ExplosionDelayExpired							
							lda #$00					;reset short frame rate		
							sta Alien3ExplosionDelay							
							ldx Alien3ExplosionPointer	;Call pointer in order						
							lda ExplosionFrame,x		;to display the explosion					
							sta $07fc					;and place to sprite 4's frame		
							lda #$07					;also set sprite 4's colour		
							sta $d02b					;to yellow.		
							inx							
							cpx #$08					;8 frames per animation		
							beq FinishAlienExplosion3	;Explosion finished?						
							inc Alien3ExplosionPointer	;Not yet.						
							rts							
FinishAlienExplosion3		ldx #$00					;Reset explosion pointer		
							stx Alien3ExplosionPointer							
							lda #0
							sta objpos+8				;Move alien out
							sta objpos+9							
							lda #1						;Place alien offset	
							sta Alien3Offset							
							lda #0						;Alien is not ready	
							sta Alien3Ready							
							sta Alien3IsDead			;Also is not dead now				
							rts							
Alien3IsNotDead																
							lda Alien3Offset
							cmp #$01
							bne Alien3NotOffset
							lda #0
							sta objpos+8
							sta objpos+9
							rts
Alien3NotOffset				lda Alien3Ready ;Is alien 1 ready to be active
							cmp #$01		
							bne Alien3NotActivated ;No
							jmp Alien3IsActivated
Alien3NotActivated			jsr HoldAlien3  ;No, just call wait subroutine!
							
							rts

;Alien 1 is active so allow it to move according to picked formation. 
Alien3IsActivated 
;Set animation object and colour for alien type.
Alien3Type					lda Alien1FrameStore
							sta $07fc 	;Store to sprite 4 hardware frame
SetAlien3Colour				lda #5
							sta $d02b	;Store to sprite 4 hardware colour
							
;As we have done before with Zap Zone. Read the X and Y position							
;from the Alien Formation table, and then store it to alien 3's							
;X and Y sprite position. 							

Alien3MoveX					lda Formation01 ;Self-modifying 							
							sta objpos+8	;Force to alien position X							
Alien3MoveY					lda Formation01+$100 ;Read the Y position table							
							sta objpos+9							

;Increment lo+hi byte of self-mod pointers 					
;so that the next byte from the formation table							
;is read. Until it is complete							
													
							inc Alien3MoveX+1 ;Increment lo-byte							
							inc Alien3MoveY+1 ;Increment hi-byte							
							lda Alien3MoveX+1 ;Resets?							
							beq EndFormation3 ;Yes, end formation.							
							rts							
														
;We now officially know that the alien formation is complete for							
;our chosen alien. So now, force the alien to offset mode.							

EndFormation3							
							lda #$01							
							sta Alien3Offset							
							lda #$00							
							sta Alien3Ready							
							rts							
														
;The chosen alien is not ready to released, so keep the alien														
;offset before it gets released into the game area. Also zero														
;both the X and Y position of the held back sprite.														

HoldAlien3					lda #0														
							sta objpos+8	;Keep alien x,y 														
							sta objpos+9	;position to zero									
							lda Alien3WaitTime									
							cmp #Alien3Interval	;Time has elapsed?									
							beq LaunchAlien3									
							inc Alien3WaitTime ;Else wait for time out									
													
							rts									
											
;Time out - Alien can now be unleashed.				
LaunchAlien3
							lda #0				
							sta Alien3Offset				
							lda #1				
							sta Alien3Ready			
							rts				
										
;--------------------------------------------------------------------------							
;Code corresponds to ALIEN 4							
;--------------------------------------------------------------------------							
TestAlien4					lda Alien4IsDead
							cmp #$01
							beq DoAlien4DeathSequence
							jmp Alien4IsNotDead
;Alien is currently dead, so destrouy it, by setting explosion colour
;to yellow, and also animate the explosion sequence.

DoAlien4DeathSequence		lda Alien4ExplosionDelay	;Short delay							
							cmp #$02					;to get frame rate
							beq Alien4ExplosionDelayExpired	;for animation						
							inc Alien4ExplosionDelay							
							rts							
Alien4ExplosionDelayExpired							
							lda #$00					;reset short frame rate		
							sta Alien4ExplosionDelay							
							ldx Alien4ExplosionPointer	;Call pointer in order						
							lda ExplosionFrame,x		;to display the explosion					
							sta $07fd					;and place to sprite 5's frame		
							lda #$07					;also set sprite 5's colour		
							sta $d02c					;to yellow.		
							inx							
							cpx #$08					;8 frames per animation		
							beq FinishAlienExplosion4	;Explosion finished?						
							inc Alien4ExplosionPointer	;Not yet.						
							rts							
FinishAlienExplosion4		ldx #$00					;Reset explosion pointer		
							stx Alien4ExplosionPointer							
							lda #0
							sta objpos+10
							sta objpos+11		
							lda #1						;Place alien offset	
							sta Alien4Offset							
							lda #0						;Alien is not ready	
							sta Alien4Ready							
							sta Alien4IsDead			;Also is not dead now				
							rts							
Alien4IsNotDead														
							lda Alien4Offset
							cmp #$01
							bne Alien4NotOffset
							lda #0
							sta objpos+10
							sta objpos+11
							rts
Alien4NotOffset				lda Alien4Ready ;Is alien 4 ready to be active
							cmp #$01		
							bne Alien4NotActivated ;No
							jmp Alien4IsActivated
Alien4NotActivated			jsr HoldAlien4  ;No, just call wait subroutine!
							
							rts

;Alien 1 is active so allow it to move according to picked formation. 
Alien4IsActivated 
;Set animation object and colour for alien type.
Alien4Type					lda Alien1FrameStore
							sta $07fd	;Store to sprite 5 hardware frame
SetAlien4Colour				lda #5
							sta $d02c	;Store to sprite 5 hardware colour
							
;As we have done before with Zap Zone. Read the X and Y position							
;from the Alien Formation table, and then store it to alien 4's							
;X and Y sprite position. 							

Alien4MoveX					lda Formation01 ;Self-modifying 							
							sta objpos+10	;Force to alien position X							
Alien4MoveY					lda Formation01+$100 ;Read the Y position table							
							sta objpos+11							

;Increment lo+hi byte of self-mod pointers 					
;so that the next byte from the formation table							
;is read. Until it is complete							
													
							inc Alien4MoveX+1 ;Increment lo-byte							
							inc Alien4MoveY+1 ;Increment hi-byte							
							lda Alien4MoveX+1 ;Resets?							
							beq EndFormation4 ;Yes, end formation.							
							rts							
														
;We now officially know that the alien formation is complete for							
;our chosen alien. So now, force the alien to offset mode.							

EndFormation4							
							lda #$01							
							sta Alien4Offset							
							lda #$00							
							sta Alien4Ready							
							rts							
														
;The chosen alien is not ready to released, so keep the alien														
;offset before it gets released into the game area. Also zero														
;both the X and Y position of the held back sprite.														

HoldAlien4					lda #0														
							sta objpos+10	;Keep alien x,y 														
							sta objpos+11	;position to zero									
							lda Alien4WaitTime									
							cmp #Alien4Interval;Time has elapsed?									
							beq LaunchAlien4									
							inc Alien4WaitTime ;Else wait for time out									
													
							rts									
											
;Time out - Alien can now be unleashed.				
LaunchAlien4
							lda #0				
							sta Alien4Offset				
							lda #1				
							sta Alien4Ready			
							rts				
								
;--------------------------------------------------------------------------							
;Code corresponds to ALIEN 5 - The last part of the alien spawn test							
;--------------------------------------------------------------------------							
TestAlien5					lda Alien5IsDead
							cmp #$01
							beq DoAlien5DeathSequence
							jmp Alien5IsNotDead
;Alien is currently dead, so destrouy it, by setting explosion colour
;to yellow, and also animate the explosion sequence.

DoAlien5DeathSequence		lda Alien5ExplosionDelay	;Short delay							
							cmp #$02					;to get frame rate
							beq Alien5ExplosionDelayExpired	;for animation						
							inc Alien5ExplosionDelay							
							rts							
Alien5ExplosionDelayExpired							
							lda #$00					;reset short frame rate		
							sta Alien5ExplosionDelay							
							ldx Alien5ExplosionPointer	;Call pointer in order						
							lda ExplosionFrame,x		;to display the explosion					
							sta $07fe					;and place to sprite 6's frame		
							lda #$07					;also set sprite 6's colour		
							sta $d02d					;to yellow.		
							inx							
							cpx #$08					;8 frames per animation		
							beq FinishAlienExplosion5	;Explosion finished?						
							inc Alien5ExplosionPointer	;Not yet.						
							rts							
FinishAlienExplosion5		ldx #$00					;Reset explosion pointer		
							stx Alien5ExplosionPointer							
							lda #0
							sta objpos+12
							sta objpos+13							
							lda #1						;Place alien offset	
							sta Alien5Offset							
							lda #0						;Alien is not ready	
							sta Alien5Ready							
							sta Alien5IsDead			;Also is not dead now				
							rts							
Alien5IsNotDead														
							lda Alien5Offset
							cmp #$01
							bne Alien5NotOffset
							lda #0
							sta objpos+12
							sta objpos+13
							rts
Alien5NotOffset				lda Alien5Ready ;Is alien 5 ready to be active
							cmp #$01		
							bne Alien5NotActivated ;No
							jmp Alien5IsActivated
Alien5NotActivated			jsr HoldAlien5  ;No, just call wait subroutine!
							
							rts

;Alien 1 is active so allow it to move according to picked formation. 
Alien5IsActivated 
;Set animation object and colour for alien type.
Alien5Type					lda Alien1FrameStore
							sta $07fe	;Store to sprite 2 hardware frame
SetAlien5Colour				lda #5
							sta $d02d	;Store to sprite 2 hardware colour
							
;As we have done before with Zap Zone. Read the X and Y position							
;from the Alien Formation table, and then store it to alien 5's							
;X and Y sprite position. 							

Alien5MoveX					lda Formation01 ;Self-modifying 							
							sta objpos+12	;Force to alien position X							
Alien5MoveY					lda Formation01+$100 ;Read the Y position table							
							sta objpos+13							

;Increment lo+hi byte of self-mod pointers 					
;so that the next byte from the formation table							
;is read. Until it is complete							
													
							inc Alien5MoveX+1 ;Increment lo-byte							
							inc Alien5MoveY+1 ;Increment hi-byte							
							lda Alien5MoveX+1 ;Resets?							
							beq EndFormation5 ;Yes, end formation.							
							rts							
														
;We now officially know that the alien formation is complete for							
;our chosen alien. So now, force the alien to offset mode.							

EndFormation5							
							lda #$01							
							sta Alien5Offset							
							lda #$00							
							sta Alien5Ready							
							rts							
														
;The chosen alien is not ready to released, so keep the alien														
;offset before it gets released into the game area. Also zero														
;both the X and Y position of the held back sprite.														

HoldAlien5					lda #0														
							sta objpos+12	;Keep alien x,y 														
							sta objpos+13	;position to zero									
							lda Alien5WaitTime									
							cmp #Alien5Interval			;Time has elapsed?									
							beq LaunchAlien5									
							inc Alien5WaitTime ;Else wait for time out									
													
							rts									
											
;Time out - Alien can now be unleashed.				
LaunchAlien5
							lda #0				
							sta Alien5Offset				
							lda #1				
							sta Alien5Ready			
							rts				
	
														
;------------------------------------------------------------																																	
;Test for alien respawn (Like with Zap Zone)																																																																		
;Call a loop to check whether or not all of the aliens are																															
;off set. If so, respawn them.																															
;------------------------------------------------------------
TestRespawn					ldx #$00																															
CheckIfOffset				lda Alien1Offset,x																															
							cmp #$01																															
							bne NotAllOffset																															
							inx																															
							cpx #$05		;Check 5 sets 																													
							bne CheckIfOffset																															
							jmp Respawn																											
NotAllOffset				rts																											

;Respawn the aliens, by zero pointers. Also reset pointers for alien																											
;bullets.																											
Respawn						lda #0																											
							sta Alien1Offset																											
							sta Alien2Offset																											
							sta Alien3Offset																											
							sta Alien4Offset																											
							sta Alien5Offset																											
							sta Alien1Ready																											
							sta Alien2Ready																											
							sta Alien3Ready																											
							sta Alien4Ready																											
							sta Alien5Ready																											
							sta Alien1WaitTime																											
							sta Alien2WaitTime																											
							sta Alien3WaitTime																											
							sta Alien4WaitTime																											
							sta Alien5WaitTime																											
							sta AlienBulletWaitTime																											
							sta AlienBulletReady																											
;Now select the table for the next group of sprites																								
																								
							;Just for fun, use a single byte zeropage randomizer
							;and store the value to the TableSelect pointer
							;so that the player least expects which alien formation
							;will come on screen.
							
							;ldx $a2
							;stx $d020
							;and #15 ;Max no of bytes to read = 16 (0 - 15)
							;stx TableSelect
							
							jsr RandomTable ;Subr. to randomize table
							jsr RespawnMain ;Then do respawn of aliens
							rts
RandomTable							
							ldx RandCounter
							lda RandAlienTable,x
							sta TableSelect
							inx
							cpx #RandAlienTableEnd-RandAlienTable ;Reached end of table
							beq Finished						  ;... Yes ... Reset.
							inc RandCounter						  ;Move to next byte on table
							rts
Finished					ldx #0
							stx RandCounter
							rts
							
RespawnMain					;After randomly selecting the next alien from the
							;byte table - Spawn it.
							
							ldx TableSelect																								
							lda AlienFrameSelectLowTable,x																						
							sta Alien1Type+1																						
							sta Alien2Type+1																						
							sta Alien3Type+1																						
							sta Alien4Type+1																						
							sta Alien5Type+1																						
							lda AlienFrameSelectHiTable,x																						
							sta Alien1Type+2																						
							sta Alien2Type+2																						
							sta Alien3Type+2																						
							sta Alien4Type+2																						
							sta Alien5Type+2																						
							lda AlienColourSelectTable,x																						
							sta SetAlien1Colour+1																						
							sta SetAlien2Colour+1																						
							sta SetAlien3Colour+1																						
							sta SetAlien4Colour+1																						
							sta SetAlien5Colour+1																						
							lda AlienFormationXSelectLowTable,x																						
							sta Alien1MoveX+1																						
							sta Alien2MoveX+1																						
							sta Alien3MoveX+1																						
							sta Alien4MoveX+1																						
							sta Alien5MoveX+1																						
							lda AlienFormationXSelectHiTable,x																						
							sta Alien1MoveX+2																						
							sta Alien2MoveX+2																						
							sta Alien3MoveX+2																						
							sta Alien4MoveX+2																						
							sta Alien5MoveX+2																						
							lda AlienFormationYSelectLowTable,x																						
							sta Alien1MoveY+1																						
							sta Alien2MoveY+1																						
							sta Alien3MoveY+1																						
							sta Alien4MoveY+1																						
							sta Alien5MoveY+1																						
							lda AlienFormationYSelectHiTable,x																						
							sta Alien1MoveY+2																						
							sta Alien2MoveY+2																						
							sta Alien3MoveY+2																						
							sta Alien4MoveY+2																						
							sta Alien5MoveY+2																						
							;																							
							rts																									
																											
;------------------------------------------------------------																											
;Test alien bullet firing. Basically, if the bullet is still																											
;moving on screen - let it continue to do so. Otherwise, if																											
;it has left the screen. Force a new bullet on to an alien																											
;that is not offset or dead, and is alive and visible.																											
;------------------------------------------------------------																											

AlienBulletProperties		;Permanant colour + frame for bullet 

							lda AlienBulletFrame ;Store alien bullet frame																									
							sta $07ff 			 ;to sprite type 7															
							lda #$07		     ;Make yellow 															
							sta $d02e			 ;and force to sprite colour 7															
																						
							;Check the bullet to see whether or not it is 															
							;released. If not, do the bullet count up process.															
																						
							lda AlienBulletReady															
							cmp #$01															
							bne AlienBulletNotReady															
							jmp AlienBulletIsReady															
																					
;The alien bullet is not quite ready to be fired. To make things fairer, time 
;the bullet to a set period, before it is ready to be launched by the aliens. 

AlienBulletNotReady			lda AlienBulletWaitTime 
							cmp #10 ;Should be enough here
							beq AlienBulletOkayForRelease
							inc AlienBulletWaitTime
							rts
AlienBulletOkayForRelease   lda #$00
							sta AlienBulletWaitTime
							jsr SelectNextAlienToFire
							lda #$01
							sta AlienBulletReady
							rts
																
AlienBulletIsReady																																
							lda objpos+15	;Read Y position of alien bullet (Sprite 7)																											
							clc																											
							adc #4 ;Bullet speed																											
							cmp #$bc ;Expiry position before goes outside background																										
							bcc NotReachedOverYet																											
							;Bullet has reached maximum position. 																											
							;Remove, and disable the bullet for a period of																											
							;time																											
							lda #$00																											
							sta objpos+14 ;X-position of bullet outside border																											
							sta objpos+15 ;Y-position of bullet outside border																											
							sta AlienBulletWaitTime ;Timer init before releasing next bullet																											
							sta AlienBulletReady	   ;Alien bullet not ready.																											
							rts																									
NotReachedOverYet			sta objpos+15	;Store Y position of alien bullet (Sprite 7)																											
							rts																											
																																		
;Bullet has reached past its bottom most position. Remove the bullet from the																																		
;screen. 																																		
																																									
SelectNextAlienToFire		lda #0																																		
							sta objpos+14																																		
							sta objpos+15																																		
																																								
;Now call subroutine to randomly select which alien should fire next.																																		
;Then check whether or not the alien selected is alive / moving, and is																																		
;not set to offset or dead. Also do not allow to fire bullets where																															
;aliens are not visible.																															

RetryEnemyFireSelect
							jsr BulletRandomizer																																		
																																									
							lda AlienBulletSelected ;Which alien has been nominated to fire?
							cmp #$01				;Alien 1?
							bne NotAlien1Selected   ;No?
							jmp CheckAlien1Available ;Check if alien is available
							
NotAlien1Selected			cmp #$02         		;Alien 2? 
							bne NotAlien2Selected   ;No?
							jmp CheckAlien2Available ;Check if alien 2 is available
							
NotAlien2Selected			cmp #$03				;Alien 3? 
			 				bne NotAlien3Selected	;No?
							jmp CheckAlien3Available ;Check if alien 3 is available
							
NotAlien3Selected			cmp #$04				;Alien 4?
							bne NotAlien4Selected	;No?
							jmp CheckAlien4Available ;Check if alien 4 is available
							
NotAlien4Selected			cmp #$05				;Alien 5?
							bne NotAlien5Selected	;No?
							jmp CheckAlien5Available ;Check if alien 5 is available
							
NotAlien5Selected			rts						;No aliens selected.	

;Check if each alien is alive or visible, in order to place a 	
;bullet on to the selected alien.	

CheckAlien1Available		lda Alien1IsDead	;Is alien 1 dead?	
							cmp #$01			
							beq CannotFire1		;Yes, it cannot shoot
							lda Alien1Offset	;Is alien 1 offset?
							cmp #$01			;Yes, it cannot shoot
							beq CannotFire1	
							lda Alien1Ready		;Is alien ready?
							cmp #$01			
							beq CanTestFire1	;Yes, it can test fire
CannotFire1					rts					;Else cannot fire at all

;Check the range of the alien position. If it is above the border. Ignore
;alien firing.

CanTestFire1				lda objpos+5 ;Ready Y position of alien sprite				
							cmp #$3a     ;Set min position where alien can shoot				
							bcc Alien1CannotShoot ;Else alien 1 cannot fire.				
																		
							lda objpos+4 ;Read X position of alien 1 sprite 				
							sta objpos+14 ;Store X position of bullet to alien				
							lda objpos+5 ;Read Y position of alien 1 sprite				
							sta objpos+15 ;Store Y position of bullet to alien				
							jsr TestAlienShootSFX				
Alien1CannotShoot			rts			 ;Job is done.				

											
CheckAlien2Available		lda Alien2IsDead											
							cmp #$01											
							beq CannotFire2											
							lda Alien2Offset											
							cmp #$01											
							beq CannotFire2											
							lda Alien2Ready											
							cmp #$01											
							beq CanTestFire2											
CannotFire2					rts											

CanTestFire2				lda objpos+7											
							cmp #$3a											
							bcc Alien2CannotShoot											
																		
							lda objpos+6											
							sta objpos+14											
							lda objpos+7											
							sta objpos+15											
							jsr TestAlienShootSFX											
Alien2CannotShoot			rts											
																		
CheckAlien3Available		lda Alien3IsDead											
							cmp #$01											
							beq CannotFire3											
							lda Alien3Offset											
							cmp #$01											
							beq CannotFire3											
							lda Alien3Ready											
							cmp #$01											
							beq CanTestFire3											
CannotFire3					rts											

CanTestFire3				lda objpos+9						
							cmp #$3a
							bcc Alien3CannotShoot
							
							lda objpos+8
							sta objpos+14
							lda objpos+9
							sta objpos+15
							jsr TestAlienShootSFX
Alien3CannotShoot			rts
							
CheckAlien4Available		lda Alien4IsDead
							cmp #$01
							beq CannotFire4
							lda Alien4Offset
							cmp #$01
							beq CannotFire4
							lda Alien4Ready
							cmp #$01
							beq CanTestFire4
CannotFire4					rts

CanTestFire4				lda objpos+11
							cmp #$3a
							bcc Alien4CannotShoot
							
							lda objpos+10
							sta objpos+14
							lda objpos+11
							sta objpos+15
							jsr TestAlienShootSFX
Alien4CannotShoot			rts
							
CheckAlien5Available		lda Alien5IsDead
							cmp #$01
							beq CannotFire5
							lda Alien5Offset
							cmp #$01
							beq CannotFire5
							lda Alien5Ready
							cmp #$01
							beq CanTestFire5
CannotFire5					rts

CanTestFire5				lda objpos+13
							cmp #$3a
							bcs Alien5CannotShoot
							lda objpos+12
							sta objpos+14
							lda objpos+13
							sta objpos+15
							jsr TestAlienShootSFX
Alien5CannotShoot			rts																				
																																		
TestAlienShootSFX			lda SoundOption 	;Check if sfx								
							cmp #$01			;enabled.			
							bne NoAlienShootSFX																						
							lda #<AlienShootSFX																						
							ldy #>AlienShootSFX																						
							ldx #14																				
							jsr SFXPlay												
NoAlienShootSFX
;------------------------------------------------------------																											
;Randomizer subroutine to select which alien should fire																											
;the bullet. This is called after the alien bullet is offset																																																
;and when it it okay for the next alien to fire a bullet																																																
;downwards.																																																
;------------------------------------------------------------																																																
																																																
BulletRandomizer			ldx RandAlienBulletPointer ;Load in pointer
							lda RandAlienBulletTable,x      ;Read byte of table
							sta AlienBulletSelected    ;Bullet has been selected
							inx
							cpx #RandAlienBulletTableEnd-RandAlienBulletTable ;Reached end of table...
							beq ResetAlienBulletTable  ;Yes, reset.
							inc RandAlienBulletPointer ;No, move to next byte from table
							rts
ResetAlienBulletTable
							lda #$00
							sta RandAlienBulletPointer
							rts
																																																																		
;------------------------------------------------------------																																																																		
;No space shoot 'em up can be without player/enemy and 																																																																		
;bullet/enemy collision. So call subroutines to test for																																																																		
;player/enemy collision and bullet/enemy collision. Also																																																																		
;test to see whether or not the enemy is dead - for a much																																																																		
;more fairer game.																																																																		
;------------------------------------------------------------																																																																		
SpriteToSpriteCollision		;Test sprite/sprite collision on player
							jsr TestPlayerCollision																																																																		
							;Test sprite/sprite collision on alien																																																													
							jsr TestBulletCollision																																																													
							rts																																																													
																																																											
;-----------------------------------------------------------																																																											
;Test sprite/sprite collision, where the aliens or the alien																																																				
;bullet touches the player. First of all, it is important to																																																				
;check whether or not the player is already dead, before a																																																				
;collision event is to take place.																																																				
;------------------------------------------------------------																																																																		
TestPlayerCollision			lda PlayerIsDead	;Check if player is already dead 
							cmp #$01			;YES
							beq IgnorePlayerCollision ;Ignore collision
							lda ShieldActive	;Check if player has shield
							cmp #$01		
							beq IgnorePlayerCollision
							jmp TestPlayerToAlienCollision
IgnorePlayerCollision		rts
;Setup the sprite to sprite collision box co-ordinates for the player
TestPlayerToAlienCollision							
							lda objpos ;Read X position of player
							sec			 			
							sbc #$06		
							sta PlayerCollision			
							clc			
							adc #$0c			
							sta PlayerCollision+1			
							
							lda objpos+1 ;Read Y position of player			
							sec			
							sbc #$0c			
							sta PlayerCollision+2			
							clc			
							adc #$18			
							sta PlayerCollision+3			 
							
							;Call subroutines to test alien/player collision
							jsr TestAlien1ToPlayer							
							jsr TestAlien2ToPlayer							
							jsr TestAlien3ToPlayer							
							jsr TestAlien4ToPlayer							
							jsr TestAlien5ToPlayer							
							jsr TestAlienBulletToPlayer							
							rts							
						
TestAlien1ToPlayer			lda Alien1IsDead ;Is alien 1 dead?							
							cmp #$01							
							beq NoPlayerCollision1							
														
							;Test enemy X/Y co-ordinates to see if they							
							;overlap any of the same area as the player							
							;if so, a collision is sought.							
														
							lda objpos+4								
							cmp PlayerCollision							
							bcc NoPlayerCollision1							
							cmp PlayerCollision+1							
							bcs NoPlayerCollision1							
							lda objpos+5							
							cmp PlayerCollision+2							
							bcc NoPlayerCollision1							
							cmp PlayerCollision+3							
							bcs NoPlayerCollision1							
							jmp PlayerHit							
NoPlayerCollision1			rts							

TestAlien2ToPlayer			lda Alien2IsDead 	;Is alien 2 dead?							
							cmp #$01							
							beq NoPlayerCollision2							
														
							;As with enemy 1, do the same X/Y co-ords							
							;check with enemy 2.					
														
							lda objpos+6							
							cmp PlayerCollision							
							bcc NoPlayerCollision2							
							cmp PlayerCollision+1							
							bcs NoPlayerCollision2							
							lda objpos+7							
							cmp PlayerCollision+2							
							bcc NoPlayerCollision2							
							cmp PlayerCollision+3							
							bcs NoPlayerCollision2							
							jmp PlayerHit							
NoPlayerCollision2			rts							

TestAlien3ToPlayer			lda Alien3IsDead	;Is alien 3 dead now?							
							cmp #$01							
							beq NoPlayerCollision3 ;Yes, no collision required							
														
							lda objpos+8							
							cmp PlayerCollision							
							bcc NoPlayerCollision3							
							cmp PlayerCollision+1							
							bcs NoPlayerCollision3							
							lda objpos+9							
							cmp PlayerCollision+2							
							bcc NoPlayerCollision3							
							cmp PlayerCollision+3							
							bcs NoPlayerCollision3							
							jmp PlayerHit							
NoPlayerCollision3			rts							

TestAlien4ToPlayer			lda Alien4IsDead	;Alien 4 dead?							
							cmp #$01
							beq NoPlayerCollision4
							
							lda objpos+10
							cmp PlayerCollision
							bcc NoPlayerCollision4
							cmp PlayerCollision+1
							bcs NoPlayerCollision4
							lda objpos+11
							cmp PlayerCollision+2
							bcc NoPlayerCollision4
							cmp PlayerCollision+3
							bcs NoPlayerCollision4
							jmp PlayerHit
NoPlayerCollision4			rts
							
TestAlien5ToPlayer			lda Alien5IsDead
							cmp #$01
							beq NoPlayerCollision5
							
							lda objpos+12
							cmp PlayerCollision
							bcc NoPlayerCollision5
							cmp PlayerCollision+1
							bcs NoPlayerCollision5
							lda objpos+13
							cmp PlayerCollision+2
							bcc NoPlayerCollision5
							cmp PlayerCollision+3
							bcs NoPlayerCollision5
							jmp PlayerHit
NoPlayerCollision5			rts
							
TestAlienBulletToPlayer		;No dead check required here, just test alien							
							;bullet to player.							
														
							lda objpos+14							
							cmp PlayerCollision							
							bcc NoPlayerCollision6							
							cmp PlayerCollision+1							
							bcs NoPlayerCollision6							
							lda objpos+15							
							cmp PlayerCollision+2							
							bcc NoPlayerCollision6							
							cmp PlayerCollision+3							
							bcs NoPlayerCollision6							
							jmp PlayerHit							
NoPlayerCollision6			rts							

;Check whether or not the player's shield has been activated?		
;if so, the player should remain alive. Otherwise, trigger 		
;the pointer PlayerIsDead to activate player death.		

PlayerHit					lda ShieldActive ;Read player's shield							
							cmp #$01		 ;Is it switched on							
							bne ShieldInactive ;Inactive, so kill player													
																			
							rts				 ;Else just do nothing			
										
;The player's shield is inactive, so destroy the player.			

ShieldInactive				ldx #$00		;Reset player death pointer			
							stx PlayerDeathPointer			
							lda #$00			
							sta PlayerDeathDelay			
							lda #$01
							sta PlayerIsDead ;Player is officially dead!
							lda SoundOption
							cmp #$01
							bne NotPlayerDeathSFX
							lda #<PlayerDeathSFX
							ldy #>PlayerDeathSFX
							ldx #14
							jsr SFXPlay
NotPlayerDeathSFX			rts
							
;------------------------------------------------------------------------							
;Test player to alien bullet collision.							
;First load the collision co-ordinates to the player's bullet, then					
;test it on to each alien. Leave the alien bullet alone.					
TestBulletCollision
							lda objpos+2 ;Read X position of player bullet					
							sec					
							sbc #$06	 ;Negative width for collision	 					
							sta BulletCollision				
							clc					
							adc #$0c	 ;Positive width for collision					
							sta BulletCollision+1
							lda objpos+3 ;Read Y position of player bullet
							sec
							sbc #$0c	;Negative height for collision
							sta BulletCollision+2
							clc
							adc #$18
							sta BulletCollision+3
							
							;Individual subroutines to test alien to bullet
							;collision.
							
							jsr Alien1ToBullet
							jsr Alien2ToBullet
							jsr Alien3ToBullet
							jsr Alien4ToBullet
							jsr Alien5ToBullet
							rts
							
;Test each alien manually, to see whether or not it has reached the bullet's							
;collision set co-ordinates. Before we can do that, we must ensure that							
;the alien is not already dead or offset. If ready, and moving, a collision event							
;can occur. Otherwise the collision should be ignored.							
							
Alien1ToBullet				lda Alien1IsDead
							cmp #$01
							beq CannotShootAlien1
							lda Alien1Offset
							cmp #$01
							beq CannotShootAlien1
							
							lda objpos+4 ;Read alien 1 X position
							cmp BulletCollision	;Match negative collision range X?
							bcc CannotShootAlien1 ;No overlap found
							cmp BulletCollision+1 ;Match positive collision range X?
							bcs CannotShootAlien1 ;No overlap found
							lda objpos+5 ;Read alien 1 Y position
							cmp BulletCollision+2 ;Match negative collision range Y?
							bcc CannotShootAlien1 ;No overlap found
							cmp BulletCollision+3 ;Match positive collision range Y?
							bcs CannotShootAlien1 ;No overlap found
							;Reset Alien 1 explosion pointers 
							ldx #$00
							stx Alien1ExplosionPointer
							lda #$00
							sta Alien1ExplosionDelay
							lda #$00		;Remove player bullet
							sta objpos+2
							sta objpos+3
							lda #$01
							sta Alien1IsDead
							jsr ScorePoints ;Score some points
CannotShootAlien1			rts							

;Do exactly the same type of test for alien 2
Alien2ToBullet				lda Alien2IsDead
							cmp #$01
							beq CannotShootAlien2
							lda Alien2Offset
							cmp #$01
							beq CannotShootAlien2
							lda objpos+6
							cmp BulletCollision
							bcc CannotShootAlien2
							cmp BulletCollision+1
							bcs CannotShootAlien2
							lda objpos+7
							cmp BulletCollision+2
							bcc CannotShootAlien2
							cmp BulletCollision+3
							bcs CannotShootAlien2
							ldx #$00
							stx Alien2ExplosionPointer
							lda #$00
							sta Alien2ExplosionDelay
							
							lda #$00
							sta objpos+2
							sta objpos+3
							
							lda #$01
							sta Alien2IsDead
							
							jsr ScorePoints
							
CannotShootAlien2			rts
							
;Now for alien 3
Alien3ToBullet				lda Alien3IsDead
							cmp #$01
							beq CannotShootAlien3
							lda Alien3Offset
							cmp #$01
							beq CannotShootAlien3
							lda objpos+8
							cmp BulletCollision
							bcc CannotShootAlien3
							cmp BulletCollision+1
							bcs CannotShootAlien3
							lda objpos+9
							cmp BulletCollision+2
							bcc CannotShootAlien3
							cmp BulletCollision+3
							bcs CannotShootAlien3
							
							ldx #$00
							stx Alien3ExplosionPointer
							lda #$00
							sta Alien3ExplosionDelay
							lda #$00
							sta objpos+2
							sta objpos+3
							
							lda #$01
							sta Alien3IsDead
							jsr ScorePoints
CannotShootAlien3			rts

;Alien to bullet now
Alien4ToBullet				lda Alien4IsDead
							cmp #$01
							beq CannotShootAlien4
							lda Alien4Offset
							cmp #$01
							beq CannotShootAlien4
							lda objpos+10
							cmp BulletCollision
							bcc CannotShootAlien4
							cmp BulletCollision+1
							bcs CannotShootAlien4
							lda objpos+11
							cmp BulletCollision+2
							bcc CannotShootAlien4
							cmp BulletCollision+3
							bcs CannotShootAlien4
							
							ldx #$00
							stx Alien4ExplosionPointer
							lda #$00
							sta Alien4ExplosionDelay
							
							lda #0
							sta objpos+2
							sta objpos+3
							
							lda #$01
							sta Alien4IsDead
							jsr ScorePoints
CannotShootAlien4			rts

;Finally test alien 5 to player bullet
Alien5ToBullet				lda Alien5IsDead
							cmp #$01
							beq CannotShootAlien5
							lda Alien5Offset
							cmp #$01
							beq CannotShootAlien5
							lda objpos+12
							cmp BulletCollision
							bcc CannotShootAlien5
							cmp BulletCollision+1
							bcs CannotShootAlien5
							lda objpos+13
							cmp BulletCollision+2
							bcc CannotShootAlien5
							cmp BulletCollision+3
							bcs CannotShootAlien5
							
							ldx #$00
							stx Alien5ExplosionPointer
							lda #$00
							sta Alien5ExplosionDelay
							
							lda #0
							sta objpos+2
							sta objpos+3
							
							lda #$01
							sta Alien5IsDead
							jsr ScorePoints
CannotShootAlien5			rts
							
;----------------------------------------------------------							
;Simple scoring system. For every alien hit, award the 							
;player 200 points							
;----------------------------------------------------------							
							
ScorePoints					lda SoundOption
							cmp #$01
							bne NotPlayKillEnemySFX
							lda #<AlienDieSFX
							ldy #>AlienDieSFX
							ldx #14
							jsr SFXPlay
NotPlayKillEnemySFX
							jsr DoScore
							jsr DoScore
							rts
DoScore						inc PlayerScore+3
							ldx #$03
ScoreLoop					lda PlayerScore,x
							cmp #$3a
							bne ScoreOkay
							lda #$30
							sta PlayerScore,x
							inc PlayerScore-1,x
ScoreOkay					dex
							bne ScoreLoop
							rts
							
							
;----------------------------------------------------------
;Render score and lives pointers to actual screen RAM 
;BANK #$00 position. 
;---------------------------------------------------------- 
RenderScoreLives			lda PlayerLives	;Read single byte of lives counter 
							sta LivesPos 	;place it to chosen screen position
							ldx #$00		
RenderScorePanel			lda PlayerScore,x ;Read each byte of the score counter							
							sta ScorePos,x    ;Place to score char position							
							inx							
							cpx #$06							
							bne RenderScorePanel							
							rts							 
							
							
							
							
							
																																																																									
;------------------------------------------------------------      
;Setup the IRQ raster interrupts that control the main body     
;visuals. The top screen raster will be used as the smooth     
;vertical screen scroller. The second split creates an      
;illegal opcode to hide the screen (using a hidden black strip     
;so that one of the rows of the screen cannot be visible.
;then display the score panel character set.
;------------------------------------------------------------     							

;IRQ1 - This sets up the control of the map's scroller.												
;This interrupt should switch to BANK #$03, display 		
;the custom game character set (The space background) 		
;and also allow multicolour to be used. This interrupt		
;should also use the soft scroller 'ypos' in order to
;scroll the background more smoothly.
															
irq1
          						sta stacka1+1 ;Self-mod stack code A for irq 1
          						stx stackx1+1 ;"     "    "    "   X  "   "  "
          						sty stacky1+1 ;"     "    "    "   Y  "   "  "
          						lda $dc0d     ;CIA Timer setting 
          						sta $dd0d     
          						
SpriteTrigger   				lda #$ff	  ;All sprites on
          						sta $d015
						        lda #$03      ;Screen BANK #$03
          						sta $dd00
						        lda #$12      ;Game charset at $0800,
          						sta $d018     ;display screen RAM $0400-$07e8
          						lda #$18      ;Screen multicolour mode enabled
          						sta $d016	  ;and horizontal position set.
          						
          						lda ypos      ;Call value of ypos, which 
          						sta $d011	  ;represents the vertical scroll
          									  ;control.
          				
          						ldx #<irq2    ;Call low-byte of IRQ2 to x
          						ldy #>irq2    ;Call hi-byte of IRQ to y
          						lda #$d0  	  ;load raster position #$d1
          						stx $fffe     ;Store low-byte of IRQ2 
          						sty $ffff     ;Store hi-byte of IRQ2
          						sta $d012     
          						asl $d019     ;Sync interrupt to perform split
stacka1    						lda #$00      ;Self mod stack a1  
stackx1				            ldx #$00      ;Self mod stack x1
stacky1					        ldy #$00      ;Self mod stack y1
          						rti			  ;Return from interrupt

;IRQ2
;The second IRQ raster interrupt. This time it will setup a black
;row to hide existing characters before it should switch to VIC Bank #$00 
;where the score panel is displayed. Disable all screen multicolour and  
;also time out the raster cycles slightly. Also display the score panel
;charset on screen.
 
irq2      						sta stacka2+1 ;Store to selfmod stacka2 
          						lda $d011     ;Check the position of $d011
          						cmp #$15      ;if at #$15, perform a flip
          						beq flip      ;to stabilise score panel
          						
          						lda #$7b      ;Read illegal opcode to make
          						sta $d011     ;a black screen cut
        				        pha				
          						pla
          						pha
          						pla
flip					        stx stackx2+1 ;Store to selfmod stackx2
					            lda #$77	      ;another illegal opcode to
          						sta $d011     ;trigger a stable panel
          						sty stacky2+1 ;Store to selfmod stacky2
          						
          						ldx #$06	;Time out the raster slightly
          						lda $d012
          						cmp $d012
          						beq *-3
          						dex
          						bne *-9
          						ldx #$08	;Time out the flick at the bottom
          						dex			;of the screen, visible on real hardware 
          						bne *-1     ;and c64sc    						
          						nop
						        lda #$00      ;Set BANK #$00 for score 
          						sta $dd00	  ;panel.
          						sta $d015	  ;All sprites off
          						lda #$18   	  ;Display score panel font 
          						sta $d018	  ;screen RAM $c400-$c7e7     
          						lda #$08      ;Disable multicolour screen
          						sta $d016     
          						
          						lda #$17      ;Set screen visible, at a
          						sta $d011     ;lower vertical position
          						
          						lda #1		  ;Enable code to sync timer for
          						sta SyncDelay ;code, outside the interrupt.
          						
          						jsr MusicPlayer
          						
          						ldx #<irq1   ;Place lowbyte of irq3 to X
          						ldy #>irq1    ;Place hibyte of irq3 to X
          						lda #$f8     ;Read raster position #$fa
          						stx $fffe	  ;Store to interrupt lobyte X     
          						sty $ffff     ;Store to interrupt hibyte Y
          						sta $d012     ;Store raster position
          						asl $d019     ;Control IRQ delay
stacka2					        lda #$00      ;Self mod stacka2
stackx2							ldx #$00      ;Self mod stackx2
stacky2				            ldy #$00      ;Self mod stacky2
nmi          					rti					
;----------------------------------------------------------------------			
;Music player. For PAL/NTSC machine detection.			

MusicPlayer						lda System
								cmp #1
								beq PAL
								inc SystemMusicDelay
								lda SystemMusicDelay
								cmp #$06
								beq ResetNTSCDelay
PAL								jsr MusicPlay
								rts
ResetNTSCDelay					lda #$00 
								sta SystemMusicDelay
								rts 
	 
;Pointer for in game sound options (For music of sound effects)	

SoundOption						.byte 0
	
System							.byte 0			
SystemMusicDelay				.byte 0			
;----------------------------------------------------------------------					
;Pointers - plenty of them.					
;----------------------------------------------------------------------					
SyncDelay						.byte 0	;<- Synchronize timer													
ydelay							.byte 0	;<- Control delay of scroll															
ypos 							.byte 0  ;<- Control speed of scroll
;----------------------------------------------------------------------
;Animation and object pointers (values)
TableSelect						.byte $00 ;Pointer for random selection
AnimDelay						.byte $00 ;Duration per anim frame 
RandCounter						.byte $00 ;Random counter for the table sequence
PlayerAnimPointer				.byte $00 ;Anim pointer for player alive
PlayerAnimStore					.byte $80 ;Pointer for player animation 
PlayerDefaultStartX				.byte $50 ;Default X position for player
PlayerDefaultStartY				.byte $b8 ;Default Y position for player
PlayerIsDead					.byte $00 ;Pointer to test player death
PlayerDeathDelay				.byte $00 ;Delay pointer for player death 
PlayerDeathPointer				.byte $00 ;Pointer to indicate player's death
ShieldActive					.byte $00 ;Shield for player when spawned
ShieldTime						.byte $00 ;Time for the shield to be active
FireButton						.byte $00 
FlashShieldPointer				.byte $00										
FlashShieldDelay				.byte $00										
FlashShieldColour				.byte $06,$04,$0e,$03,$01,$03,$0e,$04										
										
										

								;Default starting position for all sprites
SpriteDefaultStartTable			.byte $50,$b8,$00,$00,$00,$00,$00,$00
								.byte $00,$00,$00,$00,$00,$00,$00,$00
								
								;Table resrved for storing ghost X/Y 						
								;positions for all sprites.						
objpos							.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0							
								;Table reserved for storing collision					
PlayerCollision					.byte 0,0,0,0					
BulletCollision					.byte 0,0,0,0					
								;Pointers to test if each alien is dead or not
Alien1IsDead					.byte 0
Alien2IsDead					.byte 0
Alien3IsDead					.byte 0
Alien4IsDead					.byte 0
Alien5IsDead					.byte 0


;Pointers to force alien offset
Alien1Offset					.byte 0
Alien2Offset					.byte 0
Alien3Offset					.byte 0
Alien4Offset					.byte 0
Alien5Offset					.byte 0

;Pointers to set alien movement or bullet to be enabled.

Alien1Ready				.byte 0
Alien2Ready				.byte 0
Alien3Ready				.byte 0
Alien4Ready				.byte 0
Alien5Ready				.byte 0
AlienBulletReady		.byte 0
;Pointers to set waiting interval before respawning the next alien		
;or bullet.		
Alien1WaitTime					.byte 0
Alien2WaitTime					.byte 0
Alien3WaitTime					.byte 0
Alien4WaitTime					.byte 0
Alien5WaitTime					.byte 0
AlienBulletWaitTime				.byte 0
;Pointer to select which alien to fire out bullet.
AlienBulletSelected				.byte 0
;Pointer to randomly select which alien to fire out bullet
RandAlienBulletPointer			.byte 0								
								
;Alien animation pointer
AlienAnimPointer				.byte $00 
;Alien explosion pointers
Alien1ExplosionDelay			.byte $00
Alien1ExplosionPointer			.byte $00
Alien2ExplosionDelay			.byte $00
Alien2ExplosionPointer			.byte $00
Alien3ExplosionDelay			.byte $00
Alien3ExplosionPointer			.byte $00
Alien4ExplosionDelay			.byte $00
Alien4ExplosionPointer			.byte $00
Alien5ExplosionDelay			.byte $00
Alien5ExplosionPointer			.byte $00

;Alien formation pointers (1 - 5 represent which alien uses which formation).
FormationPointer1				.byte $00
FormationPointer2				.byte $00
FormationPointer3				.byte $00
FormationPointer4				.byte $00
FormationPointer5				.byte $00

;Alien animation frame values. 
Alien1FrameStore				.byte $8f ;Green eye 
Alien2FrameStore				.byte $95 ;Grey Pulser
Alien3FrameStore				.byte $9b ;Spiderzoid
Alien4FrameStore				.byte $a1 ;Pink down facing ship
Alien5FrameStore				.byte $a7 ;Lt Green frog type alien
Alien6FrameStore				.byte $ad ;Yellow cheese-a-roid
Alien7FrameStore				.byte $b3 ;Silver rotator
Alien8FrameStore				.byte $b9 ;Cyan spinner drone

PlayerShipFrameTable			;Animation frame for player ship (5 frames)
								.byte $80,$81,$82,$83,$84
								
PlayerBulletFrame				;Single frame for player bullet
								.byte $85

ExplosionFrame					;Frame table for explosion, on player
								;or alien death.
								.byte $86,$87,$88,$89,$8a,$8b,$8c,$8d

AlienBulletFrame				.byte $8e
								
Alien1FrameTable				;Animation frame for alien 1 (green eye)
								.byte $8f,$90,$91,$92,$93,$94
Alien2FrameTable				;Animation frame for alien 2 (metal pulser)
								.byte $95,$96,$97,$98,$99,$9a
Alien3FrameTable				;Animation frame for alien 3 (spiderzoid)
								.byte $9b,$9c,$9d,$9e,$9f,$a0
Alien4FrameTable				;Animation frame for alien 4 (pink space craft)
								.byte $a1,$a2,$a3,$a4,$a5,$a6
Alien5FrameTable				;Animation frame for alien 5 (green frog)
								.byte $a7,$a8,$a9,$aa,$ab,$ac
Alien6FrameTable				;Animation frame for alien 6 (cheese-a-roid)
								.byte $ad,$ae,$af,$b0,$b1,$b2
Alien7FrameTable				;Animation frame for alien 7 (silver rotator)
								.byte $b3,$b4,$b5,$b6,$b7,$b8
Alien8FrameTable				;Animation frame for alien 8 (cyan spinner drone)
								.byte $b9,$ba,$bb,$bc,$bd,$be
								
Alien1Colour 					.byte $05								
Alien2Colour					.byte $0c								
Alien3Colour					.byte $0e								
Alien4Colour					.byte $0a								
Alien5Colour					.byte $0d								
Alien6Colour					.byte $07								
Alien7Colour					.byte $0f								
Alien8Colour					.byte $03								
								
;Sequence table, which selects the colour of the alien when next								
;on screen.	This will be selected by the randomizer zeropage ($a2), for which						
;alien to pick out from the table.						

AlienColourSequence				.byte $05,$0c,$0e,$0a,$0d,$07,$0f,$03								

;Sequence table, which selects the low byte of the alien frame table,																
;selected by the randomizer zeropage ($a2).		(16 selections, for aliens and						
;formation).						

AlienFrameSelectLowTable		.byte <Alien1FrameStore								
								.byte <Alien2FrameStore								
								.byte <Alien3FrameStore								
								.byte <Alien4FrameStore								
								.byte <Alien5FrameStore								
								.byte <Alien6FrameStore								
								.byte <Alien7FrameStore								
								.byte <Alien8FrameStore								
								.byte <Alien1FrameStore								
								.byte <Alien2FrameStore								
								.byte <Alien3FrameStore								
								.byte <Alien4FrameStore								
								.byte <Alien5FrameStore								
								.byte <Alien6FrameStore								
								.byte <Alien7FrameStore								
								.byte <Alien8FrameStore													
																
AlienFrameSelectHiTable			.byte >Alien1FrameStore								
								.byte >Alien2FrameStore								
								.byte >Alien3FrameStore								
								.byte >Alien4FrameStore								
								.byte >Alien5FrameStore								
								.byte >Alien6FrameStore								
								.byte >Alien7FrameStore								
								.byte >Alien8FrameStore								
								.byte >Alien1FrameStore								
								.byte >Alien2FrameStore								
								.byte >Alien3FrameStore								
								.byte >Alien4FrameStore								
								.byte >Alien5FrameStore								
								.byte >Alien6FrameStore								
								.byte >Alien7FrameStore								
								.byte >Alien8FrameStore								
												
;Sequence table, which selects the alien colour table,																
;selected by the randomizer zeropage ($a2).		(16 selections, for aliens and						
;formation).																	
											
AlienColourSelectTable			.byte $05,$0c,$0e,$0a,$0d,$07,$0f,$03			
								.byte $05,$0c,$0e,$0a,$0d,$07,$0f,$03			
								
			
																
										
;Sequence table for Alien X formation pattern.										

;Low byte table for Alien formation (Enemy X position for sprites 2 - 6)
AlienFormationXSelectLowTable	.byte <Formation01,<Formation02,<Formation03,<Formation04										
								.byte <Formation05,<Formation06,<Formation07,<Formation08										
								.byte <Formation09,<Formation10,<Formation11,<Formation12										
								.byte <Formation13,<Formation14,<Formation15,<Formation16										
																		
;Hi byte table of Alien formation (Enemy X position for sprites 2 - 6)																		
AlienFormationXSelectHiTable	.byte >Formation01,>Formation02,>Formation03,>Formation04														
								.byte >Formation05,>Formation06,>Formation07,>Formation08														
								.byte >Formation09,>Formation10,>Formation11,>Formation12														
								.byte >Formation13,>Formation14,>Formation15,>Formation16														
																						
;Sequence table for Alien Y formation pattern														
AlienFormationYSelectLowTable	
;Low byte table for Alien formation (Enemy Y position for sprites 2-6)
								.byte <Formation01+$100,<Formation02+$100,<Formation03+$100,<Formation04+$100														
								.byte <Formation05+$100,<Formation06+$100,<Formation07+$100,<Formation08+$100														
								.byte <Formation09+$100,<Formation10+$100,<Formation11+$100,<Formation12+$100														
								.byte <Formation13+$100,<Formation14+$100,<Formation15+$100,<Formation16+$100							
;Hi byte table for Alien formation (Enemy Y position for sprites 2-6)																			
AlienFormationYSelectHiTable	.byte >Formation01+$100,>Formation02+$100,>Formation03+$100,>Formation04+$100							
								.byte >Formation05+$100,>Formation06+$100,>Formation07+$100,>Formation08+$100							
								.byte >Formation09+$100,>Formation10+$100,>Formation11+$100,>Formation12+$100							
								.byte >Formation13+$100,>Formation14+$100,>Formation15+$100,>Formation16+$100							
								
;Randomizer table (well, a series of 256 bytes with random numbers from 0 to 15)								

RandAlienTable					.byte $01,$02,$03,$04,$05,$06,$07,$08,$09								
								.byte $0a,$0b,$0c,$0d,$0e,$0f,$01,$0c,$0a																		
								.byte $07,$09,$0a,$03,$06,$02,$01,$0e,$0b								
								.byte $05,$00,$0c,$0d,$0f,$08,$02,$06,$09																								
								.byte $0f,$01,$0e,$07,$0d,$0a,$04,$0d,$02								
								.byte $0c,$0d,$01,$09,$05,$0a,$04,$07,$03																								
								.byte $01,$03,$05,$07,$09,$0b,$0d,$0f,$00								
								.byte $02,$04,$06,$08,$0a,$0c,$0e,$07,$0d																								
								.byte $03,$06,$09,$0b,$0f,$01,$04,$07,$0a 								
								.byte $04,$08,$0c,$00,$05,$0a,$0f,$01,$02																		
								.byte $09,$0d,$0f,$0c,$03,$0e,$01,$0f,$08								
								.byte $04,$08,$00,$02,$06,$0b,$03,$07,$02																						
								.byte $04,$0a,$08,$0c,$03,$0b,$0f,$05,$01								
								.byte $02,$09,$0d,$0e,$06,$0f,$01,$03,$05							
								.byte $01,$02,$03,$04,$05,$06,$07,$08,$09							
								.byte $0a,$0b,$0c,$0d,$0e,$0f,$02,$06,$07							
RandAlienTableEnd				;Marked as end of table					

;Randomizer table for picking out an alien to fire a bullet																
;Values $01 - $$05 represent alien type.												

RandAlienBulletTable			.byte $01,$02,$03,$04,$05,$02,$03,$01,$05															
								.byte $04,$01,$03,$02,$04,$02,$05,$03,$01															
								.byte $03,$02,$01,$05,$04,$02,$03,$04,$02															
								.byte $03,$01,$02,$04,$03,$01,$04,$01,$02															
								.byte $05,$01,$03,$05,$03,$04,$05,$02,$03															
								.byte $01,$05,$02,$01,$04,$05,$01,$03,$01															
RandAlienBulletTableEnd			;Marked as end of table																			
															
																
;A table to carry the player's score																
PlayerScoreSpare				.byte $00											
PlayerScore						.byte $30,$30,$30,$30,$30,$30,$30										
;Also a pointer to indicate lives left										
PlayerLives						.byte $33										
																		
;In game sound effects tables																		

PlayerFireSFX					.byte $0A,$00,$08,$CF,$81,$AA,$21,$dF,$dA,$11,$d8,$d6,$d4,$A0,$00																
PlayerDeathSFX					.byte $0B,$00,$08,$BF,$81,$AA,$41,$AC,$81,$A9,$AE,$00											
AlienDieSFX						.byte $0A,$00,$00,$BF,$81,$B4,$41,$C6,$AA,$41,$A9,$BF,$81,$DC,$00											
AlienShootSFX					.byte $0A,$00,$00,$BC,$21,$BF,$BE,$BB,$B9,$B7,$B5,$B3,$00								
																