  e  Y  Y  Y  Y  Y  Y  Y  Y  Y; Septic's Demoskola - Lektion 9c : HW Trackloading
; Skriven av Vicious / Septic - 15 Oktober 1993

CapsFlash=0	; Funkar INTE p A1200!

*** Notera att den hr rutinen endast arbetar med HELA tracks!!! ***
*** Det gr allts inte lsa in speciella sectorer enbart!       ***

	section	Lektion9a,code_c
j:	movem.l	d0-a6,-(sp)
	move.w	#$4000,$dff09a		; Interrupt av
	moveq.l	#0,d0
	moveq.l	#10,d1
	moveq.l	#0,d2
	lea.l	buffer,a0
	lea.l	destination,a1
	bsr.s	trackload
	move.w	#$c000,$dff09a		; Interrupt p
	movem.l	(sp)+,d0-a6
	rts

********************************************************
*** SEPTiX Trackload System v1.0 - Coded by ViCiOUS! ***
*** ------------------------------------------------ ***
*** D0 - Start track        | D1 - Nr of tracks      ***
*** D2 - Drive Number (0-3) |                        ***
*** A0 - Buffer             | A1 - Destination       ***
********************************************************
Trackload:
	movem.l	d1-a6,-(sp)
	bsr.w	SetRegs
	tst.w	d1		; Frhindra lngd 0
	beq.s	.out
	bsr.w	SetDrive
	bsr.s	Cyl0		; Flytta till cylinder 0
	bsr.s	Read		; Ls data
.out:
	bsr.w	DriveOff	; Stng av drive
	movem.l	(sp)+,d1-a6
	rts

Cyl0:	
	bsr.s	StepOUT		; Stt riktning utt fr diskhuvudet
.chk:	btst	#4,(a4)		; Kolla om vi r p cylinder 0
	beq.s	.cylok
	bsr.s	StepImpulse	; Flytta diskhuvudet
	bra.s	.chk
.cylok:	rts

StepIN:	
	move.w	#$3500,d6
	bsr.w	TimerWait
	bclr	#1,(a5)		; Stt riktning INT fr diskhuvudet
	move.w	#$2a00,d6
	bsr.w	TimerWait
	rts

StepOUT:
	move.w	#$3500,d6
	bsr.w	TimerWait
	bset	#1,(a5)		; Stt riktning UTT fr diskhuvudet
	move.w	#$2a00,d6
	bsr.w	TimerWait
	rts

StepImpulse:
	bclr	#0,(a5)		; Snd en impuls till driven som fr
	bset	#0,(a5)		; diskhuvudet att flytta p sig ett steg
	move	#$1000,d6
	bsr.w	TimerWait
	rts

; Get track and fix it nicely...
READ:
	bsr.s	SetHead		; Flytta diskhuvudet till rtt start track
	move.w	#$7f00,$9e(a6)	; Rensa diskbitar i ADKCON
	move.w	#$8500,$9e(a6)	; Stt FAST och WORDSYNC
	move.w	d7,$7e(a6)	; Skriv in syncvrde i DSKSYNC
.getit:	bsr.s	GetTrack	; Ls ett track och decoda det
	subq.l	#1,d1		; Minska lngden
	beq.s	.finish		; Om lngd=0 s r vi frdiga
	bsr.s	changeside	; Annars byt sida p disken
	bra.s	.getit
.finish:rts

; Move head to position in D0...
SetHead:
	bsr.s	chkside		; Stll in rtt sida
	move.w	d0,d5
	lsr.w	#1,d5		; Antal steg dividerat med tv
	bsr.s	StepIN		; Stt riktning int fr diskhuvudet
.step:	tst.w	d5		; Kolla om start track r noll
	beq.s	.correct	; Hoppa ut i s fal
	bsr.s	StepImpulse	; Annars flyttar vi diskhuvudet ett steg
	subq.w	#1,d5		; int och minskar start tracket med 1.
	bra.s	.step
.correct:rts

GetTrack:
	move.w	#$4000,$24(a6)	; Rensa DSKLEN
	move.w	#$3000,d6
	bsr.s	TimerWait	; Vnta en stund
	move.l	a0,$20(a6)	; Buffer
	move.w	#$9900,$24(a6)	; Stt lngd
	move.w	#$9900,$24(a6)	; tv gnger fr att brja lsning
.wt:	btst	#1,$1f(a6)	; Kolla om diskdma r klart
	beq.s	.wt		; Annars hoppar vi tillbaks
	move.w	#$1002,$9c(a6)	; Rensa interrupt-flaggorna som satts
	bra.w	decode

; Kolla vilken sida vi ska brja p...
ChkSide:
	btst	#0,d0		; Kolla om starttrack r jmnt eller udda
	beq.s	.notodd
	bclr	#2,(a5)		; Stll in vre sidan
	rts
.notodd:bset	#2,(a5)		; Stll in undre sidan
	rts

; Byt disksida...
ChangeSide:
	move.w	#$400,d6
	bsr.s	TimerWait
	bchg	#2,(a5)		; Byt disksida
	move.w	#$50,d6
	bsr.s	TimerWait
	btst	#2,(a5)		; Om vi r p vre sidan behver vi inte
	beq.s	.nostep		; flytta diskhuvudet
	move.w	#$1000,d6
	bsr.s	TimerWait
	bsr.w	StepImpulse
.nostep:rts

; En rutin som vntar med hjlp av CIAB Timer A
TimerWait:
	move.b	#$09,$e00(a4)
	move.b	d6,$400(a4)
	lsr.w	#8,d6
	move.b	d6,$500(a4)
.tim_wt:
	IFNE	CapsFlash
	bset	#6,$bfee01	; Dessa tv rader flashar capslock-lampan
	bclr	#6,$bfee01	; med observera att det fungerar endast med
				; skerhet p A500, men INTE alls p A1200!
	ENDC
	btst	#0,$d00(a4)
	beq.s	.tim_wt
	move.b	#0,$e00(a4)
	rts

SetDrive:
	bset	d2,(a5)		; Stt drivebit fr att sl av drive
	bclr	#7,(a5)		; Stt p motorn
	moveq	#2,d6
	bsr.s	TimerWait	; Vnta kort
	bclr	d2,(a5)		; Sl p den drive vi vill anvnda
	bsr.s	DriveReady	; Vnta tills driven r klar
	rts

DriveOff:
	bset	d2,(a5)		; Stng av drive
	moveq	#2,d6
	bsr.s	TimerWait
	bset	#7,(a5)		; Stng av motor
	moveq	#2,d6
	bsr.s	TimerWait
	bclr	d2,(a5)		; Aktivera drive
	moveq	#2,d6
	bsr.s	TimerWait
	bset	d2,(a5)		; Stng av den slutgiltigt
	rts

SetRegs:
	addq.l	#3,d2		; Drivenumret+3 ger oss bitnumret p driven
	lea.l	$dff000,a6
	lea.l	$bfd100,a5
	lea.l	$bfe001,a4
	move.l	#$4489,d7	; Detta r syncvrdet
	rts

DriveReady:
	btst	#5,(a4)		; Vnta tills diskmotorn roterar med full
	bne.s	DriveReady	; hastighet
	rts

Decode:
	move.l	a0,a2		; Spara gammalt buffer vrde
	move.l	#$55555555,d0
	moveq	#10,d6
.search:cmp.w	(a2)+,d7	; Leta fram syncvrdet i buffern
	bne.s	.search
	cmp.w	(a2),d7		; Kan eventuellt frekomma ytterligare ett
	bne.s	.nosync		; efter. Hoppa ver i s fall...
	addq.l	#2,a2
.nosync:move.l	(a2),d3		; Hmta initierande MFM-data
	move.w	6(a2),d4
	and.w	d0,d3		; Decoda
	and.w	d0,d4
	add.w	d3,d3
	or.w	d4,d3
	add.w	d3,d3
	move.l	a1,a3
	and.w	#$ff00,d3
	add.w	d3,a3
	lea.l	$38(a2),a2
	moveq	#$7f,d5
.loop:	move.l	$200(a2),d3	; Decoda en sector
	move.l	(a2)+,d4
	and.l	d0,d4
	and.l	d0,d3
	add.l	d4,d4
	or.l	d3,d4
	move.l	d4,(a3)+
	dbf	d5,.loop
	dbf	d6,.search	; Hmta nsta sector
	lea.l	$1600(a1),a1	; Peka p nsta track i vr destination
	rts

	section	buffer,bss_c
Buffer:
	ds.b	$3200
Destination:
	ds.b	10*5632
