; Septic's Demoskola - Lektion 8 : Blitter (BOBS)
; Skriven av Vicious / Septic - 9 Augusti 1993

DisableCache=1	; En nolla betyder att funktionen r avstngd...
DisableMotor=1

ScreenWidth=320
ScreenHeight=256
ScreenSize=Screenwidth/8*ScreenHeight

NrOfBobs=20
SpeedX=3
SpeedY=4

	section	Lektion8,code_c

j:	movem.l	d0-a6,-(sp)

	bsr.w	INIT
	tst.l	gfxbase		; Kolla om vi hittade gfx.library
	beq.s	error		; Nepp...D hoppar vi ut...

	move.w	#%1000011111000000,$dff096	; Vr lilla DMA
	;	  S    NDBCBSD
	;	  E    aMPOLPS
	;	  T    sALPTRK
	;	       t
	;              y

	bsr.w	SetBplptr
	bsr.w	CreateMask
	bsr.w	InitCoords

	move.l	#copper,$dff080	; Nu stter vi vr egen copperlista
	move.w	d0,$dff088	; Och tvingar den att brja direkt...

main:
	bsr.s	sync
	bsr.w	SwapPages
	bsr.w	ShowBobs
	btst	#6,$bfe001	; Testa vnster musknapp!
	bne.s	main

xit:	bsr.w	UnINIT
error:	movem.l	(sp)+,d0-a6
	rts

; Syncroniserings rutin
sync:	move.l	$dff004,d0
	and.l	#$1ff00,d0
	lsr.l	#8,d0
	cmp.w	#$110,d0		; Kolla om rasterrad=$110
	bne.s	sync
	rts

MoveBobs:
	movem.l	d0-a6,-(sp)
	lea.l	coords,a5
	move.l	#NrOfBobs-1,d7
.nxtbob:
	move.w	4(a5),d0	; X add
	add.w	d0,(a5)
	cmp.w	#screenwidth-48,(a5)
	ble.s	.RightOk
	neg.w	d0
.RightOk:cmp.w	#32,(a5)
	bge.s	.LeftOk
	neg.w	d0
.LeftOk:
	move.w	d0,4(a5)
	move.w	6(a5),d0	; Y add
	add.w	d0,2(a5)
	cmp.w	#screenheight-48,2(a5)
	ble.s	.LowerOk
	neg.w	d0
.LowerOk:cmp.w	#32,2(a5)
	bge.s	.UpperOk
	neg.w	d0
.UpperOk:
	move.w	d0,6(a5)
	addq.l	#8,a5
	dbf	d7,.nxtbob

	movem.l	(sp)+,d0-a6
	rts

ShowBobs:
	movem.l	d0-a6,-(sp)
	moveq	#0,d0
	moveq	#0,d1
	move.l	DrawPage(pc),a0
	lea.l	ball,a1
	lea.l	mask,a2

	; Rensa gamla bobs frst....
	lea.l	coords,a5
	moveq	#NrOfBobs-1,d7
.clrbobs:
	move.w	(a5)+,d0
	move.w	(a5)+,d1
	bsr.w	ClearBob
	addq.l	#4,a5
	dbf	d7,.clrbobs

	bsr.w	MoveBobs		; Flytta till nya positioner

	lea.l	coords,a5
	moveq	#NrOfBobs-1,d7
.makebobs:	
	move.w	(a5)+,d0
	move.w	(a5)+,d1
	bsr.s	PutBob
	addq.l	#4,a5
	dbf	d7,.makebobs

	movem.l	(sp)+,d0-a6
	rts

; Putbob rutin...D0=X   D1=Y   A0=Screen   A1=Bob   A2=Mask
PutBob:
	movem.l	d0/d1/d6/d7/a0-a2,-(sp)
	mulu	#screenwidth/8,d1
	add.l	d1,a0
	move.l	#srca!srcb!srcc!dest!(b&a)!(c&na),d7	; Minterm
	swap	d7
	move.b	d0,d6		; Low byte of X
	and.b	#$0f,d6		; Endast 4 lga bitarna e viktiga
	lsr.l	#4,d0		; Dividera med 16
	asl.l	#1,d0		; och multiplicera med 2
	add.l	d0,a0
	ror.l	#4,d6
	or.l	d6,d7
	swap	d6
	or.l	d6,d7
	moveq	#[screenwidth/8]-4,d0	; Screen modulo
	moveq	#-2,d1			; Bob modulo
	moveq	#4-1,d6			; Antal bitplan minus 1
.bltwt:	btst	#14,$dff002
	bne.s	.bltwt
	move.l	d7,$dff040		; BLTCON0 & BLTCON1 samtidigt...
	move.l	#$ffff0000,$dff044	; BLTAxWM
	move.l	a2,$dff050		; BLTAPT (Masken)
	move.l	a1,$dff04c		; BLTBPT (Boben)
	move.l	a0,$dff048		; BLTCPT (Bakgrunden)
	move.l	a0,$dff054		; BLTDPT (Bakgrunden igen)
	move.w	d1,$dff064		; BLTAMOD (Bob modulo)
	move.w	d1,$dff062		; BLTBMOD (Mask modulo)
	move.w	d0,$dff060		; BLTCMOD (Bakgrundsmodulo)
	move.w	d0,$dff066		; BLTDMOD   "   "    "
	move.w	#16*64+2,$dff058	; BLTSIZE (32 pixlar bred, 16 hog)

	add.l	#screenwidth/8*screenheight,a0	; Adda p screen pekaren
	add.l	#16/8*16,a1			; Adda p bob pekaren
	dbf	d6,.bltwt
	movem.l	(sp)+,d0/d1/d6/d7/a0-a2
	rts

; Ta bort en bob...   D0=X   D1=Y   A0=Screen
ClearBob:
	movem.l	d0/d1/a0,-(sp)
	subq.l	#8,d1
	mulu	#screenwidth/8,d1
	add.l	d1,a0
	subq.l	#8,d0
	lsr.l	#4,d0
	asl.l	#1,d0
	add.l	d0,a0
	move.l	#dest,d0
	moveq	#4-1,d1		; Antal bpl
.bltwt:	btst	#14,$dff002
	bne.s	.bltwt
	move.w	d0,$dff040		; BLTCON0
	move.l	#$ffffffff,$dff044	; BLTAxWM
	move.l	a0,$dff054		; BLTDPT
	move.w	#[screenwidth/8]-6,$dff066	; BLTDMOD
	move.w	#32*64+3,$dff058	; BLTSIZE (48 pixlar bred, 32 hg)

	add.l	#screenwidth/8*screenheight,a0
	dbf	d1,.bltwt
	movem.l	(sp)+,d0/d1/a0
	rts

; Detta r initialiserings-rutinen....
AttnFlags=296
INIT:
	movem.l	d0-a6,-(sp)
	bsr.w	FetchVBR

	move.l	$4.w,a6
	jsr	-132(a6)	; Forbid - Stng av multitasking

 IFNE DisableCache		; Kolla om den hr rutinen ska vara med...
	cmp.w	#36,20(a6)	; Disable Cache funkar bara p KS2.0++
	bcs.s	.not20		; Om lgre n 2.0 s hoppar vi vidare...
	move.l	#$00003818,d0	; Har inte kunnat testa de hr siffrorna
	move.l	#$80003b1b,d1	; men det ska frmodligen funka :-)
	jsr	-648(a6)	; CacheControl()
	lea.l	OldCache(pc),a0
	move.l	d0,(a0)
.not20:
 ENDC

	lea.l	gfxname(pc),a1
	jsr	-408(a6)	; OldOpenLibrary() - Funkar lika bra som
	tst.l	d0		; valiga openlibrary() om man inte behver
	beq.w	noGfx		; ppna en speciell version...
	move.l	d0,GfxBase
	move.l	d0,a6
	jsr	-456(a6)	; Ownblitter - Ska vi anvnda blittern mste
				; vi se till att vi fr ta den...
	jsr	-228(a6)	; Och det r lika bra att vnta p den ox!
				; Det gr vi med WaitBlit()
	sub.l	a1,a1
	jsr	-222(a6)	; Loadview - Nu kysser vi copperlistan adj!
	jsr	-270(a6)	; WaitTOF - Vnta tills vi med skerhet kan
	jsr	-270(a6)	; installera vra egna saker...WaitTOF ska
				; enligt Commodore helst kras tv gnger!
	lea.l	oldintena(pc),a1
	move.w	$dff01c,(a1)+	; Spara gamla interrupt statusen
	move.w	$dff002,(a1)	; Spara gammal DMA
	move.w	#$7fff,d0
	move.w	d0,$dff09a	; INTENA
	move.w	d0,$dff096	; DMACON - Vi rensar gammal skit...

 IFNE DisableMotor		; Kolla om vi ska ktta av drivemotorn...
	move.b	#-1,$bfd100	; Den hr lilla kodsnutten r inte direkt
	nop			; snll men br fungera nd. Det vrsta
	nop			; som kan hnda r att driven fortstter
	move.b	#$81,$bfd100	; att vara p.
	nop			; Mer om denna lilla snutt kommer nr jag
	nop			; tar upp HW-trackloading! Tills dess fr
	move.b	#-1,$bfd100	; ni svlja den utan frklaring...
 ENDC
	movem.l	(sp)+,d0-a6
	rts

NoGFX:	move.l	$4.w,a6
	jsr	-138(a6)	; Permit multitasking...
	movem.l	(sp)+,d0-a6
	rts

; Denna rutin stter upp systemet igen...
UNINIT:
	movem.l	d0-a6,-(sp)
	move.w	oldintena(pc),d0
	or.w	#$8000,d0		; S bitarna stts och inte rensas
	move.w	d0,$dff09a
	move.w	olddmacon(pc),d0
	or.w	#$8000,d0
	move.w	d0,$dff096

	move.l	gfxbase(pc),a6
	jsr	-228(a6)	; Waitblit()
	jsr	-462(a6)	; DisOwnBlit()

	lea.l	intname(pc),a1	; Nu mste vi ppna Intuition
	move.l	$4.w,a6
	jsr	-408(a6)	; OldOpenlibrary
	move.l	d0,a2
	tst.l	d0		; Kolla om intuition gick att ppna....
	beq.s	.closegfx	; Hoppa om det inte gick...

	lea.l	34(a2),a1	; Fetcha Viewporten!
	move.l	gfxbase(pc),a6
	jsr	-222(a6)	; Loadviewa in den riktiga viewporten!
	move.l	$26(a6),$dff080	; Och restora gamla copperlistorna...
	move.l	$30(a6),$dff084

	move.l	a2,a1
	move.l	$4.w,a6
	jsr	-414(a6)	; Stng intuition

.closegfx:
	move.l	$4.w,a6
	move.l	gfxbase(pc),a1
	jsr	-414(a6)	; och stng ocks graphics.library...

 IFNE DisableCache
; Nu stter vi p cache-minnet igen...
	cmp.w	#36,20(a6)	; Kolla version igen...Verkligen dumt
	bcs.s	.not20		; om det skulle ndra sig under programmets
				; gng! :-)))
	move.l	oldcache(pc),d0
	moveq	#-1,d1
	jsr	-648(a6)	; CacheControl()
.not20:
 ENDC
	jsr	-138(a6)	; Permit multitasking

	bsr.s	FetchTime
	movem.l	(sp)+,d0-a6
	rts

; Den hr rutinen hmtar VBR, vilket r en offset till vektoromrdet
; p hgre processorer n 68000. P en vanlig 68000 r VBR alltid 0.
FetchVBR:
	move.l	a6,-(sp)
	move.l	$4.w,a6			; Hmta exec
	sub.l	a0,a0			; Nollstll a0
	btst	#0,Attnflags+1(a6)	; Kolla om 68010++
	beq.s	.Lower
	move.l	a5,-(sp)
	lea.l	.getVBR(pc),a5
	jsr	-30(a6)		; Vi mste hmta VBR i supervisor mode
	move.l	(sp)+,a5
.lower:	move.l	(sp)+,a6
	rts

.GetVBR:movem.l	a0/a1,-(sp)
	lea.l	MyVBR(pc),a1	; Hr ska vi skriva in VBRen.
	dc.l	$4e7a8801	; Detta r egentligen instruktionen
				; MOVEC VBR,A0 men eftersom ldre versioner
				; av AsmOne inte stdjer den instruktionen
				; gjorde jag ett litet specialtrick hr...
	move.l	a0,(a1)
	movem.l	(sp)+,a0/a1
	rte			; tervnd frn supervisor...

; Fetch Time Variables
IOTV_SIZE		=$28
IO_COMMAND		=$1C
TR_SETSYSTIME		=$B
tr_time			=$20
_LVOCloseDevice		=-$1C2
_LVODoIO		=-$1C8
_LVOReadBattClock	=-$C
_LVOOpenDevice		=-$1BC
_LVOOpenResource	=-$1F2
FetchTime:
	movem.l	d0-a6,-(sp)
	move.l	4.w,a6
	lea	battclockname(pc),a1
	jsr	_LVOOpenResource(a6)
	move.l	d0,d6
	beq.b	.noclock

	moveq	#0,d0
	moveq	#0,d1
	lea	timername(pc),a0
	lea	timerio(pc),a2
	move.l	a2,a1
	jsr	_LVOOpenDevice(a6)
	move.l	d0,d7
	bne.b	.notimerdev

	exg.l	d6,a6
	jsr	_LVOReadBattClock(a6)
	exg.l	d6,a6
	move.l	a2,a1
	move.l	d0,tr_time(a1)
	move.w	#TR_SETSYSTIME,IO_COMMAND(a1)
	jsr	_LVODoIO(a6)
	move.l	a2,a1
	jsr	_LVOCloseDevice(a6)
.notimerdev
.noclock
	movem.l	(sp)+,d0-a6
	rts

timerio	blk.b	IOTV_SIZE
battclockname	dc.b	'battclock.resource',0
timername	dc.b	'timer.device',0
		even
MyVBR:	dc.l	0		; Hr lgger vi VBR!

*** End of INIT routine ***


SetBplPtr:
	movem.l	d0-a6,-(sp)
	move.l	ShowPage(pc),a0
	move.l	a0,d0
	lea.l	bplptr+2(pc),a0
	moveq	#4-1,d7
.setbpl:move.w	d0,4(a0)
	swap	d0
	move.w	d0,(a0)
	swap	d0
	lea.l	8(a0),a0
	add.l	#screensize,d0
	dbf	d7,.setbpl
	movem.l	(sp)+,d0-a6
	rts

CreateMask:
	movem.l	d0-a6,-(sp)
	lea.l	ball,a0
	lea.l	mask,a2
	moveq	#4-1,d7			; Antal bitplan
.nxtbpl:moveq	#[16/8*16]-1,d6		; Bobstorlek
	move.l	a2,a1
.maska:	move.b	(a0)+,d0
	or.b	d0,(a1)+
	dbf	d6,.maska
	dbf	d7,.nxtbpl
	movem.l	(sp)+,d0-a6
	rts

InitCoords:
	movem.l	d0-a6,-(sp)
	lea.l	coords,a0
	moveq	#32,d0		; X
	moveq	#32,d1		; Y
	moveq	#10,d2		; X add
	moveq	#6,d3		; Y add
	moveq	#SpeedX,d4	; X add in main
	moveq	#SpeedY,d5	; Y add in main
	move.l	#NrOfBobs-1,d7
.loop:	move.w	d0,(a0)+
	move.w	d1,(a0)+
	move.w	d4,(a0)+
	move.w	d5,(a0)+
	add.l	d2,d0
	add.l	d3,d1
	cmp.l	#Screenwidth-48,d0
	ble.s	.NotRightEdge
	neg.l	d2
	neg.l	d4
.NotRightEdge:
	cmp.l	#32,d0
	bge.s	.NotLeftEdge
	neg.l	d2
	neg.l	d4
.NotLeftEdge:
	cmp.l	#screenheight-16,d1
	ble.s	.NotLowerEdge
	neg.l	d3
	neg.l	d5
.NotLowerEdge:
	cmp.l	#0,d1
	bge.s	.NotUpperEdge
	neg.l	d3
	neg.l	d5
.NotUpperEdge:
	dbf	d7,.loop

	movem.l	(sp)+,d0-a6
	rts

SwapPages:
	movem.l	d0/a0,-(sp)
	lea.l	ShowPage(pc),a0
	move.l	(a0),d0
	move.l	4(a0),(a0)
	move.l	d0,4(a0)
	bsr.w	SetBplPtr
	movem.l	(sp)+,d0/a0
	rts

************* COPPER ************

copper:
	dc.w	$008e,$2c81	; DIWSTRT
	dc.w	$0090,$2cc1	; DIWSTOP
	dc.w	$0092,$0038	; DDFSTRT
	dc.w	$0094,$00d0	; DDFSTOP
	dc.w	$0100,$4200	; BPLCON0
	dc.w	$0102,$0000	; BPLCON1
	dc.w	$0104,$0000	; BPLCON2
	dc.w	$0108,$0000	; BPLMOD0
	dc.w	$010a,$0000	; BPLMOD1

	; Bitplanspekare
bplptr:	dc.w	$00e0,$0000,$00e2,$0000,$00e4,$0000,$00e6,$0000
	dc.w	$00e8,$0000,$00ea,$0000,$00ec,$0000,$00ee,$0000

	; Kulans frger (sparat i en IFF2RAW konverterare)
ballcols:
	dc.w	$0180,$0000,$0182,$0fff,$0184,$0ede,$0186,$0dce
	dc.w	$0188,$0cad,$018a,$0b9d,$018c,$0a8c,$018e,$097c
	dc.w	$0190,$096b,$0192,$085b,$0194,$074a,$0196,$063a
	dc.w	$0198,$0629,$019a,$0519,$019c,$0518,$019e,$0408

	dc.w	$4407,$fffe,$0180,$fff
	dc.w	$4507,$fffe,$0180,$005

	dc.w	$ffdf,$fffe
	dc.w	$1007,$fffe,$0180,$fff
	dc.w	$1107,$fffe,$0180,$000

	dc.w	$ffff,$fffe

gfxname:dc.b	'graphics.library',0
intname:dc.b	'intuition.library',0
	even
gfxbase:dc.l	0
oldintena:
	dc.w	0
olddmacon:
	dc.w	0
OldCache:
	dc.l	0

ShowPage:
	dc.l	screen1
DrawPage:
	dc.l	screen2

	; Tv skrmar for dubbelbuffring...
	section	scr,BSS_c
screen1:ds.b	40*256*4
screen2:ds.b	40*256*4

	section	Qula,data_c
Ball:	incbin	'df1:Kula.raw'
Mask:	blk.b	16/8*16,0
Coords:	blk.w	NrOfBobs*4,0

; Blitter MINTERM data
DEST =	$100
SRCC =	$200
SRCB =	$400
SRCA =	$800

ABC =	$80
ABNC =	$40
ANBC =	$20
ANBNC =	$10
NABC =	$8
NABNC =	$4
NANBC =	$2
NANBNC =	$1

A = ABC!ABNC!ANBC!ANBNC
B = ABC!ABNC!NABC!NABNC
C = ABC!ANBC!NABC!NANBC

NA = (~A)&$FF
NB = (~B)&$FF
NC = (~C)&$FF

