; Septic's Demoskola - Lektion 2 : Copper Madness
; Skriven av Vicious / Septic 18 April 1993

DisableCache=1	; En etta betyder att funktionen r p!
DisableMotor=1

	section	Lektion2,code_c

j:	movem.l	d0-a6,-(sp)

	bsr.w	INIT
	tst.l	gfxbase		; Kolla om vi hittade gfx.library
	beq.s	error		; Nepp...D hoppar vi ut...

	move.w	#%1000001010000000,$dff096	; Endast Copper DMA r p!
	;	  S    NDBCBSD
	;	  E    aMPOLPS
	;	  T    sALPTRK
	;	       t
	;              y

	move.l	#copper,$dff080	; Nu stter vi vr egen copperlista
	move.w	d0,$dff088	; Och tvingar den att brja direkt...

main:
	bsr.s	sync		; Vnta p en speciell strlposition
	bsr.w	ClrBars		; Rensa gamla rasterbalkar
	bsr.s	SwingBars	; Stt ut de nya balkarna!
	btst	#6,$bfe001	; Testa vnster musknapp!
	bne.s	main

xit:	bsr.w	UnINIT
error:	movem.l	(sp)+,d0-a6
	rts

sync:	move.l	$dff004,d0	; Hmta strlens position
	and.l	#$1ff00,d0	; Maska bort horisontella positionen
	lsr.l	#8,d0		; Shifta ner till lgsta bitarna
	cmp.w	#$f0,d0		; Kolla om det r rtt vertikal position
	bne.s	sync
	rts

TableCounter:
	dc.l	0

SwingBars:
	movem.l	d0-a6,-(sp)
	lea.l	CopperBarGfx(pc),a0	; Hr har vi frgerna p balkarna
	lea.l	bars+14(pc),a1		; Hr ska vi flytta in balkarna
	lea.l	SineTable(pc),a2	; Pekare till sinustabellen
	move.l	#3,d0			; Tjockleken p minsta balken

	moveq	#5,d7			; Stt ut 6 balkar (6-1 fr DBF-loop)
.get:	move.l	tablecounter(pc),d1	; Hmta offset fr sinustabellen
	addq.l	#4,tablecounter		; och ka den sen till nsta longword
	move.l	(a2,d1.w),d2		; Hmta sinusvrde till D2
	bpl.s	.notneg			; Branch if PLus...Hoppa om D2 inte
					; r negativt.
	move.l	#0,TableCounter		; Nollstll tabell-offset-pekaren
	bra.s	.get			; om vi r i slutet p sinustabellen.
.notneg:
	asl.l	#3,d2			; Multiplicera d2 med 8 (eller som
					; jag gr hr: skifta d2 tre steg
					; t vnster vilket r snabbare)
					; eftersom frgvrdena ligger med
					; ett mellanrum p 8 bytes i copper-
					; listan!
	bsr.s	MoveBar			; Flytta in balken i copperlistan
	addq.l	#1,d0			; ka p tjockleken, s att vi nsta
					; gng inte hmtar fr lite frgdata
					; frn copperbalk-grafiken...
	addq.l	#4,d1			; Vi kar ocks p sinuspekaren
					; s att vi hamnar p nsta longword
					; i tabellen...
.get2:	move.l	(a2,d1.w),d2		; Hr hmtar vi sinusvrde igen...
	bpl.s	.notneg2		; Och hoppar om det r positivt
	moveq.l	#0,d1			; Annars nollstller vi offseten....
	bra.s	.get2
.notneg2:
	dbf	d7,.notneg		; Loopa tillbaka fr mer balkar

	movem.l	(sp)+,d0-a6
	rts

MoveBar:
	movem.l	d0/a1,-(sp)
.movit:	move.w	(a0)+,(a1,d2.w)		; Flytta in frgkod i copperlistan
	lea.l	8(a1),a1		; ka copperlist-pekaren med 8
	dbf	d0,.movit		; Loopa det antal gnger som
					; tjockleken anger...
	movem.l	(sp)+,d0/a1
	rts

ClrBars:
	movem.l	d0-a6,-(sp)
	lea.l	bars(pc),a0		; Vi stller in A0 p vra balkar
					; i copperlistan
	move.l	#$5807fffe,d0		; Stter frsta wait-koden i D0
	move.l	#$01800000,d1		; Och koden fr att byta bakgrunds-
					; frg till svart i D1
	move.l	#($a8)-1,d7		; Vr lista r $A8*2 longwords...
.setup:	move.l	d0,(a0)+		; Skriv in waitkod i coperlistan
	move.l	d1,(a0)+		; och skriv in "byt-bakgrundsfrg"-kod
	add.l	#$01000000,d0		; ka waitkod s att den vntar p
					; nsta vertikala rad
	dbf	d7,.setup		; Loopa...
	movem.l	(sp)+,d0-a6
	rts

; Detta r initialiserings-rutinen....
AttnFlags=296
INIT:
	movem.l	d0-a6,-(sp)
	bsr.w	FetchVBR

	move.l	$4.w,a6
	jsr	-132(a6)	; Forbid - Stng av multitasking

 IFNE DisableCache		; Kolla om den hr rutinen ska vara med...
	cmp.w	#36,20(a6)	; Disable Cache funkar bara p KS2.0++
	bcs.s	.not20		; Om lgre n 2.0 s hoppar vi vidare...
	move.l	#$00003818,d0	; Har inte kunnat testa de hr siffrorna
	move.l	#$80003b1b,d1	; men det ska frmodligen funka :-)
	jsr	-648(a6)	; CacheControl()
	lea.l	OldCache(pc),a0
	move.l	d0,(a0)
.not20:
 ENDC

	lea.l	gfxname(pc),a1
	jsr	-408(a6)	; OldOpenLibrary() - Funkar lika bra som
	tst.l	d0		; valiga openlibrary() om man inte behver
	beq.w	noGfx		; ppna en speciell version...
	move.l	d0,GfxBase
	move.l	d0,a6
	jsr	-456(a6)	; Ownblitter - Ska vi anvnda blittern mste
				; vi se till att vi fr ta den...
	jsr	-228(a6)	; Och det r lika bra att vnta p den ox!
				; Det gr vi med WaitBlit()
	sub.l	a1,a1
	jsr	-222(a6)	; Loadview - Nu kysser vi copperlistan adj!
	jsr	-270(a6)	; WaitTOF - Vnta tills vi med skerhet kan
	jsr	-270(a6)	; installera vra egna saker...WaitTOF ska
				; enligt Commodore helst kras tv gnger!
	lea.l	oldintena(pc),a1
	move.w	$dff01c,(a1)+	; Spara gamla interrupt statusen
	move.w	$dff002,(a1)	; Spara gammal DMA
	move.w	#$7fff,d0
	move.w	d0,$dff09a	; INTENA
	move.w	d0,$dff096	; DMACON - Vi rensar gammal skit...

 IFNE DisableMotor		; Kolla om vi ska ktta av drivemotorn...
	move.b	#-1,$bfd100	; Den hr lilla kodsnutten r inte direkt
	nop			; snll men br fungera nd. Det vrsta
	nop			; som kan hnda r att driven fortstter
	move.b	#$81,$bfd100	; att vara p.
	nop			; Mer om denna lilla snutt kommer nr jag
	nop			; tar upp HW-trackloading! Tills dess fr
	move.b	#-1,$bfd100	; ni svlja den utan frklaring...
 ENDC
	movem.l	(sp)+,d0-a6
	rts

NoGFX:	move.l	$4.w,a6
	jsr	-138(a6)	; Permit multitasking...
	movem.l	(sp)+,d0-a6
	rts

; Denna rutin stter upp systemet igen...
UNINIT:
	movem.l	d0-a6,-(sp)
	move.w	oldintena(pc),d0
	or.w	#$8000,d0		; S bitarna stts och inte rensas
	move.w	d0,$dff09a
	move.w	olddmacon(pc),d0
	or.w	#$8000,d0
	move.w	d0,$dff096

	move.l	gfxbase(pc),a6
	jsr	-228(a6)	; Waitblit()
	jsr	-462(a6)	; DisOwnBlit()

	lea.l	intname(pc),a1	; Nu mste vi ppna Intuition
	move.l	$4.w,a6
	jsr	-408(a6)	; OldOpenlibrary
	move.l	d0,a2
	tst.l	d0		; Kolla om intuition gick att ppna....
	beq.s	.closegfx	; Hoppa om det inte gick...

	lea.l	34(a2),a1	; Fetcha Viewporten!
	move.l	gfxbase(pc),a6
	jsr	-222(a6)	; Loadviewa in den riktiga viewporten!
	move.l	$26(a6),$dff080	; Och restora gamla copperlistorna...
	move.l	$30(a6),$dff084

	move.l	a2,a1
	move.l	$4.w,a6
	jsr	-414(a6)	; Stng intuition

.closegfx:
	move.l	$4.w,a6
	move.l	gfxbase(pc),a1
	jsr	-414(a6)	; och stng ocks graphics.library...

 IFNE DisableCache
; Nu stter vi p cache-minnet igen...
	cmp.w	#36,20(a6)	; Kolla version igen...Verkligen dumt
	bcs.s	.not20		; om det skulle ndra sig under programmets
				; gng! :-)))
	move.l	oldcache(pc),d0
	moveq	#-1,d1
	jsr	-648(a6)	; CacheControl()
.not20:
 ENDC
	jsr	-138(a6)	; Permit multitasking

	movem.l	(sp)+,d0-a6
	rts

; Den hr rutinen hmtar VBR, vilket r en offset till vektoromrdet
; p hgre processorer n 68000. P en vanlig 68000 r VBR alltid 0.
FetchVBR:
	move.l	a6,-(sp)
	move.l	$4.w,a6			; Hmta exec
	sub.l	a0,a0			; Nollstll a0
	btst	#0,Attnflags+1(a6)	; Kolla om 68010++
	beq.s	.Lower
	move.l	a5,-(sp)
	lea.l	.getVBR(pc),a5
	jsr	-30(a6)		; Vi mste hmta VBR i supervisor mode
	move.l	(sp)+,a5
.lower:	move.l	(sp)+,a6
	rts

.GetVBR:movem.l	a0/a1,-(sp)
	lea.l	MyVBR(pc),a1	; Hr ska vi skriva in VBRen.
	dc.l	$4e7a8801	; Detta r egentligen instruktionen
				; MOVEC VBR,A0 men eftersom ldre versioner
				; inte stdjer den instruktionen gjorde jag
				; ett litet specialtrick hr...
	move.l	a0,(a1)
	movem.l	(sp)+,a0/a1
	rte			; tervnd frn supervisor...

MyVBR:	dc.l	0		; Hr lgger vi VBR!


************* COPPER ************

copper:
	dc.w	$008e,$2c81	; De hr sakerna ska vi g igenom nrmare
	dc.w	$0090,$2cc1	; i lektionen om bitplansgrafik!
	dc.w	$0092,$0038
	dc.w	$0094,$00d0
	dc.w	$0100,$0200
	dc.w	$0102,$0000
	dc.w	$0104,$0000
	dc.w	$0108,$0000
	dc.w	$010a,$0000

	; Detta r den versta, grna copperbalken!
	; Frst vntar vi p en rad, sen byter vi bakgrundsfrg och s
	; upprepar vi detta hela tiden fr att stadkomma en "balk"...
	dc.w	$4f07,$fffe,$0180,$0c0	; Rad $4f, kolumn $07, bakgrund $0c0
	dc.w	$5007,$fffe,$0180,$0e0	; Rad $50, kolumn $07, bakgrund $0e0
	dc.w	$5107,$fffe,$0180,$0f0	; osv....
	dc.w	$5207,$fffe,$0180,$0d0
	dc.w	$5307,$fffe,$0180,$0b0
	dc.w	$5407,$fffe,$0180,$090
	dc.w	$5507,$fffe,$0180,$070
	dc.w	$5607,$fffe,$0180,$040
	dc.w	$5707,$fffe,$0180,$000	; Sist stter vi svart bakgrund igen

bars:	blk.w	$a8*4,0		; Hr reserverar vi plats i copperlistan fr
				; vra rda copperbars som ska rra p sig.

	dc.w	$ffdf,$fffe	; Vnta p "PAL"-lge...Dvs dr den vertikala
				; positionen $00 gr ver till att bli $100
				; s att vi kan ha coppergrafik p rad 256 och
				; nert....(Notera att 256 r hrdvaru-
				; koordinater i det hr sammanhanget och
				; egentligen motsvarar skrmkoordinaten
				; 256 - 44 = 212)

	dc.w	$0107,$fffe,$0180,$0c0	; Hr gr vi vr andra grna balk...
	dc.w	$0207,$fffe,$0180,$0e0
	dc.w	$0307,$fffe,$0180,$0f0
	dc.w	$0407,$fffe,$0180,$0d0
	dc.w	$0507,$fffe,$0180,$0b0
	dc.w	$0607,$fffe,$0180,$090
	dc.w	$0707,$fffe,$0180,$070
	dc.w	$0807,$fffe,$0180,$040
	dc.w	$0907,$fffe,$0180,$000

	dc.w	$ffff,$fffe		; Slut p copperlistan!

; Detta r "grafiken" till vra copperbalkar...Egentligen r det en massa
; frgkoder som vi skriver in i copperlistan.
CopperBarGfx:
	; Bar 1 (Smalast)
	dc.w	$700
	dc.w	$800
	dc.w	$500
	dc.w	$000

	; Bar 2
	dc.w	$800
	dc.w	$900
	dc.w	$700
	dc.w	$400
	dc.w	$000

	; Bar 3
	dc.w	$900
	dc.w	$a00
	dc.w	$800
	dc.w	$600
	dc.w	$300
	dc.w	$000

	; Bar 4
	dc.w	$b00
	dc.w	$c00
	dc.w	$a00
	dc.w	$800
	dc.w	$600
	dc.w	$300
	dc.w	$000

	; Bar 5
	dc.w	$c00
	dc.w	$e00
	dc.w	$d00
	dc.w	$b00
	dc.w	$900
	dc.w	$700
	dc.w	$400
	dc.w	$000

	; Bar 6 (Tjockast)
	dc.w	$c00
	dc.w	$e00
	dc.w	$f00
	dc.w	$d00
	dc.w	$b00
	dc.w	$900
	dc.w	$700
	dc.w	$400
	dc.w	$000

gfxname:dc.b	'graphics.library',0
intname:dc.b	'intuition.library',0
	even
gfxbase:dc.l	0
oldintena:
	dc.w	0
olddmacon:
	dc.w	0
OldCache:
	dc.l	0

; Sinustabell, skapad med Sine Creator v1.10 (gjord av mig sjlv)! Verkligen
; ett mste nr man ska gra demos!

SineTable:
	dc.w	0,0,0,0,0,1,2,3,3,4,6,7
	dc.w	8,10,11,13,15,17,19,21,23,25,28,30
	dc.w	33,35,38,40,43,46,49,52,55,58,61,64
	dc.w	67,70,73,76,80,83,86,89,92,95,98,101
	dc.w	104,107,110,113,116,119,121,124,127,129,132,134
	dc.w	136,138,140,142,144,146,148,149,151,152,153,155
	dc.w	156,156,157,158,159,159,159,159,159,159,159,159
	dc.w	158,158,157,156,156,155,153,152,151,149,148,146
	dc.w	144,142,140,138,136,134,131,129,126,124,121,119
	dc.w	116,113,110,107,104,101,98,95,92,89,86,83
	dc.w	79,76,73,70,67,64,61,58,55,52,49,46
	dc.w	43,40,38,35,32,30,27,25,23,21,19,17
	dc.w	15,13,11,10,8,7,6,4,3,2,2,1
	dc.w	0,0,0
	dc.l	-1
