; Septic's Demoskola - Lektion 10 : Linjeritning
; Skriven av Vicious / Septic - 2 December 1993

DisableCache=1	; En nolla betyder att funktionen r avstngd...
DisableMotor=1

ScreenWidth=320
ScreenHeight=256
ScreenSize=Screenwidth/8*ScreenHeight

	section	Lektion10,code_c

j:	movem.l	d0-a6,-(sp)

	bsr.w	INIT
	tst.l	gfxbase		; Kolla om vi hittade gfx.library
	beq.s	error		; Nepp...D hoppar vi ut...

	move.w	#%1000001111000000,$dff096	; Stt DMA
	;	  S    NDBCBSD
	;	  E    aMPOLPS
	;	  T    sALPTRK
	;	       t
	;              y

	bsr.w	SetBplptr	; Stt bitplanspekare

	move.l	#copper,$dff080	; Nu stter vi vr egen copperlista
	move.w	d0,$dff088	; Och tvingar den att brja direkt...

	bsr.s	Draw		; Rita ut ngra fina figurer

main:
	bsr.s	sync
	btst	#6,$bfe001	; Testa vnster musknapp!
	bne.s	main

xit:	bsr.w	UnINIT
error:	movem.l	(sp)+,d0-a6
	rts

; Syncroniserings rutin
sync:	move.l	$dff004,d0
	and.l	#$1ff00,d0
	lsr.l	#8,d0
	cmp.w	#$f0,d0		; Kolla om rasterrad=$f0
	bne.s	sync
	rts

; Den hr rutinen ritar ut tv nonsens-figurer (en triangel och en
; fyrhrning) p tv olika stt, men anvnder sig utav samma linjeritnings-
; rutin.
Draw:
	movem.l	d0-a6,-(sp)
	move.l	showpage(pc),a0		; Skrmen vi ska rita p i A0
	move.l	#screenwidth/8,a1	; Skrmbredden i bytes
	move.l	#-1,a2			; Linjemask=$ffffffff (helt fylld)

	move.l	#100,d0		; X-koordinat 1 i D0
	move.l	#20,d1		; Y-koordinat 1 i D1
	move.l	#150,d2		; X-koordinat 2 i D2
	move.l	#200,d3		; Y-koordinat 2 i D3
	bsr.s	DrawLine	; Rita ut linjen

	move.l	#150,d0		; Gr samma sak med alla tre linjer
	move.l	#200,d1
	move.l	#50,d2
	move.l	#200,d3
	bsr.s	DrawLine

	move.l	#50,d0
	move.l	#200,d1
	move.l	#100,d2
	move.l	#20,d3
	bsr.s	DrawLine



	; Den hr metoden r smidigare...Hr har jag gjort en tabell med
	; koordinat-data som ligger vid labeln BalkData. Sen lser jag
	; bara frn den och ritar ut linjerna i en loop tills X2 r
	; negativt, dvs vi har lst till slutet av tabellen.

	lea.l	balkdata(pc),a5	; Peka p koordinat-tabellen
.nxt:	movem.l	(a5)+,d0-d3	; Hmta fyra koordinater p en gng
	tst.l	d2		; Kolla om X2 r negativt
	bmi.s	.ut		; I s fall, hoppa ut...
	bsr.s	DrawLine	; Rita ut linjen
	subq.l	#8,a5		; Backa en koordinat i tabellen s att
				; nsta linje hnger ihop med den frra...
	bra.s	.nxt		; Loopa tillbaka
.ut:
	movem.l	(sp)+,d0-a6
	rts

*** Linjeritnings Rutin  ***
; Den hr rutinen ritar en linje med blittern
; D0 - X1   D1 - Y1   D2 - X2   D3 - Y2
; A0 - Skrmpekare
; A1 - Skrmbredden i bytes
; A2 - Linjens mask ($ffff fr helt fylld linje)

DrawLine:
	movem.l	d4/d5/d7/a0-a6,-(sp)
	cmp.l	d0,d2
	bne.s	.ok
	cmp.l	d1,d3
	beq.w	.dontdraw
.ok:
	move.l	a1,d4		; Lgg skrmbredden i D4
	mulu.w	d1,d4		; Multiplicera med Y1
	moveq	#-$10,d5	; D5=$fffffff0
	and.w	d0,d5		; Plocka bort de 4 lgsta bitarna
	lsr.w	#3,d5		; Multiplicera med 8 (2^3=8)
	add.w	d5,d4		; Addera detta till Y1
	add.l	a0,d4		; Addera skrmpekaren till detta

	moveq	#0,d5
	sub.w	d1,d3		; Ta reda p delta Y
	roxl.b	#1,d5		; Shifta ut X-flaggan i D5. Att X-flaggan
				; stts hr anger att D1 r hgre n D3 och
				; drfr kan vi senare med hjlp av D5 ta
				; fram rtt oktant utan strre problem...
	tst.w	d3		; Kolla om D3 r negativt
	bge.s	.y2gy1
	neg.w	d3		; I s fall gr vi det positivt!
.y2gy1:
	sub.w	d0,d2		; Ta reda p delta X och gr samma sak som
				; med Y...
	roxl.b	#1,d5
	tst.w	d2
	bge.s	.x2gx1
	neg.w	d2
.x2gx1:
	move.w	d3,d1		; Flytta delta Y till D1
	sub.w	d2,d1		; Delta Y-Delta X anger vilket som r
				; strst!
	bge.s	.dygdx
	exg	d2,d3		; Vi vill ha det strsta vrdet i D3.
				; Detta r nu dx.

.dygdx:	roxl.b	#1,d5		; Shifta in X-flaggan hr ocks...

	move.b	Octant_table(pc,d5.l),d5	; Nu kan vi enkelt hmta
						; korrekt oktant frn en
						; speciell tabell...

	add.w	d2,d2		; dy multiplicerat med 2

.WBlit:	btst #6,$dff002	; Vnta tills blittern r klar
	bne.s	.WBlit

	move.w	d2,$dff062	; Skriv dy till BLTBMOD
	sub.w	d3,d2		; Kolla om vi behver stta SIGN-biten
	bge.s	.signnl
	or.b	#$40,d5		; Stt SIGN-flaggan i D5
.signnl: move.w	d2,$dff052	; Skriv (4*dy)-(2*dx) till BLTAPT
	sub.w	d3,d2
	move.w	d2,$dff064	; Och skriv 4*(dy-dx) till BLTAMOD

	move.w	#$8000,$dff074	; Stt BLTADAT till $8000
	move.w	a2,$dff072	; Stt linjemask i BLTBDAT
	move.w	#$ffff,$dff044	; Stt rtt BLTAFWM
	and.w	#$000f,d0	; Maska bort allt utom de lgsta 4 bitarna
	ror.w	#4,d0		; Flytta upp 4 lga bitarna till de 4 hga

	or.w	#(srca+srcc+dest)+(a&b+na&c),d0	; Minterm AB+aC

	move.w	d0,$dff040	; Stt korrekt vrde i BLTCON0
	move.w	d5,$dff042	; och i BLTCON1
	move.l	d4,$dff048	; Frsta pixeln p linjen
	move.l	d4,$dff054	; Och frsta pixeln p linjen hr ocks
	move.w	a1,$dff060	; Bredden p skrmen i BLTCMOD
	move.w	a1,$dff066	; och i BLTDMOD ocks

	lsl.w	#6,d3		; dx i bit 6-15
	addq.w	#2,d3		; och bit 0-5 = 2
	move.w	d3,$dff058	; Stt detta sen i BLTSIZE fr att starta
				; linjen...

.dontdraw:
	movem.l	(sp)+,d4/d5/d7/a0-a6
	rts

Octant_table:
	dc.b 0*4+1	; y1<y2, x1<x2, dx<dy = Okt6 
	dc.b 4*4+1	; y1<y2, x1<x2, dx>dy = Okt7
	dc.b 2*4+1	; y1<y2, x1>x2, dx<dy = Okt5
	dc.b 5*4+1	; y1<y2, x1>x2, dx>dy = Okt4
	dc.b 1*4+1	; y1>y2, x1<x2, dx<dy = Okt1
	dc.b 6*4+1	; y1>y2, x1<x2, dx>dy = Okt0
	dc.b 3*4+1	; y1>y2, x1>x2, dx<dy = Okt2
	dc.b 7*4+1	; y1>y2, x1>x2, dx>dy = Okt3


; Detta r initialiserings-rutinen....
AttnFlags=296
INIT:
	movem.l	d0-a6,-(sp)
	bsr.w	FetchVBR

	move.l	$4.w,a6
	jsr	-132(a6)	; Forbid - Stng av multitasking

 IFNE DisableCache		; Kolla om den hr rutinen ska vara med...
	cmp.w	#36,20(a6)	; Disable Cache funkar bara p KS2.0++
	bcs.s	.not20		; Om lgre n 2.0 s hoppar vi vidare...
	move.l	#$00003818,d0	; Har inte kunnat testa de hr siffrorna
	move.l	#$80003b1b,d1	; men det ska frmodligen funka :-)
	jsr	-648(a6)	; CacheControl()
	lea.l	OldCache(pc),a0
	move.l	d0,(a0)
.not20:
 ENDC

	lea.l	gfxname(pc),a1
	jsr	-408(a6)	; OldOpenLibrary() - Funkar lika bra som
	tst.l	d0		; valiga openlibrary() om man inte behver
	beq.w	noGfx		; ppna en speciell version...
	move.l	d0,GfxBase
	move.l	d0,a6
	jsr	-456(a6)	; Ownblitter - Ska vi anvnda blittern mste
				; vi se till att vi fr ta den...
	jsr	-228(a6)	; Och det r lika bra att vnta p den ox!
				; Det gr vi med WaitBlit()
	sub.l	a1,a1
	jsr	-222(a6)	; Loadview - Nu kysser vi copperlistan adj!
	jsr	-270(a6)	; WaitTOF - Vnta tills vi med skerhet kan
	jsr	-270(a6)	; installera vra egna saker...WaitTOF ska
				; enligt Commodore helst kras tv gnger!
	lea.l	oldintena(pc),a1
	move.w	$dff01c,(a1)+	; Spara gamla interrupt statusen
	move.w	$dff002,(a1)	; Spara gammal DMA
	move.w	#$7fff,d0
	move.w	d0,$dff09a	; INTENA
	move.w	d0,$dff096	; DMACON - Vi rensar gammal skit...

 IFNE DisableMotor		; Kolla om vi ska ktta av drivemotorn...
	move.b	#-1,$bfd100	; Den hr lilla kodsnutten r inte direkt
	nop			; snll men br fungera nd. Det vrsta
	nop			; som kan hnda r att driven fortstter
	move.b	#$81,$bfd100	; att vara p.
	nop			; Mer om denna lilla snutt kommer nr jag
	nop			; tar upp HW-trackloading! Tills dess fr
	move.b	#-1,$bfd100	; ni svlja den utan frklaring...
 ENDC
	movem.l	(sp)+,d0-a6
	rts

NoGFX:	move.l	$4.w,a6
	jsr	-138(a6)	; Permit multitasking...
	movem.l	(sp)+,d0-a6
	rts

; Denna rutin stter upp systemet igen...
UNINIT:
	movem.l	d0-a6,-(sp)
	move.w	oldintena(pc),d0
	or.w	#$8000,d0		; S bitarna stts och inte rensas
	move.w	d0,$dff09a
	move.w	olddmacon(pc),d0
	or.w	#$8000,d0
	move.w	d0,$dff096

	move.l	gfxbase(pc),a6
	jsr	-228(a6)	; Waitblit()
	jsr	-462(a6)	; DisOwnBlit()

	lea.l	intname(pc),a1	; Nu mste vi ppna Intuition
	move.l	$4.w,a6
	jsr	-408(a6)	; OldOpenlibrary
	move.l	d0,a2
	tst.l	d0		; Kolla om intuition gick att ppna....
	beq.s	.closegfx	; Hoppa om det inte gick...

	lea.l	34(a2),a1	; Fetcha Viewporten!
	move.l	gfxbase(pc),a6
	jsr	-222(a6)	; Loadviewa in den riktiga viewporten!
	move.l	$26(a6),$dff080	; Och restora gamla copperlistorna...
	move.l	$30(a6),$dff084

	move.l	a2,a1
	move.l	$4.w,a6
	jsr	-414(a6)	; Stng intuition

.closegfx:
	move.l	$4.w,a6
	move.l	gfxbase(pc),a1
	jsr	-414(a6)	; och stng ocks graphics.library...

 IFNE DisableCache
; Nu stter vi p cache-minnet igen...
	cmp.w	#36,20(a6)	; Kolla version igen...Verkligen dumt
	bcs.s	.not20		; om det skulle ndra sig under programmets
				; gng! :-)))
	move.l	oldcache(pc),d0
	moveq	#-1,d1
	jsr	-648(a6)	; CacheControl()
.not20:
 ENDC
	jsr	-138(a6)	; Permit multitasking

	bsr.s	FetchTime
	movem.l	(sp)+,d0-a6
	rts

; Den hr rutinen hmtar VBR, vilket r en offset till vektoromrdet
; p hgre processorer n 68000. P en vanlig 68000 r VBR alltid 0.
FetchVBR:
	move.l	a6,-(sp)
	move.l	$4.w,a6			; Hmta exec
	sub.l	a0,a0			; Nollstll a0
	btst	#0,Attnflags+1(a6)	; Kolla om 68010++
	beq.s	.Lower
	move.l	a5,-(sp)
	lea.l	.getVBR(pc),a5
	jsr	-30(a6)		; Vi mste hmta VBR i supervisor mode
	move.l	(sp)+,a5
.lower:	move.l	(sp)+,a6
	rts

.GetVBR:movem.l	a0/a1,-(sp)
	lea.l	MyVBR(pc),a1	; Hr ska vi skriva in VBRen.
	dc.l	$4e7a8801	; Detta r egentligen instruktionen
				; MOVEC VBR,A0 men eftersom ldre versioner
				; av AsmOne inte stdjer den instruktionen
				; gjorde jag ett litet specialtrick hr...
	move.l	a0,(a1)
	movem.l	(sp)+,a0/a1
	rte			; tervnd frn supervisor...

; Fetch Time Variables
IOTV_SIZE		=$28
IO_COMMAND		=$1C
TR_SETSYSTIME		=$B
tr_time			=$20
_LVOCloseDevice		=-$1C2
_LVODoIO		=-$1C8
_LVOReadBattClock	=-$C
_LVOOpenDevice		=-$1BC
_LVOOpenResource	=-$1F2
FetchTime:
	movem.l	d0-a6,-(sp)
	move.l	4.w,a6
	lea	battclockname(pc),a1
	jsr	_LVOOpenResource(a6)
	move.l	d0,d6
	beq.b	.noclock

	moveq	#0,d0
	moveq	#0,d1
	lea	timername(pc),a0
	lea	timerio(pc),a2
	move.l	a2,a1
	jsr	_LVOOpenDevice(a6)
	move.l	d0,d7
	bne.b	.notimerdev

	exg.l	d6,a6
	jsr	_LVOReadBattClock(a6)
	exg.l	d6,a6
	move.l	a2,a1
	move.l	d0,tr_time(a1)
	move.w	#TR_SETSYSTIME,IO_COMMAND(a1)
	jsr	_LVODoIO(a6)
	move.l	a2,a1
	jsr	_LVOCloseDevice(a6)
.notimerdev
.noclock
	movem.l	(sp)+,d0-a6
	rts

timerio	dcb.b	IOTV_SIZE
battclockname	dc.b	'battclock.resource',0
timername	dc.b	'timer.device',0
		even
MyVBR:	dc.l	0		; Hr lgger vi VBR!

*** End of INIT routine ***


SetBplPtr:
	movem.l	d0/a0,-(sp)
	move.l	ShowPage(pc),a0	; Hmta skrmpekaren
	move.l	a0,d0
	lea.l	bplptr+2(pc),a0
;	moveq	#4-1,d7
.setbpl:move.w	d0,4(a0)	; Stll in bitplanspekare
	swap	d0
	move.w	d0,(a0)
;	swap	d0
;	lea.l	8(a0),a0
;	add.l	#screensize,d0
;	dbf	d7,.setbpl
	movem.l	(sp)+,d0/a0
	rts

************* COPPER ************

copper:
	dc.w	$008e,$2c81	; DIWSTRT
	dc.w	$0090,$2cc1	; DIWSTOP
	dc.w	$0092,$0038	; DDFSTRT
	dc.w	$0094,$00d0	; DDFSTOP
	dc.w	$0100,$1200	; BPLCON0
	dc.w	$0102,$0000	; BPLCON1
	dc.w	$0104,$0000	; BPLCON2
	dc.w	$0108,$0000	; BPLMOD0
	dc.w	$010a,$0000	; BPLMOD1

	; Bitplanspekare
bplptr:	dc.w	$00e0,$0000,$00e2,$0000,$00e4,$0000,$00e6,$0000
	dc.w	$00e8,$0000,$00ea,$0000,$00ec,$0000,$00ee,$0000

	dc.w	$0180,$003,$0182,$0e6

	dc.w	$ffff,$fffe

gfxname:dc.b	'graphics.library',0
intname:dc.b	'intuition.library',0
	even
gfxbase:dc.l	0
oldintena:
	dc.w	0
olddmacon:
	dc.w	0
OldCache:
	dc.l	0

ShowPage:
	dc.l	screen1

BalkData:
	dc.l	300,80,200,230,200,240,300,90,300,80
	dc.l	-1

	section	scr,BSS_c
screen1:ds.b	screensize*1	; 1 bitplan

; Blitter MINTERM data
DEST =	$100
SRCC =	$200
SRCB =	$400
SRCA =	$800

ABC =	$80
ABNC =	$40
ANBC =	$20
ANBNC =	$10
NABC =	$8
NABNC =	$4
NANBC =	$2
NANBNC =	$1

A = ABC!ABNC!ANBC!ANBNC
B = ABC!ABNC!NABC!NABNC
C = ABC!ANBC!NABC!NANBC

NA = (~A)&$FF
NB = (~B)&$FF
NC = (~C)&$FF
