(****************************************************************************)
(*                                                                          *)
(*                                letjtk                                 *)
(*                                                                          *)
(*                           rta: Trk Viktor                             *)
(*                                                                          *)
(*                          ANNO DOMINI MCMXCVII                            *)
(*                                                                          *)
(****************************************************************************)

program EletJatek;

 {$R+}

 uses Crt;

 const Ures = 0;
       Sejt = 1;

 const SejtKep = ord('O');
       UresKep = ord('');

 const MaxX = 81;
       MaxY = 26;

 const Valoszinuseg = 0.5;

 type Eletter_ = array[0..MaxX,0..MaxY] of byte;

 var eletter : array[0..1] of Eletter_;

 var aktiv : byte;

(****************************************************************************)
(*                          A kurzor kikapcsolsa                           *)
(****************************************************************************)

 procedure CursorOff;

  Assembler;

  asm
   mov ah,1
   mov cx,2020h
   int 10h
  end;

(****************************************************************************)
(*                          A kurzor bekapcsolsa                           *)
(****************************************************************************)

 procedure CursorOn;

  Assembler;

  asm
   mov ah,1
   mov cx,0a0bh
   int 10h
  end;

(****************************************************************************)
(*                         Az lettr kirajzolsa                           *)
(****************************************************************************)

 procedure Kirajzolas;

  var i,j : word;

  procedure Kiir(x,y : word;t : byte);

   var cim : word;

   begin
    cim:=((x-1)+(y-1)*80)*2;

    if (t=Sejt) then

     Mem[$b800:cim]:=SejtKep

    else

     Mem[$b800:cim]:=UresKep;
   end;

  begin
   for i:=1 to MaxX-1 do

    for j:=1 to MaxY-1 do

     if (eletter[aktiv][i,j]=Sejt) then

      Kiir(i,j,Sejt)

     else

      Kiir(i,j,Ures);
  end;

(****************************************************************************)
(*                        Az lettr inicializlsa                         *)
(****************************************************************************)

 procedure Inicializalas;

  var i,j : word;

  begin
   for i:=0 to MaxX do

    for j:=0 to MaxY do

     eletter[aktiv][i,j]:=Ures;
  end;

(****************************************************************************)
(*                    Az lettr vletlenszer feltltse                   *)
(****************************************************************************)

 procedure Veletlenszeru_feltoltes;

  var i,j : word;
      x,y : word;
      a   : real;

  begin
   Randomize;

   for i:=1 to MaxX-1 do

    for j:=1 to MaxY-1 do

     begin
      a:=Random(100)/100;

      if (a<Valoszinuseg) then

       eletter[aktiv][i,j]:=Sejt

      else

       eletter[aktiv][i,j]:=Ures;
     end;
  end;

(****************************************************************************)
(*                        Az lettr sajt feltltse                       *)
(****************************************************************************)

 procedure Sajat_feltoltes;

  const Kurzor = 2;

  var b   : char;
      x,y : word;
      ki  : boolean;

   procedure Kiir(x,y : word;t : byte);

    var cim : word;

    begin
     cim:=(x-1+(y-1)*80)*2;

     if (t=Sejt) then

      Mem[$b800:cim]:=SejtKep

     else
     if (t=Ures) then

      Mem[$b800:cim]:=UresKep

     else
      Mem[$b800:cim]:=ord('');
    end;

  begin
   ki:=false;

   x:=1;
   y:=1;

   Kiir(x,y,Kurzor);

   while (not ki) do

    begin
     b:=ReadKey;

     if (eletter[aktiv][x,y]=Sejt) then

      Kiir(x,y,Sejt)

     else

      Kiir(x,y,Ures);

     case b of

      'a' : if (x>1) then x:=x-1;

      'd' : if (x<MaxX-1) then x:=x+1;

      'w' : if (y>1) then y:=y-1;

      'x' : if (y<MaxY-1) then y:=y+1;

      't' : begin
             Inicializalas;
             Kirajzolas;
            end;

      ' ' : eletter[aktiv][x,y]:=1-eletter[aktiv][x,y];

      #27: ki:=true;
     end;

     Kiir(x,y,Kurzor);
    end;
  end;

(****************************************************************************)
(*                     Egy cella l szomszdainak szma                    *)
(****************************************************************************)

 function Sejt_szomszedok(x,y : integer) : byte;

  var i,j : integer;
      sum : byte;

  begin
   sum:=0;

   for i:=-1 to 1 do

    for j:=-1 to 1 do

     if (eletter[aktiv][x+i,y+j]=Sejt) then sum:=sum+1;

   if (eletter[aktiv][x,y]=Sejt) then sum:=sum-1;

   Sejt_szomszedok:=sum;
  end;

(****************************************************************************)
(*                       Egy j letciklus szimulcija                     *)
(****************************************************************************)

 procedure Uj_ciklus;

  var i,j  : word;
      szom : byte;

  begin
   for i:=1 to MaxX-1 do

    for j:=1 to MaxY-1 do

     begin
      szom:=Sejt_szomszedok(i,j);

      if (szom=3) then

       eletter[1-aktiv][i,j]:=Sejt

      else
      if (szom<2) or (szom>3) then

       eletter[1-aktiv][i,j]:=Ures

      else
       eletter[1-aktiv][i,j]:=eletter[aktiv][i,j];
     end;
  end;

(****************************************************************************)
(*                                Fprogram                                 *)
(****************************************************************************)

 var b : char;

 begin
  CursorOff;

  while (true) do

   begin
    ClrScr;

    aktiv:=0;

    Inicializalas;

    GotoXY(35,2);
    Writeln('letjtk');
    GotoXY(35,3);
    Writeln('---------');
    GotoXY(27,4);
    Writeln('a: Vletlenszer feltlts');
    GotoXY(31,5);
    Writeln('b: Sajt feltlts');
    GotoXY(33,6);
    Writeln('Egyb: Kilps');

    b:=ReadKey;

    case b of

     'a' : begin
            Kirajzolas;
            Veletlenszeru_feltoltes;
           end;

     'b' : begin
            Kirajzolas;
            Sajat_feltoltes;
           end;

     else break; { :-> }
    end;

    Kirajzolas;

    while (not keypressed) do

     begin
      Uj_ciklus;

      Kirajzolas;

      Delay(500);

      aktiv:=1-aktiv;
     end;

    ReadKey;
   end;

  CursorOn;
 end.