PROGRAM PCX16Farben;

USES CRT,DOS;

CONST DateiName = 'c:\mag\stod\stodmain.pcx';

VAR Bild   : File;
    Puffer : Pointer;
    Regs   : Registers;

PROCEDURE InitMode(Mode : BYTE);
BEGIN
 Regs.AH := $00;
 Regs.AL := Mode;
 Intr($10,Regs);                    {Setze VideoModus}
END;

PROCEDURE ZeigePCX;
VAR Zeiger    : ^BYTE;
    Palette   : ARRAY[1..48] OF BYTE;
    Index,
    BitPlane  : BYTE;
    Offset,i  : WORD;
BEGIN
 PORTW[$03CE] := $0005;       {WriteMode #0}
 PORTW[$03C4] := $0102;       {BitPlane #0 einblenden}
 PORTW[$03CE] := $FF08;       {BitMaske auf $FF}
 PORTW[$03CE] := $0003;       {Punkte ersetzen}

 Zeiger := Puffer;                {Zeiger auf Adresse von Puffer setzen}
 INC(Zeiger,16);                  {Zeiger auf Farbtabelle}
 PORT[$03C8] := 0;                {Mit Farbe 0 anfangen}

 FOR i := 0 TO 15 DO BEGIN       {Farben setzen}

  Index := PORT[$03DA];           {Farben auf sich selbst setzen...}
  PORT[$03C0] := i; PORT[$03C0] := i;
  PORT[$03C0] := 32;

  FOR Index := 1 TO 3 DO BEGIN    {RGB-Werte eintragen}
   PORT[$03C9] := Zeiger^ SHR 2;
   Inc(Zeiger);
  END;
 END;

 Index := 0; BitPlane := 1; Offset := 0;
 Zeiger := Puffer; Inc(Zeiger,128);         {Variablen initialisieren}

 REPEAT
  IF Zeiger^ AND $C0 = $C0 THEN BEGIN       {Wenn ZhlByte, dann}
   Index := Zeiger^ AND $3F; Inc(Zeiger);      {Setze Index und erhhe Zeiger}
   FOR i := Offset TO Offset+Index DO MEM[$A000:i] := Zeiger^; {Trage Farbe 'Index-Mal' ein}
   Inc(Offset,Index); Index := 0; Inc(Zeiger); {Offset um Index erhhen, Index wieder auf 0}
  END ELSE BEGIN                            {Wenn kein ZhlByte}
   MEM[$A000:Offset] := Zeiger^;            {Setze Farbe}
   Inc(Offset); Inc(Zeiger);                {Erhhe Offset/Zeiger um eins}
  END;
  IF Offset MOD 80 = 0 THEN BEGIN           {Wenn Ende einer Zeile erreicht, dann:}
   IF BitPlane <> 8 THEN BEGIN              {Wenn BitPlane <> #3, dann:}
    BitPlane := BitPlane SHL 1;             {Nchste BitPlane}
    Dec(Offset,80);                         {Offset wieder auf ZeilenBeginn}
   END ELSE BitPlane := 1;                  {Sonst : BitPlane #0}
   PORT[$03C5] := BitPlane;                 {Trage BitPlane ein}
  END;
 UNTIL (Offset = 38400) OR KeyPressed;      {Ende: Wenn BildEnde oder Tastendruck}
 ReadLn;
END;

BEGIN
 InitMode($12);                             {VidMode: 640x580x16}
 Assign(Bild,DateiName);
 Reset(Bild,1);                             {Datei mu vorhanden sein!}
 GetMem(Puffer,FileSize(Bild));             {Gengend Speicher reservieren}
 BlockRead(Bild,Puffer^,FileSize(Bild));    {Lese Datei in Speicher/Puffer}
 ZeigePCX;
 FreeMem(Puffer,FileSize(Bild));            {Speicher wieder freigeben}
 Close(Bild);
 InitMode($03);                             {Wieder in TextModus}
END.