// Simple OpenGL plasma effect. Incube #2 edition ;-)

#pragma comment (lib,"opengl32.lib")
#pragma comment (lib,"winmm.lib")

#include <windows.h>
#include <gl\gl.h>
#include <math.h>

#define SCREEN_X 1152.0 //    :-)
#define SCREEN_Y 864.0  //    :-)

#define GRID_X 64       //    :-)
#define GRID_Y 64       //    :-)

HWND  hWnd;
HDC   hDC;
HGLRC hRC;

float*         Vertex;
unsigned char* Color;
int*           Index;

int i, j, n;

int __stdcall WinMain(HINSTANCE hInst,HINSTANCE hPrevInst,char* CmdLine,int CmdShow)
{
  Vertex = new float[GRID_X * GRID_Y * 2];
  Color  = new unsigned char[GRID_X*GRID_Y * 3];
  Index  = new int[(GRID_X - 1) * (GRID_Y - 1) * 4];

  for(i = 0, n = 0; i < GRID_Y; i++)
  {
    for(j = 0; j < GRID_X; j++)
    {
      Vertex[n++] = float(j) / (GRID_X - 1);
      Vertex[n++] = float(i) / (GRID_Y - 1);
    }
  }

  for(i = 0, n = 0; i < GRID_Y - 1; i++)
  {
    for(j = 0; j < GRID_X - 1; j++)
    {
      int pos    = i * GRID_X + j;
      Index[n++] = pos;
      Index[n++] = pos + 1;
      Index[n++] = pos + 1 + GRID_X;
      Index[n++] = pos + GRID_X;
    }
  }

  ShowCursor(FALSE);
  hWnd = CreateWindowEx(0, "edit", 0, WS_POPUP | WS_VISIBLE, CW_USEDEFAULT, CW_USEDEFAULT, SCREEN_X, SCREEN_Y, 0, 0, 0, 0);
  hDC  = GetDC(hWnd);
  SetPixelFormat(hDC, 10, 0); // ! :) PixelFormat   ! :)
  hRC  = wglCreateContext(hDC);
  wglMakeCurrent(hDC, hRC);
  glViewport(0, 0, SCREEN_X, SCREEN_Y);
  glMatrixMode(GL_PROJECTION);
  glLoadIdentity();
  glOrtho(0, 1, 0, 1, -1, 1);
  glMatrixMode(GL_MODELVIEW);
  glLoadIdentity();
  glEnableClientState(GL_VERTEX_ARRAY);
  glEnableClientState(GL_COLOR_ARRAY);
  glVertexPointer(2, GL_FLOAT, 0, Vertex);
  glColorPointer(3, GL_UNSIGNED_BYTE, 0, Color);
  DWORD start = timeGetTime();
  while(!GetAsyncKeyState(VK_ESCAPE))
  {
    float t = float(timeGetTime() - start) / 1000.0f;
    for(i = 0,n = 0; i < GRID_Y; i++)
    {
      for(j = 0; j < GRID_X; j++)
      {
        float x = float(j) / GRID_X;
        float y = float(i) / GRID_Y;
        float a1 = 8 * sin(2 * x + t);
        float a2 = 7 * cos(2 * x + t);
        float a3 = 6 * sin(2 * x + t);
        Color[n++] = 127 * fabs(sin(a1 * x + t - 5 * sin(t) / 3) + cos(a1 * y - t + 8 * sin(t) / 6));
        Color[n++] = 127 * fabs(cos(a2 * x - t + 4 * sin(t) / 4) + sin(a2 * y + t - 7 * sin(t) / 7));
        Color[n++] = 127 * fabs(sin(a3 * x + t - 3 * sin(t) / 5) + cos(a3 * y - t + 6 * sin(t) / 8));
      }
    }
    glDrawElements(GL_QUADS, (GRID_X - 1) * (GRID_Y - 1) * 4, GL_UNSIGNED_INT, Index);
    SwapBuffers(hDC);
  }
  return 0;
}