///////////////// Spline ////////////////////

float catmullrom_interpolate(float v0, float v1, float v2, float v3, float x, float distance)
// v0 and v1 are the 2 random pixels to the left
// v2 and v3 are the 2 random pixels to the right

// .  .  .  .  v0 .  .  .  v1 .  .  .  v2 .  .  .  v3 .  .  .
//                            x  x  x
{
   // make x range from 0 to 1
   float xx = x / distance;
   float P = (v3 - v2) - (v0 - v1);
   float Q = (v0 - v1) - P;
   float R =  v2 - v0;
   return (P*xx*xx*xx) + (Q*xx*xx) + (R*xx) + v1;
}


/////////////////// HSV //////////////////////

int hsv_to_rgb(float h,float s,float v)
// output = (r<<16) + (g<<8) + b
{
   float r,g,b;

   while (h<0.0) h += 360.0;
   while (h>=360.0) h -= 360.0;

   if (s==0.0) {
      r=v;
      g=v;
      b=v;
   }
   else
   {
      float f,p,q,t;
      float i;

      h /= 60.0;
      i = floor(h);
      f = h - i;
      p = v * (1.0-s);
      q = v * (1.0-(s*f));
      t = v * (1.0-(s*(1.0-f)));

      int o = i;
      switch(o) {
         case 0: r=v; g=t; b=p; break;
         case 1: r=q; g=v; b=p; break;
         case 2: r=p; g=v; b=t; break;
         case 3: r=p; g=q; b=v; break;
         case 4: r=t; g=p; b=v; break;
         case 5: r=v; g=p; b=q; break;
      } // switch
   }

   int ir,ig,ib;

   ir=r;
   ig=g;
   ib=b;
   if (ir>255) ir = 255.0;
   if (ig>255) ig = 255.0;
   if (ib>255) ib = 255.0;

   return (ir<<16) | (ig<<8) | ib;
}

void rgb_to_hsv(float r,float g,float b,float* h,float* s,float* v)
{
   float max,min;
   float temp;

   if (r>g)
      max = r;
   else
      max = g;

   if (b>max)
      max = b;

   if (r<g)
      min = r;
   else
      min = g;

   if (b<min)
      min = b;

   *v = max;

   *s = 0.0;
   if (max != 0.0)
      *s = ((max-min)/max);

   if (*s == 0.0)
      *h = -1;
   else {
      float delta = max - min;
      float maxr = max - r;
      float maxg = max - g;
      float maxb = max - b;

      if (r == max)
         *h = ((maxb)-(maxg)) / delta;
      else if (g == max)
         *h = 2.0 + (((maxr)-(maxb)) / delta);
      else if (b == max)
         *h = 4.0 + (((maxg)-(maxr)) / delta);

      *h *= 60.0;
      while (*h < 0.0)
         *h += 360.0;
      while (*h >= 360.0)
         *h -= 360.0;
   } 
}
