/*
   Sample.cpp - Example program for getting access to the screen and drawing to it
   Created by Serun (aka. Jeff DeWall) on 7/20/99
   Use as you wish, but I'm not responsible in anyway for anything that happens
   while you use/modify/fuck this code.
*/

#include <Application.h>
#include <WindowScreen.h>

typedef long (*sync_hook)();

////////////////////////////////////////////////////////////////////////////////////////
// DECLARATIONS
////////////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////////////
// PApplication - derived from BApplication, base of program
////////////////////////////////////////////////////////////////////////////////////////
class PApplication : public BApplication {
public:

   PApplication();

   // So that the WindowScreen knows what to do when disconnected and about to quit.
   bool Gonna_Quit; 
        
private:

   // Function that is called when the app receives a B_QUIT_REQUESTED message
   bool QuitRequested();

   // Function that is called after Run() (Run is called when our BApplication derived class is created
   void ReadyToRun();
};

////////////////////////////////////////////////////////////////////////////////////////
// PWindowScreen - class that gets us access to the screen 
////////////////////////////////////////////////////////////////////////////////////////
class PWindowScreen : public BWindowScreen {
public:

   PWindowScreen(status_t*);

private:

   void ScreenConnected(bool);

   // Where all the neat stuff goes!
   long MyRender();
 
   // Our thread function
   static long MyEntry(void*);

   // Flips a 16 bit 640x480 source screen to a 16 bit 640x480 destination screen
   void Flip(uint16*, uint16*);

   // Sets a pixel in a 16 bit 640x480 screen at x, y in color r, g, b
   void PutPixel(short, short, uchar, uchar, uchar, uint16*);
  
   // Our clear function, clears out a 16 bit 640x480 screen in color r, g, b
   void Clear(uchar, uchar, uchar, uint16*);

   // The variable that stores the ID of our rendering thread
   thread_id Thread_ID;

   // The semaphore that controls access to the WindowScreen
   sem_id Render_Sem;

   // The pointer to our offscreen buffer
   uint16* Virtual_Buffer;

   // Pointer to the on-screen frame buffer
   uint16* Frame_Buffer;
   
   // Used to let us know when the rendering thread is locked.
   bool Thread_Locked;

   // Used to sync to the vertical retrace
   sync_hook Sync;
};


////////////////////////////////////////////////////////////////////////////////////////
// CODE
////////////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////////////
// Main - this is where everything starts, a object of the PApplication class is
//        made. this is all we have to do in this function, the constructor is
//        automatically called and everything goes from there.
////////////////////////////////////////////////////////////////////////////////////////
int main(int, char**) {
   PApplication app;
}

////////////////////////////////////////////////////////////////////////////////////////
// PApplication - Constructor, gets message loop going with Run()
////////////////////////////////////////////////////////////////////////////////////////
PApplication::PApplication() : BApplication("application/x-vnd.Serun-example-jbq1") {
  
   // ReadyToRun is called after this.
   Run(); 
}

////////////////////////////////////////////////////////////////////////////////////////
// ReadyToRun - Setsup the program and starts our PWindowScreen
////////////////////////////////////////////////////////////////////////////////////////
void PApplication::ReadyToRun() {

   status_t ret = B_ERROR;
   Gonna_Quit = false;

   PWindowScreen* ws = new PWindowScreen(&ret);

   // exit if constructing the WindowScreen failed.
   if ( (ws == NULL) || (ret < B_OK) ) {

      // tells the OS that we want to quit
      PostMessage(B_QUIT_REQUESTED);
   }

}

////////////////////////////////////////////////////////////////////////////////////////
// QuitRequested - Hook function, called when a B_QUIT_REQUESTED message is received
////////////////////////////////////////////////////////////////////////////////////////
bool PApplication::QuitRequested() {

   // We use this as a flag so that later on in other functions we know when we
   //  should stop doing stuff 
   Gonna_Quit = true;
   return true;

}

////////////////////////////////////////////////////////////////////////////////////////
// PWindowScreen - constructor of our PWindowScreen class which is derived from
//                 the BWindowScreen class We are creating a 640x480 screen with
//                 16 bit color.
////////////////////////////////////////////////////////////////////////////////////////
PWindowScreen::PWindowScreen(status_t* ret) : BWindowScreen("Serun's Example", B_16_BIT_640x480, ret) {
   
   Thread_Locked = true;
  
   // Our thread ID is not valid;
   Thread_ID = 0;

   // If the BWindowScreen constructor didn't have a problem, proceed with our constructor
   if (*ret == B_OK) {

      // this semaphore controls the access to the WindowScreen
      Render_Sem = create_sem(0, "Screen Access");

      // Our offscreen buffer, will cut down on flickering
      Virtual_Buffer = new uint16[307200];
      
      // exit if an error occured.
      if (Render_Sem < B_OK){

         *ret = B_ERROR;

      } // end if

      // If there were no problems then we call show which goes and calls ScreenConnected
      else { 
         Show();

      } // end else
 
   } // end if

} 

////////////////////////////////////////////////////////////////////////////////////////
// ScreenConnected - called when the screen has just connected or when it's about
//                   to lose it's control
////////////////////////////////////////////////////////////////////////////////////////
void PWindowScreen::ScreenConnected(bool connected) {

   // connected == true when the screen is connected and ready to start
   if (connected) {

      // Get the hardware Sync hook.  This lets us Sync to the vertical retrace. We do this everytime
      //  because there is a chance of multiple monitors.
      Sync = (sync_hook) CardHookAt(10);

      // get the framebuffer pointer every time we are connected, again, multiple monitors
      Frame_Buffer = (uint16*)(CardInfo()->frame_buffer);

      // If the thread ID is not yet valid then we need to create a thread for it and get started
      //  with the program!
      if(Thread_ID == 0) {

         // We want to clear out any garbage that might be on the frame buffer, so we call our self-made
         //  clear function.
         Clear(0, 0, 0, Frame_Buffer);
         
         // This creates the rendering thread with a nice priority, Entry is the threads function which is
         //  called by resume_thread.
         if( ( ( Thread_ID = spawn_thread(MyEntry, "rendering thread", B_URGENT_DISPLAY_PRIORITY, this) )
               < B_OK) || ( resume_thread(Thread_ID) < B_OK ) ) {

            // If the thread was not created or resume_thread didn't work correctly, tell the system we
            //  want to quit
            be_app->PostMessage(B_QUIT_REQUESTED);

        } // end if

     } // end if
     
     // After the thread is made the only thing that must be done is to let the rendering thread run and
     //  to restore whatever was on the screen before it disconnected

      // Restore the frame buffer for when they have switched workspaces.   
      Flip(Virtual_Buffer, Frame_Buffer);
 
      // Let the rendering code run
      release_sem(Render_Sem);
      Thread_Locked = false;

   } // end if

   // The following code will be called when ScreenConnected is passed false, hence it's being disconnected
   //  It is important to remember that we still are connected when this is called so we can still
   //  cleanup and save the contents of the screen, halt other threads if need be and all sorts of other
   //  things that might need to be cleaned up when either quitting or changing to another workspace
   else {

      // Since the rendering thread needs to make sure that our Thread_Locked flag is not set and
      //  needs to be able to aquire the semaphore in order for the drawing code to execute, we set 
      //  the flag and aquire the semaphore here so that the rendering thread can't.
      if (Thread_Locked == false) {
      
         // Stop the drawing code from being executed
         acquire_sem(Render_Sem);
         Thread_Locked = true;

      } // end if

      // If we are quitting then we should permanently kill the rendering thread and the semaphore 
      if ((((PApplication*)be_app)->Gonna_Quit)) {
         status_t ret;

         // Kill the thread and wait for it to finally die
         kill_thread(Thread_ID);
         wait_for_thread(Thread_ID, &ret);

         // delete our rendering semaphore
         delete_sem(Render_Sem);

         // delete our offsreen buffer
         delete Virtual_Buffer;

      } // end if

   } // end else

}

////////////////////////////////////////////////////////////////////////////////////////
// The function that is called by resume_thread
////////////////////////////////////////////////////////////////////////////////////////
long PWindowScreen::MyEntry(void* p) {

   // calls the Render function 
   return ((PWindowScreen*)p)->MyRender();
}

////////////////////////////////////////////////////////////////////////////////////////
// Render - Our render function, does all the drawing, and is pretty important
////////////////////////////////////////////////////////////////////////////////////////
long PWindowScreen::MyRender() {

   bigtime_t Trgt = 0;

   short k = 0;

   // gain access to the framebuffer before writing to it.
   acquire_sem(Render_Sem);

   // While the thread is alive
   while(true){

    // Make sure that the screen is connected
    if(Thread_Locked == false){

      // This code just keeps clearing the screen to a diffrent color, it ends up looking like a fade.
      Clear(0, k, k, Virtual_Buffer);
      
      k++;
      
      // Make sure that our color values won't get too large
      if(k > 30){
         k = 0;
      }

      // We need to release the semaphore or else the syncing we do with the other functions will
      //  fuck up.
      release_sem(Render_Sem);

      // If we can sync to the vertical retrace, do it
      if (Sync) {
         Sync();
      }

      else {
   
         // If we can't sync to the retrace then pause for a bit each frame to make sure
         //  we don't draw to much and make the program go WAY to fast
         if (system_time() < Trgt) snooze(Trgt - system_time() );
            Trgt = system_time() + 18000;
      }

      // acquire the Render_Semaphore back before talking to the driver
      acquire_sem(Render_Sem);
       
      // copy the offscreen buffer to the screen in one large blast.
      Flip(Virtual_Buffer, Frame_Buffer);

    } // end if

   } // end while
   
   return 0;
}

////////////////////////////////////////////////////////////////////////////////////////
// Flip - copies the data from src1 to dest1 (a 640x480x16bit screen is assumed)
////////////////////////////////////////////////////////////////////////////////////////
void PWindowScreen::Flip(uint16* src1, uint16* dest1){
   uint32* src = (uint32*)src1;
   uint32* dest = (uint32*)dest1;

   int32 src_pos = 0, dest_pos = 0;

   // This copies the data from the source to the destination..
   //  would be 307200 if I weren't using 32 bit pointers.. this
   //  does the copy twice as fast this way.. hopefully =)
   for(int m = 0; m < 153600; m++){    
         // copy a pixel from the source to the destination
         dest[dest_pos] = src[src_pos];

         // update offset pointers
         dest_pos++;
         src_pos++;
   } // end for

}

////////////////////////////////////////////////////////////////////////////////////////
// PutPixel - draws a pixel on frame in r, g, b. (a 640x480x16bit screen is assumed)
////////////////////////////////////////////////////////////////////////////////////////
void PWindowScreen::PutPixel(short x, short y, uchar r, uchar g, uchar b, uint16* frame){
   uint16 col = (r << 11) | (g << 5) | b;
   frame[(y << 7) + (y << 9) + x] = col;
}

////////////////////////////////////////////////////////////////////////////////////////
// Clear - clears the screen to the specified color (a 640x480x16bit screen is assumed)
////////////////////////////////////////////////////////////////////////////////////////
void PWindowScreen::Clear(uchar r, uchar g, uchar b, uint16* frame){
   uint16 col = (r << 11) | (g << 5) | b;
   for(long i = 0; i < 307200; i++){
      frame[i] = col;
   }
}