#include "allegro.h"   
using namespace std;

// main program
int main(int argc, char *argv[]) {         
	int i; // global counter
	int j; // palette rotation
	
    RGB WrapColour; // colour that wraps around
    RGB TempColour; // Regular temp colour

    BITMAP *the_image;    // the image from the pcx file
    PALETTE the_palette;  // the palette from the pcx file

    // allegro setup
	allegro_init();        // init Allegro 
	install_keyboard();    // setup allegro keyboard	
	install_timer();       // install timer
	
    // init seed values 
	i=0;    // time count
	the_image = load_bitmap("SR_WORM.PCX", the_palette); // image load
   
    // init vieo mode
	set_color_depth(8) ;   // 8 bit colour
	if (set_gfx_mode(GFX_AUTODETECT_FULLSCREEN, 320, 200, 0, 0)<0)
	{
	    set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);  
	    allegro_message("Failure to init video mode!\n%s\n", allegro_error);
	}
	
    // set the bitmap palette [all 256 colour indices ]
    set_palette(the_palette); 
    // blit the image onto the screen 
    blit(the_image, screen, 0, 0, 0,0,320,200);
 
    // lets play a little - set index 255 to full white
    TempColour.r=63;     TempColour.g=63;     TempColour.b=63;
    set_color(255,&TempColour);
    // Draw some text  
    textout_centre(screen, font, "http://www.scenerep.org", 160, 50, 255);

	while ((!key[KEY_ESC])&&(!key[KEY_SPACE])) {
	      i++;
	      // cycle palette now
	      get_color(1,&WrapColour); // save palette 1 - become 225 later
	      for (j=1;j<225;j++) {
	             get_color(j+1,&TempColour);
	             set_color(j,&TempColour);
	      }
	      set_color(225,&WrapColour);	      
          rest(1);    

    };

    remove_timer();
	return 0;     
}     
END_OF_MAIN();

