<?php

// Check if a page is requested by the user.
if (isset($_REQUEST['page']))
{
  // Copy the requested page name. Use basename() for security reasons.
  $page = basename($_REQUEST['page']);
}
else
{
  // Set the defaut page name if nothing was requested.
  $page = "news";
}

//----------------------------------------------------------------------------

// Read the whole HTML template. Use file_get_contents() in PHP >= 4.3.0.
$template = implode("", file("template.html"));

// Get the file modification time.
$modifiedTimestamp = filemtime($page . ".php");
// Format the Unix timestamp to a readable string.
$modified = date("Y-m-d", $modifiedTimestamp);
// Insert this string into the template.
$template = str_replace("{modified}", $modified, $template);

// Split the HTML template into two parts: the header and the footer.
$templateArray = explode("{content}", $template, 2);

//----------------------------------------------------------------------------

// Output the header part of the HTML template to the browser.
echo $templateArray[0];

// Get the file contents and evaluate any PHP code if present.
include($page . ".php");

// Output the footer part of the HTML template to the browser.
echo $templateArray[1];

?>