// Example scripting engine
// written based on Obs engine
// (c)'01 by SquoQuo
// All code done by Hopper/SquoQuo

#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#ifndef __ENGINE_SCENE
#define __ENGINE_SCENE

#define MAX_FUNCTIONS 40

class Scene
{
public:
	char name[32];				// name of the scene (used by PartDispatcher)

	// constructor
	Scene();

	// returns the function given by name (NULL if not found)
	void (*getFunctionByName(char *name))(void *tthis, float time, void **p);

private:
	char functionNames[MAX_FUNCTIONS][32];	// array of strings for the function names
	void (*functionPointers[MAX_FUNCTIONS])(void *tthis, float time, void **p);
	int fCount;

protected:
	// registers the function for later call
	// function is the pointer to the function call
	// name is the name of the function...
	// parameterNames is the string that holds the names of the parameters (separated by blanks) (first parameter "time" is not included!)
	// The first parameter tthis is necessary, because the called functions must be static, so i give them their this pointer
	void registerFunction(void (*func)(void *tthis, float time, void **p), char *name);
};

#endif