#include "..\h\Parameter.h"

Parameter::~Parameter()
{
	if (x!=NULL) free(x);
	if (y!=NULL) free(y);
}

void *Parameter::getValue(float t)
{
	int i;

	switch(type)
	{
		case PT_CONST:		temp=pConst; break;
		case PT_LINEAR:	for (i=0; ((i<dotCount)&&(t>x[i])); i++);
								// now i holds the index of the first x value greater than t
								// i.e. 0 means t is smaller than all values
								// i==dotCount means t is greater than all values
								if (i==0)
									temp=y[0];
								else
									if (i==dotCount)
										temp=y[dotCount-1];
									else
										temp=(y[i]-y[i-1])/(x[i]-x[i-1])*(t-x[i-1])+y[i-1];
								break;
		case PT_SPLINE:	temp=calcSpline(t);
								break;
		case PT_SINE:		temp=(float)sin(t*2.0*PI*pSinPeriod+pSinPhase/180.0*PI)*pSinAmplitude+pSinOffset;
								break;
		case PT_STRING:	return pString;
								break;
		default:				exit(-1);
	}

	if ((min<temp)&&(max>temp))
		return &temp;
	else
		if (min>temp)
			return &min;
		else
			return &max;
}

// Calculates the natural cubic spline for the given points at position t
// First argument is x[], second y[] and third t
// The spline will be calculated from scratch because of the possibility of
// multiple simultaneous splines
// *** THIS IS A REAL HACK *** should be optimized, etc.
float Parameter::calcSpline(float t)
{
   float q, r, s;
   float *b, *c, *d;
   int i, k;
	int n=dotCount;

	if (n==0)					// no good for me!
		exit(-1);
	if (n==1)					// simple calculation ;-)
		return y[0];
	if (n==2)					// simple calculation, too!
		return y[0]+(y[1]-y[0])/(x[1]-x[0])*t;
	if (t>x[n-1])				// t has left the range=>use last value
		return y[n-1];
	if (t<x[0])
		return y[0];

	// calculate spline only, if no trivial case (see above)
   b=(float*)calloc(n, sizeof(float));
   c=(float*)calloc(n, sizeof(float));
   d=(float*)calloc(n, sizeof(float));

   n--;

   // calculate the coefficients
   s=0.0;
   for (i=0; i<n; i++)
   {
      d[i]=x[i+1]-x[i];
      if (d[i]==0.0)
			exit(-1);
      r=(y[i+1]-y[i])/d[i];
      c[i]=r-s;
      s=r;
   }

   r=s=0.0;
   c[0]=c[n]=0.0;				// natural spline (f'=0 at start and end)
   for (i=1; i<n; i++)
   {
      c[i]+=r*c[i-1];
      b[i]=(x[i-1]-x[i+1])*2-r*s;
      s=d[i];
      r=s/b[i];
   }
   for (i=n-1; i>0; i--)
      c[i]=(d[i]*c[i+1]-c[i])/b[i];
   for (i=0; i<n; i++)
   {
      s=d[i];
      r=c[i+1]-c[i];
      d[i]=r/s;
      c[i]*=3;
      b[i]=(y[i+1]-y[i])/s-(c[i]+r)*s;
   }

   // calculate the value
   i=-1;
   for (k=0; k<=n; k++)
      if (t>=x[k])
         i=k;
   if (i==-1)
		exit(-1);
   q=t-x[i];
   r=((d[i]*q+c[i])*q+b[i])*q+y[i];

   free(d);
   free(c);
   free(b);

   return r;
}
