import java.applet.*;
import java.awt.*;
import java.awt.event.*;
import java.awt.Graphics;
import java.lang.*;
import java.lang.System;

public class ThreadApplet extends Applet implements Runnable {

Thread runner=null;

// timing info
long ThenMS,NowMS;

public void start(){
//
// start the demo running
//

// check if the demo is running already
if(runner==null){
	// initialize the timer
        ThenMS=System.currentTimeMillis();

        // create a new thread and grab max priority
        runner=new Thread(this);
	runner.setPriority(Thread.MAX_PRIORITY);
	// set the thread going
        runner.start();
}
}


public void stop(){
//
// stop the demo running
//

// check if the demo is running
if(runner!=null){
	// stop the demo running
	runner=null;
}
}


public void run(){
Thread me=Thread.currentThread();
// get the applet Graphics
Graphics g=this.getGraphics();

while(me==runner){
	// directly call update()
	update(g);
}
}


public void paint(Graphics g){
// blank the applet
g.setColor(Color.black);
g.fillRect(0,0,getSize().width,getSize().height);
}


public synchronized void update(Graphics g) {
//
// update the frame
//

// time elapsed since last frame
long count;

// update timing info
NowMS=System.currentTimeMillis();
count=NowMS-ThenMS;
if(count>0){
	ThenMS=NowMS;
	animate(count);
	render(g);
}
}


void animate(long count){
//
// update animations - positions of objects, effects parameters, etc.
//
}


void render(Graphics g){
//
// draw everything
//
}

}