import java.applet.*;
import java.awt.*;
import java.awt.Graphics;
import java.awt.image.*;
import java.awt.image.ColorModel;
import java.awt.image.MemoryImageSource;
import java.awt.Toolkit;
import java.lang.*;
import java.lang.System;

public class IPApplet extends Applet implements Runnable, ImageProducer {

Thread runner=null;
int width,height;

// timing info
long ThenMS,NowMS;

// the double buffer
Image DoubleBufferImage;
Graphics DoubleBufferGraphics;

// the pixel arrray
int TargetPixels[];
ColorModel TargetCM;
Image TargetImage;

// currently registered ImageConsumer
ImageConsumer consumer=null;


public synchronized void addConsumer(ImageConsumer ic){
// register image consumer
consumer = ic;

// set image dimensions
consumer.setDimensions(width,height);

// set image consumer hints
consumer.setHints(ImageConsumer.TOPDOWNLEFTRIGHT|ImageConsumer.COMPLETESCANLINES|ImageConsumer.SINGLEPASS|ImageConsumer.SINGLEFRAME);

// set image color model
consumer.setColorModel(TargetCM);
}


public synchronized boolean isConsumer(ImageConsumer ic){
// check if consumer is registered
if(ic==consumer) return(true);
return(false);
}


public synchronized void removeConsumer(ImageConsumer ic){
// remove image consumer
if(ic==consumer) consumer=null;
}


public void requestTopDownLeftRightResend(ImageConsumer ic){
// resend pixels
if(ic==consumer){
	// copy pixel data to image consumer
	consumer.setPixels(0,0,width,height,TargetCM,TargetPixels,0,width);

	// notify image consumer that the frame is done
	consumer.imageComplete(ImageConsumer.SINGLEFRAMEDONE);
}
}


public void startProduction(ImageConsumer ic){
// add consumer
addConsumer(ic);
}


public void init(){
//
// initialize everything
//

// get size of applet
width=getSize().width;
height=getSize().height;

// create a double buffer
DoubleBufferImage=createImage(width,height);
DoubleBufferGraphics=DoubleBufferImage.getGraphics();

TargetPixels=new int[width*height];
TargetCM=new DirectColorModel(32,0x00FF0000,0x000FF00,0x000000FF,0);

// create an Image from our ImageProducer
TargetImage=createImage(this);

// do garbage collection
System.gc();
}


public void start(){
//
// start the demo running
//

// check if the demo is running already
if(runner==null){
	// initialize the timer
        ThenMS=System.currentTimeMillis();

        // create a new thread and grab max priority
        runner=new Thread(this);
	runner.setPriority(Thread.MAX_PRIORITY);
	// set the thread going
        runner.start();
}
}


public void stop(){
//
// stop the demo running
//

// check if the demo is running
if(runner!=null){
	// stop the demo running
	runner=null;
}
}


public void run(){
Thread me=Thread.currentThread();
Graphics g=this.getGraphics();

while(me==runner){
	update(g);
}
}


public void paint(Graphics g){
// blank the applet
g.setColor(Color.black);
g.fillRect(0,0,getSize().width,getSize().height);
}


public synchronized void update(Graphics g) {
//
// update the frame
//

// time elapsed since last frame
long count;

// update timing info
NowMS=System.currentTimeMillis();
count=NowMS-ThenMS;
if(count>0){
	ThenMS=NowMS;
	animate(count);
	render(DoubleBufferGraphics);

	DoubleBufferImage.flush();
	// draw double buffer
	g.drawImage(DoubleBufferImage,0,0,this);
}
}


void animate(long count){
//
// update animations - positions of objects, effects parameters, etc.
//

}


void render(Graphics g){
//
// draw everything
//

// fiddle around with pixel values in TargetPixels[] here

// check a consumer i registered
if(consumer!=null){
	// copy integer pixel data to image consumer
	consumer.setPixels(0,0,width,height,TargetCM,TargetPixels,0,width);

	// notify image consumer that the frame is done
	consumer.imageComplete(ImageConsumer.SINGLEFRAMEDONE);
}

g.drawImage(TargetImage,0,0,this);

}

}