#ifndef __VECTOR_H
#define __VECTOR_H

#include <windows.h>
#include <GL/gl.h>


class CVector
{
protected:
	GLfloat v[3];

public:
	CVector () { v[0] = v[1] = v[2] = 0.0f; }
	CVector (GLfloat x, GLfloat y, GLfloat z) { v[0] = x; v[1] = y; v[2] = z; }
	CVector (GLfloat *V) { v[0] = V[0]; v[1] = V[1]; v[2] = V[2]; }

	CVector operator=(CVector &vec) { return CVector(v[0] = vec.v[0], v[1] = vec.v[1], v[2] = vec.v[2]); }
	CVector operator=(GLfloat *V)  { return CVector(v[0] = V[0], v[1] = V[1], v[2] = V[2]); }
	int operator==(CVector &vec) { return (v[0] == vec.v[0] && v[1] == vec.v[1] && v[2] == vec.v[2]); }
	int operator==(GLfloat *V) { return (v[0] == V[0] && v[1] == V[1] && v[2] == V[2]);}
	int operator!=(CVector &vec) { return !((*this) == vec); }
	int operator!=(GLfloat *V) { return !((*this) == V); }

	CVector operator+=(CVector &vec);
	CVector operator-=(CVector &vec);
	CVector operator*=(CVector &vec);
	CVector operator*=(GLfloat val);  
	CVector operator/=(CVector &vec);
	CVector operator/=(GLfloat val);

	CVector operator+(CVector &vec) { return CVector(v[0] + vec.v[0], v[1] + vec.v[1], v[2] + vec.v[2]); }
	CVector operator-(CVector &vec)	{ return CVector(v[0] - vec.v[0], v[1] - vec.v[1], v[2] - vec.v[2]); }
	CVector operator*(CVector &vec)	{ return CVector(v[0] * vec.v[0], v[1] * vec.v[1], v[2] * vec.v[2]); }
	CVector operator*(GLfloat val)	{ return CVector(v[0] * val, v[1] * val, v[2] * val); }
	CVector operator/(CVector &vec)	{ return CVector(v[0] / vec.v[0], v[1] / vec.v[1], v[2] / vec.v[2]); }
	CVector operator/(GLfloat val)	{ return CVector(v[0] / val, v[1] / val, v[2] / val); }

	const GLfloat &operator[] (int index) const { return v[index]; }
	GLfloat &operator[] (int index) { return v[index]; }
	operator GLfloat*() { return v; }
	
	void normalize ();
	CVector normalized ();
	GLfloat length ();
	GLfloat dot (CVector &vec);
	void cross (CVector &vec1, CVector &vec2);
	void rotateX (GLfloat a);
	void rotateY (GLfloat a);
	void rotateZ (GLfloat a);

	GLfloat x () { return v[0]; }
	GLfloat y () { return v[1]; }
	GLfloat z () { return v[2]; }
	void x (GLfloat nx) { v[0] = nx; }
	void y (GLfloat ny) { v[1] = ny; }
	void z (GLfloat nz) { v[2] = nz; }
};

#endif