#include <windows.h>
#include <GL/gl.h>
#include <GL/glu.h>
#include <math.h>
#include "globals.h"
#include "system.h"
#include "text.h"
#include "cubes.h"


void ledsensmiley (float r, float g, float b, float a)
{
	glPushAttrib (GL_ALL_ATTRIB_BITS);

	glEnable (GL_BLEND);
	glDisable (GL_LIGHTING);
	glDisable (GL_TEXTURE_2D);

	glMatrixMode (GL_PROJECTION);
	glPushMatrix ();
	glLoadIdentity ();
	glOrtho (0.0f, 1.0f, 1.0f, 0.0f, -1.0f, 1.0f);
	glMatrixMode (GL_MODELVIEW);
	glPushMatrix ();
	glLoadIdentity ();

	glBegin (GL_QUADS);

	glColor4f (r, g, b, a); glVertex2f (0.0, 0.0);
	glColor4f (r, g, b, a); glVertex2f (0.0, 1.0);
	glColor4f (r, g, b, a); glVertex2f (1.0, 1.0);
	glColor4f (r, g, b, a); glVertex2f (1.0, 0.0);

	glEnd ();

	glPopMatrix ();
	glMatrixMode (GL_PROJECTION);
	glPopMatrix ();
	glMatrixMode (GL_MODELVIEW);

	glPopAttrib ();
}

void init_Tunnel ()
{
	glClearColor (0.0f, 0.0f, 0.0f, 1.0f);
	glDisable (GL_BLEND);
	glDisable (GL_LIGHTING);
	glEnable (GL_FOG);
	glFogf (GL_FOG_START, 20.0);
	glFogf (GL_FOG_END, 80.0);
	GLfloat fogCol[4] = { 0.0f, 0.0f, 0.0f, 1.0f };
	glFogfv (GL_FOG_COLOR, fogCol);
	glEnable (GL_CULL_FACE);
	glCullFace (GL_BACK);
	glFrontFace (GL_CCW);
	glEnable (GL_TEXTURE_2D);
	glDisable (GL_TEXTURE_GEN_S);
	glDisable (GL_TEXTURE_GEN_T);
	glEnable (GL_DEPTH_TEST);
	cam.pos[0] = 0;
	cam.pos[1] = 0;
	cam.pos[2] = 0;
	cam.directional = true;
	cam.tgt[0] = 0;
	cam.tgt[1] = 0;
	cam.tgt[2] = -1;
	fov = 100;
}

void drawSection (GLfloat x1, GLfloat y1, GLfloat z1, GLfloat r1, GLfloat x2, GLfloat y2, GLfloat z2, GLfloat r2, int detail = 16)
{
	glColor4f (1.0, 1.0, 1.0, 1.0);

	glBegin (GL_QUADS);

	GLfloat astep = 2*M_PI / detail;
	GLfloat ustep = 4.0f / detail;
	GLfloat u = 0;

	for (GLfloat a = 0; a < 2*M_PI; a+=astep, u += ustep)
	{
		glTexCoord2f (u,		0.0);	glVertex3f ((GLfloat)(cos(a) * r1 + x1) , (GLfloat)(sin(a) * r1 + y1), z1);
		glTexCoord2f (u+ustep,	0.0);	glVertex3f ((GLfloat)(cos(a+astep) * r1 + x1), (GLfloat)(sin(a+astep) * r1 + y1), z1);

		glTexCoord2f (u+ustep, 1.0);	glVertex3f ((GLfloat)(cos(a+astep) * r2 + x2), (GLfloat)(sin(a+astep) * r2 + y2), z2);
		glTexCoord2f (u, 1.0);			glVertex3f ((GLfloat)(cos(a) * r2 + x2), (GLfloat)(sin(a) * r2 + y2), z2);
	}
	glEnd ();
}


void part_Tunnelpart ()
{
	// 5.40
	static bool first = true;

	static float starttime = time;
	static float lasttime = 0;
	static float speed = 10;
	static float camrx = 4, camry = 5;
	static float dx = 4, dy = 5;
	static float fa = 0.0;

	float lapsedtime = time - starttime;
	float delta = lapsedtime - lasttime;
	GLfloat start, i;

	char *greets[8] = {	"We Love And Respect",
						"Royal Family",
						"Cocoon",
						"NoPP",
						"Revelation",
						"Nebula",
						"Foobug",
						"Lorenz"
						};

	if (mtime > 5.40)
	{
		speed *= 1 + (delta*0.05);

		if (mtime > 6.40)
			fa += delta*0.3;

		dx -= delta;
		dy -= delta;

		if (dx < 0) dx = 0;
		if (dy < 0) dy = 0;
	}

	cam.pos[2] = (GLfloat)(-time*speed);
	cam.pos[1] = 2;
	cam.pos[0] = -3;

	if (first)
	{
		init_Tunnel ();
		first = false;
	}

	SetProjection ();

	for (start = 0; start > cam.pos[2]+30; start -= 10.0f);

	glBindTexture (GL_TEXTURE_2D, TID_ATG[3]);
	glDisable (GL_TEXTURE_GEN_S);
	glDisable (GL_TEXTURE_GEN_T);
	for (i = start; i > cam.pos[2]-90; i-=10)
	{
		drawSection (	cos(i*0.22)*dx, sin(i*0.1)*dy, i+5, 15,
						cos((i-10)*0.22)*dx, sin((i-10)*0.1)*dy, i-5, 15);
	}

	glEnable (GL_BLEND);
	glBindTexture (GL_TEXTURE_2D, TID_ATG[0]);
	glEnable (GL_TEXTURE_GEN_S);
	glEnable (GL_TEXTURE_GEN_T);
	glScalef (0.8f, 0.8f, 1.0f);
	for (i = start; i > cam.pos[2]-90; i-=10)
	{
		drawSection (	cos(i*0.22)*dx, sin(i*0.1)*dy, i+5, 15,
						cos((i-10)*0.22)*dx, sin((i-10)*0.1)*dy, i-5, 15);
	}

	glColor4f (1.0f, 1.0f, 1.0f, 0.5f);

	i = 7;
	for (float z = (-starttime*10)-300+lapsedtime*10; z < (-starttime*10)-100+lapsedtime*10; z += 20)
	{
		if (i > -1)
			glText3D (greets[(int)i--], 0, 0, z, (i*8)+30);
	}

	glDisable (GL_BLEND);

	ledsensmiley (1.0,1.0,1.0,fa);

	lasttime = lapsedtime;
}
