#include <windows.h>
#include <fstream.h>
#include <string.h>
#include <GL/gl.h>
#include "resource.h"
#include "text.h"
#include "globals.h"
#include "lzw.h"
#include "sound.h"
#include "system.h"


//------------------------------------------------------------------>
// Function		:	InitGlText
// Description	:	Called by init. It loads a 1-bit font texture from
//					a compressed resource, expands it from 1 bit to 32,
//					blurs the alpha channel, and uploads it.
//------------------------------------------------------------------>
void InitGLText ()
{ 
	glGenTextures (1, &TID_TEXT);

	int *data = LoadPackedPic (IDR_FONT, 512, 512, true);

	FakeAlpha (data, 512*512);

	//for (int i=0;i<512*512;i++)
	//	data[i] = 0;

	UploadTexture (data, TID_TEXT, 512, 512);

	delete data; 
}

//------------------------------------------------------------------>
// Function		:	glText2D
// Description	:	Prints out a text string in 2D(ortho) projection
//					using the TID_TEXT texture. Valid x and y are from
//					0 to 1, size should be like 0.1	or there around.
//------------------------------------------------------------------>
void glText2D (char *string, GLfloat x, GLfloat y, GLfloat size)
{
	glPushAttrib (GL_ALL_ATTRIB_BITS);
	glDisable (GL_DEPTH_TEST);
	glDisable (GL_LIGHTING);
	glDisable (GL_TEXTURE_GEN_S);
	glDisable (GL_TEXTURE_GEN_T);
	glDisable (GL_FOG);
	
	//glColor4f( 1,1,1,0.5 );	
	
	glEnable (GL_TEXTURE_2D);
	glEnable (GL_BLEND);
	glBlendFunc (GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA); 
	glBindTexture (GL_TEXTURE_2D, TID_TEXT);

	

	glMatrixMode (GL_PROJECTION);
	glPushMatrix ();
	glLoadIdentity ();
	glOrtho (0.0f, 1.0f, 1.0f, 0.0f, -1.0f, 1.0f);
	glMatrixMode (GL_MODELVIEW);
	glPushMatrix ();
	glLoadIdentity ();

	glBegin (GL_QUADS);
	for (int i = 0; i < (signed)strlen(string); i++)
	{
		GLfloat texX, texY;

		if (string[i] == ' ')
		{
			texX = 15;
			texY = 7;
		}
		else
		{
			texX = (GLfloat)((string[i]-33) % 16);
			texY = (GLfloat)((string[i]-33) / 16);
		}

		glTexCoord2f((GLfloat)(texX/16.0f),	(GLfloat)(texY/16.0f)		); glVertex2f (x+(i*0.075f*size)			, y				);
		glTexCoord2f((GLfloat)(texX/16.0f),	(GLfloat)((texY+1)/16.0f)	); glVertex2f (x+(i*0.075f*size)			, y+0.1f*size	);
		glTexCoord2f((GLfloat)((texX+1)/16.0f),(GLfloat)((texY+1)/16.0f)	); glVertex2f (x+(i*0.075f*size)+0.075f*size, y+0.1f*size	);
		glTexCoord2f((GLfloat)((texX+1)/16.0f),(GLfloat)(texY/16.0f)		); glVertex2f (x+(i*0.075f*size)+0.075f*size, y				);
	}
	glEnd ();

	glPopMatrix ();
	glMatrixMode (GL_PROJECTION);
	glPopMatrix ();
	glMatrixMode (GL_MODELVIEW);

	glPopAttrib ();
}

//------------------------------------------------------------------>
// Function		:	glText3D
// Description	:	Prints out a text string in 3D space using the
//					TID_TEXT texture.
//------------------------------------------------------------------>
void glText3D (char *string, GLfloat x, GLfloat y, GLfloat z, GLfloat size)
{
	glPushAttrib (GL_ALL_ATTRIB_BITS);
	glDisable (GL_DEPTH_TEST);
	glDisable (GL_LIGHTING);
	glDisable (GL_TEXTURE_GEN_S);
	glDisable (GL_TEXTURE_GEN_T);
	glDisable (GL_FOG);

	glEnable (GL_TEXTURE_2D);
	glEnable (GL_BLEND);
	glBlendFunc (GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA); 
	glBindTexture (GL_TEXTURE_2D, TID_TEXT);

	glBegin (GL_QUADS);
	int len = (signed)strlen(string);

	for (int i = 0; i < len; i++)
	{
		GLfloat texX, texY;

		if (string[i] == ' ')
		{
			texX = 15.0f;
			texY = 7.0f;
		}
		else
		{
			texX = (GLfloat)((string[i]-33) % 16);
			texY = (GLfloat)((string[i]-33) / 16);
		}

		glTexCoord2f((GLfloat)((texX+1)/16),(GLfloat)((texY+1)/16)	); glVertex3f ((GLfloat)((x-len*0.055f*size*0.5)+(i*0.055f*size)+0.055f*size)	, y-0.05f*size	,z	);
		glTexCoord2f((GLfloat)((texX+1)/16),(GLfloat)((texY+0)/16)	); glVertex3f ((GLfloat)((x-len*0.055f*size*0.5)+(i*0.055f*size)+0.055f*size)	, y+0.05f*size	,z	);
		glTexCoord2f((GLfloat)((texX+0)/16),(GLfloat)((texY+0)/16)	); glVertex3f ((GLfloat)((x-len*0.055f*size*0.5)+(i*0.055f*size))				, y+0.05f*size	,z	);
		glTexCoord2f((GLfloat)((texX+0)/16),(GLfloat)((texY+1)/16)	); glVertex3f ((GLfloat)((x-len*0.055f*size*0.5)+(i*0.055f*size))				, y-0.05f*size	,z	);
	}
	glEnd ();

	glPopAttrib ();
}
