#include <math.h>

float wave1[256], wave2[256], wave3[256], 
      wave4[256], wave5[256], wave6[256];

unsigned char ind1, ind2, ind3, ind4, ind5, ind6;

void init_plasma(void)
{
for(int loop=0; loop<256;loop++) {
    wave1[loop]=cos(3.1415*2* (float) loop             /128) * 25.0 + 25.0;
    wave2[loop]=cos(3.1415*2* (float) (loop%128)       /128) * 15.0 + 15.0;
    wave3[loop]=cos(3.1415*2* (float) (255-loop)       /256) * 17.5 + 17.5;
    wave4[loop]=sin(3.1415*2* (float) (loop%64)         /64) * 22.5 + 22.5;
    wave5[loop]=cos(3.1415*2* (float) ((128-loop)%128) /128) * 20.0 + 20.0;
    wave6[loop]=sin(3.1415*2* (float) loop             /256) * 25.0 + 25.0;
  }

ind1=100;
ind2=200;
ind3=0;
ind4=50;
ind5=12;
ind6=150;
}

void move_plasma2(unsigned char *plasbuf)
{
for(int x=0; x<32; x++)
   for(int y=0; y<32; y++) {
      plasbuf[(y*32)+x] =
        (int)(wave1[ ( ind1 + x*12 ) & 0xFF ]+
              wave2[ ( ind2 + x*12 ) & 0xFF ]+
              wave3[ ( ind3 + x*12 ) & 0xFF ]+
              wave4[ ( ind4 + y*12 ) & 0xFF ]+
              wave5[ ( ind5 + y*12 ) & 0xFF ]+
              wave6[ ( ind6 + y*12 ) & 0xFF ]
              );
    }
    ind1+=3;
    ind2+=2;
    ind3-=1;
    ind4+=1;
    ind5-=2;
    ind6-=3;
}

