#include <windows.h>
#include <GL/gl.h>
#include <GL/glu.h>
#include <math.h>
#include "model.h"
#include "objgen.h"
#include "globals.h"


void genCube (Model &m)
{
	m.meshtype = MESH_QUAD;
	m.resize (8, 6);

	m.vertex[0].num = 0;
	m.vertex[0].x = -CUBERAD;
	m.vertex[0].y = -CUBERAD;
	m.vertex[0].z =	CUBERAD;
	m.vertex[1].num = 1;
	m.vertex[1].x =  CUBERAD;
	m.vertex[1].y = -CUBERAD;
	m.vertex[1].z =	CUBERAD;
	m.vertex[2].num = 2;
	m.vertex[2].x =	CUBERAD;
	m.vertex[2].y =	CUBERAD;
	m.vertex[2].z =	CUBERAD;
	m.vertex[3].num = 3;
	m.vertex[3].x = -CUBERAD;
	m.vertex[3].y =	CUBERAD;
	m.vertex[3].z =	CUBERAD;

	m.vertex[4].num = 4;
	m.vertex[4].x = -CUBERAD;
	m.vertex[4].y = -CUBERAD;
	m.vertex[4].z = -CUBERAD;
	m.vertex[5].num = 5;
	m.vertex[5].x =	CUBERAD;
	m.vertex[5].y = -CUBERAD;
	m.vertex[5].z = -CUBERAD;
	m.vertex[6].num = 6;
	m.vertex[6].x =	CUBERAD;
	m.vertex[6].y =	CUBERAD;
	m.vertex[6].z = -CUBERAD;
	m.vertex[7].num = 7;
	m.vertex[7].x = -CUBERAD;
	m.vertex[7].y =	CUBERAD;
	m.vertex[7].z = -CUBERAD;

	m.quad[0].v[0] = &m.vertex[0];	m.quad[0].uv[0].u = 0.0f; m.quad[0].uv[0].v = 0.0f;
	m.quad[0].v[1] = &m.vertex[1];	m.quad[0].uv[1].u = 1.0f; m.quad[0].uv[1].v = 0.0f;
	m.quad[0].v[2] = &m.vertex[2];	m.quad[0].uv[2].u = 1.0f; m.quad[0].uv[2].v = 1.0f;
	m.quad[0].v[3] = &m.vertex[3];	m.quad[0].uv[3].u = 0.0f; m.quad[0].uv[3].v = 1.0f;

	m.quad[1].v[0] = &m.vertex[1];	m.quad[1].uv[0].u = 0.0f; m.quad[1].uv[0].v = 0.0f;
	m.quad[1].v[1] = &m.vertex[5];	m.quad[1].uv[1].u = 1.0f; m.quad[1].uv[1].v = 0.0f;
	m.quad[1].v[2] = &m.vertex[6];	m.quad[1].uv[2].u = 1.0f; m.quad[1].uv[2].v = 1.0f;
	m.quad[1].v[3] = &m.vertex[2];	m.quad[1].uv[3].u = 0.0f; m.quad[1].uv[3].v = 1.0f;

	m.quad[2].v[0] = &m.vertex[5];	m.quad[2].uv[0].u = 0.0f; m.quad[2].uv[0].v = 0.0f;
	m.quad[2].v[1] = &m.vertex[4];	m.quad[2].uv[1].u = 1.0f; m.quad[2].uv[1].v = 0.0f;
	m.quad[2].v[2] = &m.vertex[7];	m.quad[2].uv[2].u = 1.0f; m.quad[2].uv[2].v = 1.0f;
	m.quad[2].v[3] = &m.vertex[6];	m.quad[2].uv[3].u = 0.0f; m.quad[2].uv[3].v = 1.0f;

	m.quad[3].v[0] = &m.vertex[4];	m.quad[3].uv[0].u = 0.0f; m.quad[3].uv[0].v = 0.0f;
	m.quad[3].v[1] = &m.vertex[0];	m.quad[3].uv[1].u = 1.0f; m.quad[3].uv[1].v = 0.0f;
	m.quad[3].v[2] = &m.vertex[3];	m.quad[3].uv[2].u = 1.0f; m.quad[3].uv[2].v = 1.0f;
	m.quad[3].v[3] = &m.vertex[7];	m.quad[3].uv[3].u = 0.0f; m.quad[3].uv[3].v = 1.0f;

	m.quad[4].v[0] = &m.vertex[3];	m.quad[4].uv[0].u = 0.0f; m.quad[4].uv[0].v = 0.0f;
	m.quad[4].v[1] = &m.vertex[2];	m.quad[4].uv[1].u = 1.0f; m.quad[4].uv[1].v = 0.0f;
	m.quad[4].v[2] = &m.vertex[6];	m.quad[4].uv[2].u = 1.0f; m.quad[4].uv[2].v = 1.0f;
	m.quad[4].v[3] = &m.vertex[7];	m.quad[4].uv[3].u = 0.0f; m.quad[4].uv[3].v = 1.0f;

	m.quad[5].v[0] = &m.vertex[1];	m.quad[5].uv[0].u = 0.0f; m.quad[5].uv[0].v = 0.0f;
	m.quad[5].v[1] = &m.vertex[0];	m.quad[5].uv[1].u = 1.0f; m.quad[5].uv[1].v = 0.0f;
	m.quad[5].v[2] = &m.vertex[4];	m.quad[5].uv[2].u = 1.0f; m.quad[5].uv[2].v = 1.0f;
	m.quad[5].v[3] = &m.vertex[5];	m.quad[5].uv[3].u = 0.0f; m.quad[5].uv[3].v = 1.0f;

	m.nPrimitives = 6;
	m.loadedNormals = false;
	m.calcNormals ();

	for (int i = 0; i < m.nVertices; i++)
	{
		m.vertex[i].r = 1.0f;
		m.vertex[i].g = 1.0f;
		m.vertex[i].b = 1.0f;
		m.vertex[i].a = 1.0f;
	}
}


void genEsher (Model &m, int SCALING_FACTOR1, int SCALING_FACTOR2, float RADIUS1, float RADIUS2, float RADIUS3)
{
	int VERTICES = SCALING_FACTOR1 * SCALING_FACTOR2;
	double dx, dy, dz, Alpha, Beta, Modulus, Value, X, Y, Z;
	double Distance, MinDistance;
	int Count1, Count2, Index1, Index2, Rotation;
	int Vertices = 0;
	int *fourthV = new int[VERTICES];

	m.resize (VERTICES, VERTICES*2);

	for(Alpha = 0, Count2 = 0; Count2 < SCALING_FACTOR2; Count2++, Alpha += 2 * M_PI / SCALING_FACTOR2)
	{
		X = RADIUS2 * cos(2 * Alpha) + RADIUS1 * sin(Alpha);
		Y = RADIUS2 * sin(2 * Alpha) + RADIUS1 * cos(Alpha);
		Z = RADIUS2 * cos(3 * Alpha);
		dx = -2 * RADIUS2 * sin(2 * Alpha) + RADIUS1 * cos(Alpha);
		dy = 2 * RADIUS2 * cos(2 * Alpha) - RADIUS1 * sin(Alpha);
		dz = -3 * RADIUS2 * sin(3 * Alpha);
		Value = sqrt(dx * dx + dz * dz);
		Modulus = sqrt(dx * dx + dy * dy + dz * dz);
		for(Beta = 0, Count1 = 0; Count1 < SCALING_FACTOR1; Count1++, Beta += 2 * M_PI / SCALING_FACTOR1)
		{
			m.vertex[Vertices].x =	(GLfloat)(X - RADIUS3 * (cos(Beta) * dz - sin(Beta) * dx * dy / Modulus) / Value);
			m.vertex[Vertices].y =	(GLfloat)(Y - RADIUS3 * sin(Beta) * Value / Modulus);
			m.vertex[Vertices].z =	(GLfloat)(Z + RADIUS3 * (cos(Beta) * dx + sin(Beta) * dy * dz / Modulus) / Value);
			m.vertex[Vertices].r = m.vertex[Vertices].g = m.vertex[Vertices].b = m.vertex[Vertices].a = 1.0;
			m.vertex[Vertices].num = Vertices;
			Vertices++;
		}
	}


	for(Count1 = 0; Count1 < SCALING_FACTOR2; Count1++)
	{
		Index1 = Count1 * SCALING_FACTOR1;
		Index2 = Index1 + SCALING_FACTOR1;
		Index2 %= Vertices;
		Rotation = 0;
		MinDistance =	(m.vertex[Index1].x - m.vertex[Index2].x) * (m.vertex[Index1].x - m.vertex[Index2].x) +
						(m.vertex[Index1].y - m.vertex[Index2].y) * (m.vertex[Index1].y - m.vertex[Index2].y) +
						(m.vertex[Index1].z - m.vertex[Index2].z) * (m.vertex[Index1].z - m.vertex[Index2].z);
		for(Count2 = 1; Count2 < SCALING_FACTOR1; Count2++)
		{
			Index2 = Count2 + Index1 + SCALING_FACTOR1;
			if(Count1 == SCALING_FACTOR2 - 1) Index2 = Count2;
			Distance =	(m.vertex[Index1].x - m.vertex[Index2].x) * (m.vertex[Index1].x - m.vertex[Index2].x) +
						(m.vertex[Index1].y - m.vertex[Index2].y) * (m.vertex[Index1].y - m.vertex[Index2].y) +
						(m.vertex[Index1].z - m.vertex[Index2].z) * (m.vertex[Index1].z - m.vertex[Index2].z);
			if(Distance < MinDistance)
			{
				MinDistance = Distance;
				Rotation = Count2;
			}
		}
		for(Count2 = 0; Count2 < SCALING_FACTOR1; Count2++)
		{
			Index2 = (SCALING_FACTOR1 + Count2 + Rotation) % SCALING_FACTOR1;
			m.triangle[Index1 + Count2].v[0] = &m.vertex[Index1 + Count2];
			m.triangle[Index1 + Count2].uv[0].u = 0.0;
			m.triangle[Index1 + Count2].uv[0].v = 0.0;
			Index2 = Count2 + 1;
			Index2 %= SCALING_FACTOR1;
			m.triangle[Index1 + Count2].v[1] = &m.vertex[Index1 + Index2];
			m.triangle[Index1 + Count2].uv[1].u = 1.0;
			m.triangle[Index1 + Count2].uv[1].v = 0.0;
			Index2 = Count2 + Rotation + 1;
			Index2 %= SCALING_FACTOR1;
			m.triangle[Index1 + Count2].v[2] = &m.vertex[(Index1 + Index2 + SCALING_FACTOR1) % Vertices];
			m.triangle[Index1 + Count2].uv[2].u = 1.0;
			m.triangle[Index1 + Count2].uv[2].v = 1.0;
			Index2 = Count2 + Rotation;
			Index2 %= SCALING_FACTOR1;
			fourthV[Index1 + Count2] = (Index1 + Index2 + SCALING_FACTOR1) % Vertices;
		}
	}

	for (int i = 0; i < VERTICES; i++)
	{
		m.triangle[i + VERTICES].v[0] = &m.vertex[m.triangle[i].v[0]->num];
		m.triangle[i + VERTICES].v[1] = &m.vertex[m.triangle[i].v[2]->num];
		m.triangle[i + VERTICES].v[2] = &m.vertex[fourthV[i]];
//		m.vertex[fourthV[i]].u = 0.0;
//		m.vertex[fourthV[i]].v = 1.0;
	}

	m.calcNormals ();
	delete fourthV;
}


void genSphere(Model &m, float r, int xrow, int yrow, bool semisphere)
{
	int		i, x, y;
	GLfloat	ylevel, radius;
	int		offset = 0;
	
	int yring = yrow*4+4;
	
	if (semisphere == false)
	    m.resize (2*yrow*xrow+xrow+2, 2*xrow+yrow*xrow*4);
	else
	    m.resize (yrow*xrow+xrow+1, xrow+yrow*xrow*2);

	
	// NORTH POLE
	m.vertex[0].x = 0;
	m.vertex[0].z = 0;
	m.vertex[0].y = -r;
	offset++;
	
	// NORTHSIDE & EQUADOR
	for (y = 0; y < yrow + 1; y++)
	{
		ylevel = (GLfloat)(-cos(2*3.1416*(y+1) / float(yring)) * r);
		radius = (GLfloat)( sin(2*3.1416*(y+1) / float(yring)) * r);
		
		for (x = 0; x < xrow; x++)
		{
			m.vertex[offset].x = (GLfloat)(sin(2*3.1416*x / (float)xrow) * radius);
			m.vertex[offset].z = (GLfloat)(cos(2*3.1416*x / (float)xrow) * radius);
			m.vertex[offset].y = ylevel;
			offset++;
		}
	}
	
   if (semisphere == false)
	{
	// SOUTHSIDE
	for (y = 0; y < yrow; y++)
	{
		ylevel = (GLfloat)(sin(2*3.1416*(y+1) / float(yring)) * r);
		radius = (GLfloat)(cos(2*3.1416*(y+1) / float(yring)) * r);
		
		for (x = 0; x < xrow; x++)
		{
			m.vertex[offset].x = (GLfloat)(sin(2*3.1416*x / (float)xrow) * radius);
			m.vertex[offset].z = (GLfloat)(cos(2*3.1416*x / (float)xrow) * radius);
			m.vertex[offset].y = ylevel;
			offset++;
		}
	}
	
	// SOUTHPOLE
	m.vertex[offset].x = 0;
	m.vertex[offset].z = 0;
	m.vertex[offset].y = r;
	offset++;
   }
	
	Triangle *ppoly = m.triangle;
	
	float xtex = 3.0f / (float)(xrow);
	float ytex = 3.0f / (float)(3+2*yrow);


	for (i = 0; i < xrow; i++)
	{
		ppoly[i].v[0] = &m.vertex[0];
		ppoly[i].v[1] = &m.vertex[1+(i+1)%xrow];
		ppoly[i].v[2] = &m.vertex[1+i];
		ppoly[i].uv[0].u = 0.5f;
		ppoly[i].uv[0].v = 0.0f;
		ppoly[i].uv[1].u = ((i+1)*xtex);
		ppoly[i].uv[1].v = ytex;
		ppoly[i].uv[2].u = (i*xtex);
		ppoly[i].uv[2].v = ytex;
	}

	for (int j = 0; j < yrow*(1+(semisphere==false)); j++)
	{
		for (i = 0; i < xrow; i++)
		{
			offset = xrow+(i+j*xrow)*2;
			ppoly[offset].v[0] = &m.vertex[j*xrow+1+i];
			ppoly[offset].v[1] = &m.vertex[j*xrow+1+(i+1)%xrow];
			ppoly[offset].v[2] = &m.vertex[j*xrow+1+i+xrow];
			ppoly[offset].uv[0].u = (i*xtex);
			ppoly[offset].uv[0].v = ((1+j)*ytex);
			ppoly[offset].uv[1].u = ((1+i)*xtex);
			ppoly[offset].uv[1].v = ((1+j)*ytex);
			ppoly[offset].uv[2].u = (i*xtex);
			ppoly[offset].uv[2].v = ((2+j)*ytex);
			
			offset = xrow+(i+j*xrow)*2+1;
			ppoly[offset].v[0] = &m.vertex[j*xrow+1+(i+1)%xrow];
			ppoly[offset].v[1] = &m.vertex[xrow+j*xrow+1+(i+1)%xrow];
			ppoly[offset].v[2] = &m.vertex[j*xrow+1+i+xrow];
			ppoly[offset].uv[0].u = ((i+1)*xtex);
			ppoly[offset].uv[0].v = ((1+j)*ytex);
			ppoly[offset].uv[1].u = ((i+1)*xtex);
			ppoly[offset].uv[1].v = ((2+j)*ytex);
			ppoly[offset].uv[2].u = (i*xtex);
			ppoly[offset].uv[2].v = ((2+j)*ytex);
		}
		
	   if (semisphere == false)
		for (i = 0; i < xrow; i++)
		{
			offset = xrow+xrow*2*yrow*2+i;
			ppoly[offset].v[0] = &m.vertex[2*yrow*xrow+1+i];
			ppoly[offset].v[1] = &m.vertex[2*yrow*xrow+1+(i+1)%xrow];
			ppoly[offset].v[2] = &m.vertex[2*yrow*xrow+1+xrow];
			ppoly[offset].uv[0].u = (i*xtex);
			ppoly[offset].uv[0].v = ((yrow*2+1)*ytex);
			ppoly[offset].uv[1].u = ((i+1)*xtex);
			ppoly[offset].uv[1].v = ((yrow*2+1)*ytex);
			ppoly[offset].uv[2].u = 0.5f;
			ppoly[offset].uv[2].v = 1.0f;
		}
	}

	for (i = 0; i < m.nVertices; i++)
		m.vertex[i].r = m.vertex[i].g = m.vertex[i].b = m.vertex[i].a = 1.0f;

	m.calcNormals ();
}
/*
void genTerrain (Model &m, char *data)
{
	int x, y, i = 0, j = 0;

	GLfloat ustep = 20.0f / (float)(51);
	GLfloat vstep = 20.0f / (float)(51);
	GLfloat u = 0, v = 0;

	m.resize (51*51, (51-1)*(51-1)*2);

	for (x = 0, u = 0; x < 51; x++, u += ustep)
	{
		for (y = 0, v = 0; y < 51; y++, v += vstep)
		{
			m.vertex[j].x = (x-25.5f)*2;
			m.vertex[j].z = (y-25.5f)*2;
			m.vertex[j].y = data[256*(y*5)+(x*5)] / 16.0f;
			m.vertex[j].r = 1.0f;
			m.vertex[j].g = 1.0f;
			m.vertex[j].b = 1.0f;
			m.vertex[j].a = 1.0f;
			m.vertex[j].num = j++;
			if ((x < 50) && (y < 50))
			{
				m.triangle[i].v[0] = &m.vertex[51*y+x];
				m.triangle[i].v[1] = &m.vertex[51*y+x+1];
				m.triangle[i].v[2] = &m.vertex[51*y+x+52];
				m.triangle[i].uv[0].u = u;
				m.triangle[i].uv[0].v = v;
				m.triangle[i].uv[1].u = u + ustep;
				m.triangle[i].uv[1].v = v;
				m.triangle[i].uv[2].u = u + ustep;
				m.triangle[i].uv[2].v = v + vstep;

				m.triangle[i+1].v[0] = &m.vertex[51*y+x];
				m.triangle[i+1].v[1] = &m.vertex[51*y+x+52];
				m.triangle[i+1].v[2] = &m.vertex[51*y+x+51];
				m.triangle[i+1].uv[0].u = u;
				m.triangle[i+1].uv[0].v = v;
				m.triangle[i+1].uv[1].u = u + ustep;
				m.triangle[i+1].uv[1].v = v + vstep;
				m.triangle[i+1].uv[2].u = u;
				m.triangle[i+1].uv[2].v = v + vstep;

				i+=2;
			}
		}
	}

	m.calcNormals ();
}
*/
void genTerrain (Model &m, int vsize, char *data, float texfreq)
{
	int x, y, i = 0, j = 0;

	int hsize = vsize-1;

	GLfloat ustep = texfreq / (float)(vsize);
	GLfloat vstep = texfreq / (float)(vsize);
	GLfloat u = 0, v = 0;

	m.resize (vsize*vsize, (hsize)*(hsize)*2);

	for (x = 0, u = 0; x < vsize; x++, u += ustep)
	{
		for (y = 0, v = 0; y < vsize; y++, v += vstep)
		{
			m.vertex[j].x = (x-hsize/2.0f)*2;
			m.vertex[j].z = (y-hsize/2.0f)*2;
			if (data == NULL)
				m.vertex[j].y = 0;
			else
				m.vertex[j].y = data[256*(y*5)+(x*5)] / 16.0f;
			m.vertex[j].r = 1.0f;
			m.vertex[j].g = 1.0f;
			m.vertex[j].b = 1.0f;
			m.vertex[j].a = 1.0f;
			m.vertex[j].num = j++;
			if ((x < (hsize)) && (y < (hsize)))
			{
				m.triangle[i].v[0] = &m.vertex[vsize*y+x];
				m.triangle[i].v[1] = &m.vertex[vsize*y+x+1];
				m.triangle[i].v[2] = &m.vertex[vsize*y+x+vsize+1];
				m.triangle[i].uv[0].u = u;
				m.triangle[i].uv[0].v = v;
				m.triangle[i].uv[1].u = u + ustep;
				m.triangle[i].uv[1].v = v;
				m.triangle[i].uv[2].u = u + ustep;
				m.triangle[i].uv[2].v = v + vstep;

				m.triangle[i+1].v[0] = &m.vertex[vsize*y+x];
				m.triangle[i+1].v[1] = &m.vertex[vsize*y+x+vsize+1];
				m.triangle[i+1].v[2] = &m.vertex[vsize*y+x+vsize];
				m.triangle[i+1].uv[0].u = u;
				m.triangle[i+1].uv[0].v = v;
				m.triangle[i+1].uv[1].u = u + ustep;
				m.triangle[i+1].uv[1].v = v + vstep;
				m.triangle[i+1].uv[2].u = u;
				m.triangle[i+1].uv[2].v = v + vstep;

				i+=2;
			}
		}
	}

	m.calcNormals ();
}


void genCone(Model &mo,int n, float height, float r_top, float r_bot)
{
int i;

mo.resize (2*n,2*n);

for (i=0;i<n;i++)
  {
  mo.vertex[i].x = (GLfloat)(sin(2*3.1415*i/(float)n)*r_top);
  mo.vertex[i].z = (GLfloat)(cos(2*3.1415*i/(float)n)*r_top);
  mo.vertex[i].y = 0.0f;
  }

for (i=0;i<n;i++)
  {
  mo.vertex[i+n].x = (GLfloat)(sin(2*3.1415*i/(float)n)*r_bot);
  mo.vertex[i+n].z = (GLfloat)(cos(2*3.1415*i/(float)n)*r_bot);
  mo.vertex[i+n].y = (GLfloat)(height);
  }

Triangle *ppoly = mo.triangle;

for (i=0;i<n;i++)
{ 
  ppoly[i*2].v[0] = &mo.vertex[i]; 
  ppoly[i*2].v[1] = &mo.vertex[(i+1)%n];
  ppoly[i*2].v[2] = &mo.vertex[i+n];

  ppoly[i*2].uv[0].u = (1.0f/(float)n)*i; 
  ppoly[i*2].uv[0].v = 0.0f;

  ppoly[i*2].uv[1].u = (1.0f/(float)n)*((i+1));
  ppoly[i*2].uv[1].v = 0.0f;

  ppoly[i*2].uv[2].u = (1.0f/(float)n)*i;
  ppoly[i*2].uv[2].v = 1.0f;


  ppoly[i*2+1].v[0] = &mo.vertex[(i+1)%n];
  ppoly[i*2+1].v[1] = &mo.vertex[n+(i+1)%n];
  ppoly[i*2+1].v[2] = &mo.vertex[i+n];
 
  ppoly[i*2+1].uv[0].u = (1.0f/(float)n)*((i+1));
  ppoly[i*2+1].uv[0].v = 0.0f;

  ppoly[i*2+1].uv[1].u = (1.0f/(float)n)*((i+1));
  ppoly[i*2+1].uv[1].v = 1.0f;

  ppoly[i*2+1].uv[2].u = (1.0f/(float)n)*i;
  ppoly[i*2+1].uv[2].v = 1.0f;  
  }

for (i = 0; i < mo.nVertices; i++)
		mo.vertex[i].r = mo.vertex[i].g = mo.vertex[i].b = mo.vertex[i].a = 1.0f;

mo.calcNormals ();
}

void loadModel(Model &mo, unsigned char *data, int nvertices, int ntriangles)
{
int i = 0, off = 0, j = 0;

mo.resize (nvertices,ntriangles);

GLfloat lenght=0.0f, maxlenght = 0.0f;

for ( i=0; i<nvertices; i++ )
	{
	mo.vertex[i].x = (GLfloat)( (short)(data[i*6  ]+(data[i*6+1]<<8)) / 20.0f ); 
	mo.vertex[i].z = (GLfloat)( (short)(data[i*6+2]+(data[i*6+3]<<8)) / 20.0f ); 
	mo.vertex[i].y = (GLfloat)( (short)(data[i*6+4]+(data[i*6+5]<<8)) / 20.0f ); 
	
	lenght = sqrt( mo.vertex[i].x*mo.vertex[i].x +
		           mo.vertex[i].y*mo.vertex[i].y + 
				   mo.vertex[i].z*mo.vertex[i].z );

	if (lenght > maxlenght) maxlenght = lenght; 
	}

Triangle *ppoly = mo.triangle;

off = nvertices*6;

for ( i=0; i<ntriangles; i++ )
	{ 
	ppoly[i].v[0] = &mo.vertex[ data[off+i*3+2] ]; 
	ppoly[i].v[1] = &mo.vertex[ data[off+i*3+1] ]; 
	ppoly[i].v[2] = &mo.vertex[ data[off+i*3  ] ]; 
	
	// Calcing texture coords

	for (int j=0;j<3;j++)
		{
		lenght = sqrt( ppoly[i].v[j]->x*ppoly[i].v[j]->x + 
					   ppoly[i].v[j]->z*ppoly[i].v[j]->z );
	
		ppoly[i].uv[j].u = (GLfloat)(lenght / maxlenght); 
	
		lenght = sqrt( ppoly[i].v[j]->y*ppoly[i].v[j]->y + 
					   ppoly[i].v[j]->z*ppoly[i].v[j]->z );
	
	
		ppoly[i].uv[j].v = (GLfloat)(lenght / maxlenght);
		}
	
	} 

for (i = 0; i < mo.nVertices; i++)
		mo.vertex[i].r = mo.vertex[i].g = mo.vertex[i].b = mo.vertex[i].a = 1.0f;

mo.calcNormals ();
}