#include <windows.h>
#include <GL/gl.h>
#include "system.h"
#include "text.h"
#include "globals.h"

void init_Intropart ()
{
	glEnable (GL_BLEND);
	glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA); 
	glEnable (GL_TEXTURE_2D);
	glDisable (GL_DEPTH_TEST);
	glBindTexture (GL_TEXTURE_2D, TID_LOGO);

	cam.pos[0] = 0;
	cam.pos[1] = 0;
	cam.pos[2] = 2;
}

void part_Intro ()
{
	static bool first = true;
	static float starttime = time;

	float lapsedtime = time - starttime;

	if (first)
		{
		init_Intropart ();
		first = false; }

	SetProjection ();

	GLfloat a = lapsedtime / 7.1;

	if (a > 1.0f)
		a = 1.0f;


	// 7.5 sek, row == 50
	if (row > 50)
	{
		glScalef ((lapsedtime-7.5)*10.0+1.0, (7.5-lapsedtime)*0.3+1.0, 1.0f);
	
		GLfloat al = (7.5-lapsedtime)*0.5+1.0;
		glBegin (GL_QUADS);
			glColor4f (1.0f, 1.0f, 1.0f, al); glTexCoord2f (1.0f, 1.0f); glVertex3f ( 2.7 + (1.0-a), -0.6f, 0.0f);
			glColor4f (1.0f, 1.0f, 1.0f, al); glTexCoord2f (1.0f, 0.0f); glVertex3f ( 2.7 + (1.0-a),  0.6f, 0.0f);
			glColor4f (1.0f, 1.0f, 1.0f, al); glTexCoord2f (0.0f, 0.0f); glVertex3f (-2.7 - (1.0-a),  0.6f, 0.0f);
			glColor4f (1.0f, 1.0f, 1.0f, al); glTexCoord2f (0.0f, 1.0f); glVertex3f (-2.7 - (1.0-a), -0.6f, 0.0f);
		glEnd ();
	} 
	else 
	{
		for (float s = 10.0; s > 1.0; s -= 0.1)
		{
			glRotatef ((1.0-a), 0.0f, 0.0f, 1.0f);
			glBegin (GL_QUADS);
				glColor4f (1.0f, 1.0f, 1.0f, 0.01); glTexCoord2f (1.0f, 1.0f); glVertex3f ( 2.7 + (1.0-a)*s, -0.6f, 0.0f);
				glColor4f (1.0f, 1.0f, 1.0f, 0.01); glTexCoord2f (1.0f, 0.0f); glVertex3f ( 2.7 + (1.0-a)*s,  0.6f, 0.0f);
				glColor4f (1.0f, 1.0f, 1.0f, 0.01); glTexCoord2f (0.0f, 0.0f); glVertex3f (-2.7 - (1.0-a)*s,  0.6f, 0.0f);
				glColor4f (1.0f, 1.0f, 1.0f, 0.01); glTexCoord2f (0.0f, 1.0f); glVertex3f (-2.7 - (1.0-a)*s, -0.6f, 0.0f);
			glEnd ();
		}
	} 
}
