#ifndef __GLOBALS_H
#define __GLOBALS_H

// Useless warnings, leave us alone
#pragma warning(disable : 4244)
#pragma warning(disable : 4305) 

#include <windows.h>
#include <GL/gl.h>
#include "vector.h"
#include "model.h"
#include "bouncer.h"
#include "camera.h"
#include "olist.h"

#define M_PI		3.1415926536f

#define ALF(c)			((c >> 24) & 0xFF)
#define BLU(c)			((c >> 16) & 0xFF)
#define GRN(c)			((c >> 8) & 0xFF)
#define RED(c)			(c & 0xFF)

#define ABGR(a, b, g, r)	((a << 24) | (b << 16) | (g << 8) | r)

extern unsigned int		TID_TEXT, TID_LOGO, TID_ATG[9], TID2_ATG[4], TID_PLASTIK, TID_RAVEN;

extern int				XRES, YRES;
extern int				oldXRES, oldYRES;

extern HDC				hDC;
extern HDC				hDCFrontBuffer;
extern HGLRC			hGLRC;
extern int				demostate, part;
extern bool				fullscreen;

extern GLfloat			fov;
extern Camera			cam;
extern Model			*sphere, *sphere2, *esher, *cube;
extern Model			*terrain, *plane;
extern Model			*nelogomodel;

extern OList            templemodel;
extern OList            buildingmodel;

extern Bouncer			*b[8];

extern GLfloat			time;

extern int				order, row;
extern float			mtime;

#endif