#include <windows.h>
#include <GL/gl.h>
#include <GL/glu.h>
#include <math.h>
#include "globals.h"
#include "system.h"
#include "esher.h"
#include "text.h"

void init_Esher ()
{
	glEnable (GL_LIGHTING);
	glFogf (GL_FOG_START, 200.0);
	glFogf (GL_FOG_END, 400.0);
	glEnable (GL_CULL_FACE);
	glCullFace (GL_BACK);
	glEnable (GL_TEXTURE_2D);
	glEnable (GL_TEXTURE_GEN_S);
	glEnable (GL_TEXTURE_GEN_T);
	glEnable (GL_FOG);
	GLfloat fogCol[4] = { 0.0f, 0.0f, 0.0f, 1.0f };
	glClearColor (0.0f, 0.0f, 0.0f, 1.0f);
	glFogfv (GL_FOG_COLOR, fogCol);
	cam.directional = false;
	//cam.pos[0] = 0;
	//cam.pos[1] = 0;
	//cam.pos[2] = 100;
	cam.tgt[0] = 0;
	cam.tgt[1] = 0;
	cam.tgt[2] = 0;
	fov = 100;
}

void drawFloors ()
{
	glPushAttrib (GL_ALL_ATTRIB_BITS);
	glEnable (GL_BLEND);
	glDisable (GL_LIGHTING);
	glDisable (GL_TEXTURE_GEN_S);
	glDisable (GL_TEXTURE_GEN_T);
	glBindTexture (GL_TEXTURE_2D, TID_ATG[2]);

	int size = 80;
	int xmax = 20;
	int zmax = 10;
	int xoffset = (int)(size*xmax*0.5);
	int zoffset = (int)(size*zmax*0.5);
 
	glColor4f (1.0f, 1.0f, 1.0f, 1.0f);

	for (int x = 0; x < xmax; x++)
	{
		for (int z = -zmax; z < zmax; z++)
		{
			glBegin (GL_QUADS);
				/* TOP 
				glTexCoord2f ( 0.0f, 0.0f);
				glVertex3f ( (float)(x*size - xoffset),  100.0f, (float)(-(z*size+zoffset)));

				glTexCoord2f ( 0.0f, 1.0f);
				glVertex3f ( (float)(x*size - xoffset),  100.0f, (float)(-(z*size+size+zoffset)));

				glTexCoord2f ( 1.0f, 1.0f);
				glVertex3f ( (float)(x*size+size - xoffset),  100.0f, (float)(-(z*size+size+zoffset)));

				glTexCoord2f ( 1.0f, 0.0f);
				glVertex3f ( (float)(x*size+size - xoffset),  100.0f, (float)(-(z*size+zoffset)));
					*/
				
				//BOTTOM
				glTexCoord2f ( 1.0f, 0.0f);
				glVertex3f ( (float)(x*size + size - xoffset),  -100.0f, (float)(-(z*size + zoffset)));

				glTexCoord2f ( 1.0f, 1.0f);
				glVertex3f ( (float)(x*size+size - xoffset),  -100.0f, (float)(-(z*size+size + zoffset)));
				
				glTexCoord2f ( 0.0f, 1.0f);
				glVertex3f ( (float)(x*size - xoffset),  -100.0f, (float)(-(z*size+size + zoffset)));

				glTexCoord2f ( 0.0f, 0.0f);
				glVertex3f ( (float)(x*size - xoffset),  -100.0f, (float)(-(z*size + zoffset)));
			glEnd ();
		}
	}

	glPopAttrib ();
}

/*
void Draw2DImage (int id, GLfloat x, GLfloat y, GLfloat z, GLfloat a)
{
	glPushAttrib (GL_ALL_ATTRIB_BITS);
	glDisable (GL_LIGHTING);
	glDisable (GL_TEXTURE_GEN_S);
	glDisable (GL_TEXTURE_GEN_T);
	glPushMatrix ();
		glTranslatef (x, y, z);
		glBlendFunc (GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
		glEnable (GL_BLEND);
		glBindTexture (GL_TEXTURE_2D, id);
		glBegin (GL_QUADS);
			glColor4f (1.0f, 1.0f, 1.0f, a); glTexCoord2f (0.0f, 1.0f); glVertex3f (-1.0f, -1.0f,  0.0f);
			glColor4f (1.0f, 1.0f, 1.0f, a); glTexCoord2f (1.0f, 1.0f); glVertex3f ( 1.0f, -1.0f,  0.0f);
			glColor4f (1.0f, 1.0f, 1.0f, a); glTexCoord2f (1.0f, 0.0f); glVertex3f ( 1.0f,  1.0f,  0.0f);
			glColor4f (1.0f, 1.0f, 1.0f, a); glTexCoord2f (0.0f, 0.0f); glVertex3f (-1.0f,  1.0f,  0.0f);
		glEnd ();
	glPopMatrix ();
	glPopAttrib ();
}
*/

void part_Esherpart ()
{
	init_Esher ();

	float dist = 15 -( sin(3.14*time/60)*10* cos(3.14*time/4) );

	cam.pos[0] = -(GLfloat)sin(3.14*time/7)*dist*15;
	cam.pos[1] = 60;
	cam.pos[2] = -(GLfloat)cos(3.14*time/7)*dist*15;


	SetProjection ();

	//esher->rY += 2.0f;
	//esher->rZ += 3.1f;
	esher->pZ = 0;//-200;
	esher->sX = esher->sY = esher->sZ = 0.8f;
	
	glDisable (GL_BLEND);
	glFrontFace (GL_CW);

	glPushMatrix();
		glScalef(1.0, -1.0, 1.0);
		glTranslatef (0.0f, 200.0, 0.0);
		esher->render ();
	glPopMatrix();
	
	glFrontFace (GL_CCW);

	drawFloors ();
	esher->render ();
}

