
%define MODE_WIDTH	dword 640
%define MODE_HEIGHT	dword 480
%define MODE_BPP	byte 24

;-- PE header ---------------------------------------------------------------

%include "pehdr.inc"

;-- Data residing in the header ---------------------------------------------

align 2, db 0
_DDrawName				db 'DDRAW.DLL'
IMPORT_FUNCTION _UpdateWindow,		'UpdateWindow'
IMPORT_FUNCTION _PeekMessage,		'PeekMessageA'
IMPORT_FUNCTION _DefWindowProc, 	'DefWindowProcA'
IMPORT_FUNCTION _PostQuitMessage,	'PostQuitMessage'
IMPORT_FUNCTION _DirectDrawCreate,	'DirectDrawCreate'
IMPORT_FUNCTION _WaitMessage,		'WaitMessage'
db 0 ; trailing zero after last function name

;-- Program section ---------------------------------------------------------

START_PROGRAM
%include "ddraw.inc"

; Window class
WindowClass	dd 0			; Style
		dd ABS(WndProc) 	; Window callback
		dd 0, 0 		; Extra class and window bytes
		dd _ImageBase		; Module handle
		dd 0, 0 		; Icon, cursor
		dd 0			; Background brush - transparent
		dd 0			; Menu name
		dd HABS(_SectionH)	; Class name

; Some constants
%define WS_OVERLAPPEDWINDOW	dword 00CF0000h
%define CW_USEDEFAULT		80000000h
%define SW_SHOWNORMAL		byte 1
%define WM_CREATE	byte 1
%define WM_DESTROY	byte 2
%define WM_QUIT 	byte 12h
%define PM_REMOVE	byte 1

; Some simplifications for calling, since ebp points near the thunk
; What's more, Msg equals _OffImage
%define xRegisterClass	   {byte ebp-(_OffImage-RegisterClass	)}
%define xCreateWindowEx    {byte ebp-(_OffImage-CreateWindowEx	)}
%define xShowWindow	   {byte ebp-(_OffImage-ShowWindow	)}
%define xUpdateWindow	   {byte ebp-(_OffImage-UpdateWindow	)}
%define xDirectDrawCreate  {byte ebp-(_OffImage-DirectDrawCreate)}
%define xPeekMessage	   {byte ebp-(_OffImage-PeekMessage	)}
%define xDefWindowProc	   {byte ebp-(_OffImage-DefWindowProc	)}
%define xWaitMessage	   {byte ebp-(_OffImage-WaitMessage	)}

	; Create and show window
_EntryPoint:	push	ebp
		mov	ebp, ABS(Msg)
		INVOKER xRegisterClass, dword ABS(WindowClass)
		mov	eax, HABS(_SectionH)	; eax = window/class name
		xor	ebx, ebx		; ebx = 0
		mov	edx, CW_USEDEFAULT
		INVOKER xCreateWindowEx, ebx, eax, eax, WS_OVERLAPPEDWINDOW, edx, edx, edx, edx, ebx, ebx, dword _ImageBase, ebx
		xchg	eax, edi
		INVOKER xShowWindow, edi, SW_SHOWNORMAL
		INVOKER xUpdateWindow, edi

	; Initialize DirectDraw
		push	eax
		mov	eax, esp
		INVOKER xDirectDrawCreate, ebx, eax, ebx
		xchg	eax, edi
		pop	edi
		mov	esi, [edi]
		INVOKER esi+ddSetCooperativeLevel, edi, eax, byte DDSCL_EXCLUSIVE+DDSCL_FULLSCREEN
		INVOKER esi+ddSetDisplayMode, edi, MODE_WIDTH, MODE_HEIGHT, MODE_BPP
		or	eax, eax
		jnz	.return

	; Render next frame
.next_frame:	INVOKER xWaitMessage

	; Message processing
.next_msg:	INVOKER xPeekMessage, ebp, ebx, ebx, ebx, PM_REMOVE
		or	eax, eax
		jz	.next_frame
		mov	eax, [ebp+4]
		cmp	eax, WM_QUIT
		je	.return
;		cmp	eax, WM_DESTROY
;		je	.return
.def_wnd_proc:	INVOKER xDefWindowProc, dword [ebp], eax, dword [ebp+8], dword [ebp+12]
		jmp	short .next_msg

	; Shut down and return
.return:	mov	eax, [edi]
		INVOKER eax+ddRelease, edi
		pop	ebp
		ret

;-- Dummy window procedure --------------------------------------------------

WndProc:	cmp	dword [esp+8], WM_DESTROY
		je	.destroy
		jmp	dword [ABS(DefWindowProc)]
.destroy:	INVOKE	PostQuitMessage, byte 0
		ret	4*4 ; 4 arguments

;-- Imports -----------------------------------------------------------------

align 4, db 0

IMPORT_DLL _User32Name-_DOSH, _User32Pointers, _User32Pointers
IMPORT_DLL _DDrawName-_DOSH, _DDrawPointers, _DDrawPointers
END_IMPORT_DLL

_User32Pointers:
RegisterClass		dd _RegisterClass-_DOSH
CreateWindowEx		dd _CreateWindowEx-_DOSH
ShowWindow		dd _ShowWindow-_DOSH
UpdateWindow		dd _UpdateWindow-_DOSH
PeekMessage		dd _PeekMessage-_DOSH
DefWindowProc		dd _DefWindowProc-_DOSH
PostQuitMessage 	dd _PostQuitMessage-_DOSH
WaitMessage		dd _WaitMessage-_DOSH
			dd 0

_DDrawPointers:
DirectDrawCreate	dd _DirectDrawCreate-_DOSH
			dd 0

_OffImage:

;-- Uninitialized data ------------------------------------------------------
section .bss
Msg			resd 7

_OffModule:

;-- End of file -------------------------------------------------------------
