; TinyPrime by Picard
; 76bytes "unstable" version
; for Hugi Size Coding Competition 12  
; (works on win2k too)

.MODEL TINY
.386
.CODE
.STARTUP

;assumed:
; bx = 00xx
; [0002] = <0
; [0000] = 20CD
; [FFFE] = 0000
; [00F6] = 0000 0000 0000 0000 0000

;no 32bit instructions 
;-prime,-remainder table is after sp

        db      13-'0',10-'0'              ;newline characters
        pop     cx                         ;pop 0 -> reset 16bit counter
	mov	si,00F6h                   ;ascii output counter's begining

Count:  mov     bl,128                     ;decrement ascii cmdline
        add     bl,[bx]                    ;last charater in cmdline
AscSub: mov     al,[bx]                    
        dec     ax
        aas
        mov     [bx],al
        dec     bl
	jns     short Print                ;exit when [80h] decremented 
        jc      short AscSub               

Next:   mov     bl,255                     ;increment ascii output counter
AscAdd: mov     al,[bx]
        inc     ax
        aaa
        mov     [bx],al
        dec     bx
        jc      short AscAdd      

        dec     cx                         ;16bit counter 
        mov     di,sp                      ;begining of table
        cwd                                ;clear dx (0 or -1)
UpdRem: inc     word ptr [di]              ;decrement -remainder
        jl      short UpdOk                ;if >= 0 -> remainder overflow
        mov     dx,[di+2]                  ;reset remainder to -prime
        mov     [di],dx                    ;(by the way set dx)
UpdOk:  add     di,4                       ;next item
        js      short UpdRem            
         
        inc     dx                         ;if dx>0 -> not a prime
        jl      short Next

        cmp     sp,10000h-546*4            ;let's limit our table to 546 items
        je      short Count
        push    cx                         ;add new -prime with initial -remainder
        push    cx                         ;(16bit is enough for 546. prime)
        jmp     short Count

PLoop:  xchg	ax,dx                      
	mov	ah,2
	int	21h
Print:  lodsb                              ;print output digits
	add	al,'0'
	jns	PLoop                      ;exit when we reach 'pop bp'
	int	20h                        ;can't use ret ([sp]<>0)
end                            
