DECLARE SUB WaterPal ()
DEFINT A-Z
'Particle Waterfall simulator
'Copyright 1999 Toshi Horie

RANDOMIZE TIMER
SCREEN 13
CONST xmax = 319
CONST ymax = 199
CONST cmax = 255
CONST spread = 15
WaterPal
CONST numparticles = 1999
almostall = numparticles - 100
TYPE watertype
   x AS INTEGER
   y AS INTEGER
   t AS INTEGER: 'how long the particle has been in freefall
   c AS INTEGER: 'color of water
END TYPE
DIM h2o(1 TO numparticles) AS watertype
DIM v(0 TO 100) 'velocity due to gravity

'set up velocity table due to gravity
FOR t = 0 TO 100
    v(t) = t + 1
NEXT t

start:
CLS
'set up water at top of screen
FOR i = 1 TO numparticles
   h2o(i).x = i MOD xmax
   h2o(i).y = i \ xmax
   h2o(i).t = 0
   h2o(i).c = 1 + INT(RND * 5)
   PSET (h2o(i).x, h2o(i).y), h2o(i).c
NEXT i

'set up barriers
ybar = h2o(numparticles).y + 1
xomax = xmax \ 3
yomax = (ymax - yd) \ 4
yvmax = (ymax - ybar)
FOR i = 1 TO 50
   x1 = RND * xmax
   y1 = ybar + RND * yvmax
   xo = RND * xomax - xomax \ 2
   yo = RND * yomax - yomax \ 2
   LINE (x1, y1)-(x1 + xo, y1 + yo), cmax
   LINE (x1 + 1, y1)-(x1 + 1 + xo, y1 + yo), cmax
NEXT
'bowl on bottom
CIRCLE (xmax \ 2, ymax \ 2), xmax * 4 \ 7, cmax, 4, 5.5, .5
'title
COLOR cmax * 3 \ 9: LOCATE 25, 5: PRINT "Falling Water       by Toshi 1999";

'show palette
'FOR i = 0 TO 255
' PSET (i, ymax \ 2), i
'NEXT

DO
ctr = 0
FOR i = 1 TO numparticles
   x = h2o(i).x
   y = h2o(i).y
   t = h2o(i).t
   c = h2o(i).c
   PSET (x, y), 0
   IF t > 100 THEN h2o(i).t = 100
   dy = v(t) + RND * 4
   IF POINT(x, y + 1) = 0 THEN
         'free space below pixel, so move down
         IF t > 2 THEN
            prob = RND * 1000
            IF prob > spread THEN
               'particles spread out
               flag = 0
               IF prob > 600 THEN 'try right first
                     IF POINT(x + 1, y + 1) = 0 THEN 'right
                        yy = 1
                        DO
                           yy = yy + 1
                           IF yy = dy THEN flag = 1
                           IF POINT(x + 1, y + yy) <> 0 THEN flag = 1: yy = yy - 1
                        LOOP UNTIL flag = 1
                        dy = yy
                        h2o(i).x = x + 1
                     'ELSEIF POINT(x - 1, y + 1) = 0 THEN 'left
                     '   yy = 1
                     '   DO
                     '      yy = yy + 1
                     '      IF yy = dy THEN flag = 1
                     '      IF POINT(x - 1, y + yy) <> 0 THEN flag = 1: yy = yy - 1
                     '   LOOP UNTIL flag = 1
                     '   dy = yy
                     '   h2o(i).x = x - 1
                     ELSE 'straight down as far as possible
                        yy = 1
                        DO
                           yy = yy + 1
                           IF yy = dy THEN flag = 1
                           IF POINT(x, y + yy) <> 0 THEN flag = 1: yy = yy - 1
                        LOOP UNTIL flag = 1
                        dy = yy
                     END IF
               ELSE 'try left first
                     IF POINT(x - 1, y + 1) = 0 THEN 'left
                        yy = 1
                        DO
                           yy = yy + 1
                           IF yy = dy THEN flag = 1
                           IF POINT(x - 1, y + yy) <> 0 THEN flag = 1: yy = yy - 1
                        LOOP UNTIL flag = 1
                        dy = yy
                        h2o(i).x = x - 1
                     'ELSEIF POINT(x + 1, y + 1) = 0 THEN 'right
                     '   yy = 1
                     '   DO
                     '      yy = yy + 1
                     '      IF yy = dy THEN flag = 1
                     '      IF POINT(x + 1, y + yy) <> 0 THEN flag = 1: yy = yy - 1
                    '    LOOP UNTIL flag = 1
                     '   dy = yy
                     '   h2o(i).x = x + 1
                     ELSE 'straight down as far as possible
                        yy = 1
                        DO
                           yy = yy + 1
                           IF yy = dy THEN flag = 1
                           IF POINT(x, y + yy) <> 0 THEN flag = 1: yy = yy - 1
                        LOOP UNTIL flag = 1
                        dy = yy
                     END IF
               END IF 'left or right spread
            END IF 'spread or not
         ELSE 't<2
            yy = 1
            DO
               yy = yy + 1
               IF yy = dy THEN flag = 1
               IF POINT(x, y + yy) <> 0 THEN flag = 1: yy = yy - 1
            LOOP UNTIL flag = 1
            dy = yy
         END IF
         h2o(i).t = h2o(i).t + 1
         h2o(i).y = h2o(i).y + dy
         h2o(i).c = c + dy
         IF c > cmax THEN h2o(i).c = cmax \ 2
      ELSE
         'no free space below-- must move sideways or stay still
         ctr = ctr + 1
         IF POINT(x + 1, y) = 0 THEN
            h2o(i).x = x + 1
         ELSEIF POINT(x - 1, y) = 0 THEN
            h2o(i).x = x - 1
         ELSE
            h2o(i).c = 20 + RND * 8
            'stay completely still
         END IF
         IF t > 2 THEN h2o(i).c = 120 + RND * 8
         h2o(i).t = 0: ' reset freefall counter
   END IF
   PSET (h2o(i).x, h2o(i).y), h2o(i).c
   IF ctr > almostall AND i = numparticles THEN GOTO start
NEXT i
LOOP UNTIL INKEY$ > ""

DEFSNG A-Z
SUB WaterPal
FOR i = 0 TO 63
OUT &H3C8, i
OUT &H3C9, 0
OUT &H3C9, 0
q = i + 10
IF q > 63 THEN q = 63
OUT &H3C9, q
OUT &H3C8, i + 64
OUT &H3C9, 0
OUT &H3C9, i \ 2 + 31
OUT &H3C9, i AND 63
NEXT i
FOR i = 128 TO 195
OUT &H3C8, i
OUT &H3C9, i - 128
OUT &H3C9, 30 + (i - 128) \ 2
OUT &H3C9, 30 + (i - 128) \ 2
NEXT
FOR i = 0 TO 62
OUT &H3C8, i + 196
OUT &H3C9, 63 - i
OUT &H3C9, 63 - i
OUT &H3C9, 63 - i
NEXT i
'white for boundaries
OUT &H3C8, 255
OUT &H3C9, i
OUT &H3C9, i
OUT &H3C9, i

END SUB

