/****************************************************************************
 * unbwtex2.cpp                                            Un-BWT Example 2 *
 ****************************************************************************
 * made by Fabian Giesen aka RYG/Chrome Design                              *
 * for my BWT article in hugi #13                                           *
 *                                                                          *
 * This implementation is the first one which builds the transformation     *
 * vector on its own. But I recommend using more advanced examples.         *
 ****************************************************************************/

#include <iostream.h>

char L[]="UNBGULEEDH";                           // our L array
int  primary_ind=9;                              // the primary index

unsigned long *T;                                // the transformation vector

unsigned long startpos[256];                     // "virtual F array" stuff
unsigned long counts[256];

// the "virtual F array" generator

void generateStartingPositions(char *data, unsigned long length)
{
  unsigned long i, sum;                          // counters.

  for (i=0; i<256; i++) counts[i]=0;             // build the counts array
  for (i=0; i<length; i++) counts[data[i]]++;    // from input data

  sum=0;

  for (i=0; i<256; i++)                          // then calculate our
  {                                              // "starting positions".
    startpos[i]=sum;                             // read the article if you
    sum+=counts[i];                              // want to know how it's
  };                                             // actually done
};

// the transformation vector generator

void buildTransformationVector(char *L, unsigned long L_len)
{
  unsigned long i;

  if (T) delete[] T;                             // setup T
  T=new unsigned long[L_len];

  generateStartingPositions(L, L_len);           // create "virtual F array"

  for (i=0; i<256; i++) counts[i]=0;

  for (i=0; i<L_len; i++)                        // then build the transfor-
  {                                              // mation vector with the
    char val=L[i];                               // algorithm described in
                                                 // the article.
    T[startpos[val]+counts[val]]=i;
    counts[val]++;
  };
};

int main()
{
  buildTransformationVector(L, 10);              // create transform. vector

  int ind=primary_ind;                           // read unbwtex1.cpp if you
                                                 // need comments for this
  for (int i=0; i<10; i++)
  {
    cout << L[ind];
    ind=T[ind];
  };

  cout << endl;

  return 0;                                      // we're already done
};
