/****************************************************************************
 * bwtex2.cpp                                                 BWT Example 2 *
 ****************************************************************************
 * made by Fabian Giesen aka RYG/Chrome Design                              *
 * for my BWT article in hugi #13                                           *
 *                                                                          *
 * I don't ask you to credit me when using this because you wouldn't use    *
 * THIS version of the encoder                                              *
 ****************************************************************************
 * WARNING: This code assumes that char is unsigned and memcmp compares     *
 *          unsigned chars! If that isn't right for your platform, you have *
 *          to write an own memcmp function and change all chars in this    *
 *          source to unsigned ones!                                        *
 ****************************************************************************/

// this is just a copy of bwtex1.cpp with a 32-bit compare function.
// you won't notice the speed benifit with this small string, though. this
// compare function is meant for "real" bwt encoders which need every bit of
// speed they can get.

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <iostream.h>

typedef unsigned long ulong;           // useful!

char *text="HUGENDUBEL";               // our text to compress
int   index[10];                       // instead of sorting strings, I
                                       // sort an index array, which is
                                       // significantly faster and uses much
                                       // less memory

int compare_func(const int *p1, const int *p2)
{
  char *in1, *in2, *end;               // comparision pointers
  int   i;                             // "bytes compared" counter

  in1=&text[*p1];                      // first input pointer
  in2=&text[*p2];                      // second input pointer
  end=&text[9];                        // end of buffer pointer

  for (i=0; i<10; i++)                 // comparision loop
  {
    if ((in1+4<end) && (in2+4<end))    // check if we can use dword compare
    {
      if (*((ulong *) in1)!=*((ulong *) in2))
      {
        if (*in1<*in2) return -1;      // compares for character 1
        if (*in1>*in2) return 1;

        if (++in1==end) in1=&text[0];  // advance & wrap
        if (++in2==end) in2=&text[0];  // advance & wrap

        if (*in1<*in2) return -1;      // compares for character 2
        if (*in1>*in2) return 1;

        if (++in1==end) in1=&text[0];  // advance & wrap
        if (++in2==end) in2=&text[0];  // advance & wrap

        if (*in1<*in2) return -1;      // compares for character 3
        if (*in1>*in2) return 1;

        if (++in1==end) in1=&text[0];  // advance & wrap
        if (++in2==end) in2=&text[0];  // advance & wrap

        if (*in1<*in2) return -1;      // compares for character 4
        if (*in1>*in2) return 1;
      };

      in1+=4; if (in1>=end) in1-=10;   // advance & wrap
      in2+=4; if (in2>=end) in2-=10;   // advance & wrap
    } else {
      if (*in1<*in2) return -1;        // compares for character 1
      if (*in1>*in2) return 1;

      if (++in1==end) in1=&text[0];    // advance & wrap
      if (++in2==end) in2=&text[0];    // advance & wrap

      if (*in1<*in2) return -1;        // compares for character 2
      if (*in1>*in2) return 1;

      if (++in1==end) in1=&text[0];    // advance & wrap
      if (++in2==end) in2=&text[0];    // advance & wrap

      if (*in1<*in2) return -1;        // compares for character 3
      if (*in1>*in2) return 1;

      if (++in1==end) in1=&text[0];    // advance & wrap
      if (++in2==end) in2=&text[0];    // advance & wrap

      if (*in1<*in2) return -1;        // compares for character 4
      if (*in1>*in2) return 1;

      if (++in1==end) in1=&text[0];    // advance & wrap
      if (++in2==end) in2=&text[0];    // advance & wrap
    };
  };

  return 0;                            // if string1==string2, return 0
};

// NOTE: Unless you use a very good optimizing compiler you won't benefit
//       much from this code (at least if you use C). But this function is
//       only written in C to be better understandable. If you really want to
//       use this function, I suggest rewriting it in assembler.

int main()
{
  int i, j;                            // counters
  int pi;                              // primary index

  for (i=0; i<10; i++) index[i]=i;     // initialize index array

  qsort(index, 10, sizeof(int),        // then sort it using compare_func
        (int(*)(const void *, const void *)) compare_func);

  cerr << endl << "L: ";               // print out column L

  for (i=0; i<10; i++)
  {
    j=index[i]-1;                      // get character no from index array
    if (j==0) pi=i;                    // if this is string 1, set primary
                                       // index
    if (j<0) j=10+j;                   // wraparound

    cerr << text[j];                   // print it
  };

  cerr << endl;                        // end this line
  cerr << "primary index: " << pi;     // write primary index
  cerr << endl;                        // line feed

  return 0;                            // and we're done
};
