comment -Ŀ
             entry for HUGI size coding competition #4          
  
  
         
             expression evaluator               
          
  
   no unary ops except at the beginning of a subexpression
   I've tested it: EAX seems to be always = 0 on startup (at
    least with my computer under WIN95/DOS70). fine.
   a 586 is recommended due to prefetch queue problems which
    otherwise may occur (e.g. on a 486 10/2*3 is evaluated as
    10*2/3).
   tested with DOS70 and a P200MMX
  
-
.model tiny
.486
.code
.startup
EAXNZ   equ     0               ; enable this if upper half of eax!=0
o       equ     offset          ; on startup
b       equ     byte ptr
nr      equ     edi
_nr     equ     di
_mul    equ     0E8h+7          ; 7=reg nr of di
_div    equ     0F8h+7
pro     equ     ebx
_pro    equ     bx
__pro   equ     bl
sum     equ     nr
_sum    equ     _nr
opc     equ     ch
_opc    equ     cx

; assumes
; eax=000000..
;  si=0100
;  cl=FF
;  ds=cs

s:      call    _parse          ; evaluate expression
        mov     al,10
        xchg    sum,eax         ; sum=10 eax=result
@l:     cdq
        idiv    sum             ; divide (if number<0 then remainder<=0)
        push    dx              ; save remainder (|remainder|<10)
        or      eax,eax         ; result zero?
        push    o @skip
        jnz     @l              ; no -> recurse
        or      dx,dx           ; was number negative?
        mov     dl,'-'
        js      @print          ; ...print a '-'
;       ret                     ; -> jmp @skip

_parse: mov     si,82h          ; expression starts at 82h
IF EAXNZ
        cwde                    ; patch for eax!=0 on startup
ENDIF
parse:  xor     sum,sum         ; sum=0
        stc                     ; set carry (->add) (can I avoid this?)
@nexts: push    sum             ; save sum
        sbb     pro,pro
        sbb     __pro,cl        ; if carry then pro=-1 else pro=1 (5b)
@nextpm:mov     opc,_mul        ; a+b -> a-(-1)*b
@nextp: xor     nr,nr           ; nr=0
        push    pro
        push    _opc            ; save pro and mul/div modr/m
next:   push    o next          ; prepare return addr
        lodsb                   ; get next char
        sub     al,'0'
        jnc     @nr             ; if digit update nr
        cmp     al,'('-'0'
        je      parse           ; if '(' "call" parse
@op:    pop     bx              ; bx=offset next (bx=_pro)
        pop     _opc            ; get modr/m
        mov     b 2[o @mul-o next+bx],opc ; patch imul<->idiv
        pop     pro             ; restore pro (ebx)
        xchg    eax,pro         ; swap eax and pro
        cdq                     ; extend to 64 bits
@mul:   imul    nr              ; (imul nr or idiv nr)
        xchg    eax,pro         ; swap back
        sub     al,'/'-'0'      ; '/'?
        mov     opc,_div
        je      @nextp          ; yes -> divide next
        sub     al,'*'-'/'      ; '*'?
        je      @nextpm         ; yes -> multiply next
        pop     sum             ; restore sum
        sub     sum,pro         ; update sum
        sub     al,'-'-'*'      ; sets carry if al='+' (or '.' or ',')
        jbe     @nexts          ; if '-' or '+' then continue
        ret                     ; bye!

@skip:  pop     dx              ; get remainder
@neg:   neg     dx
        js      @neg            ; calculate absolute value of remainder
        add     dl,'0'          ; make digit
@print: mov     ah,2
        int     21h             ; print it
;       ret                     ; next digit/return to DOS

@nr:    imul    nr,10
        add     nr,eax          ; update nr
        ret                     ; and continue (-> next)

end
comment @
EOL  (   )   *   +   -   /   0.. 9
13  40  41  42  43  45  47  48..57
@

