;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;                                 K I N   II                             ;;
;;                                version 1.10                            ;;
;;                            by Jordan Touzsouzov                        ;;
;;                               MORDRED  '1998                           ;;
;;                            mordreds@hotmail.com                        ;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

; Use i80186/286 assembler.

.186

; Jump to Main program

JMP START_GAME

; New Interrupt 1Ch handle

Int1C:

    mov byte ptr cs:CLTick, 0
    iret

; Put Sprite Procedure
; CX = X, DX = Y, SI = Offset of CS:sprite
; If the sprite has collision with another sprite, then the Status variable
; sets to 0

put_sprite proc
     pusha
     push ds
     mov byte ptr cs:Status, 1
     mov ax, cs:DBSeg
     mov es, ax
     mov ax, dx
     mov bx, 320
     mul bx
     add ax, cx
     mov di, ax
     xor bh, bh
     mov bl, cs:[si]
     mov dx, bx
     xor ch, ch
     inc si
Sp_begin:
     mov cl, dl
     shr cl, 1
XSprite:
     mov al, cs:[si]
     push al
     shr al, 4
     jz No_point_1
     mov ah, es:[di]
     cmp ah, 15
     jg cont_sp_1
     mov cs:Status, 0
cont_sp_1:
     add al, cs:ADDWith
     mov es:[di], al
No_point_1:

     pop al
     inc di
     and al, 00001111b
     jz No_point_2
     add al, cs:ADDWith
     mov es:[di], al
No_point_2:
     inc si
     inc di
     loop XSprite
YSprite:
     add di, 320
     sub di, dx
     dec bl
     jnz Sp_begin
     pop ds
     popa
     ret
put_sprite endp

; Put Shadow Procedure
; CX = X, DX = Y, SI = Offset of CS:sprite

put_shadow proc
     pusha
     push ds
     mov ax, cs:DBSeg
     mov es, ax
     mov ax, dx
     mov bx, 320
     mul bx
     add ax, cx
     mov di, ax
     xor bh, bh
     mov bl, cs:[si]
     mov dx, bx
     xor ch, ch
     inc si
Sh_begin:
     mov cl, dl
     shr cl, 1
XShadow:
     mov al, cs:[si]
     push al
     shr al, 4
     jz No_shado_1
     mov al, es:[di]
     cmp al, 19
     jle No_shado_1
     sub al, 3
     mov es:[di], al
No_shado_1:

     pop al
     inc di
     and al, 00001111b
     jz No_shado_2
     mov al, es:[di]
     cmp al, 19
     jle No_shado_2
     sub al, 3
     mov es:[di], al
No_shado_2:

     inc si
     inc di
     loop XShadow
YShadow:
     add di, 320
     sub di, dx
     dec bl
     jnz Sh_begin
     pop ds
     popa
     ret
put_shadow endp

; Put Object - sprite with shadow - procedure, It's a genial !
; CX = X, DX = Y, SI = offset

put_object proc
     push cx
     push dx
     mov ax, 160
     sub ax, cx
     sar ax, 3
     add cx, ax
     mov ax, 100
     sub ax, dx
     sar ax, 2
     add dx, ax
     call put_shadow
     pop dx
     pop cx
     call put_sprite
     ret
put_object endp

; Make a Blast
; CX = X, DX = Y

make_blast proc
     pusha
     push ds
     push dx
     mov ax, cs:DBSeg
     mov es, ax
     mov ax, dx
     mov bx, 320
     mul bx
     add ax, cx
     add ax, 7
     mov di, ax
     mov ah, 4
     sub di, 640
     pop dx
blast1:
     mov al, es:[di]
     cmp al, 15
     jg cblast
     jmp short end_blast
cblast:
     mov es:[di], ah
     cmp di, 1200
     sub di, 640
     dec dx
     dec dx
     jg blast1
end_blast:
     add cx, 5
     lea si, cs:explod
     call put_sprite
     pop ds
     popa
     ret
make_blast endp

; Show the Live status bar

show_status proc
     pusha
     push ds
     mov ax, cs:DBSeg
     mov es, ax
     mov di, 64000-320+1
     mov bl, cs:LIVE
     inc bl
     shl bl, 2
     mov ax, 0404h
stat_rep:
     mov cx, 5
     rep stosw
     sub di, 320+10
     dec bl
     jnz stat_rep
     mov ax, 0f0fh
     mov cl, 5
     rep stosw
     pop ds
     popa
     ret
show_status endp

; "Happy End" Procedure

happy_end proc
     pusha
     push ds
     mov ax, 0a000h
     mov es, ax
     xor di, di
     mov si, 64000
     xor ax, ax
clearh:
     mov cx, 160
     rep stosw
     xchg si, di
     mov cx, 160
     rep stosw
     xchg si, di
     sub si, 640
     mov bl, 1
     mov cs:CLTick, bl
waitL:
     mov bl, cs:CLTick
     or bl, bl
     jnz waitL
     cmp di, 32000
     jle clearh
     pop ds
     popa
     ret
happy_end endp

; Show Double Buffer Procedure

show_double proc
     pusha
     push ds
     mov ax, 0a000h
     mov es, ax
     mov ax, cs:DBSeg
     mov ds, ax
     mov cx, 32000
     xor si, si
     xor di, di
     rep movsw
     pop ds
     popa
     ret
show_double endp

; Scroll procedure
; SCRow = row of screen swapping

scroll proc
     pusha
     push ds
     mov ax, cs:DBSeg
     mov es, ax
     mov ax, cs:LDSeg
     mov ds, ax
     mov ax, cs:SCRow
     mov bx, 320
     mul bx
     xor di, di
     mov si, ax
     mov cx, 64000
     sub cx, ax
     shr cx, 1
     rep movsw
     xor si, si
     mov cx, ax
     shr cx, 1
     rep movsw
     pop ds
     popa
     ret
scroll endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;                             Main program                             ;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

START_GAME:

      push ds

; Set interrupt vector 1Ch to my handle

      xor ax, ax
      mov ds, ax
      mov di, word ptr ds:[112]
      mov si, word ptr ds:[114]
      mov word ptr cs:Intr1C, di
      mov word ptr cs:Intr1C+2, si
      cli
      mov ds:[112], offset Int1C
      mov ds:[114], cs
      mov byte ptr cs:crpt, 4bh
      sti

      pop ds

      mov ax, 13h                      ; Init Graph
      int 10h

      xor ax, ax                       ; Init Mouse
      int 33h
      or ax, ax
      jz NoMem

      mov ax, 01ah
      mov bx, 25
      mov cx, bx
      int 33h

      mov cx, 46                       ; Set mouse range
      mov ax, 7
      mov dx, (320-36)*2
      int 33h
      inc ax
      xor cl, cl
      mov dx, 200-20
      int 33h

      mov ah, 49h                      ; Free Mem
      int 21h

      mov ah, 48h                      ; Get CS Mem
      mov bx, 4096
      int 21h

      mov ah, 48h                      ; Get Landscape Mem
      mov bx, 4096
      int 21h
      jc  NoMem
      mov LDSeg, ax

      mov ah, 48h                      ; Get Double Buffer Mem
      mov bx, 4096
      int 21h
      jc  NoMem
      mov DBSeg, ax

      jmp short MemAllocOK
NoMem:
      jmp EndProgram

MemAllocOK:

;Init the LandScape

      mov ax, LDSeg
      mov bx, DBSeg
      xchg bx, LDSeg
      xchg ax, DBSeg

      lea bx, cs:lndmap
      mov al, 10h
      mov ah, 10
      xor cx, cx
      xor dx, dx
      mov di, 1000000000000000b

lndrep:
      lea si, land
      call put_sprite
      test di, cs:[bx]
      je nohouse
      lea si, house
      call put_sprite
nohouse:
      add cx, 20
      shr di, 1
      dec al
      jnz lndrep

      mov al, 10h
      xor cx, cx
      add dx, 20
      mov di, 1000000000000000b
      inc bx
      dec ah
      jnz lndrep

      mov ax, DBSeg
      mov bx, LDSeg
      xchg ax, LDSeg
      xchg bx, DBSeg
      mov byte ptr ADDWith, 0

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;                            Body of the Game                           ;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

REPEAT:                                ; Point of repeat

; Scrolls the LandScape

      mov byte ptr CLTick, 1
      mov word ptr Trofeus, 10

      mov ax, SCRow
      dec ax
      jne cont0
      mov ax, 200
cont0:
      mov SCRow, ax
      call scroll

; Put the enemies

      mov di, 5
      lea bx, Ex
ENEMYREP:
      cmp cs:[bx+8], 20
      jg InGame
      mov cx, 2
      mov dx, Trofeus
      lea si, enemy
      call put_sprite
      add Trofeus, 20
      jmp WasDead
InGame:
      mov cx, [bx]
      mov dx, [bx+2]
      cmp dx, 5
      jle CorrectDY
      cmp dx, 180
      jge CorrectDY
      jmp short GoY
CorrectDY:
      neg [bx+6]
GoY:
      cmp cx, 24
      jle CorrectDX
      cmp cx, 280
      jge CorrectDX
      jmp short GoX
CorrectDX:
      neg [bx+4]
GoX:
      add dx, [bx+6]
      add cx, [bx+4]
      mov [bx+2], dx
      mov [bx], cx
      lea si, enemy
      call put_object

      cmp byte ptr buttons, 1
      jnz HappyEnemy
      cmp dx, MyY
      jge HappyEnemy
      cmp cx, MyX
      jge HappyEnemy
      add cx, 16
      cmp cx, MyX
      jle HappyEnemy
      dec [bx+8]
HappyEnemy:

WasDead:
      dec di
      add bx, 10
      or di, di
      jz ENEMYEND
      jmp ENEMYREP
ENEMYEND:

; Put the Rockets

      mov dx, posss
      add dx, 5
      cmp dx, 190
      jle cont1
      xor dx, dx
      cmp numb, 7
      jle nozero
      mov numb, 0
nozero:
      inc numb
      mov di, numb
      inc di
      mov ax, 320
      xor dx, dx
      div di
      mov begx, ax

cont1:
      mov bx, numb
      lea si, rocket
      mov posss, dx
      mov cx, begx
reproc:
      call put_object
      add cx, begx
      dec bx
      jnz reproc

; Get Control of our hero !

      mov ax, 3
      int 33h
      shr cx, 1
      add cx, 8
      mov MyX, cx
      sub cx, 8
      mov MyY, dx
      mov buttons, bl

; Put our hero

      lea si, sprite
      call put_object
      cmp Status, 0
      jne ISDead
      dec LIVE
ISDead:
      cmp bx, 1
      jnz no_blast
      call make_blast
      dec TIMEPLAY
      je Dead

no_blast:

      cmp byte ptr [83h], '-'
      jz no_clock
wait_clock:
      cmp byte ptr CLTick, 0
      jnz wait_clock

no_clock:

; Show scene

      call show_status
      call show_double
      cmp Trofeus, 110
      jge VICTORY
      cmp byte ptr LIVE, 0
      je Dead
      cmp buttons, 2                ; If not Right Button pressed,
      je  Dead                      ; repeat the
      jmp REPEAT                    ; Game body.

Dead:
      mov TIMEPLAY, 0

VICTORY:
      call happy_end
EndProgram:

      mov ax, 3                        ; Close Graph
      int 10h

      lea bx, Ex-1
print:
      mov al, [bx]
      cmp al, 74
      je stop_print
      xor al, 110
      int 29h
crpt  inc bx
      jmp short print
stop_print:

      mov ax, TIMEPLAY              ; Output the SCORE
      mov di, 10
      xor cx, cx
lp1:
      xor dx, dx
      div di
      push dl
      inc cl
      or ax, ax
      jnz lp1
lp2:
      pop al
      add al, 30h
      int 29h
      loop lp2


      xor ax, ax
      mov ds, ax

; Restore 1Ch interrupt vector

      cli
      mov word ptr ax, cs:Intr1C
      mov ds:[112], ax
      mov word ptr ax, cs:Intr1C+2
      mov ds:[114], ax
      sti
BLOCKAGE:
      int 20h                          ; Terminate the program

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;                           DATA Section                               ;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

; Main Data

buttons  DB 0        ; Button status
MyX      DW 0        ; Coordinates of
MyY      DW 0        ; our hero.
SCRow    DW 200      ; Row of scrolling
Status   DB 0ffh     ; Live status, returned by Put_sprite func. 0 = Dead
LIVE     DB 20       ; Live Units of our hero
Intr1C   DD 0        ; Segment and Offset of old 01ch interrupt
CLTick   DB 0        ; One Clock Tick (18.2 per second)
Trofeus  DW 10       ; Where put the tropheus
ADDWith  DB 8        ; Color offset
TIMEPLAY DW 0ffffh   ; Time to play
AnyLIVE  DB 0ffh     ; Flag, =0 if all enemies are dead.

; Message of the end of the game

messag DB 74,78,84,78,11,28,1,13,61,100,99,86,87,87,95,78,66,71,24,1,20
       DB 27,1,29,20,27,1,58,78,0,15,10,28,1,36
       DB 70,78,10,11,28,10,28,1,35,78,71,45,70,100,99,32,39,37


; Enemies Data
; All - words : Ex, Ey, DeX, DeY, Status

Ex     DW 25,20,4,4,222,  80,30,2,3,222,  25,100,5,4,222
       DW 200,20,4,3,222,  100,130,1,3,222

; Rockets Data

posss DW 0          ; Y-position of rockets
begx  DW 160        ; First X and step
numb  DW 1          ; Number of rockets (1...8)


; DBSeg - Segment for Double Buffer
; LDSeg - Segment for the LandScape

DBSeg  DW 0
LDSeg  DW 0


; SPRITES
; Format of sprite is :
; Byte XSize and YSize, Byte Data[XSize/2][YSize]
; Color of the point is coded with 4bit + color offset (ADDWith)
; NOTE : XSize = YSize always !
; VERY IMPORTANT : All active sprites, are with colors 1..15.
; 0 - Invisible color.

; Battle Ship sprite 16*16
sprite DB  16
       DB  00h, 00h, 00h, 0fh, 00h, 00h, 00h, 00h
       DB  00h, 00h, 00h, 0fh, 00h, 00h, 00h, 00h
       DB  00h, 00h, 00h,0ffh,0f0h, 00h, 00h, 00h
       DB  00h, 00h, 00h,0ffh,0f0h, 00h, 00h, 00h
       DB 0f0h, 00h, 0fh,0ffh,0ffh, 00h, 00h,0f0h
       DB 0ffh, 00h, 0fh, 4fh, 4fh, 00h, 0fh,0f0h
       DB 0f0h, 00h, 04h,0ffh,0f4h, 00h, 00h,0f0h
       DB 0f0h, 00h, 0fh,0ffh,0ffh, 00h, 00h,0f0h
       DB 0f0h, 00h, 0fh,0f9h,0ffh, 00h, 00h,0f0h
       DB 0ffh, 00h,0ffh, 99h, 9fh,0f0h, 0fh,0f0h
       DB 0ffh,0ffh,0ffh, 94h, 9fh,0ffh,0ffh,0f0h
       DB 0ffh,0ffh,0ffh, 94h, 9fh,0ffh,0ffh,0f0h
       DB 0f0h,0ffh,0ffh, 44h, 4fh,0ffh,0f0h,0f0h
       DB 0f0h, 0fh,0ffh, 44h, 4fh,0ffh, 00h,0f0h
       DB  00h, 00h,0ffh,0ffh,0ffh,0f0h, 00h, 00h
       DB  00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h

; Enemy sprite 16*16
enemy  DB  16
       DB  00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h
       DB  00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h
       DB  00h, 01h, 00h, 00h, 00h, 00h, 10h, 00h
       DB  00h, 10h, 00h, 00h, 00h, 00h, 01h, 00h
       DB  01h,0f0h, 00h, 01h, 10h, 00h, 0fh, 10h
       DB  1fh, 00h, 00h, 19h, 91h, 00h, 00h,0f1h
       DB  1fh,0f0h, 00h, 11h, 11h, 00h, 0fh,0f1h
       DB  1fh,0ffh,0ffh, 11h, 11h,0ffh,0ffh,0f1h
       DB  1fh,0f0h, 00h, 11h, 11h, 00h, 0fh,0f1h
       DB  1fh, 00h, 00h, 19h, 91h, 00h, 00h,0f1h
       DB  01h,0f0h, 00h, 01h, 10h, 00h, 0fh, 10h
       DB  00h, 10h, 00h, 00h, 00h, 00h, 01h, 00h
       DB  00h, 01h, 00h, 00h, 00h, 00h, 10h, 00h
       DB  00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h
       DB  00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h
       DB  00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h

; Rocket sprite 10*10
rocket DB  10
       DB  77h, 00h, 70h, 07h, 70h
       DB  77h, 00h, 70h, 07h, 70h
       DB  07h, 44h, 74h, 47h, 00h
       DB  00h, 4ch, 44h, 40h, 00h
       DB  00h, 4ch, 44h, 40h, 00h
       DB  00h, 4ch, 44h, 40h, 00h
       DB  00h, 4ch, 44h, 40h, 00h
       DB  00h, 04h,0c4h, 00h, 00h
       DB  00h, 00h, 40h, 00h, 00h
       DB  00h, 00h, 00h, 00h, 00h

; Explode sprite 6*6
explod DB 6
       DB 0e0h,0c0h,0e0h
       DB  00h, 00h, 00h
       DB 0c0h,0e0h,0c0h
       DB  00h, 00h, 00h
       DB 0e0h,0c0h,0e0h
       DB  00h, 00h, 00h

; Land sprite
land   DB 20
       DB 0edh,0edh,0edh,0edh,0bch,0cch,0fdh,0edh,0edh,0edh
       DB 0deh,0deh,0deh,0deh,0bch,0cch,0feh,0deh,0deh,0deh
       DB 0edh,0edh,0edh,0edh,0bch,0cch,0fdh,0edh,0edh,0edh
       DB 0deh,0deh,0deh,0deh,0bch,0cch,0feh,0deh,0deh,0deh
       DB 0edh,0edh,0edh,0edh,0bch,0cch,0fdh,0edh,0edh,0edh
       DB 0deh,0deh,0deh,0deh,0bch,0cch,0feh,0deh,0deh,0deh
       DB 0edh,0edh,0edh,0edh,0bch,0cch,0fdh,0edh,0edh,0edh
       DB 0bbh,0bbh,0bbh,0bbh,0bch,0cch,0cbh,0bbh,0bbh,0bbh
       DB 0cch,0cch,0cch,0cch,0cch,0cch,0cch,0cch,0cch,0cch
       DB 0cch,0cch,0cch,0cch,0cch,0cch,0cch,0cch,0cch,0cch
       DB 0cch,0cch,0cch,0cch,0cch,0cch,0cch,0cch,0cch,0cch
       DB 0cch,0cch,0cch,0cch,0cch,0cch,0cch,0cch,0cch,0cch
       DB 0ffh,0ffh,0ffh,0ffh,0cch,0cch,0ffh,0ffh,0ffh,0ffh
       DB 0deh,0deh,0deh,0deh,0bch,0cch,0feh,0deh,0deh,0deh
       DB 0edh,0edh,0edh,0edh,0bch,0cch,0fdh,0edh,0edh,0edh
       DB 0deh,0deh,0deh,0deh,0bch,0cch,0feh,0deh,0deh,0deh
       DB 0edh,0edh,0edh,0edh,0bch,0cch,0fdh,0edh,0edh,0edh
       DB 0deh,0deh,0deh,0deh,0bch,0cch,0feh,0deh,0deh,0deh
       DB 0edh,0edh,0edh,0edh,0bch,0cch,0fdh,0edh,0edh,0edh
       DB 0deh,0deh,0deh,0deh,0bch,0cch,0feh,0deh,0deh,0deh

; Pyramid sprite 20*20
house  DB  20
       DB  00h,0ffh,0ffh,0fbh, 00h, 00h, 0bh,0ffh,0ffh,0ffh
       DB  0fh, 0fh,0ffh,0fbh, 00h, 00h, 0bh,0ffh,0ffh,0f0h
       DB  0fh,0f0h,0ffh,0ffh,0b0h, 00h,0bfh,0ffh,0ffh, 0eh
       DB  0fh,0ffh, 0fh,0ffh,0b0h, 00h,0bfh,0ffh,0f0h,0eeh
       DB  0fh,0ffh,0f0h,0ffh,0fbh,0bbh,0ffh,0ffh, 0eh,0eeh
       DB  0fh,0ffh,0ffh, 0fh,0ffh,0ffh,0ffh,0f0h,0eeh,0eeh
       DB  0bh,0bfh,0ffh,0f0h,0ffh,0ffh,0ffh, 0eh,0eeh,0bbh
       DB  00h, 0bh,0bfh,0ffh, 0fh,0ffh,0f0h,0eeh,0bbh, 00h
       DB  00h, 00h, 0bh,0ffh,0f0h,0ffh, 0eh,0ebh, 00h, 00h
       DB  00h, 00h, 0bh,0ffh,0ffh, 22h,0eeh,0ebh, 00h, 00h
       DB  00h, 00h, 0bh,0ffh,0ffh, 22h,0eeh,0ebh, 00h, 00h
       DB  00h, 00h, 0bh,0ffh,0f0h,0ffh, 0eh,0ebh, 00h, 00h
       DB  00h, 0bh,0bfh,0ffh, 0fh,0ffh,0f0h,0eeh,0bbh, 00h
       DB  0bh,0bfh,0ffh,0f0h,0ffh,0ffh,0ffh, 0eh,0eeh,0bbh
       DB  0fh,0ffh,0ffh, 0fh,0ffh,0ffh,0ffh,0f0h,0eeh,0eeh
       DB  0fh,0ffh,0f0h,0ffh,0fbh,0bbh,0ffh,0ffh, 0eh,0eeh
       DB  0fh,0ffh, 0fh,0ffh,0b0h, 00h,0bfh,0ffh,0f0h,0eeh
       DB  0fh,0f0h,0ffh,0ffh,0b0h, 00h,0bfh,0ffh,0ffh, 0eh
       DB  0fh, 0fh,0ffh,0fbh, 00h, 00h, 0bh,0ffh,0ffh,0f0h
       DB  00h,0ffh,0ffh,0fbh, 00h, 00h, 0bh,0ffh,0ffh,0ffh


; LandScape Map 16*10
lndmap DW 0000000000000000b
       DW 0100000000100000b
       DW 0000000100000010b
       DW 0000000000000000b
       DW 0010000000010000b
       DW 0000000000000100b
       DW 0000010010000000b
       DW 0000000000000000b
       DW 0010000000100000b
       DW 0000000000000000b
