//
//  3rd example for lzp-style data decompression                 red_13 1998
//
//
//  if you use any parts from this code in your programs (i recommend you to
//  improve the algorithm before doing that, though), please credit me. :)
//
//

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <conio.h>
#include <iostream.h>

//
//  some global crap
//

char *hashbuf[0x10000];
char *inbuf, *dstbuf; long buflen, bytes_out = 0;

//
//  function to read variable-length codes from input stream
//

static long incount = 0;
static unsigned long inpbuf = 0;

unsigned long getcode (long csize) {
   unsigned long retval;

   while (incount <= 24 ) {
     inpbuf |= (unsigned long) *inbuf++ << (24 - incount);
     incount += 8;
     buflen--;
   }

   retval = inpbuf >> (32-csize);
   inpbuf <<= csize;
   incount -= csize;
   return(retval);
}

//
//  the hashing function
//

inline long hashval (long value) {
  return (long) (((value >> 15) ^ value) & 0xffff);
}

//
//  main
//

void main (long argc, char *argv[]) {
  if (argc < 3) {
    cout << endl << "syntax: unlzp <infile> <outfile>" << endl;
    exit(1);
  }

  FILE *qf = fopen(argv[1], "rb");

  if (!qf) {
    cout << "can't open input file." << endl;
    exit(1);
  }

  FILE *zf = fopen(argv[2], "wb");

  if (!zf) {
    cout << "can't create output file." << endl;
    exit(1);
  }

  fseek(qf, 0, SEEK_END);                       // get input file's size
  buflen = ftell(qf);
  fseek(qf, -4, SEEK_END);                      // read output file's size
  fread(&bytes_out, 1, 4, qf);
  fseek(qf, 0, SEEK_SET);

  cout << endl << "decompressing" << endl << "   ";

  inbuf = new char [buflen+100];
  dstbuf = new char [bytes_out+100];

  memset(hashbuf, 0, 0x10000 * 4);              // initialize hash table
  memset(dstbuf, 0, bytes_out+100);             // clear destination buffer

  fread(inbuf, 1, buflen, qf);                  // read compressed input
  fclose(qf);

  char *string, *hashstr, *dstbufb = dstbuf, *inbufb = inbuf;
  long hash, prebytes, length, buflenb = buflen;

  do {
    string = dstbuf;
    prebytes = *((long *) (string-4));          // get preceeding 4 bytes
    hash = hashval(prebytes);
    hashstr = hashbuf[hash];
    hashbuf[hash] = string;

    if (hashstr) {                              // is it a match?
      long prefix = getcode(1);

      if (!(buflen % 2000)) putch('.');         // dum-di-dum... =)

      switch (prefix) {
        case 0 : *dstbuf++ = getcode(8);        // retrieve single character
                 break;

        case 1 : long temp = getcode(2);        // decode length of match
                 if (temp == 3) {
                   length = 3;
                   temp = getcode(3);

                   if (temp == 7) {
                     length += 7;
                     temp = getcode(5);

                     if (temp == 31) {
                       length += 31;
                       temp = getcode(8);

                       if (temp == 0xff) {
                         while (temp == 0xff) {
                           length += 0xff;
                           temp = getcode(8);
                         }
                         length += temp;

                       } else length += temp;
                     } else length += temp;
                   } else length += temp;
                 } else length = temp;

                 for (long i = 0; i < length; i++)
                   *dstbuf++ = *hashstr++;      // retrieve string

                 break;
      }
    } else *dstbuf++ = getcode(8);              // single character
  } while (buflen > 1);

  fwrite(dstbufb, 1, bytes_out, zf);
  fclose(zf);

  cout << endl << endl << "bytes in : " << buflenb << endl;
  cout << "bytes out: " << bytes_out << endl;
  cout << "i/o ratio: " << (bytes_out * 100) / buflenb << "%" << endl;

  delete [] inbufb;
  delete [] dstbufb;
}

//
