db "Author : GreenGhost                     "
db "Assembler : NASM                        "
db "Program to test zero page init.         "

%include "spew.inc"

Main:
  .NextP0:
    rdi Ptr             ;read byte
    pushb Safe0         ;clear carry
    popb status
    sbba Ptr            ;compare
    jpne P0Err
    lda Safe1           ;move pointer
    addw Ptr
    lda Ptr             ;loop
    adca Safe0
  jpnz .NextP0
  gosub WriteStr        ;show message
  db ".. zero page "
  db "init OK.",13,10
  oscall 0              ;quit

P0Err:
  gosub WriteStr        ;show error
  db "Error in "
  db "zero page "
  db "init!",13,10
  oscall 0              ;quit

WriteStr:
  popb Ptr              ;get pointer
  popb Ptr+1
  .Next:
    rdi Ptr             ;read char
    pushb a             ;save a
    oscall 6            ;write char
    lda Safe1           ;move pointer
    addw Ptr
    popb a              ;restore a
    pushb Safe0         ;clear carry
    popb status
    sbba Safe10         ;test if 10
  jpne .Next
  pushb Ptr+1
  pushb Ptr
return

Ptr:    dw 0
Safe0:  db 0
Safe1:  db 1
Safe10: db 10

epilogue
