; SPEW include file
; Copyright 1999 GreenGhost
; Assembler : NASM
;
; 99.08.21 : 1.00
; 99.08.22 : 1.01 : message in header
; 99.08.23 : 1.02 : bugfix in jpb define, jpcc macro
; 99.08.23 : 1.03 : epilogue macro added

times 240-($-$$) db ' '
db "GG SPEWinc 1.03",26

%macro fillto 1
  times %1-($-$$) db 0
%endm

%macro oscall 1
  dw %1
%endm

%macro jp 1
  dw %1
%endm

%macro return 0
  dw 1000h
%endm

%macro gosub 1
  dw 1000h+(%1)
%endm

%macro pushb 1
  dw 2000h+(%1)
%endm

%macro popb 1
  dw 3000h+(%1)
%endm

%macro lda 1
  dw 4000h+(%1)
%endm

%macro sta 1
  dw 5000h+(%1)
%endm

%macro rdi 1
  dw 6000h+(%1)
%endm

%macro wri 1
  dw 7000h+(%1)
%endm

%macro rdsys 1
  dw 8000h+(%1)
%endm

%macro addw 1
  dw 9000h+(%1)
%endm

%idefine jpb jpc
%idefine jpnae jpc
%idefine jpae jpnc
%idefine jpnb jpnc
%idefine jpe jpz
%idefine jpne jpnz
%idefine jpna jpbe
%idefine jpnbe jpa
%idefine jppe jpp
%idefine jppo jpnp
%idefine jpnge jpl
%idefine jpnl jpge
%idefine jpng jple
%idefine jpnle jpg

%macro jpcc 2
  db (%2)-$-2,0A0h+%1
%endm

%idefine jpo jpcc 0,
%idefine jpno jpcc 1,
%idefine jpc jpcc 2,
%idefine jpnc jpcc 3,
%idefine jpz jpcc 4,
%idefine jpnz jpcc 5,
%idefine jpbe jpcc 6,
%idefine jpa jpcc 7,
%idefine jps jpcc 8,
%idefine jpns jpcc 9,
%idefine jpp jpcc 10,
%idefine jpnp jpcc 11,
%idefine jpl jpcc 12,
%idefine jpge jpcc 13,
%idefine jple jpcc 14,
%idefine jpg jpcc 15,

%macro adca 1
  dw 0B000h+(%1)
%endm

%macro sbba 1
  dw 0C000h+(%1)
%endm

%macro ora 1
  dw 0D000h+(%1)
%endm

%macro anda 1
  dw 0E000h+(%1)
%endm

%macro xora 1
  dw 0F000h+(%1)
%endm

%macro epilogue 0
  fillto 0F00h
  a:      db 0
  status: db 0
  stk:    dw 1000h
  pc:     dw 0100h
  fillto 1000h
%endm

%macro epilogue 1
  fillto 0F00h
  a:      db 0
  status: db 0
  stk:    dw 1000h
  pc:     dw %1
  fillto 1000h
%endm
