comment <--------------------------------------------------------

  ENTRY.COM     by Ben Lunt
  05 Sept 1999  Last date modified
  261           size in bytes

  I use MASM 5.1x to assemble this source code.

  comments:
    See BONUS.ZIP for a small assembler to assemble .SPU
    files.

<----------------------------------------------------------------

CodeSeg    segment
           assume cs:CodeSeg, ds:CodeSeg, es:CodeSeg
.186
           org 100h

start:     mov  es,ax                   ; es points to 0000:xxxxh

           mov  ax,1A5Ch                ; set dta and 5Ch for below
           int  21h                     ; DTA at dx
           cbw                          ; 5Ch from al above
           xchg dx,ax                   ; dx at FCB
           xchg di,ax                   ; di = Code buffer
           mov  ah,0Fh                  ;  (thanks Ruud)
           int  21h                     ; Open the file

           mov  ah,21h                  ; read in 21??h bytes
           mov  ds:[006Bh],ah           ;  (27h sets cx to 1, 21h doesn't)
           int  21h                     ; Read file and zero buffer
                                        ;  (ensures the top of stk = 00h)
           inc  cx                      ; set 00h..FFh to 00..255
Inc1:      mov  [bx+di],bl              ; di = buffer set above
           inc  bx                      ; bx = 0 on startup
           loop Inc1                    ;

Main:      mov  si,di                   ;
           add  si,0F00h                ; si points to A

           mov  bx,[si+4]
           and  bh,0Fh
           mov  ax,[bx+di]
           mov  dx,ax
           add  word ptr [si+4],02      ; PC += 2
           shr  ax,12

           mov  bx,offset table
           xlat
           add  ax,bx
           xchg dx,ax

           pushf                        ; status --> flag
           pop  bp                      ;
           mov  bl,[si+1]               ;
           mov  bh,bl                   ;
           and  bx,0000100011010101b    ;
           and  bp,1111011100101010b    ;
           or   bp,bx                   ; bp now = flags

           and  ah,0Fh                  ; clear Hi Nibble of instruction
           mov  bx,ax                   ; we need bx to = 0xxx too.

           push bp                      ; s2flag
           popf
           mov  cl,[bx+di]              ; for B thorough F

           call dx
           jmp  short Main

table      db   low (offset OSCallJP - offset table) ; 0xxx
           db   low (offset RetGo - offset table)    ; 1000/1xxx
           db   low (offset PushB - offset table)    ; 2xxx
           db   low (offset PopB - offset table)     ; 3xxx
           db   low (offset LDA - offset table)      ; 4xxx
           db   low (offset STA - offset table)      ; 5xxx
           db   low (offset RDI - offset table)      ; 6xxx
           db   low (offset WRI - offset table)      ; 7xxx
           db   low (offset RDSYS - offset table)    ; 8xxx
           db   low (offset ADDW - offset table)     ; 9xxx
           db   low (offset JPcc - offset table)     ; Acxx
           db   low (offset ADCA - offset table)     ; Bxxx
           db   low (offset SBBA - offset table)     ; Cxxx
           db   low (offset ORA - offset table)      ; Dxxx
           db   low (offset ANDA - offset table)     ; Exxx
           db   low (offset XORA - offset table)     ; Fxxx

RetGo      proc near
           or   ax,ax
           jnz  short DoGo              ; test for Ret or Call
           sub  word ptr [si+4],02      ; PC -= 2 (for testv2.zip)
           mov  bx,[si+2]
           and  bh,0Fh
           mov  ax,[bx+di]
           add  word ptr [si+2],02      ; STK
           jmp  short DoJp
DoGo:      sub  word ptr [si+2],02      ; STK
           mov  dx,[si+4]               ; PC
           mov  bx,[si+2]               ; STK
           and  bh,0Fh                  ;
           mov  [bx+di],dx              ;
DoJp:      mov  [si+4],ax               ; PC
           ret
RetGo      endp

OSCallJP   proc near
           or   ah,ah
           jnz  short DoJp              ; test for OSCALL or JP
           mov  ah,al
           mov  al,[si]                 ; A
           mov  dl,al
           push bp                      ; s2flag
           popf                         ;
           int  21h
           mov  [si],al
           jmp  short f2stat
OSCallJP   endp

PushB      proc near
           dec  word ptr [si+2]
           mov  al,[bx+di]
           mov  bx,[si+2]
           and  bh,0Fh
           jmp  short PPD
PushB      endp

PopB       proc near
           mov  bp,[si+2]            ; STK
           and  bp,0FFFh
           mov  al,[bp+di]
           mov  [bx+di],al
           inc  word ptr [si+2]      ; STK
           ret
PopB       endp

RDSYS:     mov  cl,es:[bx]
           jmp  short LDA

RDI:       mov  bx,[bx+di]
           and  bh,0Fh
           mov  cl,[bx+di]
LDA:       mov  [si],cl
           ret

WRI:       mov  bx,[bx+di]
           and  bh,0Fh
STA:       lodsb
PPD:       mov  [bx+di],al
           ret

ADDW:      lodsb
           cbw
           add  [bx+di],ax
           ret

JPcc       proc near
           xor  bh,71h      ; 70h for opcode, 01h for jNcc
           mov  byte ptr [Here],bh
           push bp                      ; s2flag
           popf                         ;
Here:      db   70h,04h    ; jNcc  to 'ret' below
           cbw
           add  [si+4],ax
           ret
JPcc       endp

ADCA:      adc  [si],cl
           db   0B8h             ; mov ax,????
SBBA:      sbb  [si],cl
           db   0B8h             ; mov ax,????
ORA:       or   [si],cl
           db   0B8h             ; mov ax,????
ANDA:      and  [si],cl
           db   0B8h             ; mov ax,????
XORA:      xor  [si],cl

f2stat:    pushf
           pop  ax
           and  ax,0000100011010101b
           or   al,ah
           mov  [si+1],al
           ret

CodeSeg    ends
           end  start
