;*** Entry for Hugi compo #9 by Ruud
;
;    Thanks TAD for the countles usefull tips and suggestions...
;


by  EQU <BYTE PTR>
wo  EQU <WORD PTR>
dwo EQU <DWORD PTR>
off EQU <OFFSET DS:>

                    .MODEL    TINY
                    .386

                    .CODE
                    ORG       100h

                    ;*** Load the spu image via FCB

Start:              pop       es                  ;es=0, sp=0
                    mov       dx,0fffh            ;Nice point for SPU memory
                    mov       di,dx               ;Need base in di
                    mov       ax,1a5ch            ;FCB at 5ch
                    int       21h                 ;DTA at ds:dx
                    cbw                           ;Need 005ch for FCB
                    xchg      ax,dx               ;Dx at FCB, ah=0fh
                    int       21h                 ;Open file via FCB
                    mov       ah,27h              ;Ax=2700h
                    int       21h                 ;Read file to DTA

                    ;*** Initialize mem 0-0ffh

@@St0:              mov       [di+bx],bl
                    inc       bl
                    jne       @@St0               ;Init 00-ff

                    ;*** Emulator main loop

GoStep:             mov       si,0fffh+0f04h      ;Directly points to PC
                    mov       bp,di               ;Copy for mask
                    push      off GoStep          ;Next ret becomes loop
                    push      off AfterFetch      ;Return here after fetch !!!
                    mov       bx,sp               ;Bx=-4, save area
                    mov       dx,[si+bx]          ;Accu and status to dx

                    ;*** Return used as fetch, si points to PC
                    ;    DI+BX at save area... BASE-4

spu_Return:         add       [di+bx],sp          ;Undo 'add PC,2' for return
                    call      spu_POPB            ;Pop 1th bytes
                    xchg      ax,cx               ;FetchInstr,(cx=mem[PC])
                    inc       bx                  ;At next byte
spu_POPB:           and       bp,[si]             ;Get SP (PC for Fetch)
                    mov       ax,[bp+di]          ;Get mem[SP] (mem[PC])
                    mov       [bx+di],al          ;Stuff byte here
                    inc       wo [si]             ;inc SP (PC for Fetch)
                    mov       bp,di               ;Restore mask (0fff)
                    
                    ;*** Use a debugger to check out the code below, it
                    ;    saved me one byte bringing me down to 179 after
                    ;    fetch it gives bx=bTable effectively using 2 bytes !

                    db        23h    ;AND AX,DI         (uses next byte)
AfterFetch:         db        0c7h   ;MOV BX,OFF bTable (uses next byte)
                    db        0c3h   ;RET
                    dw        bTable              ;Value for bx after fetch

                    ;At this point : bx=Table pointer
                    ;                si=Direct pointer to PC
                    ;                di=bp=0fffh=BASE
                    ;                al=mem[PC+1]
                    ;                dl=A, dh=status
                    ;                cx=mem[PC] mod 1000h
                    ;                PC at next instruction

                    mov       ah,10h              ;Need AH=1 after shift
                    shr       ax,4                ;ax->010x, x is opcode
                    add       si,sp               ;Directly points to SP
                    cmp       al,0ah              ;Set flags for all routines
                    xlatb                         ;Get descriptor from table
                    mov       bx,cx               ;Need a copy of operand
                    jnz       NoJpcc              ;>> AX!=0170 no JPCC

;*** Instructions needing and updating the status register
;    ADCA, SBBA, ORA, ANDA, XORA, JPcc, OSCALL

spu_Jpcc:           xor       al,ch               ;Create Jcc opcode
spu_OSCALL:         mov       ah,off JccOff2-JccOff1 ;Displacement = 21h !!!
spu_Arith:          mov       wInstr,ax           ;Instruction for 80x86
                    mov       ax,dx               ;Accu and status
                    and       dx,bp               ;Bit dh.3 highest bit
                    add       dh,78h              ;Take care of OV (bit dh.3)
                    sahf                          ;Rest of flags
                    mov       ah,cl               ;Just in case of OSCALL

                    ;Instruction below is modified by program
                    ;
                    ; Either 01??  "??  al,[bx+si]" : ?=ADC,SBB,....
                    ;        217?  "J?  JccOff2"    : ?=Condition
                    ;        21cd  "INT 21h" 
                    ;
                    ; Pentium takes care of prefetch que ! no JMP $+2 needed

wInstr              dw        ?                   ;Some instruction

JccOff1:            lahf                          ;Stuff low flags
                    pushf                         ;
                    pop       dx                  ;High flags in dh
                    and       dx,bp               ;Keep useful bits, thanx TAD
spu_RDSYS:          xor       ah,dh               ;Finish status
                    mov       [si-2],ax           ;New status and A
                    ret

                    ;*** Placed here because I need JccOff2-JccOff1=21h !!

NoJpcc:             jnc       spu_Arith           ;>> AX=01?? adc, ora, anda...
                    push      ax                  ;AX=01xx = routine address
                    movzx     ax,by es:[bx]       ;Al for RDSYS, ah=0
                    ret                           ;Jump to routine

                    ;*** Table with instruction descriptors

bTable              db        OSCall_Jp-Start     ;00h JP/OSCALL
                    db        Gosub_Ret-Start     ;01h GOSUB/RETURN
                    db        spu_PUSHB-Start     ;02h PUSHB
                    db        spu_POPB -Start     ;03h POPB
                    db        spu_LDA  -Start     ;04h LDA
                    db        spu_STA  -Start     ;05h STA
                    db        spu_RDI  -Start     ;06h RDI
                    db        spu_WRI  -Start     ;07h WRI
                    db        spu_RDSYS-Start     ;08h RDSYS
                    db        spu_ADDW -Start     ;09h ADDW
                    db        70h                 ;0ah JPcc
                    db        12h                 ;0bh ADCA
                    db        1ah                 ;0ch SBBA
                    db        0ah                 ;0dh ORA

;*** Part of table for JccOff2 "AND DH,[BP+SI]" clears CY !!! saved a clc
;    which finaly got me down to 180 bytes...

JccOff2:            db        22h                 ;0eh ANDA
                    db        32h                 ;0fh XORA
                    xchg      ax,bx               ;Displacement in al

Gosub_Ret:          mov       bx,0f04h            ;Destination is pc
                    jnb       AddPc               ;>> Finish JPCC
                    jcxz      spu_Return          ;>> Is return instruction
spu_GOSUB:          or        ah,bh               ;Bit AH.0=1, CY cleared
spu_PUSHB:          adc       [si],sp             ;Sp-1,PUSHB, Sp-2 GOSUB
                    and       bp,[si]             ;Filtered SP.
                    sahf                          ;NC (NP) if PUSHB
                    mov       dx,[di+bx]          ;Get mem[xxx] or PC
                    jnc       StuffDl             ;>> PUSHB, DL only
                    mov       [bp+di],dx          ;Old PC on stack
OSCall_Jp:          mov       al,0cdh             ;Int 21h (21h at spu_Jpcc)
                    or        bh,bh               ;JP xxx if bh!=0
                    jz        spu_OSCALL          ;>> is OSCALL
spu_JP:             mov       [si+2],cx           ;New PC value.
                    ret

spu_WRI:            ;Different PF than spu_RDI, same entry point
spu_RDI:            pushf                         ;Keep PF
                    and       bp,[bx+di]          ;Filtered indirect address
                    popf                          ;Restore PF
StuffDl:            mov       bx,bp               ;Need address in bx
spu_LDA:            mov       al,[bx+di]          ;Indirect or direct byte
                    jpe       spu_RDSYS           ;>> RDI or LDA
spu_STA:            mov       [bx+di],dl          ;WRI, STA or SuffDl
                    ret

spu_ADDW:           xchg      ax,dx               ;Get adder in al
AddPc:              cbw                           ;make it a word
                    add       [bx+di],ax          ;add to destination
                    ret

                    END       Start
