;
;nasm -f bin -o entry.com entry.asm
;

;	  BITS 16
	  ORG 0x100
start:
	;; scan filename from command-line ;;
	;; assume bx = 0000 ,di = fffe = -2 ,ax = 0000
	mov	bl,82h
	mov	dx,bx
        add     bl,[bx+di]		; bx = end of command line
        mov     [bx+di+1],bh
	mov	ah,3dh 
        int     21h
;	mov	bh,4ch			; #
        xchg    ax,bx			; bx = File Handle
	jnc	no_quit			; CY = 1 ,file not found
;	int	21h			; #quit 
	int	20h			; if I use this, can save 2bytes
					; and comment out #marked line
no_quit:

	mov	cx,4096			; size = 4096
	mov	dx,cx			; dx = offset 1000h
	mov	ah,3Fh
	int	21h			; read file
	;; fill mem[000]..mem[0FF] hex with 00..FF hex ;;
	;; al = 00h , dx = offset mem
	mov	di,dx			; di = mem[0]
fillmem:
	stosb
	inc	al
	jnz	fillmem
emulate:
	db	0x68			; push offset emulate
	dw	$emulate
execute1:
	mov	di,mem
	mov	bx,0FFFh
	mov	cx,bx
	mov	si,A
	and	bx,[si+4]		; bx = 0fff & [PC]
	mov	dx,[bx+di]		; dx = mem[bx]

	mov	al,dh
	xor	al,0d1h
        mov     BYTE  [x_JPmain],al
        xor     al,0d1h
	jz	DHne0
	shr	al,4
	mov	bx,x_decodetable
	cmp	al,0bh
	xlatb
	mov     BYTE [x_XORA2],al
	jc	under0BH
	mov	al,x_XORA-exec_sub3+50h		; Bxxx
under0BH:
DHne0:
	mov	bx,cx			; bx = cx (0fffh)
	and	bx,dx
	and	cx,[si+2]		; cx = 0fff & [STK]
	cmp	dx,di			; cmp dx,1000h
	jnz	no_RET
x_RETURN:
	mov	bx,cx			; bx = STK & 0fffh 
	mov	al,x_JP- exec_sub3+50h
	dec	si
	dec	si
no_RET:
	add	word [byte si+4], byte 2
	cmp	al,50h
	jc	no_xxI
	mov	bx,[bx+di]
	sub	al,50h
no_xxI:
	mov     BYTE [exec_sub2+1],al
extractflags:
	mov	ax,[si]
	push	ax
	shr	ah,3
	;;	DO NOT modify FLAGS !!
	ror	ah,1			;set overflow flag
	pop	ax
	sahf
	mov	ah,0fh
exec_sub2:
	jmp	short x_XORA
exec_sub3:
x_OSCALL:
	mov	ah,bl			; ah = xx
        mov     dl,al			; dl = A (al)
	int	21h	     		; int 21h  
	mov	[si],al
	jmp	short packstatus
;
; 00xx    OSCALL xx               Operating System CALL
; 0xxx    JP xxx                  Jump to new PC address (ie. JMP)
; 1000    RETURN                  Return from sub-routine (ie. RET)
; 1xxx    GOSUB xxx               Goto sub-routine (ie. a CALL)
;
x_GOSUB:
	lodsw				; si = si +2 ( STK = A +2 )
	sub	WORD [si],byte 2
	lodsw				; si = si +2 ( PC = STK + 2 )
	and	ah,0fh
	add	di,ax
	movsw				; STK = [PC]
x_JP:
	mov	[PC],bx			; PC = xxx
	ret
;
; 2xxx    PUSHB xxx               Push memory byte onto the stack
;
x_PUSHB:
	dec	cx
	xchg	cx,bx
	dec	WORD  [si+2]
x_PUSHB2:
	mov	si,cx			; si = STK & 0fffh
	add	si,di			; si = mem[STK]
x_PUSHB3:
x_WRI:
	and	bh,ah
x_STA:
	add	di,bx			; di = mem[xxx]
	movsb
	ret
;
; 3xxx    POPB xxx                Pop memory byte from the stack
;
x_POPB:
	call	x_PUSHB2
	inc	Word [STK]			; STK + 1
	ret
;
; 4xxx    LDA [xxx]               Load A (accumulator) from memory
; 5xxx    STA [xxx]               Store A (accumulator) in memory
; 6xxx    RDI [(xxx)]             Read indirect byte from memory pointer
; 7xxx    WRI [(xxx)]             Write indirect byte from memory-pointer
; 8xxx    RDSYS [0000:0xxx]       Read a system byte from segment zero.
;
x_RDSYS:
	sub	di,di
	mov	ES,di
x_RDSYS3:
x_RDI:
x_LDA:
	and	bh,ah
	mov	al,[ES:bx+di]
	push	DS
	pop	ES
x_RDSYS2:
	jmp	short pack2
;	mov	[si],al
;	ret
;
; 9xxx    ADDW [xxx],A            Add sign-extended A register to word location
; Acpp    JPcc    +pp             Conditional jump instruction (ie. Jcc)
;
x_JPcc:
x_JPmain:
        db      70h,06h         ;jc      short x_goJP
	mov	al,04h			; ah = 0fh ,al =04h  PC = [f04]
	xchg	ax,bx			; bl = xx
x_ADDW:
	cbw
	add	[bx+di],ax		; WORD mem[xxx] + A
x_goJP:
	ret
;
; Bxxx    ADCA [xxx]              Add byte to the accumulator with Carry
; Cxxx    SBBA [xxx]              Subtract byte to the accumulator with Borrow
; Dxxx    ORA [xxx]               Logical OR byte to the accumulator
; Exxx    ANDA [xxx]              Logical AND byte to the accumulator
; Fxxx    XORA [xxx]              Logical XOR byte to the accumulator
;
x_XORA:
x_XORA2:
	xor	[si],bl			; this line is 2 byte.
					; and modify first byte every time 
;
; pack SPEW "STATUS <--<-- flags"
;
packstatus:
	pushf
	pop	ax
	and	ax,0000100011010101b
	or	al,ah
;	mov	STATUS,al
	inc	si
pack2:
	mov	[si],al
	ret
;
; extract 80x86 "flags <--<-- STATUS"
;

x_decodetable	db	 x_JP- exec_sub3		; 0xxx
		db	 x_GOSUB- exec_sub3		; 1xxx
		db	 x_PUSHB- exec_sub3		; 2xxx
		db	 x_POPB- exec_sub3		; 3xxx
		db	 x_LDA- exec_sub3		; 4xxx
		db	 x_STA- exec_sub3		; 5xxx
		db	 x_RDI- exec_sub3+50h		; 6xxx
		db	 x_WRI- exec_sub3+50h		; 7xxx
		db	 x_RDSYS- exec_sub3		; 8xxx
		db	 x_ADDW- exec_sub3		; 9xxx
		db	 x_JPcc- exec_sub3		; Axxx
;		db	 x_XORA- exec_sub3		; Bxxx
;		db	 x_XORA- exec_sub3		; Cxxx
;		db	 x_XORA- exec_sub3		; Dxxx
;		db	 x_XORA- exec_sub3		; Exxx
;		db	 x_XORA- exec_sub3		; Fxxx
	
x_DB:
        db      10h,18h,08h,20h,30h

endcode:

	SECTION .bss
	absolute	0x1000
mem	resb	256 
	resb	(0F00h-256)
A	resb	1	      		; mem[F00]
STATUS	resb	1			; mem[F01]
STK	resw	1			; mem[F02]..mem[F03]
PC	resw	1			; mem[F04]..mem[F05]
	resb	(1000h-0F06h)


