;SPEW emulator for Hugi Size Compo #9
; Coded by Metalbrain (metalb@bart.us.es) from Spain

                org     256
                mov     dx,130          ;PSP first argument uses to be here
tryopen         mov     [si],bl         ;Try to make file name asciiZ
                mov     ah,3dh
                dec     si
                int     33              ;Open?
                jc      tryopen         ;If not: try again
                xchg    ax,bx           ;BX=handle, AX=0
                mov     ch,0fh          ;CX=0fffh = mem
                xchg    di,cx           ;CX= -2 (useful) = 65534, long enough
                mov     dx,di
                mov     ah,3fh
                int     33              ;Read to mem, AX=1000h
setfirst        stosb
                inc     al
                jnz     setfirst
                mov     bp,dx           ;BP=mem
                pop     es              ;ES = page 0 segment
mainloop        push    word mainloop
                mov     bx,mem+0f02h
                mov     dx,[bx-2]       ;DL > A, DH > STATUS
                mov     di,[bx+2]       ;DI > PC
                and     di,bp           ;Use only 12 bits
                mov     al,dh           ;Flags <- STATUS
                and     al,8
                add     al,120          ;Excite V flag
                mov     ah,dh
                sahf                    ;Set rest of flags
                pushf
                mov     ax,[bp+di]      ;AX=opcode: AH=code*16+high address
                                        ; AL=low address
                mov     si,[bx]         ;SI > STACK
                and     si,bp
                add     si,bp           ;Now SI points to STACK in memory, and
                                        ; (SI and BP) = STACK-1

                mov     di,ax
                and     di,bp           ;DI=0xxx
                cmp     ax,1000h
                jz      return
                sub     [bx+2],cx       ;PC=PC+2
                and     ah,ah
                jz      code00
nocode00        shr     ax,12
                push    bx
                mov     bx,insttable
                xlatb
                add     ax,bx
                pop     bx
                popf                    ;Set flags
                xchg    ax,dx           ;AH= STATUS, AL = A
                jmp     dx

insttable       db      (code0 - insttable)
                db      (code1 - insttable)
                db      (code2 - insttable)
                db      (code3 - insttable)
                db      (code4 - insttable)
                db      (code5 - insttable)
                db      (code6 - insttable)
                db      (code7 - insttable)
                db      (code8 - insttable)
                db      (code9 - insttable)
                db      (codeA - insttable)
                db      (codeB - insttable)
                db      (codeC - insttable)
                db      (codeD - insttable)
                db      (codeE - insttable)
                db      (codeF - insttable)

code00          xchg    ah,al           ;OSCALL xx
                mov     al,dl
                popf                    ;Set flags
                int     33
                db      0BAh            ;-mov dx,xxxx (harmless)
codeB           adc     al,[bp+di]      ;/  ADCA
                db      0BAh            ;-mov dx,xxxx (harmless)
codeC           sbb     al,[bp+di]      ;/  SBBA
                db      0BAh            ;-mov dx,xxxx (harmless)
codeD           or      al,[bp+di]      ;/  ORA
                db      0BAh            ;-mov dx,xxxx (harmless)
codeE           and     al,[bp+di]      ;/  ANDA
                db      0BAh            ;-mov dx,xxxx (harmless)
codeF           xor     al,[bp+di]      ;/  XORA
                mov     [bx-2],al
                pushf                   ;Flags -> STATUS
                pop     ax
                and     ax,0000100011010101b
                or      al,ah
                mov     [bx-1],al
                ret

return          popf                    ;RETURN
                lodsw
                xchg    ax,di
                sub     [bx],cx
                jmp     short code0

code1           add     [bx],cx         ;GOSUB
                dec     si
                and     si,bp           ;SI = STACK-2
                mov     ax,[bx+2]
                mov     [bp+si],ax

code0           mov     [bx+2],di       ;JP xxx
                ret

code2           dec     word [bx]       ;PUSHB xxx
                mov     al,[bp+di]
                and     si,bp           ;SI = STACK-1
                mov     [bp+si],al
                ret

code3           lodsb                   ;POPB xxx
                mov     [bp+di],al
                inc     word [bx]
exithere        ret                     ;Exit from JPcc not taken

codeA           pushf                   ;JPcc xx
                xchg    ax,di           ;AH=condition code
                xor     ah,71h
                mov     [puthere],ah
                mov     di,0f04h        ;Jump taken must modify PC
                popf                    ;Set flags
puthere         jo      exithere

code9           cbw                     ;ADDW and JPcc taken
                add     [bp+di],ax
                ret

code6           mov     di,[bp+di]      ;RDI
                and     di,bp
code4           mov     al,[bp+di]      ;LDA
                db      0               ;-add [058ah],ah (harmless)
code8           mov     al,[es:di]      ;/ RDSYS
                mov     [bx-2],al
                ret

code7           mov     di,[bp+di]      ;WRI
                and     di,bp
code5           mov     [bp+di],al      ;STA
                ret

mem             EQU     0fffh           ;BP is both base for mem and bit mask
