;
; Hugi Size Optimization Competition #9 - SPEW Emulator
;
; Written by Timo Ters    (Fabled / LtE), Finland
;        and Kari Salminen (Buddha / LtE), Finland
;


        Ideal
        Model Tiny
        P586




o               equ <offset>
s               equ <short>
b               equ <byte ptr>
w               equ <word ptr>
l               equ <low offset>

IDI             = 0f04h
IBP             = 0f02h + 01000h - IDI
A               = [b di-4]
STATUS          = [b di-3]
STK             = [w bp+di]    ;di-2
PC              = [w di]



macro   salc            ; Set AL on Carry
        db 0d6h         ; Undocumented opcode (8086+)
        endm

ID = 0

        ; Some helper macros
macro   relo yy
        db o yy - ID - 100h
        ID = ID + 1
        endm

macro   cmdo yy
        db yy - ID
        ID = ID + 1
        endm


        CodeSeg

        Org 100h

start:
        ; AX = 0000h
        ; BX = 0000h
        ; CX = 00FFh
        ; DX = CS = DS = ES = SS
        ; SI = 0100h
        ; DI = FFFEh
        ; BP = 09??h
        ; SP = FFFEh
        ; IP = 0100h

        mov     fs, bx                  ; FS = 0, for RDSYS

        add     dx, si                  ; cs+0100=>ds (segment for SPEW image)
        push    dx                      ; push ds

        cwd                             ; mov dx, 82h (ptr to beginning of
        mov     dl, 082h                ; the filename).
reopen: dec     si              
        mov     [si], bl                ; try to null terminate filename
        mov     ah, 03dh
        int     21h                     ; OPEN, DS:DX = name
        jc      s reopen                ; keep opening file until file opened
        xchg    bx, ax                  ; now bx is the file handle

        pop     ds                      ; ds = SPEW segment
        push    ds
        pop     es                      ; es = SPEW segment

        mov     ch, 010h                ; cx = 10ffh > 1000h
        mov     ah, 03Fh
        cwd                             ; clear dx
        int     21h                     ; READ BX = handle, CX bytes -> DS:DX

        ; AX = 1000h
        ; CX = 10FFh
        ; DX = 0000h
        ; DI = FFFEh

        ; fill mem[000]..mem[0FF] hex with 00..FF hex

        pop     di                      ; di = 0 and sp = 0
fill:   stosb                           ; write byte to spew memory
        inc     al                      ; update byte to write
        loopnz  s fill                  ; loop 100h times and decrement cx


        ; AX = 01000h
        ; CX = 00FFFh = 4kb mask
        ; DI = 00100h

emulate:
        mov     bx, o emulate           ; bh is needed later (bh=1)
        push    bx                      ; push o emulate, for retns

        mov     di, IDI                 ; =0F04h (used to point PC)
        mov     bp, IBP                 ; =0FFEh (used to point STK)

        mov     si, PC                  ; point ds:si to the spew memory
        and     si, cx                  ; using value in PC.
        lodsw                           ; get current opcode to ax.
        mov     si, cx                  ; si = 0fff
        inc     cx                      ; cx = 1000
        cmp     ax, cx                  ; is opcode RETURN?
        loope   s RETURN                ; decrement cx to 0fffh and
                                        ; jump if ax == 1000h

        sub     PC, sp                  ; PC + 2 (sp = -2), advance one opcode
        and     si, ax                  ; point si to address given in opcode

        mov     bl, l OSCALL            ; bx = o OSCALL

        xchg    al, ah                  ; ah = XX
        or      al, al                  ; 00xx? 
        jz      s BLok                  ; if yes, do OSCALL

        mov     bl, al                  ; bh = 1
        shr     bl, 4                   ; bl = uppermost nybble of opcode

;
;       Stupid tasm wont put 8-bit offset....
;       add     bl, [b cs:bx+l decodetable]
;                                        
        db 02eh,002h,05fh,l decodetable ; get jump address/intel opcode
        js      s BLok                  ; if sf=1 then it is a jump address

        mov     [b BCDEF+bp-IBP], bl    ; otherwise update opcode and jump
        mov     bl, l BCDEF             ; there
                                        

BLok:   push    bx                      ; push jump offset

        mov     bx, cx                  ; bx = mem[xxx] for RDI, WRI
        jp      s nBX                   ; and for GOSUB, PUSHB and POPB
        and     bx, [si]                ; bx is set to 0fffh
                                        ; the parity is hacked by ordering
                                        ; the branches correctly

nBX:    xor     al, 11010001b           ; complemented intel jump command
        mov     [b JPcc+bp-IBP], al     ; update it

        xchg    ax, dx                  ; dh=XX (store temporarily)
        mov     ax, [di-4]              ; ah=flags,al=A
        mov     dl, 00001000b           ; overflow flag mask
        and     dl, ah                  ; isolate overflow flag to dl
        add     dl, 7fh                 ; set overflow flag if bit #3 is set
        sahf                            ; set all other flags
        xchg    ax, dx                  ; ah=XX,dl=A

        mov     al, dl                  ; al=A
        retn


RETURN: and     si, STK                 ; si = STK
        sub     STK, sp                 ; STK + 2 (sp = -2)
        movsw                           ; mem[STK] -> PC
        retn                            ; loop back to emulate

        ; jump/opcode table

label decodetable byte
        relo JUMP          ; 0x  0000xxxx
        relo GOSUB         ; 1x  0001xxxx (parity=0)
        relo PUSHB         ; 2x  0010xxxx (parity=0)
        relo POPB          ; 3x  0011xxxx (parity=0)
        relo LDA           ; 4x  0100xxxx
        relo STA           ; 5x  0101xxxx
        relo RDI           ; 6x  0110xxxx (parity=1)
        relo WRI           ; 7x  0111xxxx (parity=1)
        relo RDSYS         ; 8x  1000xxxx
        relo ADDW          ; 9x  1001xxxx
        relo JPcc          ; Ax  1010xxxx
        cmdo 012h          ; Bx  1011xxxx
        cmdo 01Ah          ; Cx  1100xxxx
        cmdo 00Ah          ; Dx  1101xxxx
        cmdo 022h          ; Ex  1110xxxx
        cmdo 032h          ; Fx  1111xxxx


        Org $-1                         ; previous byte is 23h already

POPB:   and     bx, STK                 ; get STK pointer to bx (clear cf)
        salc                            ; clear al
        xlat                            ; al = [bx]
        mov     [si], al                ; mem[xxx] = mem[STK]
        inc     STK                     ; STK + 1
        retn

GOSUB:  add     STK, sp                 ; STK - 2
        and     bx, STK                 ; get STK pointer to bx
        mov     ax, PC                  ; load PC to ax
        mov     [bx], ax                ; mem[STK] = PC        
JUMP:   xchg    ax, si                  ;
        stosw                           ; PC = si
        retn

OSCALL: int     21h                     ; do the OSCALL
        db      0BAh                    ; BA ?? ?? = mov dx, ????
                                        ; (used to skip next instruction)
RDSYS:  db      064h                    ; FS: -prefix
LDA:    lodsb                           ; read direct byte from SPEW
        db      0BAh                    ; BA ?? ??
BCDEF:  and     ax, [si]                ; self modified emulation opcode
        db      0BAh                    ; BA ?? ??
RDI:    mov     al, [bx]                ; read indirect byte from SPEW
        lahf                            ; ah = low i86flags
        pushf   
        pop     dx                      ; dx = i86 flags
        and     dh, ch                  ; dh = 0 0 0 0 OF DF IF TF
                                        ; TF=Trap Flag          (should be 0)
                                        ; IF=Interrupt Flag     (should be 1)
                                        ; DF=Direction Flag     (should be 0)
                                        ; OF=Overflow Flag      (varies)
                                        ; Flag are the way they are described
                                        ; if OS or interrupt hasn't changed
                                        ; them. Normally this doesn't happen.
                                        ; (Maybe under debugger.)
        xor     ah, dh                  ; Turn bit #2 off in STATUS
                                        ; and set overflow flag if needed.

        mov     [di-4], ax              ; Store A and STATUS.
        retn

PUSHB:  dec     STK                     ; STK - 1
        and     bx, STK                 ; get STK pointer to bx
        lodsb                           ; temp = mem[xxx]
WRI:    mov     si, bx
STA:    mov     [si], al                ; mem[xxx] = A or temp
        retn

JPcc:   jmp     s JPskip                ; selfmodified jump command
        xchg    ax, di                  ; ax = o PC
        xchg    ax, si                  ; si = o PC, ax = opcode
ADDW:   cbw                             ;   PC + pp
        add     [si], ax                ;or WORD mem[xxx] + A
JPskip: retn



	end	start
