.486
.model tiny


CODE SEGMENT 'CODE' USE16
	ASSUME CS:CODE,DS:CODE,ES:CODE,SS:CODE

	org 100h

start:
;*********************
;* Read file
;*********************
	mov fs,bx	; BX assumed to be 0
	mov ah,1ah	; Set file DTA
	mov dx,1000h
	sub sp,dx
	int 21h
	mov ah,0fh	; Open file
	mov dx,005ch
	int 21h
	mov ah,27h	; Read file
	mov cl,20h	; Assuming CX=00ffh NOT...
	int 21h
; 22
;*********************
;* Init segment registers
;*********************
	mov bx,ds	; get current DS in AH
	xadd si,bx	; add current DS to SI and move current SI(before add) to BX
	mov ds,si
	mov ss,si
; 12
;*********************
;* Init low memory (000h-fffh)
;*********************
FillMem:
	dec bx
	mov [bx],bl
	jg FillMem
; 7
;-- 35 --
DoInstruction:
	push offset DoInstruction	
	mov di,offset STK
	mov bp,2
	mov si,0fffh
	push si
	and si,[bp+di]
	lodsw
	pop si
	cmp ax,1000h
;	je IRETURN					; TASM inserts NOPs after some jumps. I don't.
	db 74h
	db (offset IRETURN-($+1))
	add [bp+di],bp
	push ax
	shr ax,12
	mov bx,offset ITab
	xlat cs:bx
	mov ah,1
	xchg ax,dx
	pop bx
	or bh,bh
;	jnz NotOSCALL
	db 075h
	db (offset NotOSCALL-($+1))
	mov dl,low (offset IOSCALL)
NotOSCALL:
	and bx,si
	mov ax,[di-2]
	push ax				; save status on stack
	and ah,00001000b	; mask out bit 3
	add ah,78h			; if bit 3 of status is set, then this creates an overflow (O-bit is set:)
	pop ax				; get status from stack
	sahf				; move ah to flags
	jmp dx


	
IPUSHB:
	dec word ptr [di]
	and si,[di]
	mov al,[bx]
	mov [si],al
	ret
IPOPB:
	and si,[di]
	lodsb
	mov [bx],al
	inc word ptr [di]
	ret
	
IRETURN:
	and si,[di]
	lodsw
	mov [di+bp],ax
	add [di],bp
	ret

IRDI:
	mov bx,[bx]
	and bx,si
	db 0b2h
IRDSYS:
	db 064h
ILDA:
	mov al,[bx]
;	jmp SetAReg
	db 0ebh
	db (offset SetAReg-($+1))
IWRI:
	mov bx,[bx]
	and bx,si
ISTA:
	mov [bx],al
	ret

IJPCC:
	pushf
	xchg ax,bx
	or ah,70h
	mov byte ptr cs:[IJPCCIns],ah
;	jmp IJPCCNext
	db 0ebh
	db (offset IJPCCNext-($+1))
IJPCCNext:
	popf
IJPCCIns:
;	jne IJPCCJump
	db 075h
	db (offset IJPCCJump-($+1))
	ret
IJPCCJump:
	lea bx,[di+bp]
IADDW:
	cbw
	add [bx],ax
	ret


IGOSUB:
	sub [di],bp
	and si,[di]
	mov ax,[di+bp]
	mov [si],ax
IJP:
	mov [di+bp],bx
	ret
IOSCALL:
	mov dl,al
	mov ah,bl
	int 21h
	db 0b9h
IADCA:
	adc al,[bx]
	db 0b9h
ISBBA:
	sbb al,[bx]
	db 0b9h
IORA:
	or al,[bx]
    db 0b9h
IANDA:      
	and al,[bx]
	db 0b9h
IXORA:
	xor al,[bx]

	pushf
	pop dx
	and dx,0000100011010101b
	or dl,dh
	mov ah,dl
SetAReg:
	mov [di-2],ax
	ret

	
ITab:
	db           low (offset IJP)
	db           low (offset IGOSUB)
	db           low (offset IPUSHB)
	db           low (offset IPOPB)
	db           low (offset ILDA)
	db           low (offset ISTA)
	db           low (offset IRDI)
	db           low (offset IWRI)
	db           low (offset IRDSYS)
	db           low (offset IADDW)
	db           low (offset IJPCC)
	db           low (offset IADCA)
	db           low (offset ISBBA)
	db           low (offset IORA)
	db           low (offset IANDA)
	db           low (offset IXORA)

		org 0000h
EmulMem	db 0f00h dup (?)
A		db ?	      	
STATUS	db ?		
STK		dw ?			
PC		dw ?			
		db	(1000h-0F06h) dup (?)

code	ends
		end start
	
	

