 ;"""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""";
 ;  SPEW emulator for the 9th HUGI compo    --    by  Jibz^q!p '99  ;
 ;                                                                  ;
 ;   - Used the FCB functions, which seems to work                  ;
 ;   - A few ideas from Chut helped me kill some more bytes         ;
 ;..................................................................;

; A few notes:
;  - The self-modifying code in x_JPcc does not pose a problem on p5+
;    processors, as they handle it correctly (but give a speed penalty).
;    On 486 and below there would have had to be a jmp (or something else
;    that reloads the cache) between the modifier and the modified code.
;  - Since SI points to the beginning of the buffer during emulation, the
;    HIDE3, which (together with the next instruction) translates to
;    AND B,[SI-76],7 does not modify anything important (nice one Chut ;).
;  - We can assume that the SPU image is always 4096 bytes, so reading
;    a 4k block using the FCB function will result in a success, which
;    means AL = 0 for the fill-code.
;  - I assume DF = 0 when I use SCASW, but this should be ok.

.model tiny
.586
.code
org 100h

A     equ byte ptr [di]
STK   equ word ptr [di+2]
PC    equ word ptr [di+4]

HIDE2 equ db 0bah                       ; hides next 2 bytes
HIDE3 equ db 080h                       ; hides next 3 bytes

start:
; ===================================================================
;  Read SPU image
; ===================================================================
        mov     fs, bx                  ; FS = 0000h

        mov     dx, 1000h               ; DX -> buffer
        mov     si, dx                  ; SI -> buffer
        mov     ah, 1ah                 ; set DTA address to 1000h
        int     21h

        mov     dx, 5ch                 ; dx -> FCB of first argument
        mov     ah, 0fh                 ; open file using FCB
        int     21h

        mov     [di+2+005ch+0eh], si    ; set record size to 1000h
        mov     di, si                  ; DI -> buffer

        mov     ah, 14h                 ; read from file to DTA
        int     21h                     ; success => AL = 0

; ===================================================================
;  Fill mem[000]..mem[0ff] hex with 00..ff hex
; ===================================================================
fillmem:
        stosb
        inc     al
        jnz     fillmem

        mov     cl, 2                   ; CX = 2

; ===================================================================
;  The main emulator
; ===================================================================
emulate:
        push    offset emulate

        mov     di, offset A_

        mov     bx, 0fffh
        mov     bp, bx
        and     bx, PC
        mov     dx, word ptr [si+bx]

        cmp     dx, si
        jz      short x_RETURN          ; 1000 ?

        add     PC, cx                  ; PC += 2

        or      dh, dh
        jz      short x_OSCALL          ; 00xx ?

        mov     bx, offset x_decodetable
        mov     ax, dx
        shr     ax, 12
        xlatb                           ; get 8 bit offset in table
        add     ax, bx
        push    ax                      ; push address of function

        and     dx, bp                  ; BX = DX = 0xxx
        mov     bx, dx                  ;

        mov     ax, word ptr [si+bx]

        ; the ret at extractflags will return to the function
        ; which address was pushed above...

; -------------------------------------------------------------------
; extract 80x86 "flags <-- STATUS"
; -------------------------------------------------------------------
extractflags:
        pusha
        mov     al, STATUS
        mov     ah, 00001000b
        and     ah, al
        pushf
        pop     dx
        mov     dl, 0
        or      dx, ax
        push    dx
        popf
        popa
        ret

x_decodetable   db x_JP    - x_decodetable ; 0xxx
                db x_GOSUB - x_decodetable ; 1xxx
                db x_PUSHB - x_decodetable ; 2xxx
                db x_POPB  - x_decodetable ; 3xxx
                db x_LDA   - x_decodetable ; 4xxx
                db x_STA   - x_decodetable ; 5xxx
                db x_RDI   - x_decodetable ; 6xxx
                db x_WRI   - x_decodetable ; 7xxx
                db x_RDSYS - x_decodetable ; 8xxx
                db x_ADDW  - x_decodetable ; 9xxx
                db x_JPcc  - x_decodetable ; axxx
                db x_ADCA  - x_decodetable ; bxxx
                db x_SBBA  - x_decodetable ; cxxx
                db x_ORA   - x_decodetable ; dxxx
                db x_ANDA  - x_decodetable ; exxx
                db x_XORA  - x_decodetable ; fxxx

; -------------------------------------------------------------------
; 1000    RETURN             Return from sub-routine (ie. RET)
; -------------------------------------------------------------------
x_RETURN:
        scasw                           ; di -> STK
        and     bp, [di]
        mov     ax, word ptr [si+bp]
        mov     [di+2], ax              ; PC = mem[STK]
        add     word ptr [di], cx       ; STK += 2
        ret

; -------------------------------------------------------------------
; 1xxx    GOSUB xxx          Goto sub-routine (ie. a CALL)
; -------------------------------------------------------------------
x_GOSUB:
        sub     STK, cx                 ; STK -= 2
        and     bp, STK
        mov     ax, PC
        mov     word ptr [si+bp], ax    ; mem[STK] = PC
; -------------------------------------------------------------------
; 0xxx    JP xxx             Jump to new PC address (ie. JMP)
; -------------------------------------------------------------------
x_JP:
        mov     PC, bx                  ; PC = xxx
        ret

; -------------------------------------------------------------------
; 2xxx    PUSHB xxx          Push memory byte onto the stack
; -------------------------------------------------------------------
x_PUSHB:
        scasw                           ; di -> STK
        dec     word ptr [di]           ; STK -= 1
        mov     al, [si+bx]             ; temp = mem[xxx]
        and     bp, [di]
        mov     [si+bp], al             ; mem[STK] = temp
        ret

; -------------------------------------------------------------------
; 00xx    OSCALL xx          Operating System CALL
; -------------------------------------------------------------------
x_OSCALL:
        mov     ah, dl                  ; ah = xx
        mov     al, A                   ; al = A
        mov     dl, al                  ; dl = A
        call    extractflags            ; flags <-- STATUS
        int     21h                     ; int 21h
        stosb                           ; A = al
        HIDE2

; -------------------------------------------------------------------
; bxxx    ADCA [xxx]         Add byte to accumulator with Carry
; -------------------------------------------------------------------
x_ADCA:
        adc     A, al                   ; A + mem[xxx] + CF
        HIDE2

; -------------------------------------------------------------------
; cxxx    SBBA [xxx]         Subtract byte to accumulator with Borrow
; -------------------------------------------------------------------
x_SBBA:
        sbb     A, al                   ; A - mem[xxx] - CF
        HIDE2

; -------------------------------------------------------------------
; exxx    ANDA [xxx]         Logical AND byte to the accumulator
; -------------------------------------------------------------------
x_ANDA:
        and     A, al                   ; A and mem[xxx]
        HIDE2

; -------------------------------------------------------------------
; dxxx    ORA [xxx]          Logical OR byte to the accumulator
; -------------------------------------------------------------------
x_ORA:
        or      A, al                   ; A or mem[xxx]
        HIDE2

; -------------------------------------------------------------------
; fxxx    XORA [xxx]         Logical XOR byte to the accumulator
; -------------------------------------------------------------------
x_XORA:
        xor     A, al                   ; A xor mem[xxx]
        ; fall through to packstatus

; -------------------------------------------------------------------
; pack SPEW "STATUS <-- flags"
; -------------------------------------------------------------------
packstatus:
        pushf
        pop     ax
        and     ax, 0000100011010101b
        or      al, ah
        mov     STATUS, al
        ret

; -------------------------------------------------------------------
; 3xxx    POPB xxx           Pop memory byte from the stack
; -------------------------------------------------------------------
x_POPB:
        scasw                           ; di -> STK
        and     bp, [di]
        mov     al, [si+bp]             ; temp = mem[STK]
        mov     [si+bx], al             ; mem[xxx] = temp
        inc     word ptr [di]           ; STK += 1
        ret

; -------------------------------------------------------------------
; 6xxx    RDI [(xxx)]        Read indirect byte from memory pointer
; -------------------------------------------------------------------
x_RDI:
        and     bp, ax
        mov     al, [si+bp]
        HIDE3
; -------------------------------------------------------------------
; 8xxx    RDSYS [0000:0xxx]  Read a system byte from segment zero.
; -------------------------------------------------------------------
x_RDSYS:
        mov     al, fs:[bx]             ; A = SYS ram[0000:0xxx]
; -------------------------------------------------------------------
; 4xxx    LDA [xxx]          Load A (accumulator) from memory
; -------------------------------------------------------------------
x_LDA:
        stosb                           ; A = mem[temp]
        ret

; -------------------------------------------------------------------
; 7xxx    WRI [(xxx)]        Write indirect byte from memory-pointer
; -------------------------------------------------------------------
x_WRI:
        and     ax, bp
        xchg    ax, bx                  ; temp = mem[xxx]
; -------------------------------------------------------------------
; 5xxx    STA [xxx]          Store A (accumulator) in memory
; -------------------------------------------------------------------
x_STA:
        mov     al, A
        mov     [si+bx], al             ; mem[xxx] = A
        ret

; -------------------------------------------------------------------
; 9xxx    ADDW [xxx],A       Add sign-extended A to word location
; -------------------------------------------------------------------
x_ADDW:
        mov     al, A
        cbw
        add     word ptr [si+bx], ax    ; WORD mem[xxx] + A
        ret

; -------------------------------------------------------------------
; acpp    JPcc    +pp        Conditional jump instruction (ie. Jcc)
; -------------------------------------------------------------------
x_JPcc:
        pushf
        xchg    ax, bx
        xor     ah, 71h                 ; DH = x86 jcc reversed opcode
        mov     byte ptr [self_mod], ah ; self modify jmp
        cbw                             ; AX = pp sign extended
        popf                            ; flags = STATUS
self_mod:
        jmp     x_goJP                  ; cache is no problem on p5+
        add     PC, ax                  ; PC += AX
x_goJP:
        ret

; -------------------------------------------------------------------
; the 4096 byte SPEW cpu memory image
; -------------------------------------------------------------------

org 1000h

mem     db 256 dup (?)
        db (0f00h - 256) dup (?)
A_      db ?                       ; mem[f00]
STATUS  db ?                       ; mem[f01]
STK_    dw ?                       ; mem[f02]..mem[f03]
PC_     dw ?                       ; mem[f04]..mem[f05]
        db (1000h - 0f06h) dup (?)

end start
