; SPEW emulator
; Copyright 1999 GreenGhost
;
; Assembler : NASM
;
; 99.08.21 : 336 bytes
; 99.08.21 : 313 bytes - no memclear, di=Mem, optimizing
; 99.08.22 : 316 bytes - gets flags before oscall
; 99.08.22 : 330 bytes - inits page 0, mem wraparound correct
; 99.08.22 : 316 bytes - 8 bit Mux entries
; 99.08.22 : 296 bytes - no word access across 4kB limit
; 99.08.22 : 266 bytes - code reuse, optimizing
; 99.08.23 : 256 bytes - CalcCodes table, es for rdsys
; 99.08.23 : 248 bytes - prefetch mem
; 99.08.23 : 245 bytes - use file handle
; 99.08.27 : 243 bytes - use si in self modifying code
; 99.08.29 : 240 bytes - db 38h skips, uses init si

;Ŀ
; Offsets for the registers in the memory map                          
;

%define REGS 0F00h
%define A 0
%define STATUS 1
%define STK 2
%define PC 4

%define Mem 200h

section .text
org 100h

Main:

;Ŀ
; Read .spu image                                                      
;

  shr si,1                      ;point to params        2       [23]
  lodsb                         ;get len                1
  xchg bx,ax                    ;                       1
  mov [si+bx],al                ;store terminator       2
  mov dx,82h                    ;point to name          3
  mov ah,3Dh                    ;cmd=open,read          2
  int 21h                       ;open                   2
  xchg bx,ax                    ;get handle             1
  mov ah,3Fh                    ;cmd=read               2
  mov ch,16                     ;len=4096               2
  mov dx,Mem                    ;point to mem           3
  int 21h                       ;read                   2

;Ŀ
; Init static registers                                                
;

  mov di,dx                     ;point to mem           2       [6]
  mov si,Mem+REGS               ;point to registers     3
  pop es                        ;set es=0               1

;Ŀ
; Init page 0                                                          
;

  push di                       ;save pointer           1       [7]
; xor al,al                     ;clear counter
  .NextP0:                      ;
    stosb                       ;store counter          1
    inc al                      ;loop                   2
  jnz .NextP0                   ;                       2
  pop di                        ;restore pointer        1

;Ŀ
; Main loop of the emulator                                            
;

.Emulate:                       ;                               [28]
  mov bx,[si+PC]                ;get PC                 3
  call ReadMem                  ;get instruction        3
  add word[si+PC],byte 2        ;advance PC             4
  mov bx,ax                     ;copy opcode            2
  shr bx,12                     ;get hi nibble          3
  add bx,Mux                    ;point into Mux         4
  mov cl,[bx+5]                 ;get calc code          3
  mov bl,[bx]                   ;get offset (same page) 2
  push word .Emulate            ;push return address    3
  push bx                       ;push handler address   1
; jmp short ReadMem_ax          ;move to bx, mask, get mem
                                ;and call opcode handler

;Ŀ
; Move ax to bx and read word from Mem[bx]                             
;

ReadMem_ax:                     ;                               [1]
  xchg bx,ax                    ;move to bx             1
; jmp short ReadMem             ;read from mem

;Ŀ
; Read word from Mem[bx]                                               
;

ReadMem:                        ;                               [6]
  and bh,0Fh                    ;mask to 4 kB           3
  mov ax,[di+bx]                ;get byte/word          2
ret                             ;                       1

;Ŀ
; These are addresses to the opcode handlers. They are called with:    
;   bx = opcode & 0FFFh                                                
;   ax = Mem[bx]                                                       
;   zf = status of bh                                                  
;   cl = CalcCodes[opcode>>12] (valid for Bxxx-Fxxx)                   
;

Mux:                    ;opcode multiplexer                     [16]
  db JUMP-$$
  db GOSUB-$$
  db PUSHM-$$
  db POPM-$$
  db LDA-$$
  db STA-$$
  db RDI-$$
  db WRI-$$
  db RDSYS-$$
  db ADDW-$$
  db JPCC-$$
  db Calc-$$            ;ADCA
  db Calc-$$            ;SBBA
  db Calc-$$            ;ORA
  db Calc-$$            ;ANDA
  db Calc-$$            ;XORA

;Ŀ
; These are opcodes used in the Calc subroutine. They are written      
; into the program code to perform the selected operation.             
;

CalcCodes: db 10h               ;opcode for adc                 [5]
           db 18h               ;opcode for sbb
           db 08h               ;opcode for or
           db 20h               ;opcode for and
           db 30h               ;opcode for xor

;Ŀ
; JUMP - jump to location                                              
;

JUMP:                           ;                               [6]
  jz OSCALL                     ;if ah=0                2
  mov [si+PC],bx                ;change PC              3
ret                             ;                       1

;Ŀ
; OSCALL - call dos service                                            
;

OSCALL:                         ;                               [15]
  call GetFlags                 ;get flags              3
  mov ah,bl                     ;set cmd no             2
  mov al,[si]                   ;get A                  2
  mov dl,al                     ;                       2
  int 21h                       ;call os                2
  mov [si],al                   ;set A                  2
  jmp short StoreFlags          ;set flags              2

;Ŀ
; GOSUB - call subroutine                                              
;

GOSUB:                          ;                               [21]
  or bx,bx                      ;test if 000            2
  jz RETURN                     ;                       2
  sub word [si+STK],byte 2      ;change STK             4
  xchg bx,ax                    ;move adr to ax         1
  mov bx,[si+STK]               ;get STK                3
  and bh,0Fh                    ;mask to 4kB            3
  xchg ax,[si+PC]               ;set PC, get PC         3
  mov [di+bx],ax                ;store on stack         2
ret                             ;                       1

;Ŀ
; PUSHB - push byte on stack                                           
;

PUSHM:                          ;                               [9]
  dec word [si+STK]             ;change STK             3
  mov ax,[di+bx]                ;get from mem           2
  mov bx,[si+STK]               ;get STK                3
; jmp short WriteMem            ;write to stack
  db 38h                        ;turns next 3 bytes     1
                                ;into (harmless):
                                ;cmp [bp+di+48Ah],dl

;Ŀ
; WRI - indirect write to memory                                       
;

WRI:                            ;                               [1]
  xchg bx,ax                    ;adr in bx              1
; jmp short STA                 ;store

;Ŀ
; STA - store ackumulator in memory                                    
;

STA:                            ;                               [2]
  mov al,[si]                   ;get A                  2
; jmp short WriteMem            ;write to mem

;Ŀ
; Mask bx to 0FFFh and write al to Mem[bx]                             
;

WriteMem:                       ;                               [6]
  and bh,0Fh                    ;mask to 4kB            3
  mov [di+bx],al                ;store                  2
ret                             ;                       1


;Ŀ
; RETURN - return from subroutine                                      
;

RETURN:                         ;                               [7]
  mov bx,REGS+PC                ;point to PC            3
  call POPM                     ;pop lo byte            3
  inc bx                        ;                       1
; jmp short POPM                ;pop hi byte

;Ŀ
; POPA - pop byte from stack                                           
;

POPM:                           ;                               [14]
  push bx                       ;save                   1
  mov bx,[si+STK]               ;get STK                3
  call ReadMem                  ;get from stack         3
  pop bx                        ;                       1
  mov [di+bx],al                ;write to mem           2
  inc word [si+STK]             ;change STK             3
ret                             ;                       1

;Ŀ
; Common routine for ADCA,SBBA,ORA,ANDA and XORA                       
;

Calc:                           ;                               [8]
  mov [byte di+.Calc-Mem],cl    ;change calc            3
  call GetFlags                 ;get flags              3
  .Calc:                        ;
  sub [si],al                   ;general calc           2
; jmp short StoreFlags          ;store flags

;Ŀ
; Move 8086 flags to the status register                               
;

StoreFlags:                     ;                               [13]
  lahf                          ;get flags              1
  jno .NoV                      ;                       2
    or ah,00001000b             ;set overflow           3
  .NoV:                         ;
  and ah,11011101b              ;mask undefined bits    3
  mov [si+STATUS],ah            ;store in mem           3
ret                             ;                       1

;Ŀ
; Move the status register into 8086 flags                             
;

GetFlags:                       ;                               [14]
  mov ah,[si+STATUS]            ;get from mem           3
  bt ax,11                      ;test overflow bit      4
  mov cl,127                    ;set overflow           2
  adc cl,0                      ;                       3
  sahf                          ;set flags              1
ret                             ;                       1

;Ŀ
; RDI - indirect read from memory                                      
;

RDI:                            ;                               [4]
  call ReadMem_ax               ;get from mem           3
; jmp short LDA                 ;put in A
  db 38h                        ;turns next 3 bytes     1
                                ;into (harmless):
                                ;cmp [78Ah],bh
                                
;Ŀ
; RDSYS - read from host PC memory [0:0xxx]                            
;

RDSYS:                          ;                               [3]
  mov al,[es:bx]                ;get from 0:mem         3
; jmp short LDA                 ;put in A

;Ŀ
; LDA - load ackumulator from memory                                   
;

LDA:                            ;                               [3]
  mov [si],al                   ;put in A               2
ret                             ;                       1

;Ŀ
; ADDW - add accumulator to memory word                                
;

ADDW:                           ;                               [2]
  mov al,[si]                   ;get A                  2
; jmp short AddMemWord          ;

;Ŀ
; Sign extend al and add to Mem[bx]                                    
;

AddMemWord:                     ;                               [4]
  cbw                           ;sign extend            1
  add [di+bx],ax                ;                       2
ret                             ;                       1

;Ŀ
; JPCC - Conditional jump                                              
;

JPCC:                           ;                               [16]
  or bh,70h                     ;make jcc code          3
  mov [byte di+.Jump-Mem],bh    ;modify jump            3
  call GetFlags                 ;                       3
  xchg bx,ax                    ;move offset to al      1
  mov bx,REGS+PC                ;point to PC            3
  .Jump:                        ;
  jo AddMemWord                 ;test                   2
ret                             ;                       1

;Ŀ
; The whopping 4 kB memory                                             
;

section .bss

;Mem: resb 4096
