;
; SPEW emulator
; Hugi compo entry by GBM, 6th version, 09/99
; assemble with multipass enabled (tasm -m3 entry.asm)
;
;

	.model tiny
	.386

	.code
	org	100h
start:
	; ax, bx = 0
	; cx = 00ff
	; si = 0100
	mov	gs, bx
	add	si, cx
	; set DTA
	mov	dx, si
	mov	ah, 1ah
	int	21h
	; open
	mov	dx, 5ch
	mov	ah, 0fh
	int	21h
	daa
	jc	quit
	; read
	mov	ah, 27h
	int	21h

	;; fill mem[000]..mem[0FF] hex with 00..FF hex ;;
fillmem:
	mov	[si+bx],bl
	inc	bl
	jnz	short fillmem

;
;			The main emulator...
;
MBASE	equ	si	; memory base
SPADDR	equ	di	; SP address
AOFF	equ	bp	; A offset
IARG	equ	bx	; 12 bit instruction argument
	;	ax	; 12 bit word at argument

emulate:
	push	offset emulate

	mov	AOFF, 0f04h

	mov	bx, [MBASE+AOFF]
	add	word ptr [MBASE+AOFF],2			; PC + 2
	dec	AOFF
	dec	AOFF

	mov	dx, 0fffh
	and	bh, dh			; bx - stripped PC
	mov	IARG, [MBASE+IARG]	; bx - opcode
	push	bx
	shr	bx, 12
	mov	al, x_decodetable-mem[MBASE+bx]
	cmp	al, 30h
	mov	cx, 188h	; offset x_aluop
	jbe	yyaluop
	xchg	al, cl
yyaluop:
	mov	[MBASE+aluopc-mem], al

	pop	bx
	xor	bh, 0d0h	; convert A0 to Jcc opcode
	mov	[MBASE+jpopc-mem], bh
	and	bh, dh			; bx - stripped arg
	and	dx, [MBASE+IARG]	; stripped word at arg

	lea	SPADDR, [MBASE+AOFF]	; di at SP
	dec	AOFF
	push	cx

	mov	al, [MBASE+AOFF]
	dec	AOFF
	and	al, 00001000b
	add	al, 7fh
	mov	ax, [MBASE+AOFF]
	sahf

	xchg	ax, dx
	mov	cx, IARG
	; dl	A
	; bx,cx	IARG
quit:
	ret

;
; 1xxx    GOSUB xxx               Goto sub-routine (ie. a CALL)
;
x_GOSUB:	; 14 bytes
	jcxz	short x_RETURN		; 1000 ?

	mov	ax,[MBASE+AOFF+4]
	dec	word ptr [SPADDR]
	call	dloadSP
	mov	[MBASE+AOFF], ax	; mem[STK] = PC
	jmp	short loadPC

;
; 2xxx    PUSHB xxx               Push memory byte onto the stack
;
x_PUSHB:	; 11 bytes, uses ax
	call	dloadSP
;
; 4xxx    LDA [xxx]               Load A (accumulator) from memory
;
x_LDA:	; [a]<-[i]
	xchg	ax, IARG
;
; 6xxx    RDI [(xxx)]             Read indirect byte from memory pointer
;
x_RDI:	; [a]<-[x]
	xchg	ax, AOFF
;
; 7xxx    WRI [(xxx)]             Write indirect byte from memory-pointer
;
x_WRI:	; [x]<-[a]
	xchg	ax, IARG
;
; 5xxx    STA [xxx]               Store A (accumulator) in memory
;
x_STA:	; [i]<-[a]
	mov	al, [MBASE+AOFF]
	mov	[MBASE+IARG], al
	ret

;
; Acpp    JPcc    +pp             Conditional jump instruction (ie. Jcc)
;
x_JPcc:	; 7 bytes
	xchg	ax, IARG
	mov	IARG, 0f04h
jpopc:
	jo	short addw
	ret

;
	org	182h
;
; 00xx    OSCALL xx               Operating System CALL
;
x_OSCALL:	; uses dl
	mov	ah, bl	   	  	; ah = xx
	mov	al, dl			; dl = A
	int	21h

;
; Bxxx    ADCA [xxx]              Add byte to the accumulator with Carry
; Cxxx    SBBA [xxx]              Subtract byte to the accumulator with Borrow
; Dxxx    ORA [xxx]               Logical OR byte to the accumulator
; Exxx    ANDA [xxx]              Logical AND byte to the accumulator
; Fxxx    XORA [xxx]              Logical XOR byte to the accumulator
;
x_aluop:	; uses al
aluopc	label	byte
	adc	[MBASE+AOFF],al  			; A + mem[xxx] + CF
;
packstatus:
	pushf
	pop	ax
	and	ax,0000100011010101b
	or	al,ah
	inc	AOFF
	db	68h
;
; 8xxx    RDSYS [0000:0xxx]       Read a system byte from segment zero.
;
x_RDSYS:	; 5 bytes
	mov	al, gs:[IARG]
	mov	[MBASE+AOFF],al  			; A + mem[xxx] + CF
	ret

;
; 3xxx    POPB xxx                Pop memory byte from the stack
;
x_POPB:	; 9 bytes
	call	loadSP
	call	x_STA
	inc	word ptr [SPADDR]			; STK + 1
	ret

;
; 9xxx    ADDW [xxx],A            Add sign-extended A register to word location
;
x_ADDW:	; 5 bytes, uses dl
	xchg	ax, dx
addw:
	cbw
	add	[MBASE+IARG], ax	; WORD mem[xxx] + A
addwq:
	ret

;
dloadSP:	; 8 bytes
	dec	word ptr [SPADDR]
loadSP:
	mov	AOFF, 0fffh
	and	AOFF, [SPADDR]
	ret
;
; 1000    RETURN                  Return from sub-routine (ie. RET)
;
x_RETURN:	; 13+8=21 bytes
	dec	cx
	dec	cx
	add	word ptr [MBASE+AOFF+4], cx	; PC - 2
	call	loadSP
	sub	word ptr [SPADDR], cx		; STK + 2
	mov	IARG, [MBASE+AOFF]
;
; 0xxx    JP xxx                  Jump to new PC address (ie. JMP)
;
x_JP:	; 8 bytes
	mov	cl, ch
	jcxz	x_OSCALL
loadPC:
	mov	[SPADDR+2],IARG			; PC = xxx
	ret

;

;
x_decodetable	label byte
	db	low offset x_JP		; 0xxx
	db	low offset x_GOSUB		; 1xxx
	db	low offset x_PUSHB		; 2xxx
	db	low offset x_POPB		; 3xxx
	db	low offset x_LDA		; 4xxx
	db	low offset x_STA		; 5xxx
	db	low offset x_RDI		; 6xxx
	db	low offset x_WRI		; 7xxx
	db	low offset x_RDSYS		; 8xxx
	db	low offset x_ADDW		; 9xxx
	db	low offset x_JPcc		; Axxx
	db	10h, 18h, 08h, 20h, 30h


	org	1ffh
;
; the 4096 byte SPEW cpu memory image
;
mem	db	256 dup (?)
	db	(0F00h-256) dup (?)
A	db	?	      		; mem[F00]
STATUS	db	?			; mem[F01]
STK	dw	?			; mem[F02]..mem[F03]
PC	dw	?			; mem[F04]..mem[F05]
	db	(1000h-0F06h) dup (?)

	end	start
