;***************************************************************************
;  Program: SPEW-Emulator
; Platform: DOS
; Compiled: ENTRY.COM (312 bytes)
;    Sense: HUGI Size coding competition #9
;     Date: Aug'99
;   Author: BertI
; Language: ASM
; Compiler: MASM6/TASM3 (MASM should be used)
;  Version: 1.1c
;   Answer: 42
;  History: 26.8.99	First Bug-Free Version & Optimations	315 bytes
;	    29.8.99	Several Optimations			307 bytes
;	    30.8.99	Fixed Return (STK=PC)-bug (1st entry)	312 bytes
;     Bugs: unable to handel parameters with spaces at the beginning
;		(NOTE: I'm not sure if the program has to handle that...)
;***************************************************************************

.model tiny
.code
.486

; remove the ; to aktivate debug mode (setup registers at startup)
;_Debug		EQU	1

A		EQU	00F00h
STATUS		EQU	00F01h
STK		EQU	00F02h
PC		EQU	00F04h
ParamOffset	EQU	00080h
RotateWord	EQU	1000010110100110b	;Used in the ALU

MStoreFLAGS	MACRO
        pushf
        pop	ax
        and	ax,0000100011010101b	;not sure if bit 5 should be 0...
        or	al,ah
        mov     ds:[status],al
ENDM	MStoreFlags

	org	100h
	
; assumptions on entry :
;AX = BX = 0000, CX = 00FF, SI = 0100, BP = 09xx
;DX = CS = DS = ES = SS = xxxx, SP = DI = FFFE
	
@Start:

IFDEF	_Debug
; Reset all registers (some debuggers don't handle them correctly...)
	xor	ax,ax
	xor	bx,bx
	mov	cx,00FFh
	mov	dx,cs
	mov	ds,dx
	mov	es,dx
	mov	fs,dx
	mov	gs,dx
	mov	si,0100h
	mov	di,0FFFEh
	mov	bp,0900h
ENDIF

;*** Setup some registers
	mov	FS,ax		;>>>Make FS=0 (used in RDSYS)
	mov	BP,0FFFh	;>>>Used as 4K-mask
;*** Allocate Memory in the Stack-area
	mov	sp,bp		;!!! only 800 bytes for stack left !!!
	add	dh,01h
	mov	es,dx	
	;OOO gs benutzen und unten stosb beim 0-terminaten benutzen?
;*** Read file into virtual memory:
	mov	bl,ParamOffset	;>>>bh is still zero...
	add	bl,[bx]		;>>>Add length of parameters
	inc	bx		;>>>Add 1
	mov	byte ptr[bx],0	;>>>Zero-terminate Filename

	mov	dx,ParamOffset+2	;>>>First Argument =>DS:DX=String
	mov	ah,03dh		;>>>Funct 3Dh -> Open File
	int	021h
	
	push	es		;>>>Set DS to the real value
	pop	ds		;>>>Store it in DS...
	
	mov	bx,ax		;>>>Store File Handel
	mov	ah,03fh		;>>>Funct 3Fh -> Read File
	xor	dx,dx		;>>>DS:DX=Pointer into Memory...
	mov	cx,1000h	;>>>"Give me all"-"ok"-ratatatata
	int	021h

;*** Setup 0-FF VMEM Area
	xor	di,di
	xor	al,al
@loop_2:
	stosb
	inc	al
	jnz	@loop_2		;>>> Till wrap-around of al
	
	JMP	@NoStore
	
;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
;***************** Fetch - decode - execute pipeline ************************
;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>

@StoreRegisters:	;If Registers (A & PC) were changed...
	mov	DS:[A],cl
@StorePC:	;Store ONLY PC ;OOO evtl. auch ein @StoreA einfgen??
	mov	DS:[PC],si	
@NoStore:	;if they weren't changed, but memory was
	mov	cl,ds:[A]	;>>>preload A
	mov	di,ds:[STK]	;>>>preload STK
        and	di,bp		;>>>validate STK
        mov	si,ds:[PC]	;>>>preload PC
        
	push	si		;den "echten" PC zwischenspeichern
	and	si,bp		;den "falschen" "validaten"
	Lodsw			;>>>Get Command
	pop	si		;den "echten" restaurieren
	inc	si		;2 dazu
	inc	si
	mov	DS:[pc],si	;und sichern...
	
	mov	bx,ax		;>>>Copy Command into BX
	mov	al,ah		;>>>Get Upper byte (Opcode & add. Info)
	DW	010D4h		;>>>AAM by 10h => ah=Opcode, al=bits 8-11
	and	bx,bp		;>>>Make bx bits 0-11 (mov bh,al is ok too)
	mov	dx,ds:[bx]	;>>>prefetch data
	and	dh,0Fh		;>>>Make data a valid Pointer

	cmp	ah,0Ah
	jae	@ALU_JMP	;direct
	cmp	ah,08h
	jae	@ADDW_RDSYS	;direct
	cmp	ah,06h
	jae	@MEM_Indirect	
	cmp	ah,04h
	jae	@MEM_direct
	cmp	ah,02h
	jae	@POPB_PUSHB
	cmp	ah,00h
	je	@JP_OsCall

@GOSUB_or_RETURN:
	mov	cx,2
	test	bl,bl
	jz	Return
Gosub:	sub	di,cx			;>>>STK-2
	and	di,bp			;>>>STK and 0FFFh
	neg	cx			;>>>STK-2 (2->-2)
	mov	ds:[di],si		;>>>[STK]=PC+2
	mov	si,bx			;>>>PC=xxx
	jmp	QS
Return:	sub	word ptr ds:[pc],2	;>>>PC-2 (return STK=PC - bug)
	mov	si,ds:[di]		;>>>PC=[STK]
QS:	add	word ptr ds:[STK],cx	;>>>STK+-2
STPC2:	jmp	@StorePC		;>>>cl(=A) ist zerstrt!!
			
; ->>>>>>>>>>>> ADDW
@ADDW_RDSYS:
	je	@RDSYS
@ADDW:	mov	al,cl		;>>>Get A
	cbw			;>>>Sign-extend A
	add	ds:[bx],ax	;>>>[xxx]+A
NOST4:	jmp	@NoStore	;>>>Continue
	
; ->>>>>>>>>>>> RDSYS
@RDSYS:
	mov	cl,FS:[bx]	;>>>MOV [A],0000:0xxx
STRG1:	jmp	@StoreRegisters

; ->>>>>>>>>>>> JCPP	(AL=Condition)
@ALU_JMP:
	ja	@ALU_Instruction
@JCPP:
	or	al,070h		;>>>Create Jumping-Code
	mov	byte ptr cs:[@CJSM],al	;>>>Self-modify
	CALL	PLoadFlags	;>>>Load Flags, empty prefetch-queue
@CJSM:
	jz	@IsTrue
NOST3:	jmp	NOST4	;@NoStore	;OOO Maybe storing them???
@IsTrue:
	mov	al,bl		;>>>get the Modifikator
	cbw			;>>>Sign-extend it
	add     si,ax		;>>>PC:=PC+xx
STPC1:	jmp	STPC2	;@StorePC

; ->>>>>>>>>>>> Push/Pop
@POPB_PUSHB:
	je	@PUSHB
@POPB:	mov	cl,ds:[di]		;>>>tmp = [STK]
	mov	ds:[bx],cl		;>>>[xxx] = tmp
	inc	word ptr ds:[STK]	;>>>STK + 1
NOST2:	jmp	NOST3		;@NoStore
@PUSHB:	dec	di			;>>>STK - 1
	and	di,bp			;>>>(AND 0FFFh)
	dec	word ptr ds:[STK]	;>>>STK - 1 (xxx might be STK)!
	mov	cl,DS:[bx]		;>>>tmp = [xxx]
	mov	bx,di
	jmp	@STA			;>>>[STK] = tmp (Saved a byte)

; ->>>>>>>>>>>> Memory-Accsses-Instructions (direct & Indirect)
@MEM_Indirect:
	mov	bx,dx		;>>>den DX-Wert nach BX laden, schon gemaskt
@MEM_direct:
	ja	@STA		;>>>Unterscheidung zwischen STORE und LOAD
@RDA:	mov	cl,DS:[bx]	;>>>MOV [A],[xxx]; dont use dl(mem_indirect!)
	jmp	STRG1		;@StoreRegisters
@STA:	mov	DS:[bx],cl	;>>>MOV [xxx],[A]
NOST1:	jmp	NOST3		;@NoStore, sonnst fehler falls xxx=A

; ->>>>>>>>>>>> Alu-Instructions: (to be optimized...)
@ALU_Instruction:
	mov	bx,RotateWord
	xchg	ah,cl		;AH=A  cl=OPCODE
	imul	cx,11b		;or 3 times ror - 1 byte saved...
	ror	bx,cl
	and	bl,00111000b	;Mask Opcode
	mov	byte ptr cs:[SM],bl	;Self-modifikate
	CALL	PLoadFlags	;Load flags and clear prefetch-queue
SM:	AND	DS:[A],dl	;This Code will be self-modified (4B)
@FlagAktualize:
	MStoreFLAGS
	jmp	NOST1		;@NoStore

; ->>>>>>>>>>>> JP and OSCALL
@Jp_OsCall:	
	test	al,al
	jz	OSCall
@JP:	mov	si,bx		;>>>MOV	[PC],xxx
	jmp	STPC1		;@StorePC
OSCALL:	mov	ah,bl   	;>>>MOV	ah,xx
	mov	al,cl		;>>>MOV	al,[A]
	mov	dl,cl		;>>>MOV	dl,[A]
	call	PLoadFLAGS
	int	021h		;>>>OSCALL
		;mov	cl,al	;>>>MOV	[A],al nein, da jmp @NoStore kommt s.o.
	mov	ds:[A],al	
	jmp	@FlagAktualize	;>>>MOV [STATUS],flags
			
PLoadFLAGS	Proc	near	;>>>Flags <--<-- Status
	pusha
	dec	bp	;Lscht OV (bp=0FFF)
	pushf
	pop	ax		;>>>ax = Flags
	mov	al,ds:[status]	;>>>tmp = Status
	mov	bx,ax		;>>>bx = Flags:Status
	and	al,00001000b	;>>>mask OV
	or	bh,al		;>>>Note: OV in bh is cleaned (see above)
	push	bx
	popf
	popa
	ret
PLoadFlags ENDP		;TEMP: 375

END	@Start

; AL = Bits  8-11 of Command Word (x*xx) = JumpID/Syscall-JP-ID
; AH = Bits 12-15 of Command Word (*xxx) = Command ID
; BX = Bits  0-11 of Command Word (x***) = Adress
; CL = A-Register
; CH = ???
; DX = [BX] AND 0FFF (Updatet after instruction is read)
; DI = [STK]
; SI = [PC]
; BP = 0FFFh = AND-Maske fr Speicherzugriffe
; FS = 0000 to accsses SysMem
; GS = ???