        name    hcompo08
        page    60,132
        .lfcond         ;list false conditionals also
        title   'H Compo 08'
        .186
;
; Hugi size coding competition #8
; - see Hcompo08.txt for rules'n'regs etc.
;
; Description:
;  Program operates as a DOS filter, converts raw ASCII to MORSE
;  or MORSE to ASCII depending if the 1st character read is '_'
;
; Entry from: TonyWilk
;      email: TonyWilk@dial.pipex.com
;  assembler: MASM 5.00         masm /l entry.asm
;     linker: MS LINK 5.10      link /tiny entry.asm;
;    version: 3.2
;     length: 242 bytes   (previous was 248)
;  submitted:
;
; Version Info:
;  1.0 Initial submitted version, 295 bytes
;
;  2.0 (not submitted, 262 bytes)
;  * Mostly using shorter instructions, re-ordering execution
;    and storing morse with leading and trailing '1's
;  * Simplified output for WORD separators.
;
;  3.0 (not submitted, 251 bytes)
;  * Managed to make use of cmpxchg !
;  * Tried to sort out register usage.
;  * Lots of re-ordering
;
;  3.1 2nd Submission, 248 bytes: 
;  - final nasty bits to save a byte or 2...
;  * Using starting reg value of CX=00ff to frig BEGIN detection
;    in morse->text (saved 2 bytes)
;  * Using starting value of SI=0100h as char buffer for I/O (saved 1 byte)
;
;  3.2 3rd submission, 242 bytes:
;  * realised INT21 0x4C isn't the shortest way back to DOS !
;    Now just RETs back to DOS (so INT20 in PSP at 0000 must be valid)
;  * Shuffled stack usage around to enable clean exit.
;
;  Side effects:
;    a. will NOT terminate properly in DEBUG (since INT20 is pissed on)
;    b. non-redirected Morse->Text *must* start with a valid START code
;
;-------------------------------------------------------------------------------;
; Equates... for reference only
;
STDIN       equ     0               ;Standard I/O handles
STDOUT      equ     1
READFILE    equ     03fh            ;INT21 read/write file
WRITEFILE   equ     040h

CR      equ     0dh
LF      equ     0ah

;-----------------------------------;
; Main Code....
;
code   segment byte public 'CODE'
       assume cs:code,ds:code

        ;
        ; DATA (nasty!)
        ; -if run in DOS, 0100h = character buffer (i.e. code pissed on)
        ; -if run under DEBUG, 0000h= char. buffer (i.e. PSP pissed on)

        org     100h                ;will be a .COM program
                                    ;entry point from DOS
;-----------------------------------;
START:
;       xchg    ax,si               ;si->charbuf *constant*
                                    ;si=0100h from DOS (0000h in DEBUG)

        call    get1in              ;get a char from stdin
        push    ax                  ;(1)stack char 
                                    ;cl= part-coded 1st dash (cx=00ff at startup)
        cmp     al,'_'              ;MORSE->Text ?
        jz      short ToText        ; yes: stack contains 'not-a-valid-terminator'
                                    ; no: do Text->MORSE...
;
; Convert text input to Morse
;  on entry: 1st character is stacked
;            cl=02
ToMorse:
        mov     cl,6bh              ;BEGIN (bit pattern in cl)
        call    opMorse             ;convert to morse symbol
        pop     ax                  ;(0)restore 1st character
        mov     dl,'/'              ;dl= word sep.

ToMnext:
        call    ToMsep              ;o/p morse symbol+separator
        call    get1in              ;get another character 
        jnz     ToMnext

        mov     dl,'/'              ;dl=end separator
        mov     al,2ah              ;END symbol index
        jmp     short ToMsymsep     ;output END symbol, 
                                    ;ret to DOS
;-----------------------------------
;
; Convert Morse input to text...  
;  entry point is 'ToText' with cl=0ffh, non-terminator on stack
;
ToTnext:
        xor     cx,cx               ;cl=0, first inc is 'leading 1'
isdash:
        inc     cx
ToText:                             ;(1) terminator on stack
        shl     cl,1                ;shift dots'n'dashes into cl
ToTskip:
        call    get1in
        jz      lilypad             ;EOF, tidy stack and quit
        cmp     al,'_'
        jz      isdash
        cmp     al,'.'              ;not . or _ = symbol terminator (in al)
        jz      ToText
        cmp     al,0fh              ;skip CR/LF stuff
        jc      ToTskip
;
; now have morse bit pattern in cl, terminating character in [si]
; ...so look it up in the table
donesym:
        inc     cx                  ;add trailing 1 for lookup
        xchg    ax,cx               ;al:=lookup value, cx:=00??
        mov     cl,39h              ;cx = max count (invalid symbol char '_')
mlookup:
        mov     di,offset morse
        repnz   scasb               ;go find it
        xchg    ax,di
        sub     ax,offset morse+2   ;al=index-1 (ffh,0..38h) ah=0
        ;
        ; values 0,1,2,3 are 'invalid', rest are ASCII-28h
        ; 0 = newline, 1=startcode, 2=endcode, 3='`'  (0x60)
        ;
        jz      doCRLF              ;0=NEWLINE
        cmp     al,4
        jnc     okchar              ;al=ff,4..n = ok
                                    ;al= 1, 2, 3
        dec     ax
        jz      ToTnext             ;1=startcode, (leave stacked terminator)
        dec     ax
lilypad:
        jz      popquit             ;2=endcode, clean stack and exit
        mov     al,53h              ;3='`'= 60h = 53h+e5h+28h
doCRLF:
        add     al,0e5h             ;NEWLINE: 00+E5+28=0dh 
okchar:
        add     al,28h              ;add offset to make ASCII
        ;
        ; output any terminator before the character...
        ;
        xchg    ax,bx               ;save current character in bx
        pop     ax                  ;<0> get previous terminator
        push    [si]                ;<1> save current terminator
        cmp     al,'/'              ;word separator ?
        jnz     nosep
        mov     al,20h              ;output a space
        call    put1out             ;(saves cx,bx)
nosep:
        xchg    ax,bx               ;restore current char from bx
again:
        call    put1out             ;output text character (saves cx)
        sub     al,10h              ;(0dh->put1out->1ah-10h = 0ah)
        cmp     al,0ah
        jz      again               ;do 0ah after 0dh
        jmp     short ToTnext
;-----------------------------------;
; Text input to morse output routines...
;
; ToMsep    - output separator in dl + morse for char in al
; ToMsymsep - output separator in dl + morse for index in al
; ToMsym    - output morse for index in al
; opMorse   - output morse for bit pattern in cl
;
ToMsep:
        cmp     al,5Bh              ;char > 5Ah ?
        jc      ToMadj
        sub     al,20h              ;'`'->'@', 'a'->'A' etc.
ToMadj:
        cmp     al,27h              ;char > 27h ?
        jnc     toMsymsep           ;  yup: 's ok
        cmp     al,0dh              ;CR?
        jnz     ToMspace            ;  nope: go check for space
        mov     al,28h              ;  yup: 28h-27h= 01h == NEWLINE index
        ;
        ; ready to output a symbol, do separator first...
        ;
ToMsymsep:
        xchg    ax,dx               ;get separator flag from dl
        call     put1out            ;o/p separator
        xchg    ax,dx               ;restore index in al
        ;
        ; output morse symbol for index in al...
        ;
ToMsym:
        mov     bx,offset morse-27h ;bx->table, offset for ASCII
        xlatb                       
        xchg    ax,cx               ;get bit pattern in cl
        ;
        ; now output the morse code... (pattern in cl)
        ;
opMorse:
        mov     dx,2f20h            ;setup: dh='/'  dl=' ' separators
dahloo:
        shl     cl,1                ;looking for 'leading 1'
        jnc     dahloo
ditloo:                             ;output dots and dashes
        mov     al,'.'
        shl     cl,1
        jz      ToMret              ;stop on empty byte
        jnc     dit
        mov     al,'_'
dit:
        call    put1out
        jmp     short ditloo

ToMspace:
                                    ;SPACE?        ( dl=space, dh='/')
;       cmpxchg dl,dh               ;if al==space, dl:='/' word separator
        db  0fh,0b0h,0f2h
ToMret:
        ret
;-----------------------------------;
; morse code look-up table
;  table is in order of ASCII value from 0x27..0x60
;  entries are morse code in binary (dot=0, dash=1) 
;  with leading '1' and trailing '1'
;  invalid entries are 0xff (now used for a few instructions!)
;  e.g.
;      '2' = "..___" = 00111 stored as: 1001111 = 0x4f
;
morse:			; Index -ASCII-	  Morse	  Comment
    db   0bdh   ; 0x00  0x27  '   .____.  
    db   063h   ; 0x01  0x28  (   _..._   NEWLINE
    db   0ebh   ; 0x02  0x29  )   _._._   BEGIN  **INPUT ONLY** (was:06bh)
    db   055h   ; 0x03  0x2a  *   ._._.   END
    db   0a5h   ; 0x04  0x2b  +   ._.._.  '`' 0x60
    db   0e7h   ; 0x05  0x2c  ,   __..__  
    db   0c3h   ; 0x06  0x2d  -   _...._  
    db   0abh   ; 0x07  0x2e  .   ._._._  
    db   065h   ; 0x08  0x2f  /   _.._.   
    db   07fh   ; 0x09  0x30  0   _____   
    db   05fh   ; 0x0a  0x31  1   .____   
    db   04fh   ; 0x0b  0x32  2   ..___   
    db   047h   ; 0x0c  0x33  3   ...__   
    db   043h   ; 0x0d  0x34  4   ...._   
    db   041h   ; 0x0e  0x35  5   .....   
    db   061h   ; 0x0f  0x36  6   _....   
    db   071h   ; 0x10  0x37  7   __...   
    db   079h   ; 0x11  0x38  8   ___..   
    db   07dh   ; 0x12  0x39  9   ____.   
    db   0f1h   ; 0x13  0x3a  :   ___...  
    db   0d5h   ; 0x14  0x3b  ;   _._._.  
popquit:
        pop     ax            ; luckily, these instructions are not
        ret                   ; valid morse pattern values !

;   db   0ffh   ; 0x15  0x3c  <   *invalid*
;   db   0ffh   ; 0x16  0x3d  =   *invalid*
    db   0ffh   ; 0x17  0x3e  >   *invalid*
    db   099h   ; 0x18  0x3f  ?   ..__..  
    db   0a5h   ; 0x19  0x40  @   ._.._.  (0x60)
    db   00bh   ; 0x1a  0x41  A   ._      (0x61 etc.)
    db   031h   ; 0x1b  0x42  B   _...    
    db   035h   ; 0x1c  0x43  C   _._.    
    db   019h   ; 0x1d  0x44  D   _..     
    db   005h   ; 0x1e  0x45  E   .       
    db   025h   ; 0x1f  0x46  F   .._.    
    db   01dh   ; 0x20  0x47  G   __.     
    db   021h   ; 0x21  0x48  H   ....    
    db   009h   ; 0x22  0x49  I   ..      
    db   02fh   ; 0x23  0x4a  J   .___    
    db   01bh   ; 0x24  0x4b  K   _._     
    db   029h   ; 0x25  0x4c  L   ._..    
    db   00fh   ; 0x26  0x4d  M   __      
    db   00dh   ; 0x27  0x4e  N   _.      
    db   01fh   ; 0x28  0x4f  O   ___     
    db   02dh   ; 0x29  0x50  P   .__.    
    db   03bh   ; 0x2a  0x51  Q   __._    
    db   015h   ; 0x2b  0x52  R   ._.     
    db   011h   ; 0x2c  0x53  S   ...     
    db   007h   ; 0x2d  0x54  T   _       
    db   013h   ; 0x2e  0x55  U   .._     
    db   023h   ; 0x2f  0x56  V   ..._    
    db   017h   ; 0x30  0x57  W   .__     
    db   033h   ; 0x31  0x58  X   _.._    
    db   037h   ; 0x32  0x59  Y   _.__    
    db   039h   ; 0x33  0x5a  Z   __..    

;-----------------------------------;
; get a character from STDIN
; passed:    nothing
; destroys:  none
; returns:   NZ, char in ax (al=char, ah=0)
;            Z, error
get1in:
        xor     ax,ax               ;ah=0, (al --> 3fh for read)
goio:
        pusha  
        xor     bx,bx
        mov     bl,ah               ;bx: 0=STDIN, 1=STDOUT
        add     ah,3fh              ;3fh=read, 40h=write
        xor     cx,cx
        mov     dx,si               ;dx->charbuf
        inc     cx                  ;cx=1 char to read/write
        int     21h                 ;do I/O
        aaa                         ;al=0 or 1,  set Z flag
        popa                        ;restore regs, (al=0 if get1in)
        jz      ioerr
        add     al,[si]             ;get char in al, set NZ (char*2 if put1out)
ioerr:
        ret
;-----------------------------------;
; stuff a character to STDOUT
;  passed:   char in al
;  destroys: none
;  returns:  NZ, char*2 in al, ah=1
;             Z, error
put1out:
        mov     [si],al             ;stuff char in buffer
        mov     ah,01h              ;ah=01 (ends up as 40h)
        jmp     short goio          ;go do IO
;-----------------------------------;
code ends

     end START

;end of hcompo08.asm 
