
; Technolord's entry for HC#8 -- l.raiser@deathsdoor.com
;
; Code is too clean to win (and I don't know how to shrink it more!)

.model tiny
.586
.code
.startup
locals @@

  SALC MACRO
    db 0D6h
  ENDM
                                ; defaults:
  USING_DEBUGGER            = 0 ; 0
  RELOC_IO_ACCESS           = 1 ; 1
  RELOC_EXIT_POINT          = 1 ; 1
  ASSUME_NO_CHARS_AFTER_EOM = 1 ; 1 (adok said "EOM is last char before EOF".
                                ;  --will work as long as there's no " " or "/"
                                ;   after EOM code, that is, for valid files :)

  DAT  = '_'       ; dash
  DIT  = '.'       ; dot
  SSEP = ' '       ; symbol separator
  WSEP = '/'       ; word separator
  BOM  = 00010101b ; "_._._" Begin Of Message without the first "_" ("._._")
  EOM  = 00101010b ; "._._."   End Of Message

  LASTCHAR = '`'

  OUTPUT = byte ptr [SI]

  ; I ASSUME ON START:
  ;
  ; AX = 0000
  ; BX = 0000
  ; CX = 00FF
  ; DX = CS = DS = ES = SS = xxxx
  ;
  ; SI = 0100
  ; DI = FFFE
  ; BP = 09xx
  ; SP = FFFE
  ; IP = 0100

IF USING_DEBUGGER
  mov  cx, 00FFh
  mov  di, bp
  mov  dx, ds
  mov  si, (offset CodeTable)-LASTCHAR-1 ; Load table position
ENDIF

;---------------------------------[ DATA ]------------------------------------
;                                  ] 97 [



;  mov  si, (offset CodeTable)-LASTCHAR-1 ; Load table position
  cwd
  call IO_Read           ; check input type
  cmp  al, DAT
  je   short Bridge_to_Decode
  jmp  short Bridge_to_Encode
;db        0b
;db        0b
;db        0b
;db        0b
;db        0b
;db        0b
;db        0b
;db        0b
;db        0b
;db        0b
db 00110001b ; NEWLINE (0Ah) -- used in encoding
IF RELOC_EXIT_POINT
  EndOfDecode:
    INT 20h
ELSE
  db        0b
  db        0b
ENDIF
db 00110001b ; NEWLINE (0Dh) -- used in decoding

IF RELOC_IO_ACCESS
  IO_Access_CRLF:
      sub  OUTPUT, 3
  IO_Access proc
      pusha
      mov  dx, si
      xchg ah, bh
      mov  cl, 1
      int  21h
      dec  ax
      popa
  ExitAddress:
      jnz  short EndOfEncode
      mov  al, OUTPUT
      cmp  al, 0Dh
      je   IO_Access_CRLF
      mov  bx, si
      ret
  IO_Access endp
ELSE
  db        0b
  db        0b
  db        0b
  db        0b
  db        0b
  db        0b
  db        0b
  db        0b
  db        0b
  db        0b
  db        0b
  db        0b
  db        0b
  db        0b
  db        0b
  db        0b
  db        0b
  db        0b
  db        0b
  db        0b
  db        0b
  db        0b
  db        0b
  db        0b
  db        0b
ENDIF

db 01011110b ; '

  bridge_to_encode:
    mov  DL, DAT  ; Message Header
    jmp  short Encode

db 01110011b ; ,
db 01100001b ; -
db 01010101b ; .
db 00110010b ; /
db 00111111b ; 0
db 00101111b ; 1
db 00100111b ; 2
db 00100011b ; 3
db 00100001b ; 4
db 00100000b ; 5
db 00110000b ; 6
db 00111000b ; 7
db 00111100b ; 8
db 00111110b ; 9
db 01111000b ; :
db 01101010b ; ;

  bridge_to_decode:
    STD
    jmp  short Decode

db 01001100b ; ?
db 0         ; ARGH! An useless byte!!!
db 00000101b ; A
db 00011000b ; B
db 00011010b ; C
db 00001100b ; D
db 00000010b ; E
db 00010010b ; F
db 00001110b ; G
db 00010000b ; H
db 00000100b ; I
db 00010111b ; J
db 00001101b ; K
db 00010100b ; L
db 00000111b ; M
db 00000110b ; N
db 00001111b ; O
db 00010110b ; P
db 00011101b ; Q
db 00001010b ; R
db 00001000b ; S
db 00000011b ; T
db 00001001b ; U
db 00010001b ; V
db 00001011b ; W
db 00011001b ; X
db 00011011b ; Y
db 00011100b ; Z

IF RELOC_IO_ACCESS
  IO_Write proc            ;  5 BYTES
      mov  bx, 4001h
      jmp  short IO_Access
  IO_Write endp
ELSE
  db        0b
  db        0b
  db        0b
  db        0b
  db        0b
ENDIF

db 01010010b ; `
CodeTable label byte     ; Symbols take 48 bytes (46 codes, 1 dupe, 1 wasted)

;-----------------------------[ ENCODE PART ]---------------------------------
;                                  ] 60 [

  SEPARATOR = DL

Encode proc
    push ax                                                              ;  9
    mov  al, BOM
    call Write_Morse
    pop  ax
    mov  SEPARATOR, WSEP

  @@WholeMessage:

        ; Force UpperCase
    cmp  al, 61h                                                         ;  6
    jb   short @@NotLetter
    and  al, not 20h
  @@NotLetter:

        ; Check Word_Separator
    cmp  al, ' '                                                         ;  8
    jne  short @@NotWordSep
    mov  SEPARATOR, WSEP
    jmp  short @@ReadMore
  @@NotWordSep:
        ; Do the conversion!
    xlat                                                                 ;  4
    call Write_Morse

  @@ReadMore:
;    call IO_Read                                                        ;  3
;    jmp  short @@WholeMessage
    push offset @@WholeMessage
Encode endp                                                              ;=30


;-----------------------------[ I/O SECTION ]---------------------------------
;                                  ]  5 [

IO_Read proc                                                             ;  3
    mov  bx, 3f00h
IF RELOC_IO_ACCESS
  jmp  short IO_Access                                                   ;[ 2]
ELSE
  IO_Access_CRLF:                                                        ;(25)
      sub  OUTPUT, 3
  IO_Access proc
      pusha
      mov  dx, si
      xchg ah, bh
      mov  cl, 1
      int  21h
      dec  ax
      popa
  ExitAddress:
      jnz  short EndOfEncode
      mov  al, OUTPUT
      cmp  al, 0Dh
      je   IO_Access_CRLF
      mov  bx, si
      ret
  IO_Access endp
ENDIF
IO_Read endp

IF RELOC_IO_ACCESS
ELSE
IO_Write proc                                                            ;( 5)
    mov  bx, 4001h
    jmp  short IO_Access
IO_Write endp
ENDIF

IF RELOC_EXIT_POINT
ELSE
  EndOfDecode:                                                           ;( 2)
    INT 20h
ENDIF                                                                    ;=35
                                                                         ;( 5)

;------------------------[ ENCODE PART (repraise) ]---------------------------

  SEPARATOR = DL

EndOfEncode:             ; Message Footer                                ;  5
    pop  di
    mov  SEPARATOR, WSEP
    mov  al, EOM

; AL = encoded morse message
Write_Morse proc
    xchg dx, ax                                                          ;  4
    bsr  cx, DX

  @@do_write:
    mov  OUTPUT, al                                                      ;  5
    call IO_Write

    dec  cx                                                              ; 12
    bt   DX, CX
    mov  al, DAT
    jc   short @@do_write
    mov  al, DIT
    jns  short @@do_write

    inc  cx
    mov  SEPARATOR, SSEP                                                 ;  4
  ItsAllOver:
    ret
Write_Morse endp                                                         ;=30

;-----------------------------[ DECODE PART ]---------------------------------
;                                  ] 59 [

  SEPARATOR = DL

Decode proc
  @@SkipBOM:
    call IO_Read                                                         ;  7
    cmp  al, WSEP
    jne  short @@SkipBOM        ; Skip header!

IF RELOC_IO_ACCESS                                                       ;  4
    mov  byte ptr [bx+1Dh], (offset EndOfDecode)-(offset ExitAddress)-2
ELSE                            ; ^^ handcoded :)
    IF USING_DEBUGGER
        mov  byte ptr [bx](ExitAddress-0FFh), (offset EndOfDecode)-(offset ExitAddress)-2
    ELSE
        mov  byte ptr [bx+si](ExitAddress-1FFh), (offset EndOfDecode)-(offset ExitAddress)-2
    ENDIF                       ; ^^ this compiles badly, wasting 1 byte
ENDIF

  @@NextSymbol:                 ; Start new symbol                       ;  2
    mov  cl, 1
  @@StillHungry:
    call IO_Read                                                         ;  3

    cmp  al, SSEP               ; Space (skip return and ^Z)             ;  6
    jb   short @@StillHungry
    je   short @@MatchSymbol

    cmp  al, WSEP               ; Slash                                  ;  6
    jne  short @@DecodeMorse
    inc  dx
    inc  dx

  @@MatchSymbol:
IF ASSUME_NO_CHARS_AFTER_EOM
ELSE
    cmp  cl, EOM                ; Is it the end of message?              ;( 5)
    je   short ItsAllOver
ENDIF

    shr  dl, 1                                                           ; 10
    jnc  short @@StillWording
    mov  OUTPUT, ' '
    call IO_Write

  @@StillWording:                                                        ; 15
    xchg ax, cx
    mov  cl, 1+LASTCHAR         ; Always one less than char
    mov  di, (offset CodeTable) - 1
    repne scasb                 ; doing backwards makes cl=ASCII code
    mov  OUTPUT, cl             ; also makes the "double entries" trick work :)
    call IO_Write
    jmp  short @@NextSymbol

  @@DecodeMorse:                                                         ;  6
    shr  al, 1                  ; DAT has LSB=1, DIT has LSB=0
    adc  cl, cl
    jmp  short @@StillHungry
Decode endp                                                              ;=59
                                                                         ;(64)

;----------------------------[ USELESS PART ]---------------------------------

; 1 = dat, 0 = dit
;RET 0d (0a?)
;'   27
;,   2c
;-   2d
;.   2e
;/   2f
;0-9 30-39
;:   3a
;;   3b
;?   3f
;`      (40)
;A-Z 41-5a
;`   60
;a-z 61-7a

END
