 ;"""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""";
 ; Morse Translator for the 8th HUGI compo  --  by Jibz^q!p '99 ;
 ;                                                              ;
 ;   - Encoded table takes up 53 bytes                          ;
 ;   - Table decoder is 19 bytes                                ;
 ;   - Finally seems to work                                    ;
 ;   - Sent it in just to send something ;)                     ;
 ;..............................................................;

.model tiny
.486
.code
org 100h

START_SYMBOL equ 35h
END_SYMBOL   equ 2ah

MAX_SYMBOL   equ 61h

start:
     ; decode encoded_table into trans_table
     lea    si, encoded_table
     lea    di, trans_table         ; shr di, 1?
pause:
     xchg   ax, cx                  ; ax = 0 on first run
     rep    stosb
next:
     lodsb                          ; at start ch = 0, so ah = 0
     shr    ax, 1
     jc     pause
     stosb
     jnz    next

     ; decide if input is morse or plaintext
     call   read_char

     cmp    al, '_'
     jne    text_to_morse

; ===============================================================
;  MORSE_TO_TEXT
; ===============================================================
morse_to_text:
     xchg   ax, bp                  ; now bp is not '/'
skip_BOM:
     call   read_char
     cmp    al, '/'
     jne    skip_BOM

decode_next_code:
     xor    bx, bx                  ; sets carry = 0

decode_to_bx:
     cmc                            ; shift in bit
     adc    bx, bx                  ; (first run will set BX = 1)

next_char:
     call   read_char
     jz     all_done
     jb     next_char               ; skip newlines in morse code
     cmp    al, 30h                 ; sets parity odd for '.' and '_'
     jpo    decode_to_bx            ; and parity even for ' ' and '/'

     xchg   ax, bp                  ; save+restore seperator

     cmp    al, '/'
     jne    no_space_2

     mov    dl, ' '
     call   write_char

no_space_2:
     lea    di, trans_table
     mov    cl, MAX_SYMBOL          ; ch = 0 from read_char above
     xchg   ax, bx
     repne  scasb
     jne    decode_next_code

code_found:
     mov    dl, MAX_SYMBOL
     sub    dl, cl

     ; newline expansion
     cmp    dl, 0dh
     jne    newline_ok
     call   write_char
     mov    dl, 0ah

newline_ok:
     call   write_char

     jmp    decode_next_code

write_slash:
     mov    dl, '/'
write_char:
     mov    ah, 06h                 ; write dl to stdout
     int    21h
all_done:
     ret

; ===============================================================
;  TEXT_TO_MORSE
; ===============================================================
text_to_morse:
     push   ax
     mov    bl, START_SYMBOL
     call   decode_bl_to_morse
     jmp    space_cont

next_text_symbol:
     cmp    al, 0ah
     je     escape_next_text_symbol
     test   bp, bp
     jz     seperator_done

     push   ax
     cmp    al, ' '
     jne    not_space

space_cont:
     mov    dl, '/'
     db     0a9h

not_space:
     mov    dl, ' '
     call   write_char
     pop    ax

seperator_done:
     mov    ah, 0
     cmp    al, 60h
     jbe    small_ok
     sub    al, 20h

small_ok:
     mov    si, offset trans_table - 1
     add    si, ax
     lodsb
     xchg   bx, ax
     mov    bp, bx                  ; save seperator for testing

     call   decode_bl_to_morse

escape_next_text_symbol:
     call   read_char
     jnz    next_text_symbol

text_done:
     call   write_slash
     mov    bl, END_SYMBOL
     ; fall-through to decode_bl_to_morse instead of call + ret

decode_bl_to_morse:
     stc                            ; shift in a 1 first time
to_left:
     rcl    bl, 1                   ; shift bits to the left of
     jnc    to_left                 ; the byte

decode_bl_to_morse_cont:
     add    bl, bl
     jz     all_done

     mov    dl, '_'
     jc     not_dash
     mov    dl, '.'
not_dash:
     call   write_char
     jmp    decode_bl_to_morse_cont

read_char:
     push   bx
     lea    si, encoded_table
     mov    dx, si
     mov    ah, 3fh
     xor    bx, bx
     xor    cx, cx
     inc    cx
     int    21h
     daa                            ; ZF set if nothing read
     jz     got_char                ;
     lodsb
     cmp    al, 1ah                 ; ZF set if EOF
got_char:
     pop    bx
     ret

; ===============================================================
;  TABLES
; ===============================================================

; - the lowest bit is used to distinguish values from distances
; - highest bit of values is only a delimiter, the rest are the
;   direct encoding of '_' = 1 and '.' = 0
encoded_table:
     db 2*0Ch + 1 ; 0Ch empty bytes
     db 2*31h     ; value 31h = 110001b, which means _..._ = NEWLINE
     db 2*19h + 1 ; 19h empty bytes
     db 2*5Eh     ; value 5Eh
     db 2*04h + 1 ; 04h empty bytes
     db 2*73h     ; value 73h
     db 2*61h     ; value 61h
     db 2*55h     ; value 55h
     db 2*32h     ; value 32h
     db 2*3Fh     ; value 3Fh
     db 2*2Fh     ; value 2Fh
     db 2*27h     ; value 27h
     db 2*23h     ; value 23h
     db 2*21h     ; value 21h
     db 2*20h     ; value 20h
     db 2*30h     ; value 30h
     db 2*38h     ; value 38h
     db 2*3Ch     ; value 3Ch
     db 2*3Eh     ; value 3Eh
     db 2*78h     ; value 78h
     db 2*6Ah     ; value 6Ah
     db 2*03h + 1 ; 03h empty bytes
     db 2*4Ch     ; value 4Ch
     db 2*01h + 1 ; 01h empty bytes
     db 2*05h     ; value 05h
     db 2*18h     ; value 18h
     db 2*1Ah     ; value 1Ah
     db 2*0Ch     ; value 0Ch
     db 2*02h     ; value 02h
     db 2*12h     ; value 12h
     db 2*0Eh     ; value 0Eh
     db 2*10h     ; value 10h
     db 2*04h     ; value 04h
     db 2*17h     ; value 17h
     db 2*0Dh     ; value 0Dh
     db 2*14h     ; value 14h
     db 2*07h     ; value 07h
     db 2*06h     ; value 06h
     db 2*0Fh     ; value 0Fh
     db 2*16h     ; value 16h
     db 2*1Dh     ; value 1Dh
     db 2*0Ah     ; value 0Ah
     db 2*08h     ; value 08h
     db 2*03h     ; value 03h
     db 2*09h     ; value 09h
     db 2*11h     ; value 11h
     db 2*0Bh     ; value 0Bh
     db 2*19h     ; value 19h
     db 2*1Bh     ; value 1Bh
     db 2*1Ch     ; value 1Ch
     db 2*05h + 1 ; 05h empty bytes
     db 2*52h     ; value 52h
     db 00h       ; end of data

; table[ character ] = morse_code_encoding
trans_table:

end start
